# $Id: Duration.pm,v 1.8 2012/03/06 19:47:07 je Exp $

package Expr::Duration;

use overload '<=>'    => \&compare,
             fallback => 1;

use Fuzz;
use Moose;

extends qw(Expr);

has 'length' => (is => 'ro', isa => 'Num', required => 1);

sub add {
  my ($self, $another) = @_;
  blessed($self)->new(length => $self->length + $another->length);
}

sub compare {
  my ($self, $another) = @_;
  $self->length <=> $another->length;
}

sub parse_ly {
  my ($class, $ly_text) = @_;

  $ly_text =~ / (?<digits>\d+) (?<dots>\.*) /gmx;
  my $base_duration = 1 / $+{digits};    # XXX 0 is also a digit
  my $total_duration = $base_duration;

  foreach (1 .. length($+{dots})) {
    $base_duration  /= 2;
    $total_duration += $base_duration;
  }

  $class->new(length => $total_duration);
}

sub to_ly {
  my ($self) = @_;

  # XXX this does not find the exact if is not available with "dotted" notation

  my $base = 1;
  $base /= 2 while $base > $self->length;

  my $test_duration = $base;
  my $dots = 0;
  while ($test_duration < $self->length) {
    $test_duration += $base / 2**(++$dots);
  }

  (1 / $base) . ("." x $dots);
}

1;
