# $Id: Delayed.pm,v 1.10 2012/03/04 07:58:54 je Exp $

package Expr::Delayed;

use Fuzz;
use Moose;

extends qw(Expr);

has 'coderef' => (is => 'ro', isa => 'CodeRef', required => 1);
has 'context' => (is => 'ro', isa => 'HashRef', default  => fn { {} });

our %Context;

sub expr {
  my ($self, %context) = @_;
  local %Context = (%Context, %context, %{ $self->context });
  my $expr = $self->coderef->()
                  ->expr(%Context);

  $expr->isa('Expr::Delayed')
    ? $expr->expr(%Context)
    : $expr;
}

# XXX is this really okay?
sub op {
  my ($self, $op, $another) = @_;
  my $expr         = $self->expr;
  my $another_expr = $another->can('expr')
                       ? $another->expr
		       : $another;

  $expr->$op($another_expr);
}

sub to_ly {
  my ($self, $mode) = @_;
  $self->expr->to_ly($mode);
}

1;
