# $Id: Expr.pm,v 1.9 2012/03/04 07:58:53 je Exp $

package Expr;

use Fuzz;
use Moose;

use overload '%'      => fn { shift->op(tag         => @_) },
             '+'      => fn { shift->op(add         => @_) },
             '.'      => fn { shift->op(concatenate => @_) },
             '~~'     => fn { shift->op(match       => @_) },
             fallback => 1;

sub expr { $_[0]; }

sub match_error {
  my ($self, $another) = @_;
  confess("Could not find a match between type ${\ $self->blessed } "
	  . "and type ${\ $another->blessed }");
}

sub op {
  my ($self, $op, $another) = @_;
  $self->$op($another);
}

sub track {
  my ($self, $name, $type) = @_;
  $self->expr;
}

1;
