# $Id: Instanssi.pm,v 1.10 2012/03/08 20:02:23 je Exp $

package Song::Instanssi;

use bigrat;

use Fuzz;
use Moose;
use Song qw(:all);

extends qw(Song);

no warnings qw(qw);

my @common_grammarspec = (
  a32_1 => [
    [ Sl("a8_1",  qw(A8 A8 B8 A8)), ] => 0.2,
    [ Sl("a8_1",  qw(C8 D8 C8 D8)), ] => 0.4,
    [ Sl("a8_1",  qw(E8 F8 F8 E8)), ] => 0.6,
    [ Sl("a8_1",  qw(G8 H8 I8 G8)), ] => 0.9,
    [ Sl("a8_1",  qw(J8 K8 L8 J8)), ] => 1.0,
  ],

  a8_1 => [
    [ Sl("a4_1", qw(A4    B4)),    ] => 0.2,
    [ Sl("a4_1", qw(A4    C4)),    ] => 0.4,
    [ Sl("a4_1", qw(B4    C4)),    ] => 0.5,
    [ Sl("a2_1", qw(A2 A2 B2 A2)), ] => 0.6,
    [ Sl("a2_1", qw(A2 C2 C2 A2)), ] => 0.7,
    [ Sl("a2_1", qw(C2 D2 E2 C2)), ] => 0.75,
    [ Sl("a2_1", qw(D2 E2 E2 C2)), ] => 0.8,
    [ Sl("a2_1", qw(D2 E2 F2 G2)), ] => 0.85,
    [ Sl("a2_1", qw(E2 F2 G2 E2)), ] => 0.9,
    [ Sl("a2_1", qw(E2 F2 H2 F2)), ] => 1.0,
  ],
);

our %Grammars = (
  chords => grammar(
    @common_grammarspec,

    a4_1 => [
      [ S"a2_1", S"a2_1",               ] => 0.3,
      [ Sl("a2_1", qw(A2 B2)),          ] => 0.5,
      [ Sl("a2_1", qw(C2 E2)),          ] => 0.7,
      [ E"c1:maj7 e1:m7 f1:maj7 g1:",   ] => 0.8,
      [ E"c1: e2.:m f4:maj7 d1:m7 g1:", ] => 1.0,
    ],

    a2_1 => [
      [ E"a1:m    ~ a1:m",     ] => 0.05,
      [ E"e1:m    ~ e1:m",     ] => 0.1,
      [ E"f1:maj7 ~ f1:maj7",  ] => 0.15,
      [ E"g1:       f1:maj7",  ] => 0.25,
      [ E"a1:m      g1:maj7",  ] => 0.4,
      [ Sl("a1_1", qw(A1 B1)), ] => 0.6,
      [ Sl("a1_1", qw(C1 D1)), ] => 0.8,
      [ (S"a1_1") x 2,         ] => 1.0,
    ],

    a1_1 => [
      [ E"r1",                                               ] => 0.2,
      [ Sl("a1_2", qw(A1_2 B1_2)),                           ] => 0.3,
      [ E"cis8:m9 g8:9 fis8:dim e8:aug", Sl("a1_2", 'B1_2'), ] => 0.4,
      [ Sl("a1_4", qw(A1_4 B1_4 C1_4 D1_4)),                 ] => 0.65,
      [ E"a2:m c:",                                          ] => 0.7,
      [ E"a2:m d:m",                                         ] => 0.8,
      [ E"d1:m",                                             ] => 0.85,
      [ E"d4:m f4: g4:sus4 g4:",                             ] => 0.95,
      [ E"a2:m c4: e4:m",                                    ] => 1.0,
    ],

    a1_2 => [
      [ E"r2",         ] => 0.2,
      [ E"f2:",        ] => 0.4,
      [ E"f2:maj7",    ] => 0.6,
      [ (S"a1_4") x 2, ] => 0.9,
      [ E"fis4:m f4:", ] => 1.0,
    ],

    a1_4 => [
      [  E"r4",                  ] => 0.2,
      [  E"g4:m",                ] => 0.3,
      [  E"g4:",                 ] => 0.5,
      [  E"gis4:dim7",           ] => 0.55,
      [  E"dis4:m9",             ] => 0.6,
      [ (E"e16:m") x 4,          ] => 0.7,
      [ (E"e16:m") x 2, S"a1_8", ] => 0.8,
      [  S"a1_8", E"c8:",        ] => 0.9,
      [ (E"g16:" ) x 4,          ] => 1.0,
    ],

    a1_8 => [
      [  E"r8",     ] => 0.5,
      [  E"d8:m7",  ] => 1.0,
    ],
  ),

  melody => grammar(
    @common_grammarspec,

    a4_1 => [
      [ Sl("a2_1", qw(A2    B2)),    ] => 0.3,
      [ Sl("a2_1", qw(C2    D2)),    ] => 0.5,
      [ Sl("a2_1", qw(E2    F2)),    ] => 0.7,
      [ Sl("a2_1", qw(G2    H2)),    ] => 0.9,
      [ Sl("a1_1", qw(A1 E1 G1 G1)), ] => 1.0,
    ],

    a2_1 => [
      [ Sl("a1_1", qw(A1        B1)),        ] => 0.2,
      [ Sl("a1_1", qw(C1        D1)),        ] => 0.4,
      [ Sl("a1_1", qw(E1        F1)),        ] => 0.6,
      [ Sl("a1_1", qw(G1        G1)),        ] => 0.8,
      [ Sl("a1_2", qw(A1_2 B1_2 C1_2 D1_2)), ] => 1.0,
    ],

    a1_1 => [
      [ Sl("a3_8", 'A3_8'), Sl("a5_8", 'A5_8'),          ] => 0.1,
      [ Sl("a3_8", 'B3_8'), Sl("a5_8", 'B5_8'),          ] => 0.2,
      [ Sl("a5_8", 'A5_8'), Sl("a3_8", 'B3_8'),          ] => 0.3,

      [ S"a1_2",                         S"a1_2",        ] => 0.7,
      [ E"a16 e' a, e'    b c b d",      S"a1_2",        ] => 0.8,
      [ E"a16 e' a, d'",  S"a1_4",       S"a1_2",        ] => 0.9,
      [ E"a16 e' b, d'",  S"a1_4",       S"a1_2",        ] => 0.95,
      [ E"c8 d            d16 c d a ~    a4    g8. e16", ] => 1.0,
    ],

    a1_2 => [
      [ S"a1_4",                       S"a1_4",               ] => 0.4,
      [ E"b16 d         c",  S"a1_16", S"a1_16", E"c16 b a",  ] => 0.5,
      [ Sl("a3_16",
	   'A3_16'),    S"a1_16",      S"a1_16", Sl("a3_16",
					            'B3_16'), ] => 0.6,
      [ E"b16 d         c b            a c            b a",   ] => 0.7,
      [ E"e8 f ~        f16 g d8",                            ] => 0.8,
      [ E"b4                           d8.            g16",   ] => 0.9,
      [ E"a16 e         a c            b r            f r",   ] => 1.0,
    ],

    a5_8 => [
      [ E"a4 c8 d4",   ] => 0.2,
      [ E"d8 ~ d2",    ] => 0.5,
      [ E"f8 ~ f4 r4", ] => 1.0,
    ],

    a3_8 => [
      [ E"a4.",    ] => 0.2,
      [ E"a4 g8",  ] => 0.3,
      [ E"c8 d g", ] => 0.9,
      [ E"r4.",    ] => 1.0,
    ],

    a1_4 => [
      [ E"c4",                         ] => 0.1,
      [ E"e4",                         ] => 0.2,
      [ E"f4",                         ] => 0.3,
      [ E"g'4",                        ] => 0.4,
      [ E"g'8. d16",                   ] => 0.5,
      [ E"g'8 d'",                     ] => 0.6,
      [ S"a1_8", S"a1_8",              ] => 0.9,
      [ E"f,16 c' f g'",               ] => 0.95,
      [ E"f,32 c'16 g'32 d", S"a3_32", ] => 1.0,
    ],

    a3_16 => [
      [ (Sl("a1_16", "A3_16")) x 3 ] => 0.6,
      [ (Sl("a1_16"))          x 3 ] => 1.0,
    ],

    a1_8 => [
      [ S"a1_16", S"a1_16", ] => 0.5,
      [ S"a1_16", S"b1_16", ] => 0.75,
      [ S"b1_16", S"b1_16", ] => 0.9,
      [ S"b1_8",            ] => 1.0,
    ],

    b1_8 => [
      [ S"a1_32", E"f,32 g a",  ] => 0.3,
      [ S"a1_32", E"f,32 c' f", ] => 0.6,
      [ E"g16 r",               ] => 0.8,
      [ E"r8",                  ] => 1.0,
    ],

    a3_32 => [
      [ E"f,32 f' c'", ] => 0.5,
      [ E"c16.",       ] => 0.8,
      [ E"r16.",       ] => 1.0,
    ],

    a1_16 => [
      [ E"b16",  ] => 0.05,
      [ E"c16",  ] => 0.1,
      [ E"d16",  ] => 0.2,
      [ E"e16",  ] => 0.3,
      [ E"f16",  ] => 0.35,
      [ E"g'16", ] => 0.6,
      [ E"a'16", ] => 0.7,
      [ E"r16",  ] => 1.0,
    ],

    b1_16 => [
      [ E"c32 f",  ] => 0.2,
      [ E"d32 r",  ] => 0.4,
      [ E"d16",    ] => 0.5,
      [ E"e16",    ] => 0.7,
      [ E"g'32 d", ] => 0.8,
      [ E"r16",    ] => 1.0,
    ],

    a1_32 => [
      [ E"c32",  ] => 0.1,
      [ E"a32",  ] => 0.2,
      [ E"e32",  ] => 0.4,
      [ E"g'32", ] => 0.6,
      [ E"a'32", ] => 0.8,
      [ E"r32",  ] => 1.0,
    ],
  ),
);

our %Chords = (
  map {
    my $seed = $_;
    $seed => chords { $Grammars{chords}->produce(S('a32_1'),
						 $seed,
						 \&pass_chords) }
  } (10 .. 19),
);

my @melody_seeds = (1, 8);

our %Melodies = (
  map {
    my $seed = $_;
    $seed => melody { $Grammars{melody}->produce(S('a32_1'),
						 $seed,
						 \&relative_melody) },
  } @melody_seeds,
);

sub make_parts {
  my %winning_chords;

  for my $melody_key (@melody_seeds) {
    my %scores
      = map { $_  =>  $Melodies{ $melody_key }->expr ~~ $Chords{ $_ }->expr }
            keys %Chords;

    my $winning_chord_key
      = (map { $_->[0] }
           sort { $a->[1] <=> $b->[1] }
	     map { [ $_, $scores{$_} ] }
	       keys %scores)
	[-1];

    say "chose chord seed $winning_chord_key with melody seed $melody_key";
    $winning_chords{ $melody_key } = $Chords{ $winning_chord_key };
  }
  
  {
    melody =>
      (parts break  => melody { qw(r1 r1), },
             first  => $Melodies{ $melody_seeds[0] },
	     second => $Melodies{ $melody_seeds[1] }),
    chords =>
      (parts break  => chords { qw(r1 r1), },
             first  => $winning_chords{ $melody_seeds[0] },
             second => $winning_chords{ $melody_seeds[1] }),
  }
}

sub make_mixer {
  {
    strings => { max_volume => 0.7 },
  }
}

sub make_router {
  first  => [[ '_' ]],
  break  => [[ '_' ]],
  second => [[ '_' ]],
}

# XXX why is this function even necessary?  see also relative_melody below.
sub pass_chords {    
  my ($choice) = @_;
  map {
    my $expr = $_;
    ref($expr) eq 'ARRAY'
      ? chords { @$expr }
      : $expr
  } @$choice;
}

sub relative_melody {
  my ($choice) = @_;
  map {
    my $expr = $_;
    ref($expr) eq 'ARRAY'
      ? melody { (relative q{c'}, @$expr) }
      : $expr
  } @$choice;
}

sub tempo { '4=90' }

sub trackscheme {
  # [ 'Track::ChordNames' => strings => 'chords' ],
  [ 'Track::Voice'      => piano   => 'melody' ],
  [ 'Track::Voice'      => strings => 'chords' ],
}

1;
