/**
	The Shader file.
	fragment and vertex shader resides here.
	Gratz: to iq and auld of the nice tutorials.
*/

/* Vertex Shader */
static const char vsh[] = \
"uniform vec4 fp[5];"
"varying vec3 raydir;"
"void main(void)"
"{"
  "gl_Position=gl_Vertex;"

  "vec3 r = gl_Vertex.xyz*vec3(1.3333,1.0,0.0)+vec3(0.0,0.0,-1.0);"

  // dot product of manipulated vertex data and camera projection matrix (the quick and dirty version)
    "raydir.x=dot(r,vec3(1,0,0));"
    "raydir.y=dot(r,vec3(0,1,0));"
    "raydir.z=dot(r,vec3(0,0,1));"
"}";


/* Fragment Shader */
static const char fsh[] = \
"uniform vec4 fp[5];"
"varying vec3 raydir;"  

"float sdSphere(vec3 p,float r)"
"{"
  "return length(p)-r;"
"}"

"float sdPlane( vec3 p, vec4 n )"
"{"
  // n must be normalized
  "return dot(p,n.xyz) + n.w;"
"}"

"float opDisplace(vec3 p)"
"{"
    "float d1=sdSphere(p,1.0);"
    "float d2=sin(fp[1].w*p.x)*sin(fp[1].w*p.y)*sin(fp[1].w*p.z);"
    "if(fp[1].w==0.0)"
      "d2=0.0;"
    "return d1+d2;"
"}"

"float dist(vec3 p)"
"{"
  "if(fp[1].y==0.0)"  
    "return min(sdSphere(p,fp[2].w),sdPlane(p,vec4(0,0.9,-0.1,1)));"
  "if(fp[1].y==1.0)"
    "return opDisplace(p);"
"}"

"float shadow(vec3 ro,vec3 rd,float k)"
"{"
  "float h,res=1.0;"
  "for(float t=0.005;t<100.0;t+=h)"
  "{"
    "h = dist(ro+rd*t);"
    "if(h<0.001)"
    "{"
      "return 0.0;"
    "}"
    "res = min(res,k*h/t);"
  "}"
  "return res;"
"}"

"void main(void)"
"{"
  "vec3 wrd = normalize(raydir);"
 "vec3 wro = fp[0].xyz;"
  "vec3 n,p=wro;"    // next pos of cam
  "float d;"         //distance
  "int h=0;"

  "for(int step=0;step < fp[1].z && !h;step++)"
  "{"
     "d=dist(p);"
     "p=p+d*wrd;"
    "if(d<0.01)"
    "{"
         "n=normalize(vec3("
          "length(p+vec3(0.001,0,0))-length(p-vec3(0.001,0,0)),"
          "length(p+vec3(0,0.001,0))-length(p-vec3(0,0.001,0)),"
          "length(p+vec3(0,0,0.001))-length(p-vec3(0,0,0.001))));"
         "n=normalize(p-vec3(0.0));"
       "h=1;"        //ray hit
    "}"
  "}"

  // if hit something then do this
  "if(h)"
  "{"
    // lighting direction
    "vec3 ld=p-fp[2].xyz;"
    // calculate diffuse intensity
    "float df=max(0.0,dot(normalize(n),normalize(ld)));"
    //multiply with diffuse color. Add some alpha and base color to hinder it from vanishing, eg.ambient color.
   "gl_FragColor=df*fp[3]+fp[4];"
    // specular light
    "vec3 rf=normalize(reflect(-normalize(ld),normalize(n)));"
    "float sp=max(0.0,dot(normalize(n),rf));"
    "if(d)"
    "{"
      "float fsp=pow(sp,128.0);"
       "gl_FragColor.rgb+=vec3(fsp,fsp,fsp);"
     "}"
    //add shadow
    "gl_FragColor.rgb*=(vec3(0.5)+vec3(0.5)*shadow(p,fp[2].xyz,2));"
  "}"
  "gl_FragColor*=fp[0].w;"
"}";
