//#define NO_AUDIO
//#define NO_GL

#include "SDL/SDL.h"
#ifndef NO_GL
#include "graphic.h"
#endif
#ifndef NO_AUDIO
#include "audio.h"
#endif

#define DEMO_TIME 60000 // in ms

#ifndef NO_AUDIO
SDL_AudioSpec spec;
#endif

/* void _start() instead of main() to hinder glibc default beginning code */
void _start()
{
  SDL_Event event;
  int quit=0;

  // SDL init (may not require)
  SDL_Init(SDL_INIT_VIDEO|SDL_INIT_AUDIO|SDL_INIT_TIMER);

#ifndef NO_AUDIO
  // init audio
  spec.freq=SAMPLE_RATE;
  spec.format=AUDIO_S16SYS;
  spec.channels=2;
  spec.samples=1024;
  spec.callback=play;
  spec.userdata=NULL;

  SDL_OpenAudio(&spec,NULL);
  init(SAMPLE_RATE);
#endif

  // init window
  //    SDL_SetVideoMode(640,480,32,SDL_OPENGL|SDL_FULLSCREEN);
  //    SDL_SetVideoMode(800,600,32,SDL_OPENGL|SDL_FULLSCREEN);
  //    SDL_SetVideoMode(1280,720,32,SDL_OPENGL|SDL_FULLSCREEN);
       SDL_SetVideoMode(1366,768,32,SDL_OPENGL|SDL_FULLSCREEN);
  //SDL_SetVideoMode(1920,1080,32,SDL_OPENGL|SDL_FULLSCREEN);
  SDL_ShowCursor(SDL_DISABLE);

#ifndef NO_GL
  // init graphics
  if(!ginit())
    quit = 1;
#endif

#ifndef NO_AUDIO
  // start playing audio
  SDL_PauseAudio(0);
#endif

  unsigned int time,start = SDL_GetTicks();
  // update loop
  while(!quit)
    {
#ifndef NO_GL      
      // update gl graphics
      time = SDL_GetTicks()-start;
      gupdate(time);
#endif
      // swap buffers
      SDL_GL_SwapBuffers();

      // if demo has been executed
      if(time>=DEMO_TIME)
	quit=1;

      // poll for keyboard interrupt
      while(SDL_PollEvent(&event)>0)
	{
	  if (event.type==SDL_KEYDOWN)
	    if(event.key.keysym.sym == SDLK_ESCAPE)
	      quit=1;
	} 
  }
  SDL_Quit();

  // this assebler piece to hinder the default glibc ending code
  asm ( \
       "movl $1,%eax\n" \
       "xor %ebx,%ebx\n" \
       "int $128\n" \
      );
}
