#version 330

uniform sampler2DRect S;
uniform float s = 1.0 / 1.0;
out vec3 O0;

void main()
{
	ivec2 c = ivec2(gl_FragCoord.xy * 2.0);

	vec3 s0 = texelFetch(S, c - ivec2(0, 0)).rgb;
	vec3 s1 = texelFetch(S, c - ivec2(1, 0)).rgb;
	vec3 s2 = texelFetch(S, c - ivec2(0, 1)).rgb;
	vec3 s3 = texelFetch(S, c - ivec2(1, 1)).rgb;

	O0 = max(s0, max(s1, max(s2, s3)));
	
	//O0 = max(vec3(0.0), O0 - 1.0);

	O0 = log2(max(vec3(1.0), O0)) * s;	//O0 = max(0.0, O0 / (O0 + 1.0) - 0.5) * 2.0;
}
