// 2011-12 - rascy@dilemma.ws

$(document).ready(function() {

    $.extend(demo, {

        object : {

            json : {},

            files : ["antenna", "spikes", "spikerball", "star2"],

            axis : function(scale) {
                var object = new THREE.AxisHelper();
                object.name = 'axis';
                object.scale.x = object.scale.y = object.scale.z = scale;
                return object;
            },

            box : function(size, mat) {

                var object = new THREE.Mesh(new THREE.CubeGeometry(size, size, size, 1, 1, 1, false, true), mat);
                object.name = 'box';
                object.position.set(0, 0, 0);
                object.castShadow = false;
                object.receiveShadow = true;
                return object;
            },

            sky : function(size, mat) {
                var object = new THREE.Mesh(new THREE.SphereGeometry(size, 32, 32), mat);
                object.name = 'sky';
                return object;
            },

            spots : function(space, count, size) {

                var geometry = new THREE.Geometry();

                for ( i = 0; i < count; i++) {
                    var vertex = new THREE.Vector3();
                    vertex.x = Math.random() * space - (space / 2);
                    vertex.y = Math.random() * space - (space / 2);
                    vertex.z = Math.random() * space - (space / 2);
                    geometry.vertices.push(vertex);
                }

                var mat = new THREE.ParticleBasicMaterial({
                    size : size,
                    color : 0xffffff,
                    map : demo.texture.dust,
                    blending : THREE.AdditiveBlending,
                    depthTest : true,
                    transparent : true
                });

                return new THREE.ParticleSystem(geometry, mat);

            },

            balls : function(space, count, size) {

                var geometry = new THREE.Geometry();

                for ( i = 0; i < count; i++) {
                    var vertex = new THREE.Vector3();
                    vertex.x = Math.random() * space - (space / 2);
                    vertex.y = Math.random() * space - (space / 2);
                    vertex.z = Math.random() * space - (space / 2);
                    geometry.vertices.push(vertex);
                }

                var mat = new THREE.ParticleBasicMaterial({
                    size : size,
                    sizeAttenuation : true,
                    opacity : 0.7,
                    map : demo.texture.canvas.sprite(40, 40, '01'),
                    blending : THREE.AdditiveBlending,
                    depthTest : true,
                    transparent : false
                });

                return new THREE.ParticleSystem(geometry, mat);

            },

            sindots : function(space, count, size, pad) {

                var geometry = new THREE.Geometry();
                if (!pad)
                    pad = 0;

                for ( i = 0; i < count; i++) {
                    var vertex = new THREE.Vector3();
                    vertex.x = Math.sin(i + pad) * space - space / 2;
                    vertex.y = Math.sin(i + pad) * space - space / 2;
                    vertex.z = Math.cos(i + pad) * space - space / 2;
                    geometry.vertices.push(vertex);
                }

                var mat = new THREE.ParticleBasicMaterial({
                    size : size,
                    sizeAttenuation : true,
                    opacity : 0.7,
                    map : THREE.ImageUtils.loadTexture("data/balls/ball.png"),
                    blending : THREE.AdditiveBlending,
                    depthTest : true,
                    transparent : false
                });

                var particle = new THREE.ParticleSystem(geometry, mat);
                particle.sortParticles = true;
                particle.updateMatrix();
                particle.name = 'particle';

                return particle;

            },

            dust : function(space, count, size, color) {

                var geometry = new THREE.Geometry();

                for ( i = 0; i < count; i++) {
                    var vertex = new THREE.Vector3();
                    vertex.x = Math.random() * space - (space / 2);
                    vertex.y = Math.random() * space - (space / 2);
                    vertex.z = Math.random() * space - (space / 2);
                    geometry.vertices.push(vertex);
                }

                if (!color)
                    color = 0xfefefe;

                var mat = new THREE.ParticleBasicMaterial({
                    color : color,
                    size : size,
                    map : demo.texture.dust,
                    blending : THREE.AdditiveBlending,
                    depthTest : true,
                    transparent : true,
                });

                var particle = new THREE.ParticleSystem(geometry, mat);
                particle.sortParticles = true;
                particle.updateMatrix();
                particle.name = 'particle';

                return particle;

            },

            stars : function(space, count, size, color) {

                var geometry = new THREE.Geometry();

                for ( i = 0; i < count; i++) {
                    var vertex = new THREE.Vector3();
                    vertex.x = Math.random() * space - (space / 2);
                    vertex.y = Math.random() * space - (space / 2);
                    vertex.z = Math.random() * space - (space / 2);
                    geometry.vertices.push(vertex);
                }

                if (!color)
                    color = 0xfefefe;

                var mat = new THREE.ParticleBasicMaterial({
                    color : color,
                    size : size,
                    map : demo.texture.star,
                    blending : THREE.AdditiveBlending,
                    opacity : 0.85,
                    depthTest : true,
                    transparent : true,
                });

                var particle = new THREE.ParticleSystem(geometry, mat);
                particle.sortParticles = true;
                particle.updateMatrix();
                particle.name = 'particle';

                return particle;

            },

            text : function(text, mat, size) {

                var text3d = new THREE.TextGeometry(text, {
                    size : size,
                    height : 20,
                    curveSegments : 1,
                    font : "helvetiker",
                    //weight : "bold",
                    //style : "normal",
                    bevelEnabled : true,
                    bevelThickness : 5,
                    bevelSize : 10,
                    bend : false
                });

                var text = new THREE.Mesh(text3d, mat);
                text.overdraw = true;
                text.name = 'text';
                return text;

            },

            polip_new : function(type, mat) {

                var geometry = new THREE.CubeGeometry(400, 400, 400);
                var mesh = new THREE.Mesh(geometry, mat);

                objects = [];
                var amount = 30, child, sizeX, sizeY, sizeZ, object = mesh;

                mesh.name = 'polip';
                objects.push(mesh);

                for (var j = 0; j < 6; j++) {

                    for (var i = 0; i < amount; i++) {

                        sizeX = (amount - i) * 18;
                        sizeY = (amount - i) * 18;
                        sizeZ = (amount - i) * 18;

                        var geometry = new THREE.CubeGeometry(sizeX, sizeY, sizeZ);

                        child = new THREE.Mesh(geometry, mat);
                        posi = 100;

                        switch (j) {

                            case 0:
                                child.position.x = posi;
                                break;
                            case 1:
                                child.position.x = -posi;
                                break;
                            case 2:
                                child.position.y = posi;
                                break;
                            case 3:
                                child.position.y = -posi;
                                break;
                            case 4:
                                child.position.z = posi;
                                break;
                            case 5:
                                child.position.z = -posi;
                                break;

                        }
                        object.add(child);
                        object.name = 'polip';
                        object.castShadow = true;
                        object.receiveShadow = true;

                        object = child;
                        objects.push(child);
                    }

                    object = mesh;
                }

                return mesh;

            },

            polip : function(type, mat, scale) {

                var size = (400 / 18) * scale;

                if (type == 'cube') {
                    var geometry = new THREE.CubeGeometry(size, size, size);
                }
                if (type == 'sphere') {
                    var geometry = new THREE.SphereGeometry(size, 4, 4);
                }

                var mesh = new THREE.Mesh(geometry, mat);
                mesh.name = 'polip';
                objects = [];
                objects.push(mesh);

                var amount = 30, child, object = mesh;

                for (var j = 0; j < 6; j++) {

                    for (var i = 0; i < amount; i++) {

                        sizeX = (amount - i) * scale;
                        sizeY = (amount - i) * scale;
                        sizeZ = (amount - i) * scale;

                        if (type == 'cube') {
                            var geometry = new THREE.CubeGeometry(sizeX, sizeY, sizeZ);
                        }
                        if (type == 'sphere') {
                            var geometry = new THREE.SphereGeometry(sizeX, 4, 4);
                        }

                        child = new THREE.Mesh(geometry, mat);
                        posi = 100;

                        switch (j) {

                            case 0:
                                child.position.x = posi;
                                break;
                            case 1:
                                child.position.x = -posi;
                                break;
                            case 2:
                                child.position.y = posi;
                                break;
                            case 3:
                                child.position.y = -posi;
                                break;
                            case 4:
                                child.position.z = posi;
                                break;
                            case 5:
                                child.position.z = -posi;
                                break;

                        }
                        object.add(child);
                        object.name = 'polip' + i + j;
                        object.doubleSided = false;
                        object.castShadow = true;
                        object.receiveShadow = true;

                        object = child;
                        objects.push(child);
                    }

                    object = mesh;
                }

                return mesh;

            }
        },

        objects_loaded : 0,

        objinit : function(name) {

            if (!demo.object.json[name]) {
                $("#objects").append('ERROR ' + name + ' ');
                return;
            }

            var loader = new THREE.GeometryLoader();
            var geometry = loader.parse(demo.object.json[name]);
            var mesh = new THREE.Mesh(geometry, demo.material.basic);
            mesh.name = name;
            demo.object[name] = mesh;
            $("#objects").append(name + ' ');
            demo.objects_loaded++;

        },

        // not used, because in offline mode need extra config in browser
        objload : function(name) {

            var loader = new THREE.GeometryLoader();
            loader.addEventListener('load', function(event) {

                var geometry = event.content;

                var mesh = new THREE.Mesh(geometry, demo.material.basic);
                mesh.name = name;
                demo.object[name] = mesh;
                $("#objects").append(name + ' ');
                demo.objects_loaded++;

            });

            loader.load('data/objects/' + name + '.js');

        }
    });

});
