/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opencl.util.concurrent;

import com.jogamp.opencl.CLCommandQueue;
import com.jogamp.opencl.CLDevice;
import com.jogamp.opencl.CLResource;
import com.jogamp.opencl.util.CLMultiContext;
import com.jogamp.opencl.util.concurrent.CLQueueContext;
import com.jogamp.opencl.util.concurrent.CLQueueContextFactory;
import com.jogamp.opencl.util.concurrent.CLTask;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;

public class CLCommandQueuePool<C extends CLQueueContext>
implements CLResource {
    private List<CLQueueContext> contexts;
    private ExecutorService excecutor;
    private FinishAction finishAction = FinishAction.DO_NOTHING;
    private boolean released;

    private CLCommandQueuePool(CLQueueContextFactory cLQueueContextFactory, Collection<CLCommandQueue> collection) {
        this.contexts = this.initContexts(collection, cLQueueContextFactory);
        this.initExecutor();
    }

    private List<CLQueueContext> initContexts(Collection<CLCommandQueue> collection, CLQueueContextFactory cLQueueContextFactory) {
        ArrayList<CLQueueContext> arrayList = new ArrayList<CLQueueContext>(collection.size());
        int n = 0;
        for (CLCommandQueue cLCommandQueue : collection) {
            CLQueueContext cLQueueContext = null;
            if (this.contexts != null && !this.contexts.isEmpty()) {
                cLQueueContext = this.contexts.get(n++);
                cLQueueContext.release();
            }
            arrayList.add((CLQueueContext)cLQueueContextFactory.setup(cLCommandQueue, cLQueueContext));
        }
        return arrayList;
    }

    private void initExecutor() {
        this.excecutor = Executors.newFixedThreadPool(this.contexts.size(), new QueueThreadFactory(this.contexts));
    }

    public static <C extends CLQueueContext> CLCommandQueuePool<C> create(CLQueueContextFactory<C> cLQueueContextFactory, CLMultiContext cLMultiContext, CLCommandQueue.Mode ... modeArray) {
        return CLCommandQueuePool.create(cLQueueContextFactory, cLMultiContext.getDevices(), modeArray);
    }

    public static <C extends CLQueueContext> CLCommandQueuePool<C> create(CLQueueContextFactory<C> cLQueueContextFactory, Collection<CLDevice> collection, CLCommandQueue.Mode ... modeArray) {
        ArrayList<CLCommandQueue> arrayList = new ArrayList<CLCommandQueue>(collection.size());
        for (CLDevice cLDevice : collection) {
            arrayList.add(cLDevice.createCommandQueue(modeArray));
        }
        return CLCommandQueuePool.create(cLQueueContextFactory, arrayList);
    }

    public static <C extends CLQueueContext> CLCommandQueuePool create(CLQueueContextFactory<C> cLQueueContextFactory, Collection<CLCommandQueue> collection) {
        return new CLCommandQueuePool<C>(cLQueueContextFactory, collection);
    }

    public <R> Future<R> submit(CLTask<? super C, R> cLTask) {
        return this.excecutor.submit(new TaskWrapper<C, R>(cLTask, this.finishAction));
    }

    public <R> List<Future<R>> submitAll(Collection<? extends CLTask<? super C, R>> collection) {
        ArrayList<Future<R>> arrayList = new ArrayList<Future<R>>(collection.size());
        for (CLTask<C, R> cLTask : collection) {
            arrayList.add(this.submit(cLTask));
        }
        return arrayList;
    }

    public <R> List<Future<R>> invokeAll(Collection<? extends CLTask<? super C, R>> collection) throws InterruptedException {
        List<TaskWrapper<C, R>> list = this.wrapTasks(collection);
        return this.excecutor.invokeAll(list);
    }

    public <R> List<Future<R>> invokeAll(Collection<? extends CLTask<? super C, R>> collection, long l, TimeUnit timeUnit) throws InterruptedException {
        List<TaskWrapper<C, R>> list = this.wrapTasks(collection);
        return this.excecutor.invokeAll(list, l, timeUnit);
    }

    private <R> List<TaskWrapper<C, R>> wrapTasks(Collection<? extends CLTask<? super C, R>> collection) {
        ArrayList<TaskWrapper<C, R>> arrayList = new ArrayList<TaskWrapper<C, R>>(collection.size());
        for (CLTask<C, R> cLTask : collection) {
            if (cLTask == null) {
                throw new NullPointerException("at least one task was null");
            }
            arrayList.add(new TaskWrapper<C, R>(cLTask, this.finishAction));
        }
        return arrayList;
    }

    public <C extends CLQueueContext> CLCommandQueuePool switchContext(CLQueueContextFactory<C> cLQueueContextFactory) {
        this.excecutor.shutdown();
        this.finishQueues();
        this.contexts = this.initContexts(this.getQueues(), cLQueueContextFactory);
        this.initExecutor();
        return this;
    }

    public void flushQueues() {
        for (CLQueueContext cLQueueContext : this.contexts) {
            cLQueueContext.queue.flush();
        }
    }

    public void finishQueues() {
        for (CLQueueContext cLQueueContext : this.contexts) {
            cLQueueContext.queue.finish();
        }
    }

    @Override
    public void release() {
        if (this.released) {
            throw new RuntimeException(this.getClass().getSimpleName() + " already released");
        }
        this.released = true;
        this.excecutor.shutdown();
        for (CLQueueContext cLQueueContext : this.contexts) {
            cLQueueContext.queue.finish().release();
            cLQueueContext.release();
        }
    }

    public List<CLCommandQueue> getQueues() {
        ArrayList<CLCommandQueue> arrayList = new ArrayList<CLCommandQueue>(this.contexts.size());
        for (CLQueueContext cLQueueContext : this.contexts) {
            arrayList.add(cLQueueContext.queue);
        }
        return arrayList;
    }

    public int getSize() {
        return this.contexts.size();
    }

    public FinishAction getFinishAction() {
        return this.finishAction;
    }

    @Override
    public boolean isReleased() {
        return this.released;
    }

    public void setFinishAction(FinishAction finishAction) {
        this.finishAction = finishAction;
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [queues: " + this.contexts.size() + " on finish: " + (Object)((Object)this.finishAction) + "]";
    }

    public static enum FinishAction {
        DO_NOTHING,
        FLUSH,
        FINISH;

    }

    private static class TaskWrapper<C extends CLQueueContext, R>
    implements Callable<R> {
        private final CLTask<? super C, R> task;
        private final FinishAction mode;

        public TaskWrapper(CLTask<? super C, R> cLTask, FinishAction finishAction) {
            this.task = cLTask;
            this.mode = finishAction;
        }

        @Override
        public R call() throws Exception {
            CLQueueContext cLQueueContext = ((QueueThread)Thread.currentThread()).context;
            R r = this.task.execute(cLQueueContext);
            if (this.mode.equals((Object)FinishAction.FLUSH)) {
                cLQueueContext.queue.flush();
            } else if (this.mode.equals((Object)FinishAction.FINISH)) {
                cLQueueContext.queue.finish();
            }
            return r;
        }
    }

    private static class QueueThread
    extends Thread {
        private final CLQueueContext context;

        public QueueThread(ThreadGroup threadGroup, Runnable runnable, CLQueueContext cLQueueContext, int n) {
            super(threadGroup, runnable, "queue-worker-thread-" + n + "[" + cLQueueContext + "]");
            this.context = cLQueueContext;
        }
    }

    private static class QueueThreadFactory
    implements ThreadFactory {
        private final List<CLQueueContext> context;
        private int index;

        private QueueThreadFactory(List<CLQueueContext> list) {
            this.context = list;
            this.index = 0;
        }

        @Override
        public synchronized Thread newThread(Runnable runnable) {
            SecurityManager securityManager = System.getSecurityManager();
            ThreadGroup threadGroup = securityManager != null ? securityManager.getThreadGroup() : Thread.currentThread().getThreadGroup();
            CLQueueContext cLQueueContext = this.context.get(this.index);
            QueueThread queueThread = new QueueThread(threadGroup, runnable, cLQueueContext, this.index++);
            queueThread.setDaemon(true);
            return queueThread;
        }
    }
}

