/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opencl.impl;

import com.jogamp.common.nio.Buffers;
import com.jogamp.common.nio.PointerBuffer;
import com.jogamp.common.os.Platform;
import com.jogamp.opencl.CLException;
import com.jogamp.opencl.spi.CLInfoAccessor;
import com.jogamp.opencl.util.CLUtil;
import java.nio.Buffer;
import java.nio.ByteBuffer;

public abstract class CLTLInfoAccessor
implements CLInfoAccessor {
    private static final int BB_SIZE = 512;
    protected static final ThreadLocal<ByteBuffer> localBB = new ThreadLocal<ByteBuffer>(){

        @Override
        protected ByteBuffer initialValue() {
            return Buffers.newDirectByteBuffer(512);
        }
    };
    protected static final ThreadLocal<PointerBuffer> localNSB = new ThreadLocal<PointerBuffer>(){

        @Override
        protected PointerBuffer initialValue() {
            return PointerBuffer.allocateDirect(1);
        }
    };

    @Override
    public final long getLong(int n) {
        ByteBuffer byteBuffer = this.getBB(8).putLong(0, 0L);
        int n2 = this.getInfo(n, 8L, byteBuffer, null);
        CLException.checkForError(n2, "error while asking for info value");
        return byteBuffer.getLong(0);
    }

    @Override
    public final String getString(int n) {
        PointerBuffer pointerBuffer = this.getNSB();
        int n2 = this.getInfo(n, 0L, null, pointerBuffer);
        CLException.checkForError(n2, "error while asking for info string");
        int n3 = (int)pointerBuffer.get(0);
        ByteBuffer byteBuffer = this.getBB(n3);
        n2 = this.getInfo(n, byteBuffer.capacity(), byteBuffer, null);
        CLException.checkForError(n2, "error while asking for info string");
        byte[] byArray = new byte[n3];
        byteBuffer.get(byArray).rewind();
        return CLUtil.clString2JavaString(byArray, n3);
    }

    @Override
    public final int[] getInts(int n, int n2) {
        ByteBuffer byteBuffer = this.getBB(n2 * (Platform.is32Bit() ? 4 : 8));
        int n3 = this.getInfo(n, byteBuffer.capacity(), byteBuffer, null);
        CLException.checkForError(n3, "error while asking for info value");
        int[] nArray = new int[n2];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = Platform.is32Bit() ? byteBuffer.getInt() : (int)byteBuffer.getLong();
        }
        byteBuffer.rewind();
        return nArray;
    }

    protected ByteBuffer getBB(int n) {
        if (n > 512) {
            return Buffers.newDirectByteBuffer(n);
        }
        return localBB.get();
    }

    protected PointerBuffer getNSB() {
        return localNSB.get();
    }

    protected abstract int getInfo(int var1, long var2, Buffer var4, PointerBuffer var5);
}

