/*
 * Decompiled with CFR 0.152.
 */
package jogamp.opengl.windows.wgl;

import javax.media.nativewindow.NativeWindowException;
import javax.media.nativewindow.VisualIDHolder;
import javax.media.opengl.GLCapabilities;
import javax.media.opengl.GLException;
import javax.media.opengl.GLProfile;
import jogamp.nativewindow.windows.PIXELFORMATDESCRIPTOR;

public class WGLGLCapabilities
extends GLCapabilities {
    private final PIXELFORMATDESCRIPTOR pfd;
    private final int pfdID;
    private int arb_pixelformat;

    public WGLGLCapabilities(PIXELFORMATDESCRIPTOR pIXELFORMATDESCRIPTOR, int n, GLProfile gLProfile) {
        super(gLProfile);
        this.pfd = pIXELFORMATDESCRIPTOR;
        this.pfdID = n;
        this.arb_pixelformat = 0;
    }

    public boolean setValuesByGDI() {
        this.arb_pixelformat = -1;
        this.setRedBits(this.pfd.getCRedBits());
        this.setGreenBits(this.pfd.getCGreenBits());
        this.setBlueBits(this.pfd.getCBlueBits());
        this.setAlphaBits(this.pfd.getCAlphaBits());
        this.setAccumRedBits(this.pfd.getCAccumRedBits());
        this.setAccumGreenBits(this.pfd.getCAccumGreenBits());
        this.setAccumBlueBits(this.pfd.getCAccumBlueBits());
        this.setAccumAlphaBits(this.pfd.getCAccumAlphaBits());
        this.setDepthBits(this.pfd.getCDepthBits());
        this.setStencilBits(this.pfd.getCStencilBits());
        this.setDoubleBuffered((this.pfd.getDwFlags() & 1) != 0);
        this.setStereo((this.pfd.getDwFlags() & 2) != 0);
        this.setHardwareAccelerated((this.pfd.getDwFlags() & 0x40) == 0 || (this.pfd.getDwFlags() & 0x1000) != 0);
        return true;
    }

    public boolean setValuesByARB(int[] nArray, int n, int[] nArray2) {
        this.arb_pixelformat = 1;
        block21: for (int i = 0; i < n; ++i) {
            int n2 = nArray[i];
            switch (n2) {
                case 8193: 
                case 8194: 
                case 8237: {
                    continue block21;
                }
                case 8195: {
                    this.setHardwareAccelerated(nArray2[i] == 8231);
                    continue block21;
                }
                case 8208: {
                    if (nArray2[i] == 1) continue block21;
                    return false;
                }
                case 8226: {
                    this.setDepthBits(nArray2[i]);
                    continue block21;
                }
                case 8227: {
                    this.setStencilBits(nArray2[i]);
                    continue block21;
                }
                case 8209: {
                    this.setDoubleBuffered(nArray2[i] == 1);
                    continue block21;
                }
                case 8210: {
                    this.setStereo(nArray2[i] == 1);
                    continue block21;
                }
                case 8211: {
                    if (nArray2[i] == 8236) {
                        return false;
                    }
                    if (nArray2[i] != 8608) continue block21;
                    this.setPbufferFloatingPointBuffers(true);
                    continue block21;
                }
                case 8368: {
                    if (nArray2[i] == 0) continue block21;
                    this.setPbufferFloatingPointBuffers(true);
                    continue block21;
                }
                case 8213: {
                    this.setRedBits(nArray2[i]);
                    continue block21;
                }
                case 8215: {
                    this.setGreenBits(nArray2[i]);
                    continue block21;
                }
                case 8217: {
                    this.setBlueBits(nArray2[i]);
                    continue block21;
                }
                case 8219: {
                    this.setAlphaBits(nArray2[i]);
                    continue block21;
                }
                case 8222: {
                    this.setAccumRedBits(nArray2[i]);
                    continue block21;
                }
                case 8223: {
                    this.setAccumGreenBits(nArray2[i]);
                    continue block21;
                }
                case 8224: {
                    this.setAccumBlueBits(nArray2[i]);
                    continue block21;
                }
                case 8225: {
                    this.setAccumAlphaBits(nArray2[i]);
                    continue block21;
                }
                case 8257: {
                    this.setSampleBuffers(nArray2[i] != 0);
                    continue block21;
                }
                case 8258: {
                    this.setNumSamples(nArray2[i]);
                    continue block21;
                }
                default: {
                    throw new GLException("Unknown pixel format attribute " + nArray[i]);
                }
            }
        }
        return true;
    }

    @Override
    public Object cloneMutable() {
        return this.clone();
    }

    @Override
    public Object clone() {
        try {
            return super.clone();
        }
        catch (RuntimeException runtimeException) {
            throw new GLException(runtimeException);
        }
    }

    public final PIXELFORMATDESCRIPTOR getPFD() {
        return this.pfd;
    }

    public final int getPFDID() {
        return this.pfdID;
    }

    public final boolean isSetByARB() {
        return 0 < this.arb_pixelformat;
    }

    public final boolean isSetByGDI() {
        return 0 > this.arb_pixelformat;
    }

    public final boolean isSet() {
        return 0 != this.arb_pixelformat;
    }

    @Override
    public final int getVisualID(VisualIDHolder.VIDType vIDType) throws NativeWindowException {
        switch (vIDType) {
            case INTRINSIC: 
            case NATIVE: 
            case WIN32_PFD: {
                return this.getPFDID();
            }
        }
        throw new NativeWindowException("Invalid type <" + (Object)((Object)vIDType) + ">");
    }

    @Override
    public StringBuilder toString(StringBuilder stringBuilder) {
        if (null == stringBuilder) {
            stringBuilder = new StringBuilder();
        }
        stringBuilder.append("wgl vid 0x").append(Integer.toHexString(this.pfdID)).append(" ");
        switch (this.arb_pixelformat) {
            case -1: {
                stringBuilder.append("gdi");
                break;
            }
            case 0: {
                stringBuilder.append("nop");
                break;
            }
            case 1: {
                stringBuilder.append("arb");
                break;
            }
            default: {
                throw new InternalError("invalid arb_pixelformat: " + this.arb_pixelformat);
            }
        }
        stringBuilder.append(": ");
        return super.toString(stringBuilder);
    }
}

