/*
 * Decompiled with CFR 0.152.
 */
package jogamp.opengl.util.pngj;

import java.io.ByteArrayOutputStream;
import java.io.IOException;

abstract class ProgressiveOutputStream
extends ByteArrayOutputStream {
    private final int size;

    public ProgressiveOutputStream(int n) {
        this.size = n;
    }

    @Override
    public final void close() throws IOException {
        this.flush();
        super.close();
    }

    @Override
    public final void flush() throws IOException {
        super.flush();
        this.checkFlushBuffer(true);
    }

    @Override
    public final void write(byte[] byArray, int n, int n2) {
        super.write(byArray, n, n2);
        this.checkFlushBuffer(false);
    }

    @Override
    public final void write(byte[] byArray) throws IOException {
        super.write(byArray);
        this.checkFlushBuffer(false);
    }

    @Override
    public final void write(int n) {
        super.write(n);
        this.checkFlushBuffer(false);
    }

    @Override
    public final synchronized void reset() {
        super.reset();
    }

    private final void checkFlushBuffer(boolean bl) {
        while (bl || this.count >= this.size) {
            int n;
            int n2 = this.size;
            if (n2 > this.count) {
                n2 = this.count;
            }
            if (n2 == 0) {
                return;
            }
            this.flushBuffer(this.buf, n2);
            this.count = n = this.count - n2;
            if (n <= 0) continue;
            System.arraycopy(this.buf, n2, this.buf, 0, n);
        }
    }

    public abstract void flushBuffer(byte[] var1, int var2);
}

