/*
 * Decompiled with CFR 0.152.
 */
package javax.media.nativewindow;

import com.jogamp.common.util.ReflectionUtil;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.media.nativewindow.AbstractGraphicsConfiguration;
import javax.media.nativewindow.AbstractGraphicsDevice;
import javax.media.nativewindow.AbstractGraphicsScreen;
import javax.media.nativewindow.CapabilitiesChooser;
import javax.media.nativewindow.CapabilitiesImmutable;
import javax.media.nativewindow.NativeWindowException;
import javax.media.nativewindow.NativeWindowFactory;
import jogamp.nativewindow.Debug;
import jogamp.nativewindow.DefaultGraphicsConfigurationFactoryImpl;

public abstract class GraphicsConfigurationFactory {
    protected static final boolean DEBUG;
    private static Map<Class<?>, GraphicsConfigurationFactory> registeredFactories;
    private static Class<?> abstractGraphicsDeviceClass;
    static boolean initialized;

    public static synchronized void initSingleton() {
        if (!initialized) {
            initialized = true;
            if (DEBUG) {
                System.err.println(Thread.currentThread().getName() + " - GraphicsConfigurationFactory.initSingleton()");
            }
            registeredFactories = Collections.synchronizedMap(new HashMap());
            GraphicsConfigurationFactory.registerFactory(abstractGraphicsDeviceClass, new DefaultGraphicsConfigurationFactoryImpl());
            if ("X11".equals(NativeWindowFactory.getNativeWindowType(true))) {
                try {
                    ReflectionUtil.callStaticMethod((String)"jogamp.nativewindow.x11.X11GraphicsConfigurationFactory", (String)"registerFactory", null, null, (ClassLoader)GraphicsConfigurationFactory.class.getClassLoader());
                }
                catch (Exception exception) {
                    throw new RuntimeException(exception);
                }
                if (NativeWindowFactory.isAWTAvailable()) {
                    try {
                        ReflectionUtil.callStaticMethod((String)"jogamp.nativewindow.x11.awt.X11AWTGraphicsConfigurationFactory", (String)"registerFactory", null, null, (ClassLoader)GraphicsConfigurationFactory.class.getClassLoader());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
    }

    public static synchronized void shutdown() {
        if (initialized) {
            initialized = false;
            if (DEBUG) {
                System.err.println(Thread.currentThread().getName() + " - GraphicsConfigurationFactory.shutdown()");
            }
            registeredFactories.clear();
            registeredFactories = null;
        }
    }

    protected static String getThreadName() {
        return Thread.currentThread().getName();
    }

    protected static String toHexString(int n) {
        return "0x" + Integer.toHexString(n);
    }

    protected static String toHexString(long l) {
        return "0x" + Long.toHexString(l);
    }

    protected GraphicsConfigurationFactory() {
    }

    public static GraphicsConfigurationFactory getFactory(AbstractGraphicsDevice abstractGraphicsDevice) {
        if (abstractGraphicsDevice == null) {
            return GraphicsConfigurationFactory.getFactory(AbstractGraphicsDevice.class);
        }
        return GraphicsConfigurationFactory.getFactory(abstractGraphicsDevice.getClass());
    }

    public static GraphicsConfigurationFactory getFactory(Class<?> clazz) throws IllegalArgumentException, NativeWindowException {
        if (!abstractGraphicsDeviceClass.isAssignableFrom(clazz)) {
            throw new IllegalArgumentException("Given class must implement AbstractGraphicsDevice");
        }
        GraphicsConfigurationFactory graphicsConfigurationFactory = null;
        for (Class<?> clazz2 = clazz; clazz2 != null; clazz2 = clazz2.getSuperclass()) {
            graphicsConfigurationFactory = registeredFactories.get(clazz2);
            if (graphicsConfigurationFactory == null) continue;
            if (DEBUG) {
                System.err.println("GraphicsConfigurationFactory.getFactory() " + clazz + " -> " + graphicsConfigurationFactory);
            }
            return graphicsConfigurationFactory;
        }
        graphicsConfigurationFactory = registeredFactories.get(abstractGraphicsDeviceClass);
        if (DEBUG) {
            System.err.println("GraphicsConfigurationFactory.getFactory() DEFAULT " + abstractGraphicsDeviceClass + " -> " + graphicsConfigurationFactory);
        }
        return graphicsConfigurationFactory;
    }

    protected static GraphicsConfigurationFactory registerFactory(Class<?> clazz, GraphicsConfigurationFactory graphicsConfigurationFactory) throws IllegalArgumentException {
        GraphicsConfigurationFactory graphicsConfigurationFactory2;
        if (!abstractGraphicsDeviceClass.isAssignableFrom(clazz)) {
            throw new IllegalArgumentException("Given class must implement AbstractGraphicsDevice");
        }
        if (null == graphicsConfigurationFactory) {
            graphicsConfigurationFactory2 = registeredFactories.remove(clazz);
            if (DEBUG) {
                System.err.println("GraphicsConfigurationFactory.registerFactory() remove " + clazz + ", deleting: " + graphicsConfigurationFactory2);
            }
        } else {
            graphicsConfigurationFactory2 = registeredFactories.put(clazz, graphicsConfigurationFactory);
            if (DEBUG) {
                System.err.println("GraphicsConfigurationFactory.registerFactory() put " + clazz + " -> " + graphicsConfigurationFactory + ", overridding: " + graphicsConfigurationFactory2);
            }
        }
        return graphicsConfigurationFactory2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final AbstractGraphicsConfiguration chooseGraphicsConfiguration(CapabilitiesImmutable capabilitiesImmutable, CapabilitiesImmutable capabilitiesImmutable2, CapabilitiesChooser capabilitiesChooser, AbstractGraphicsScreen abstractGraphicsScreen) throws IllegalArgumentException, NativeWindowException {
        if (null == capabilitiesImmutable) {
            throw new NativeWindowException("Chosen Capabilities are null");
        }
        if (null == capabilitiesImmutable2) {
            throw new NativeWindowException("Requested Capabilities are null");
        }
        if (null == abstractGraphicsScreen) {
            throw new NativeWindowException("Screen is null");
        }
        AbstractGraphicsDevice abstractGraphicsDevice = abstractGraphicsScreen.getDevice();
        if (null == abstractGraphicsDevice) {
            throw new NativeWindowException("Screen's Device is null");
        }
        abstractGraphicsDevice.lock();
        try {
            AbstractGraphicsConfiguration abstractGraphicsConfiguration = this.chooseGraphicsConfigurationImpl(capabilitiesImmutable, capabilitiesImmutable2, capabilitiesChooser, abstractGraphicsScreen);
            return abstractGraphicsConfiguration;
        }
        finally {
            abstractGraphicsDevice.unlock();
        }
    }

    protected abstract AbstractGraphicsConfiguration chooseGraphicsConfigurationImpl(CapabilitiesImmutable var1, CapabilitiesImmutable var2, CapabilitiesChooser var3, AbstractGraphicsScreen var4) throws IllegalArgumentException, NativeWindowException;

    static {
        initialized = false;
        DEBUG = Debug.debug("GraphicsConfiguration");
        if (DEBUG) {
            System.err.println(Thread.currentThread().getName() + " - Info: GraphicsConfigurationFactory.<init>");
        }
        abstractGraphicsDeviceClass = AbstractGraphicsDevice.class;
    }
}

