/*
 * Decompiled with CFR 0.152.
 */
package javax.media.nativewindow;

import javax.media.nativewindow.CapabilitiesImmutable;
import javax.media.nativewindow.NativeWindowException;
import javax.media.nativewindow.VisualIDHolder;

public class Capabilities
implements CapabilitiesImmutable,
Cloneable,
Comparable {
    protected static final String na_str = "----";
    private int redBits = 8;
    private int greenBits = 8;
    private int blueBits = 8;
    private int alphaBits = 0;
    private boolean backgroundOpaque = true;
    private int transparentValueRed = 0;
    private int transparentValueGreen = 0;
    private int transparentValueBlue = 0;
    private int transparentValueAlpha = 0;
    private boolean onscreen = true;

    public Object cloneMutable() {
        return this.clone();
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new NativeWindowException(cloneNotSupportedException);
        }
    }

    @Override
    public int hashCode() {
        int n = 31 + this.redBits;
        n = (n << 5) - n + this.greenBits;
        n = (n << 5) - n + this.blueBits;
        n = (n << 5) - n + this.alphaBits;
        n = (n << 5) - n + (this.backgroundOpaque ? 1 : 0);
        n = (n << 5) - n + this.transparentValueRed;
        n = (n << 5) - n + this.transparentValueGreen;
        n = (n << 5) - n + this.transparentValueBlue;
        n = (n << 5) - n + this.transparentValueAlpha;
        n = (n << 5) - n + (this.onscreen ? 1 : 0);
        return n;
    }

    @Override
    public boolean equals(Object object) {
        boolean bl;
        if (this == object) {
            return true;
        }
        if (!(object instanceof CapabilitiesImmutable)) {
            return false;
        }
        CapabilitiesImmutable capabilitiesImmutable = (CapabilitiesImmutable)object;
        boolean bl2 = bl = capabilitiesImmutable.getRedBits() == this.redBits && capabilitiesImmutable.getGreenBits() == this.greenBits && capabilitiesImmutable.getBlueBits() == this.blueBits && capabilitiesImmutable.getAlphaBits() == this.alphaBits && capabilitiesImmutable.isBackgroundOpaque() == this.backgroundOpaque && capabilitiesImmutable.isOnscreen() == this.onscreen;
        if (!this.backgroundOpaque) {
            bl = bl && capabilitiesImmutable.getTransparentRedValue() == this.transparentValueRed && capabilitiesImmutable.getTransparentGreenValue() == this.transparentValueGreen && capabilitiesImmutable.getTransparentBlueValue() == this.transparentValueBlue && capabilitiesImmutable.getTransparentAlphaValue() == this.transparentValueAlpha;
        }
        return bl;
    }

    public int compareTo(Object object) {
        int n;
        int n2;
        if (!(object instanceof Capabilities)) {
            Class<?> clazz = null != object ? object.getClass() : null;
            throw new ClassCastException("Not a Capabilities object: " + clazz);
        }
        Capabilities capabilities = (Capabilities)object;
        int n3 = this.alphaBits > 0 ? this.alphaBits : 1;
        int n4 = this.redBits * this.greenBits * this.blueBits * n3;
        if (n4 > (n2 = capabilities.redBits * capabilities.greenBits * capabilities.blueBits * (n = capabilities.alphaBits > 0 ? capabilities.alphaBits : 1))) {
            return 1;
        }
        if (n4 < n2) {
            return -1;
        }
        return 0;
    }

    @Override
    public int getVisualID(VisualIDHolder.VIDType vIDType) throws NativeWindowException {
        switch (vIDType) {
            case INTRINSIC: 
            case NATIVE: {
                return 0;
            }
        }
        throw new NativeWindowException("Invalid type <" + (Object)((Object)vIDType) + ">");
    }

    @Override
    public int getRedBits() {
        return this.redBits;
    }

    public void setRedBits(int n) {
        this.redBits = n;
    }

    @Override
    public int getGreenBits() {
        return this.greenBits;
    }

    public void setGreenBits(int n) {
        this.greenBits = n;
    }

    @Override
    public int getBlueBits() {
        return this.blueBits;
    }

    public void setBlueBits(int n) {
        this.blueBits = n;
    }

    @Override
    public int getAlphaBits() {
        return this.alphaBits;
    }

    public void setAlphaBits(int n) {
        this.alphaBits = n;
    }

    public void setBackgroundOpaque(boolean bl) {
        this.backgroundOpaque = bl;
        if (!bl && this.getAlphaBits() == 0) {
            this.setAlphaBits(1);
        }
    }

    @Override
    public boolean isBackgroundOpaque() {
        return this.backgroundOpaque;
    }

    public void setOnscreen(boolean bl) {
        this.onscreen = bl;
    }

    @Override
    public boolean isOnscreen() {
        return this.onscreen;
    }

    @Override
    public int getTransparentRedValue() {
        return this.transparentValueRed;
    }

    @Override
    public int getTransparentGreenValue() {
        return this.transparentValueGreen;
    }

    @Override
    public int getTransparentBlueValue() {
        return this.transparentValueBlue;
    }

    @Override
    public int getTransparentAlphaValue() {
        return this.transparentValueAlpha;
    }

    public void setTransparentRedValue(int n) {
        this.transparentValueRed = n;
    }

    public void setTransparentGreenValue(int n) {
        this.transparentValueGreen = n;
    }

    public void setTransparentBlueValue(int n) {
        this.transparentValueBlue = n;
    }

    public void setTransparentAlphaValue(int n) {
        this.transparentValueAlpha = n;
    }

    @Override
    public StringBuilder toString(StringBuilder stringBuilder) {
        if (null == stringBuilder) {
            stringBuilder = new StringBuilder();
        }
        if (this.onscreen) {
            stringBuilder.append("on-scr");
        } else {
            stringBuilder.append("offscr");
        }
        stringBuilder.append(", rgba 0x").append(this.toHexString(this.redBits)).append("/").append(this.toHexString(this.greenBits)).append("/").append(this.toHexString(this.blueBits)).append("/").append(this.toHexString(this.alphaBits));
        if (this.backgroundOpaque) {
            stringBuilder.append(", opaque");
        } else {
            stringBuilder.append(", trans-rgba 0x").append(this.toHexString(this.transparentValueRed)).append("/").append(this.toHexString(this.transparentValueGreen)).append("/").append(this.toHexString(this.transparentValueBlue)).append("/").append(this.toHexString(this.transparentValueAlpha));
        }
        return stringBuilder;
    }

    protected final String toHexString(int n) {
        return Integer.toHexString(n);
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Caps[");
        this.toString(stringBuilder);
        stringBuilder.append("]");
        return stringBuilder.toString();
    }
}

