/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.util;

import javax.media.opengl.GL;
import javax.media.opengl.GLException;

public class FBObject {
    static final int MAX_FBO_TEXTURES = 32;
    private int[] fbo_tex_names = new int[32];
    private int[] fbo_tex_units = new int[32];
    private int fbo_tex_num = 0;
    private int colorattachment_num = 0;
    private boolean initialized = false;
    private int width;
    private int height;
    private int fb;
    private int depth_rb;
    private int stencil_rb;
    private int vStatus;
    private boolean bound;

    public FBObject(int n, int n2) {
        this.width = n;
        this.height = n2;
        this.fb = 0;
        this.depth_rb = 0;
        this.stencil_rb = 0;
        this.bound = false;
    }

    public boolean isStatusValid() {
        switch (this.vStatus) {
            case 36053: {
                return true;
            }
        }
        System.out.println("Framebuffer " + this.fb + " is incomplete: status = 0x" + Integer.toHexString(this.vStatus) + " : " + FBObject.getStatusString(this.vStatus));
        return false;
    }

    public int getStatus() {
        return this.vStatus;
    }

    public String getStatusString() {
        return FBObject.getStatusString(this.vStatus);
    }

    public static final String getStatusString(int n) {
        switch (n) {
            case -1: {
                return "NOT A FBO";
            }
            case 36053: {
                return "OK";
            }
            case 36061: {
                return "GL FBO: Unsupported framebuffer format";
            }
            case 36054: {
                return "GL FBO: incomplete, incomplete attachment\n";
            }
            case 36055: {
                return "GL FBO: incomplete, missing attachment";
            }
            case 36057: {
                return "GL FBO: incomplete, attached images must have same dimensions";
            }
            case 36058: {
                return "GL FBO: incomplete, attached images must have same format";
            }
            case 36059: {
                return "GL FBO: incomplete, missing draw buffer";
            }
            case 36060: {
                return "GL FBO: incomplete, missing read buffer";
            }
            case 36182: {
                return "GL FBO: incomplete, missing multisample buffer";
            }
            case 0: {
                return "GL FBO: incomplete, implementation fault";
            }
        }
        return "GL FBO: incomplete, implementation ERROR";
    }

    private boolean checkNoError(GL gL, int n, String string) {
        if (0 != n) {
            if (null != gL) {
                this.destroy(gL);
            }
            if (null != string) {
                throw new GLException(string + " GL Error 0x" + Integer.toHexString(n));
            }
            return false;
        }
        return true;
    }

    private final void checkInitialized() {
        if (!this.initialized) {
            throw new GLException("FBO not initialized, call init(GL) first.");
        }
    }

    private final void checkBound(GL gL, boolean bl) {
        this.checkInitialized();
        if (this.bound != bl) {
            String string = bl ? "not" : "already";
            throw new GLException("FBO " + string + " bound " + this.toString());
        }
        this.checkNoError(null, gL.glGetError(), "FBObject pre");
    }

    public void init(GL gL) throws GLException {
        if (this.initialized) {
            throw new GLException("FBO already initialized");
        }
        this.checkNoError(null, gL.glGetError(), "FBObject Init.pre");
        int[] nArray = new int[1];
        gL.glGenFramebuffers(1, nArray, 0);
        this.fb = nArray[0];
        if (this.fb == 0) {
            throw new GLException("null generated framebuffer");
        }
        gL.glBindFramebuffer(36160, this.fb);
        this.checkNoError(gL, gL.glGetError(), "FBObject Init.bindFB");
        if (!gL.glIsFramebuffer(this.fb)) {
            this.checkNoError(gL, 1281, "FBObject Init.isFB");
        }
        this.bound = true;
        this.initialized = true;
        this.updateStatus(gL);
    }

    public int attachTexture2D(GL gL, int n, int n2, int n3, int n4, int n5) throws GLException {
        int n6;
        int n7;
        int n8;
        if (gL.isGLES()) {
            n8 = 6408;
            n7 = 6408;
            n6 = 5121;
        } else {
            n8 = 32856;
            n7 = 32993;
            n6 = 33639;
        }
        return this.attachTexture2D(gL, n, n8, n7, n6, n2, n3, n4, n5);
    }

    public int attachTexture2D(GL gL, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) throws GLException {
        this.checkBound(gL, true);
        int n9 = this.fbo_tex_num;
        gL.glGenTextures(1, this.fbo_tex_names, this.fbo_tex_num);
        if (this.fbo_tex_names[n9] == 0) {
            throw new GLException("null generated texture");
        }
        this.fbo_tex_units[n9] = n;
        ++this.fbo_tex_num;
        if (0 <= n) {
            gL.glActiveTexture(33984 + n);
        }
        gL.glBindTexture(3553, this.fbo_tex_names[n9]);
        this.checkNoError(gL, gL.glGetError(), "FBObject Init.bindTex");
        gL.glTexImage2D(3553, 0, n2, this.width, this.height, 0, n3, n4, null);
        int n10 = gL.glGetError();
        if (0 != n10) {
            int[] nArray = new int[1];
            gL.glGetIntegerv(3379, nArray, 0);
            this.checkNoError(gL, n10, "FBObject Init.texImage2D:  int-fmt 0x" + Integer.toHexString(n2) + ", " + this.width + "x" + this.height + ", data-fmt 0x" + Integer.toHexString(n3) + ", data-type 0x" + Integer.toHexString(n4) + ", max tex-sz " + nArray[0]);
        }
        if (0 < n5) {
            gL.glTexParameteri(3553, 10240, n5);
        }
        if (0 < n6) {
            gL.glTexParameteri(3553, 10241, n6);
        }
        if (0 < n7) {
            gL.glTexParameteri(3553, 10242, n7);
        }
        if (0 < n8) {
            gL.glTexParameteri(3553, 10243, n8);
        }
        gL.glFramebufferTexture2D(36160, 36064 + this.colorattachment_num++, 3553, this.fbo_tex_names[n9], 0);
        this.updateStatus(gL);
        return this.isStatusValid() ? n9 : -1;
    }

    public boolean attachDepthBuffer(GL gL, int n) throws GLException {
        this.checkBound(gL, true);
        if (this.depth_rb != 0) {
            throw new GLException("FBO depth buffer already attached (rb " + this.depth_rb + ")");
        }
        int[] nArray = new int[1];
        gL.glGenRenderbuffers(1, nArray, 0);
        this.depth_rb = nArray[0];
        if (this.depth_rb == 0) {
            throw new GLException("null generated renderbuffer");
        }
        gL.glBindRenderbuffer(36161, this.depth_rb);
        if (!gL.glIsRenderbuffer(this.depth_rb)) {
            System.err.println("not a depthbuffer: " + this.depth_rb);
            nArray[0] = this.depth_rb;
            gL.glDeleteRenderbuffers(1, nArray, 0);
            this.depth_rb = 0;
            return false;
        }
        gL.glRenderbufferStorage(36161, n, this.width, this.height);
        gL.glFramebufferRenderbuffer(36160, 36096, 36161, this.depth_rb);
        this.updateStatus(gL);
        return this.isStatusValid();
    }

    public boolean attachStencilBuffer(GL gL, int n) throws GLException {
        this.checkBound(gL, true);
        if (this.stencil_rb != 0) {
            throw new GLException("FBO stencil buffer already attached (rb " + this.stencil_rb + ")");
        }
        int[] nArray = new int[1];
        gL.glGenRenderbuffers(1, nArray, 0);
        this.stencil_rb = nArray[0];
        if (this.stencil_rb == 0) {
            throw new GLException("null generated stencilbuffer");
        }
        gL.glBindRenderbuffer(36161, this.stencil_rb);
        if (!gL.glIsRenderbuffer(this.stencil_rb)) {
            System.err.println("not a stencilbuffer: " + this.stencil_rb);
            nArray[0] = this.stencil_rb;
            gL.glDeleteRenderbuffers(1, nArray, 0);
            this.stencil_rb = 0;
            return false;
        }
        gL.glRenderbufferStorage(36161, n, this.width, this.height);
        gL.glFramebufferRenderbuffer(36160, 36128, 36161, this.stencil_rb);
        this.updateStatus(gL);
        return this.isStatusValid();
    }

    public void destroy(GL gL) {
        if (this.bound) {
            this.unbind(gL);
        }
        int[] nArray = new int[1];
        if (0 != this.stencil_rb) {
            nArray[0] = this.stencil_rb;
            gL.glDeleteRenderbuffers(1, nArray, 0);
            this.stencil_rb = 0;
        }
        if (0 != this.depth_rb) {
            nArray[0] = this.depth_rb;
            gL.glDeleteRenderbuffers(1, nArray, 0);
            this.depth_rb = 0;
        }
        if (null != this.fbo_tex_names && this.fbo_tex_num > 0) {
            gL.glDeleteTextures(1, this.fbo_tex_names, this.fbo_tex_num);
            this.fbo_tex_names = new int[32];
            this.fbo_tex_units = new int[32];
            this.fbo_tex_num = 0;
        }
        this.colorattachment_num = 0;
        if (0 != this.fb) {
            nArray[0] = this.fb;
            gL.glDeleteFramebuffers(1, nArray, 0);
            this.fb = 0;
        }
        this.initialized = false;
    }

    public void bind(GL gL) {
        this.checkBound(gL, false);
        gL.glBindFramebuffer(36160, this.fb);
        this.bound = true;
    }

    public void unbind(GL gL) {
        this.checkBound(gL, true);
        gL.glBindFramebuffer(36160, 0);
        this.bound = false;
    }

    public void use(GL gL, int n) {
        this.checkBound(gL, false);
        if (n >= this.fbo_tex_num) {
            throw new GLException("Invalid texId, only " + this.fbo_tex_num + " textures are attached");
        }
        if (0 <= this.fbo_tex_units[n]) {
            gL.glActiveTexture(33984 + this.fbo_tex_units[n]);
        }
        gL.glBindTexture(3553, this.fbo_tex_names[n]);
    }

    public void unuse(GL gL) {
        this.checkBound(gL, false);
        gL.glBindTexture(3553, 0);
    }

    public final boolean isBound() {
        return this.bound;
    }

    public final int getWidth() {
        return this.width;
    }

    public final int getHeight() {
        return this.height;
    }

    public final int getFBName() {
        return this.fb;
    }

    public final int getTextureNumber() {
        return this.fbo_tex_num;
    }

    public final int getTextureName(int n) {
        return this.fbo_tex_names[n];
    }

    public final int getTextureUnit(int n) {
        return this.fbo_tex_units[n];
    }

    public final int getColorAttachmentNumber() {
        return this.colorattachment_num;
    }

    public final int getStencilBuffer() {
        return this.stencil_rb;
    }

    public final int getDepthBuffer() {
        return this.depth_rb;
    }

    public final String toString() {
        return "FBO[name " + this.fb + ", size " + this.width + "x" + this.height + ", color num " + this.colorattachment_num + ", tex num " + this.fbo_tex_num + ", depth " + this.depth_rb + ", stencil " + this.stencil_rb + "]";
    }

    private void updateStatus(GL gL) {
        this.vStatus = !gL.glIsFramebuffer(this.fb) ? -1 : gL.glCheckFramebufferStatus(36160);
    }
}

