/*
 * Decompiled with CFR 0.152.
 */
package jogamp.nativewindow.x11.awt;

import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import javax.media.nativewindow.AbstractGraphicsConfiguration;
import javax.media.nativewindow.AbstractGraphicsScreen;
import javax.media.nativewindow.CapabilitiesChooser;
import javax.media.nativewindow.CapabilitiesImmutable;
import javax.media.nativewindow.GraphicsConfigurationFactory;
import javax.media.nativewindow.NativeWindowException;
import javax.media.nativewindow.NativeWindowFactory;
import javax.media.nativewindow.ToolkitLock;
import javax.media.nativewindow.awt.AWTGraphicsConfiguration;
import javax.media.nativewindow.awt.AWTGraphicsDevice;
import javax.media.nativewindow.awt.AWTGraphicsScreen;
import javax.media.nativewindow.x11.X11GraphicsConfiguration;
import javax.media.nativewindow.x11.X11GraphicsDevice;
import javax.media.nativewindow.x11.X11GraphicsScreen;
import jogamp.nativewindow.jawt.x11.X11SunJDKReflection;
import jogamp.nativewindow.x11.X11Lib;
import jogamp.nativewindow.x11.X11Util;

public class X11AWTGraphicsConfigurationFactory
extends GraphicsConfigurationFactory {
    public static void registerFactory() {
        GraphicsConfigurationFactory.registerFactory(AWTGraphicsDevice.class, new X11AWTGraphicsConfigurationFactory());
    }

    private X11AWTGraphicsConfigurationFactory() {
    }

    @Override
    protected AbstractGraphicsConfiguration chooseGraphicsConfigurationImpl(CapabilitiesImmutable capabilitiesImmutable, CapabilitiesImmutable capabilitiesImmutable2, CapabilitiesChooser capabilitiesChooser, AbstractGraphicsScreen abstractGraphicsScreen) {
        if (abstractGraphicsScreen != null && !(abstractGraphicsScreen instanceof AWTGraphicsScreen)) {
            throw new IllegalArgumentException("This GraphicsConfigurationFactory accepts only AWTGraphicsScreen objects");
        }
        if (null == abstractGraphicsScreen) {
            abstractGraphicsScreen = AWTGraphicsScreen.createDefault();
        }
        return X11AWTGraphicsConfigurationFactory.chooseGraphicsConfigurationStatic(capabilitiesImmutable, capabilitiesImmutable2, capabilitiesChooser, (AWTGraphicsScreen)abstractGraphicsScreen);
    }

    public static AWTGraphicsConfiguration chooseGraphicsConfigurationStatic(CapabilitiesImmutable capabilitiesImmutable, CapabilitiesImmutable capabilitiesImmutable2, CapabilitiesChooser capabilitiesChooser, AWTGraphicsScreen aWTGraphicsScreen) {
        GraphicsConfigurationFactory graphicsConfigurationFactory;
        X11GraphicsConfiguration x11GraphicsConfiguration;
        Object object;
        if (DEBUG) {
            System.err.println("X11AWTGraphicsConfigurationFactory: got " + aWTGraphicsScreen);
        }
        GraphicsDevice graphicsDevice = ((AWTGraphicsDevice)aWTGraphicsScreen.getDevice()).getGraphicsDevice();
        long l = X11SunJDKReflection.graphicsDeviceGetDisplay(graphicsDevice);
        boolean bl = false;
        if (0L == l) {
            l = X11Util.openDisplay(null);
            bl = true;
            if (DEBUG) {
                System.err.println(Thread.currentThread().getName() + " - X11AWTGraphicsConfigurationFactory: create local X11 display");
            }
        } else {
            object = X11Lib.XDisplayString(l);
            if (DEBUG) {
                System.err.println(Thread.currentThread().getName() + " - X11AWTGraphicsConfigurationFactory: create X11 display @ " + (String)object + " / 0x" + Long.toHexString(l));
            }
            l = X11Util.openDisplay((String)object);
            bl = true;
        }
        object = bl ? NativeWindowFactory.getDefaultToolkitLock("AWT") : NativeWindowFactory.createDefaultToolkitLock("X11", "AWT", l);
        X11GraphicsDevice x11GraphicsDevice = new X11GraphicsDevice(l, 0, (ToolkitLock)object, bl);
        X11GraphicsScreen x11GraphicsScreen = new X11GraphicsScreen(x11GraphicsDevice, aWTGraphicsScreen.getIndex());
        if (DEBUG) {
            System.err.println("X11AWTGraphicsConfigurationFactory: made " + x11GraphicsScreen);
        }
        if ((x11GraphicsConfiguration = (X11GraphicsConfiguration)(graphicsConfigurationFactory = GraphicsConfigurationFactory.getFactory(x11GraphicsDevice)).chooseGraphicsConfiguration(capabilitiesImmutable, capabilitiesImmutable2, capabilitiesChooser, x11GraphicsScreen)) == null) {
            throw new NativeWindowException("Unable to choose a GraphicsConfiguration (1): " + capabilitiesImmutable + ",\n\t" + capabilitiesChooser + "\n\t" + x11GraphicsScreen);
        }
        if (DEBUG) {
            System.err.println("X11AWTGraphicsConfigurationFactory: chosen x11Config: " + x11GraphicsConfiguration);
        }
        GraphicsConfiguration[] graphicsConfigurationArray = graphicsDevice.getConfigurations();
        long l2 = x11GraphicsConfiguration.getVisualID();
        for (int i = 0; i < graphicsConfigurationArray.length; ++i) {
            GraphicsConfiguration graphicsConfiguration = graphicsConfigurationArray[i];
            if (graphicsConfiguration == null || (long)X11SunJDKReflection.graphicsConfigurationGetVisualID(graphicsConfiguration) != l2) continue;
            if (DEBUG) {
                System.err.println("Found matching AWT visual: 0x" + Long.toHexString(l2) + " -> " + x11GraphicsConfiguration);
            }
            return new AWTGraphicsConfiguration(aWTGraphicsScreen, x11GraphicsConfiguration.getChosenCapabilities(), x11GraphicsConfiguration.getRequestedCapabilities(), graphicsConfiguration, x11GraphicsConfiguration);
        }
        GraphicsConfiguration graphicsConfiguration = graphicsDevice.getDefaultConfiguration();
        x11GraphicsConfiguration = (X11GraphicsConfiguration)graphicsConfigurationFactory.chooseGraphicsConfiguration(capabilitiesImmutable = AWTGraphicsConfiguration.setupCapabilitiesRGBABits(capabilitiesImmutable, graphicsConfiguration), capabilitiesImmutable2, capabilitiesChooser, x11GraphicsScreen);
        if (x11GraphicsConfiguration == null) {
            throw new NativeWindowException("Unable to choose a GraphicsConfiguration (2): " + capabilitiesImmutable + ",\n\t" + capabilitiesChooser + "\n\t" + x11GraphicsScreen);
        }
        l2 = x11GraphicsConfiguration.getVisualID();
        for (int i = 0; i < graphicsConfigurationArray.length; ++i) {
            graphicsConfiguration = graphicsConfigurationArray[i];
            if ((long)X11SunJDKReflection.graphicsConfigurationGetVisualID(graphicsConfiguration) != l2) continue;
            if (DEBUG) {
                System.err.println("Found matching default AWT visual: 0x" + Long.toHexString(l2) + " -> " + x11GraphicsConfiguration);
            }
            return new AWTGraphicsConfiguration(aWTGraphicsScreen, x11GraphicsConfiguration.getChosenCapabilities(), x11GraphicsConfiguration.getRequestedCapabilities(), graphicsConfiguration, x11GraphicsConfiguration);
        }
        if (DEBUG) {
            System.err.println("!!! Using default configuration");
        }
        graphicsConfiguration = graphicsDevice.getDefaultConfiguration();
        return new AWTGraphicsConfiguration(aWTGraphicsScreen, x11GraphicsConfiguration.getChosenCapabilities(), x11GraphicsConfiguration.getRequestedCapabilities(), graphicsConfiguration, x11GraphicsConfiguration);
    }
}

