/*
 * Decompiled with CFR 0.152.
 */
package jogamp.nativewindow.jawt.macosx;

import java.nio.Buffer;
import java.security.AccessController;
import java.security.PrivilegedAction;
import javax.media.nativewindow.AbstractGraphicsConfiguration;
import javax.media.nativewindow.Capabilities;
import javax.media.nativewindow.NativeWindowException;
import javax.media.nativewindow.SurfaceChangeable;
import javax.media.nativewindow.util.Point;
import jogamp.nativewindow.MutableGraphicsConfiguration;
import jogamp.nativewindow.jawt.JAWT;
import jogamp.nativewindow.jawt.JAWTUtil;
import jogamp.nativewindow.jawt.JAWTWindow;
import jogamp.nativewindow.jawt.JAWT_DrawingSurface;
import jogamp.nativewindow.jawt.JAWT_DrawingSurfaceInfo;
import jogamp.nativewindow.jawt.macosx.JAWT_MacOSXDrawingSurfaceInfo;
import jogamp.nativewindow.macosx.OSXUtil;

public class MacOSXJAWTWindow
extends JAWTWindow
implements SurfaceChangeable {
    private JAWT_DrawingSurface ds;
    private boolean dsLocked;
    private JAWT_DrawingSurfaceInfo dsi;
    private JAWT_MacOSXDrawingSurfaceInfo macosxdsi;
    private long rootSurfaceLayerHandle = 0L;
    private long surfaceHandle = 0L;
    private int sscWidth;
    private int sscHeight;
    private boolean sscSet = false;
    private boolean firstLock = true;

    public MacOSXJAWTWindow(Object object, AbstractGraphicsConfiguration abstractGraphicsConfiguration) {
        super(object, abstractGraphicsConfiguration);
        if (DEBUG) {
            this.dumpInfo();
        }
    }

    @Override
    protected void invalidateNative() {
        this.surfaceHandle = 0L;
        if (this.isOffscreenLayerSurfaceEnabled() && 0L != this.drawable) {
            OSXUtil.DestroyNSWindow(this.drawable);
            this.drawable = 0L;
        }
    }

    @Override
    protected void attachSurfaceLayerImpl(long l) {
        OSXUtil.AddCASublayer(this.rootSurfaceLayerHandle, l);
    }

    @Override
    protected void detachSurfaceLayerImpl(long l) {
        OSXUtil.RemoveCASublayer(this.rootSurfaceLayerHandle, l);
    }

    @Override
    public long getSurfaceHandle() {
        return this.isOffscreenLayerSurfaceEnabled() ? this.surfaceHandle : super.getSurfaceHandle();
    }

    @Override
    public void setSurfaceHandle(long l) {
        if (!this.isOffscreenLayerSurfaceEnabled()) {
            throw new UnsupportedOperationException("Not using CALAYER");
        }
        if (DEBUG) {
            System.err.println("MacOSXJAWTWindow.setSurfaceHandle(): 0x" + Long.toHexString(l));
        }
        this.sscSet &= 0L != l;
        this.surfaceHandle = l;
    }

    @Override
    public void surfaceSizeChanged(int n, int n2) {
        this.sscSet = true;
        this.sscWidth = n;
        this.sscHeight = n2;
    }

    @Override
    public int getWidth() {
        return this.sscSet ? this.sscWidth : super.getWidth();
    }

    @Override
    public int getHeight() {
        return this.sscSet ? this.sscHeight : super.getHeight();
    }

    @Override
    protected JAWT fetchJAWTImpl() throws NativeWindowException {
        return JAWTUtil.getJAWT(this.getShallUseOffscreenLayer() || this.isApplet());
    }

    @Override
    protected int lockSurfaceImpl() throws NativeWindowException {
        int n;
        int n2 = 1;
        if (null == this.ds) {
            this.ds = this.getJAWT().GetDrawingSurface(this.component);
            if (this.ds == null) {
                this.unlockSurfaceImpl();
                return 1;
            }
        }
        boolean bl = this.dsLocked = 0 == ((n = this.ds.Lock()) & 1);
        if (!this.dsLocked) {
            this.unlockSurfaceImpl();
            throw new NativeWindowException("Unable to lock surface");
        }
        if ((n & 8) != 0) {
            n2 = 2;
        }
        if (null == this.dsi) {
            if (this.firstLock) {
                AccessController.doPrivileged(new PrivilegedAction<Object>(){

                    @Override
                    public Object run() {
                        MacOSXJAWTWindow.this.dsi = MacOSXJAWTWindow.this.ds.GetDrawingSurfaceInfo();
                        return null;
                    }
                });
            } else {
                this.dsi = this.ds.GetDrawingSurfaceInfo();
            }
            if (this.dsi == null) {
                this.unlockSurfaceImpl();
                return 1;
            }
        }
        this.updateBounds(this.dsi.getBounds());
        if (DEBUG && this.firstLock) {
            this.dumpInfo();
        }
        this.firstLock = false;
        if (!this.isOffscreenLayerSurfaceEnabled()) {
            this.macosxdsi = (JAWT_MacOSXDrawingSurfaceInfo)this.dsi.platformInfo(this.getJAWT());
            if (this.macosxdsi == null) {
                this.unlockSurfaceImpl();
                return 1;
            }
            this.drawable = this.macosxdsi.getCocoaViewRef();
            if (this.drawable == 0L) {
                this.unlockSurfaceImpl();
                return 1;
            }
            n2 = 3;
        } else {
            if (0L == this.drawable) {
                this.drawable = OSXUtil.CreateNSWindow(0, 0, this.getBounds().getWidth(), this.getBounds().getHeight());
                if (0L == this.drawable) {
                    this.unlockSurfaceImpl();
                    throw new NativeWindowException("Unable to created dummy NSWindow (layered case)");
                }
                Capabilities capabilities = (Capabilities)this.getPrivateGraphicsConfiguration().getChosenCapabilities().cloneMutable();
                capabilities.setOnscreen(false);
                this.getPrivateGraphicsConfiguration().setChosenCapabilities(capabilities);
                capabilities = (Capabilities)this.getGraphicsConfiguration().getChosenCapabilities().cloneMutable();
                capabilities.setOnscreen(false);
                ((MutableGraphicsConfiguration)this.getGraphicsConfiguration()).setChosenCapabilities(capabilities);
            }
            if (0L == this.rootSurfaceLayerHandle) {
                this.rootSurfaceLayerHandle = OSXUtil.CreateCALayer();
                if (0L == this.rootSurfaceLayerHandle) {
                    OSXUtil.DestroyNSWindow(this.drawable);
                    this.drawable = 0L;
                    this.unlockSurfaceImpl();
                    throw new NativeWindowException("Could not create root CALayer: " + this);
                }
                if (!MacOSXJAWTWindow.AttachJAWTSurfaceLayer(this.dsi, this.rootSurfaceLayerHandle)) {
                    OSXUtil.DestroyCALayer(this.rootSurfaceLayerHandle);
                    this.rootSurfaceLayerHandle = 0L;
                    OSXUtil.DestroyNSWindow(this.drawable);
                    this.drawable = 0L;
                    this.unlockSurfaceImpl();
                    throw new NativeWindowException("Could not attach JAWT surfaceLayerHandle: " + this);
                }
            }
            n2 = 3;
        }
        return n2;
    }

    @Override
    protected void unlockSurfaceImpl() throws NativeWindowException {
        if (null != this.ds) {
            if (null != this.dsi) {
                this.ds.FreeDrawingSurfaceInfo(this.dsi);
            }
            if (this.dsLocked) {
                this.ds.Unlock();
            }
            this.getJAWT().FreeDrawingSurface(this.ds);
        }
        this.ds = null;
        this.dsi = null;
    }

    private void dumpInfo() {
        System.err.println("MaxOSXJAWTWindow: 0x" + Integer.toHexString(this.hashCode()) + " - thread: " + Thread.currentThread().getName());
        if (null != this.getJAWT()) {
            System.err.println("JAWT version: 0x" + Integer.toHexString(this.getJAWT().getCachedVersion()) + ", CA_LAYER: " + JAWTUtil.isJAWTUsingOffscreenLayer(this.getJAWT()) + ", isLayeredSurface " + this.isOffscreenLayerSurfaceEnabled() + ", bounds " + this.bounds + ", insets " + this.insets);
        } else {
            System.err.println("JAWT n/a, bounds " + this.bounds + ", insets " + this.insets);
        }
    }

    @Override
    public Point getLocationOnScreen(Point point) {
        return MacOSXJAWTWindow.getLocationOnScreenNonBlocking(point, this.component);
    }

    @Override
    protected Point getLocationOnScreenNativeImpl(int n, int n2) {
        return null;
    }

    private static boolean AttachJAWTSurfaceLayer(JAWT_DrawingSurfaceInfo jAWT_DrawingSurfaceInfo, long l) {
        if (0L == l) {
            throw new IllegalArgumentException("caLayer 0x" + Long.toHexString(l));
        }
        return MacOSXJAWTWindow.AttachJAWTSurfaceLayer0(jAWT_DrawingSurfaceInfo.getBuffer(), l);
    }

    private static native boolean AttachJAWTSurfaceLayer0(Buffer var0, long var1);
}

