/*
 * Decompiled with CFR 0.152.
 */
package javax.media.opengl.awt;

import com.jogamp.common.GlueGenVersion;
import com.jogamp.common.util.VersionUtil;
import com.jogamp.common.util.locks.LockFactory;
import com.jogamp.common.util.locks.RecursiveLock;
import com.jogamp.opengl.JoglVersion;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.EventQueue;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.geom.Rectangle2D;
import java.beans.Beans;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.List;
import javax.media.nativewindow.AbstractGraphicsDevice;
import javax.media.nativewindow.AbstractGraphicsScreen;
import javax.media.nativewindow.GraphicsConfigurationFactory;
import javax.media.nativewindow.NativeSurface;
import javax.media.nativewindow.NativeWindowFactory;
import javax.media.nativewindow.OffscreenLayerOption;
import javax.media.nativewindow.WindowClosingProtocol;
import javax.media.nativewindow.awt.AWTGraphicsConfiguration;
import javax.media.nativewindow.awt.AWTGraphicsDevice;
import javax.media.nativewindow.awt.AWTGraphicsScreen;
import javax.media.nativewindow.awt.AWTWindowClosingProtocol;
import javax.media.opengl.GL;
import javax.media.opengl.GLAnimatorControl;
import javax.media.opengl.GLAutoDrawable;
import javax.media.opengl.GLCapabilities;
import javax.media.opengl.GLCapabilitiesChooser;
import javax.media.opengl.GLCapabilitiesImmutable;
import javax.media.opengl.GLContext;
import javax.media.opengl.GLDrawable;
import javax.media.opengl.GLDrawableFactory;
import javax.media.opengl.GLEventListener;
import javax.media.opengl.GLException;
import javax.media.opengl.GLProfile;
import javax.media.opengl.GLRunnable;
import javax.media.opengl.Threading;
import javax.media.opengl.awt.AWTGLAutoDrawable;
import javax.swing.SwingUtilities;
import jogamp.nativewindow.jawt.JAWTWindow;
import jogamp.opengl.Debug;
import jogamp.opengl.GLContextImpl;
import jogamp.opengl.GLDrawableHelper;
import jogamp.opengl.ThreadingImpl;

public class GLCanvas
extends Canvas
implements AWTGLAutoDrawable,
WindowClosingProtocol,
OffscreenLayerOption {
    private static final boolean DEBUG = Debug.debug("GLCanvas");
    private GLDrawableHelper drawableHelper = new GLDrawableHelper();
    private AWTGraphicsConfiguration awtConfig;
    private GLDrawable drawable;
    private GLContextImpl context;
    private boolean sendReshape = false;
    private GLCapabilitiesImmutable capsReqUser;
    private GLCapabilitiesChooser chooser;
    private GLContext shareWith;
    private int additionalCtxCreationFlags = 0;
    private GraphicsDevice device;
    private boolean shallUseOffscreenLayer = false;
    private AWTWindowClosingProtocol awtWindowClosingProtocol = new AWTWindowClosingProtocol(this, new Runnable(){

        @Override
        public void run() {
            GLCanvas.this.destroy();
        }
    });
    RecursiveLock drawableSync = LockFactory.createRecursiveLock();
    private boolean disposeRegenerate;
    private DisposeAction disposeAction = new DisposeAction();
    private DisposeOnEventDispatchThreadAction disposeOnEventDispatchThreadAction = new DisposeOnEventDispatchThreadAction();
    private DisposeAbstractGraphicsDeviceAction disposeAbstractGraphicsDeviceAction = new DisposeAbstractGraphicsDeviceAction();
    private InitAction initAction = new InitAction();
    private DisplayAction displayAction = new DisplayAction();
    private SwapBuffersAction swapBuffersAction = new SwapBuffersAction();
    private DisplayOnEventDispatchThreadAction displayOnEventDispatchThreadAction = new DisplayOnEventDispatchThreadAction();
    private SwapBuffersOnEventDispatchThreadAction swapBuffersOnEventDispatchThreadAction = new SwapBuffersOnEventDispatchThreadAction();
    private static boolean disableBackgroundEraseInitialized;
    private static Method disableBackgroundEraseMethod;

    public GLCanvas() throws GLException {
        this((GLCapabilitiesImmutable)null);
    }

    public GLCanvas(GLCapabilitiesImmutable gLCapabilitiesImmutable) throws GLException {
        this(gLCapabilitiesImmutable, null, null, null);
    }

    public GLCanvas(GLCapabilitiesImmutable gLCapabilitiesImmutable, GLContext gLContext) throws GLException {
        this(gLCapabilitiesImmutable, null, gLContext, null);
    }

    public GLCanvas(GLCapabilitiesImmutable gLCapabilitiesImmutable, GLCapabilitiesChooser gLCapabilitiesChooser, GLContext gLContext, GraphicsDevice graphicsDevice) throws GLException {
        GraphicsConfiguration graphicsConfiguration;
        gLCapabilitiesImmutable = null == gLCapabilitiesImmutable ? new GLCapabilities(GLProfile.getDefault(GLProfile.getDefaultDesktopDevice())) : (GLCapabilitiesImmutable)gLCapabilitiesImmutable.cloneMutable();
        if (null == graphicsDevice && null != (graphicsConfiguration = super.getGraphicsConfiguration())) {
            graphicsDevice = graphicsConfiguration.getDevice();
        }
        this.capsReqUser = gLCapabilitiesImmutable;
        this.chooser = gLCapabilitiesChooser;
        this.shareWith = gLContext;
        this.device = graphicsDevice;
    }

    @Override
    public void setShallUseOffscreenLayer(boolean bl) {
        this.shallUseOffscreenLayer = bl;
    }

    @Override
    public final boolean getShallUseOffscreenLayer() {
        return this.shallUseOffscreenLayer;
    }

    @Override
    public final boolean isOffscreenLayerSurfaceEnabled() {
        if (null != this.drawable) {
            return ((JAWTWindow)this.drawable.getNativeSurface()).isOffscreenLayerSurfaceEnabled();
        }
        return false;
    }

    @Override
    public GraphicsConfiguration getGraphicsConfiguration() {
        GraphicsConfiguration graphicsConfiguration = super.getGraphicsConfiguration();
        GraphicsConfiguration graphicsConfiguration2 = this.awtConfig.getAWTGraphicsConfiguration();
        if (graphicsConfiguration != null && graphicsConfiguration2 != null && !graphicsConfiguration2.equals(graphicsConfiguration)) {
            if (!graphicsConfiguration2.getDevice().getIDstring().equals(graphicsConfiguration.getDevice().getIDstring())) {
                AWTGraphicsConfiguration aWTGraphicsConfiguration = this.chooseGraphicsConfiguration((GLCapabilitiesImmutable)this.awtConfig.getChosenCapabilities(), (GLCapabilitiesImmutable)this.awtConfig.getRequestedCapabilities(), this.chooser, graphicsConfiguration.getDevice());
                GraphicsConfiguration graphicsConfiguration3 = null != aWTGraphicsConfiguration ? aWTGraphicsConfiguration.getAWTGraphicsConfiguration() : null;
                boolean bl = ((Object)aWTGraphicsConfiguration.getChosenCapabilities()).equals(this.awtConfig.getChosenCapabilities());
                if (DEBUG) {
                    Exception exception = new Exception("Info: Call Stack: " + Thread.currentThread().getName());
                    exception.printStackTrace();
                    System.err.println("!!! Created Config (n): HAVE    GC " + graphicsConfiguration2);
                    System.err.println("!!! Created Config (n): THIS    GC " + graphicsConfiguration);
                    System.err.println("!!! Created Config (n): Choosen GC " + graphicsConfiguration3);
                    System.err.println("!!! Created Config (n): HAVE    CF " + this.awtConfig);
                    System.err.println("!!! Created Config (n): Choosen CF " + aWTGraphicsConfiguration);
                    System.err.println("!!! Created Config (n): EQUALS CAPS " + bl);
                }
                if (graphicsConfiguration3 != null) {
                    graphicsConfiguration2 = graphicsConfiguration3;
                    this.awtConfig = aWTGraphicsConfiguration;
                    if (!bl && GLAutoDrawable.SCREEN_CHANGE_ACTION_ENABLED) {
                        this.dispose(true);
                    }
                }
            }
            return graphicsConfiguration2;
        }
        if (graphicsConfiguration == null) {
            return graphicsConfiguration2;
        }
        return graphicsConfiguration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GLContext createContext(GLContext gLContext) {
        this.drawableSync.lock();
        try {
            GLContext gLContext2 = null != this.drawable ? this.drawable.createContext(gLContext) : null;
            return gLContext2;
        }
        finally {
            this.drawableSync.unlock();
        }
    }

    @Override
    public void setRealized(boolean bl) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isRealized() {
        this.drawableSync.lock();
        try {
            boolean bl = null != this.drawable ? this.drawable.isRealized() : false;
            return bl;
        }
        finally {
            this.drawableSync.unlock();
        }
    }

    @Override
    public int getDefaultCloseOperation() {
        return this.awtWindowClosingProtocol.getDefaultCloseOperation();
    }

    @Override
    public int setDefaultCloseOperation(int n) {
        return this.awtWindowClosingProtocol.setDefaultCloseOperation(n);
    }

    @Override
    public void display() {
        if (!this.validateGLDrawable()) {
            if (DEBUG) {
                System.err.println("Info: GLCanvas display - skipped GL render, drawable not valid yet");
            }
            return;
        }
        this.maybeDoSingleThreadedWorkaround(this.displayOnEventDispatchThreadAction, this.displayAction);
        this.awtWindowClosingProtocol.addClosingListenerOneShot();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dispose(boolean bl) {
        this.drawableSync.lock();
        try {
            GLAnimatorControl gLAnimatorControl = this.getAnimator();
            if (DEBUG) {
                Exception exception = new Exception("Info: dispose(" + bl + ") - START, hasContext " + (null != this.context) + ", hasDrawable " + (null != this.drawable) + ", " + gLAnimatorControl);
                exception.printStackTrace();
            }
            if (null != this.context) {
                boolean bl2 = false;
                if (null != gLAnimatorControl) {
                    bl2 = gLAnimatorControl.pause();
                }
                this.disposeRegenerate = bl;
                if (Threading.isSingleThreaded() && !Threading.isOpenGLThread()) {
                    if (ThreadingImpl.isAWTMode() && Thread.holdsLock(this.getTreeLock())) {
                        if (this.context.isCreated()) {
                            this.drawableHelper.invokeGL(this.drawable, this.context, this.disposeAction, null);
                        }
                    } else if (this.context.isCreated()) {
                        Threading.invokeOnOpenGLThread(this.disposeOnEventDispatchThreadAction);
                    }
                } else if (this.context.isCreated()) {
                    this.drawableHelper.invokeGL(this.drawable, this.context, this.disposeAction, null);
                }
                if (bl2) {
                    gLAnimatorControl.resume();
                }
            }
            if (!bl) {
                this.disposeAbstractGraphicsDevice();
            }
            if (DEBUG) {
                System.err.println("dispose(" + bl + ") - END, " + gLAnimatorControl);
            }
        }
        finally {
            this.drawableSync.unlock();
        }
    }

    @Override
    public void destroy() {
        this.removeNotify();
    }

    @Override
    public void paint(Graphics graphics) {
        if (Beans.isDesignTime()) {
            int n;
            graphics.setColor(Color.BLACK);
            graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
            FontMetrics fontMetrics = graphics.getFontMetrics();
            String string = this.getName();
            if (string == null && (n = (string = this.getClass().getName()).lastIndexOf(46)) >= 0) {
                string = string.substring(n + 1);
            }
            Rectangle2D rectangle2D = fontMetrics.getStringBounds(string, graphics);
            graphics.setColor(Color.WHITE);
            graphics.drawString(string, (int)(((double)this.getWidth() - rectangle2D.getWidth()) / 2.0), (int)(((double)this.getHeight() + rectangle2D.getHeight()) / 2.0));
            return;
        }
        if (!this.drawableHelper.isAnimatorAnimating()) {
            this.display();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addNotify() {
        if (DEBUG) {
            Exception exception = new Exception(Thread.currentThread().getName() + " - Info: addNotify - start, bounds: " + this.getBounds());
            exception.printStackTrace();
        }
        this.drawableSync.lock();
        try {
            this.awtConfig = this.chooseGraphicsConfiguration(this.capsReqUser, this.capsReqUser, this.chooser, this.device);
            if (null == this.awtConfig) {
                throw new GLException("Error: NULL AWTGraphicsConfiguration");
            }
            this.disableBackgroundErase();
            super.addNotify();
            this.disableBackgroundErase();
            if (!Beans.isDesignTime()) {
                this.createDrawableAndContext();
            }
            if (DEBUG) {
                System.err.println(Thread.currentThread().getName() + " - Info: addNotify - end: peer: " + this.getPeer());
            }
        }
        finally {
            this.drawableSync.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createDrawableAndContext() {
        JAWTWindow jAWTWindow = (JAWTWindow)NativeWindowFactory.getNativeWindow(this, this.awtConfig);
        jAWTWindow.setShallUseOffscreenLayer(this.shallUseOffscreenLayer);
        jAWTWindow.lockSurface();
        try {
            this.drawable = GLDrawableFactory.getFactory(this.capsReqUser.getGLProfile()).createGLDrawable(jAWTWindow);
            this.context = (GLContextImpl)this.drawable.createContext(this.shareWith);
            this.context.setSynchronized(true);
            this.context.setContextCreationFlags(this.additionalCtxCreationFlags);
        }
        finally {
            jAWTWindow.unlockSurface();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean validateGLDrawable() {
        boolean bl = false;
        if (!Beans.isDesignTime()) {
            this.drawableSync.lock();
            try {
                if (null != this.drawable && !(bl = this.drawable.isRealized()) && 0 < this.drawable.getWidth() * this.drawable.getHeight()) {
                    this.drawable.setRealized(true);
                    bl = true;
                    this.sendReshape = true;
                    if (DEBUG) {
                        String string = Thread.currentThread().getName() + " - Realized Drawable: " + ((Object)this.drawable).toString();
                        Throwable throwable = new Throwable(string);
                        throwable.printStackTrace();
                    }
                }
            }
            finally {
                this.drawableSync.unlock();
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeNotify() {
        if (DEBUG) {
            Exception exception = new Exception(Thread.currentThread().getName() + " - Info: removeNotify - start");
            exception.printStackTrace();
        }
        this.awtWindowClosingProtocol.removeClosingListener();
        if (Beans.isDesignTime()) {
            super.removeNotify();
        } else {
            this.drawableSync.lock();
            try {
                this.dispose(false);
            }
            finally {
                this.context = null;
                this.drawable = null;
                this.awtConfig = null;
                super.removeNotify();
                this.drawableSync.unlock();
            }
        }
        if (DEBUG) {
            System.err.println(Thread.currentThread().getName() + " - Info: removeNotify - end, peer: " + this.getPeer());
        }
    }

    @Override
    public void reshape(int n, int n2, int n3, int n4) {
        super.reshape(n, n2, n3, n4);
        if (null != this.drawable && this.drawable.isRealized() && !this.drawable.getChosenGLCapabilities().isOnscreen()) {
            this.dispose(true);
        } else {
            this.sendReshape = true;
        }
    }

    @Override
    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    @Override
    public void addGLEventListener(GLEventListener gLEventListener) {
        this.drawableHelper.addGLEventListener(gLEventListener);
    }

    @Override
    public void addGLEventListener(int n, GLEventListener gLEventListener) {
        this.drawableHelper.addGLEventListener(n, gLEventListener);
    }

    @Override
    public void removeGLEventListener(GLEventListener gLEventListener) {
        this.drawableHelper.removeGLEventListener(gLEventListener);
    }

    @Override
    public void setAnimator(GLAnimatorControl gLAnimatorControl) {
        this.drawableHelper.setAnimator(gLAnimatorControl);
    }

    @Override
    public GLAnimatorControl getAnimator() {
        return this.drawableHelper.getAnimator();
    }

    @Override
    public void invoke(boolean bl, GLRunnable gLRunnable) {
        this.drawableHelper.invoke(this, bl, gLRunnable);
    }

    @Override
    public void setContext(GLContext gLContext) {
        this.context = (GLContextImpl)gLContext;
        if (null != this.context) {
            this.context.setContextCreationFlags(this.additionalCtxCreationFlags);
        }
    }

    @Override
    public GLContext getContext() {
        return this.context;
    }

    @Override
    public GL getGL() {
        if (Beans.isDesignTime()) {
            return null;
        }
        GLContext gLContext = this.getContext();
        return gLContext == null ? null : gLContext.getGL();
    }

    @Override
    public GL setGL(GL gL) {
        GLContext gLContext = this.getContext();
        if (gLContext != null) {
            gLContext.setGL(gL);
            return gL;
        }
        return null;
    }

    @Override
    public void setAutoSwapBufferMode(boolean bl) {
        this.drawableHelper.setAutoSwapBufferMode(bl);
    }

    @Override
    public boolean getAutoSwapBufferMode() {
        return this.drawableHelper.getAutoSwapBufferMode();
    }

    @Override
    public void swapBuffers() {
        this.maybeDoSingleThreadedWorkaround(this.swapBuffersOnEventDispatchThreadAction, this.swapBuffersAction);
    }

    @Override
    public void setContextCreationFlags(int n) {
        this.additionalCtxCreationFlags = n;
    }

    @Override
    public int getContextCreationFlags() {
        return this.additionalCtxCreationFlags;
    }

    @Override
    public GLProfile getGLProfile() {
        return this.capsReqUser.getGLProfile();
    }

    @Override
    public GLCapabilitiesImmutable getChosenGLCapabilities() {
        if (this.awtConfig == null) {
            throw new GLException("No AWTGraphicsConfiguration: " + this);
        }
        return (GLCapabilitiesImmutable)this.awtConfig.getChosenCapabilities();
    }

    public GLCapabilitiesImmutable getRequestedGLCapabilities() {
        if (this.awtConfig == null) {
            return this.capsReqUser;
        }
        return (GLCapabilitiesImmutable)this.awtConfig.getRequestedCapabilities();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NativeSurface getNativeSurface() {
        this.drawableSync.lock();
        try {
            NativeSurface nativeSurface = null != this.drawable ? this.drawable.getNativeSurface() : null;
            return nativeSurface;
        }
        finally {
            this.drawableSync.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getHandle() {
        this.drawableSync.lock();
        try {
            long l = null != this.drawable ? this.drawable.getHandle() : 0L;
            return l;
        }
        finally {
            this.drawableSync.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GLDrawableFactory getFactory() {
        this.drawableSync.lock();
        try {
            GLDrawableFactory gLDrawableFactory = null != this.drawable ? this.drawable.getFactory() : null;
            return gLDrawableFactory;
        }
        finally {
            this.drawableSync.unlock();
        }
    }

    @Override
    public String toString() {
        int n = null != this.drawable ? this.drawable.getWidth() : -1;
        int n2 = null != this.drawable ? this.drawable.getHeight() : -1;
        return "AWT-GLCanvas[Realized " + this.isRealized() + ",\n\t" + (null != this.drawable ? this.drawable.getClass().getName() : "null-drawable") + ",\n\tRealized " + this.isRealized() + ",\n\tFactory   " + this.getFactory() + ",\n\thandle    0x" + Long.toHexString(this.getHandle()) + ",\n\tDrawable size " + n + "x" + n2 + ",\n\tAWT pos " + this.getX() + "/" + this.getY() + ", size " + this.getWidth() + "x" + this.getHeight() + ",\n\tvisible " + this.isVisible() + ",\n\t" + this.awtConfig + "]";
    }

    private void maybeDoSingleThreadedWorkaround(Runnable runnable, Runnable runnable2) {
        if (Threading.isSingleThreaded() && !Threading.isOpenGLThread()) {
            Threading.invokeOnOpenGLThread(runnable);
        } else {
            this.drawableHelper.invokeGL(this.drawable, this.context, runnable2, this.initAction);
        }
    }

    void disposeAbstractGraphicsDevice() {
        if (EventQueue.isDispatchThread() || Thread.holdsLock(this.getTreeLock())) {
            this.disposeAbstractGraphicsDeviceAction.run();
        } else {
            try {
                EventQueue.invokeAndWait(this.disposeAbstractGraphicsDeviceAction);
            }
            catch (InvocationTargetException invocationTargetException) {
                throw new GLException(invocationTargetException.getTargetException());
            }
            catch (InterruptedException interruptedException) {
                throw new GLException(interruptedException);
            }
        }
    }

    private void disableBackgroundErase() {
        if (!disableBackgroundEraseInitialized) {
            try {
                AccessController.doPrivileged(new PrivilegedAction<Object>(){

                    @Override
                    public Object run() {
                        try {
                            Class<?> clazz = GLCanvas.this.getToolkit().getClass();
                            while (clazz != null && disableBackgroundEraseMethod == null) {
                                try {
                                    disableBackgroundEraseMethod = clazz.getDeclaredMethod("disableBackgroundErase", Canvas.class);
                                    disableBackgroundEraseMethod.setAccessible(true);
                                }
                                catch (Exception exception) {
                                    clazz = clazz.getSuperclass();
                                }
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        return null;
                    }
                });
            }
            catch (Exception exception) {
                // empty catch block
            }
            disableBackgroundEraseInitialized = true;
            if (DEBUG) {
                System.err.println("GLCanvas: TK disableBackgroundErase method found: " + (null != disableBackgroundEraseMethod));
            }
        }
        if (disableBackgroundEraseMethod != null) {
            Exception exception = null;
            try {
                disableBackgroundEraseMethod.invoke((Object)this.getToolkit(), this);
            }
            catch (Exception exception2) {
                exception = exception2;
            }
            if (DEBUG) {
                System.err.println("GLCanvas: TK disableBackgroundErase error: " + exception);
            }
        }
    }

    private AWTGraphicsConfiguration chooseGraphicsConfiguration(final GLCapabilitiesImmutable gLCapabilitiesImmutable, final GLCapabilitiesImmutable gLCapabilitiesImmutable2, final GLCapabilitiesChooser gLCapabilitiesChooser, GraphicsDevice graphicsDevice) {
        if (Beans.isDesignTime()) {
            return null;
        }
        final AbstractGraphicsScreen abstractGraphicsScreen = null != graphicsDevice ? AWTGraphicsScreen.createScreenDevice(graphicsDevice, 0) : AWTGraphicsScreen.createDefault();
        AWTGraphicsConfiguration aWTGraphicsConfiguration = null;
        if (EventQueue.isDispatchThread() || Thread.holdsLock(this.getTreeLock())) {
            aWTGraphicsConfiguration = (AWTGraphicsConfiguration)GraphicsConfigurationFactory.getFactory(AWTGraphicsDevice.class).chooseGraphicsConfiguration(gLCapabilitiesImmutable, gLCapabilitiesImmutable2, gLCapabilitiesChooser, abstractGraphicsScreen);
        } else {
            try {
                final ArrayList arrayList = new ArrayList(1);
                EventQueue.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        AWTGraphicsConfiguration aWTGraphicsConfiguration = (AWTGraphicsConfiguration)GraphicsConfigurationFactory.getFactory(AWTGraphicsDevice.class).chooseGraphicsConfiguration(gLCapabilitiesImmutable, gLCapabilitiesImmutable2, gLCapabilitiesChooser, abstractGraphicsScreen);
                        arrayList.add(aWTGraphicsConfiguration);
                    }
                });
                aWTGraphicsConfiguration = arrayList.size() > 0 ? (AWTGraphicsConfiguration)arrayList.get(0) : null;
            }
            catch (InvocationTargetException invocationTargetException) {
                throw new GLException(invocationTargetException.getTargetException());
            }
            catch (InterruptedException interruptedException) {
                throw new GLException(interruptedException);
            }
        }
        if (aWTGraphicsConfiguration == null) {
            throw new GLException("Error: Couldn't fetch AWTGraphicsConfiguration");
        }
        return aWTGraphicsConfiguration;
    }

    public static void main(String[] stringArray) {
        System.err.println(VersionUtil.getPlatformInfo());
        System.err.println(GlueGenVersion.getInstance());
        System.err.println((Object)JoglVersion.getInstance());
        GLDrawableFactory gLDrawableFactory = GLDrawableFactory.getDesktopFactory();
        List<GLCapabilitiesImmutable> list = gLDrawableFactory.getAvailableCapabilities(null);
        for (int i = 0; i < list.size(); ++i) {
            System.err.println(list.get(i));
        }
        GLCapabilities gLCapabilities = new GLCapabilities(GLProfile.getDefault(GLProfile.getDefaultDesktopDevice()));
        Frame frame = new Frame("JOGL AWT Test");
        GLCanvas gLCanvas = new GLCanvas(gLCapabilities);
        frame.add(gLCanvas);
        frame.setSize(128, 128);
        gLCanvas.addGLEventListener(new GLEventListener(){

            @Override
            public void init(GLAutoDrawable gLAutoDrawable) {
                GL gL = gLAutoDrawable.getGL();
                System.err.println(JoglVersion.getGLInfo(gL, null));
            }

            @Override
            public void reshape(GLAutoDrawable gLAutoDrawable, int n, int n2, int n3, int n4) {
            }

            @Override
            public void display(GLAutoDrawable gLAutoDrawable) {
            }

            @Override
            public void dispose(GLAutoDrawable gLAutoDrawable) {
            }
        });
        final Frame frame2 = frame;
        final GLCanvas gLCanvas2 = gLCanvas;
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    frame2.setVisible(true);
                }
            });
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        gLCanvas.display();
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    frame2.setVisible(false);
                    frame2.remove(gLCanvas2);
                    frame2.dispose();
                }
            });
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    class SwapBuffersOnEventDispatchThreadAction
    implements Runnable {
        SwapBuffersOnEventDispatchThreadAction() {
        }

        @Override
        public void run() {
            GLCanvas.this.drawableHelper.invokeGL(GLCanvas.this.drawable, GLCanvas.this.context, GLCanvas.this.swapBuffersAction, GLCanvas.this.initAction);
        }
    }

    class DisplayOnEventDispatchThreadAction
    implements Runnable {
        DisplayOnEventDispatchThreadAction() {
        }

        @Override
        public void run() {
            GLCanvas.this.drawableHelper.invokeGL(GLCanvas.this.drawable, GLCanvas.this.context, GLCanvas.this.displayAction, GLCanvas.this.initAction);
        }
    }

    class SwapBuffersAction
    implements Runnable {
        SwapBuffersAction() {
        }

        @Override
        public void run() {
            GLCanvas.this.drawable.swapBuffers();
        }
    }

    class DisplayAction
    implements Runnable {
        DisplayAction() {
        }

        @Override
        public void run() {
            if (GLCanvas.this.sendReshape) {
                if (DEBUG) {
                    System.err.println(Thread.currentThread().getName() + " - reshape: " + GLCanvas.this.getWidth() + "x" + GLCanvas.this.getHeight());
                }
                GLCanvas.this.drawableHelper.reshape(GLCanvas.this, 0, 0, GLCanvas.this.getWidth(), GLCanvas.this.getHeight());
                GLCanvas.this.sendReshape = false;
            }
            GLCanvas.this.drawableHelper.display(GLCanvas.this);
        }
    }

    class InitAction
    implements Runnable {
        InitAction() {
        }

        @Override
        public void run() {
            GLCanvas.this.drawableHelper.init(GLCanvas.this);
        }
    }

    class DisposeAbstractGraphicsDeviceAction
    implements Runnable {
        DisposeAbstractGraphicsDeviceAction() {
        }

        @Override
        public void run() {
            if (null != GLCanvas.this.awtConfig) {
                AbstractGraphicsDevice abstractGraphicsDevice = GLCanvas.this.awtConfig.getScreen().getDevice();
                String string = DEBUG ? abstractGraphicsDevice.toString() : null;
                boolean bl = GLCanvas.this.awtConfig.getScreen().getDevice().close();
                if (DEBUG) {
                    System.err.println(Thread.currentThread().getName() + " - GLCanvas.dispose(false): closed GraphicsDevice: " + string + ", result: " + bl);
                }
                GLCanvas.this.awtConfig = null;
            }
        }
    }

    class DisposeOnEventDispatchThreadAction
    implements Runnable {
        DisposeOnEventDispatchThreadAction() {
        }

        @Override
        public void run() {
            GLCanvas.this.drawableHelper.invokeGL(GLCanvas.this.drawable, GLCanvas.this.context, GLCanvas.this.disposeAction, null);
        }
    }

    class DisposeAction
    implements Runnable {
        DisposeAction() {
        }

        @Override
        public void run() {
            GLCanvas.this.drawableHelper.dispose(GLCanvas.this);
            if (null != GLCanvas.this.context) {
                GLCanvas.this.context.makeCurrent();
                GLCanvas.this.context.destroy();
                GLCanvas.this.context = null;
            }
            if (null != GLCanvas.this.drawable) {
                JAWTWindow jAWTWindow = (JAWTWindow)GLCanvas.this.drawable.getNativeSurface();
                GLCanvas.this.drawable.setRealized(false);
                GLCanvas.this.drawable = null;
                if (null != jAWTWindow) {
                    jAWTWindow.destroy();
                }
            }
            if (GLCanvas.this.disposeRegenerate) {
                GLCanvas.this.createDrawableAndContext();
                if (DEBUG) {
                    System.err.println("GLCanvas.dispose(true): new drawable: " + GLCanvas.this.drawable);
                }
                GLCanvas.this.validateGLDrawable();
            }
        }
    }
}

