/*
 * Decompiled with CFR 0.152.
 */
package javax.media.opengl;

import com.jogamp.common.util.IntObjectHashMap;
import java.nio.IntBuffer;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.util.HashMap;
import java.util.HashSet;
import javax.media.nativewindow.AbstractGraphicsDevice;
import javax.media.opengl.GL;
import javax.media.opengl.GLDebugListener;
import javax.media.opengl.GLDrawable;
import javax.media.opengl.GLException;
import jogamp.opengl.Debug;
import jogamp.opengl.GLContextImpl;

public abstract class GLContext {
    public static final boolean DEBUG = Debug.debug("GLContext");
    public static final boolean DEBUG_GL;
    public static final boolean TRACE_GL;
    public static final int CONTEXT_NOT_CURRENT = 0;
    public static final int CONTEXT_CURRENT = 1;
    public static final int CONTEXT_CURRENT_NEW = 2;
    protected static final int CTX_IS_ARB_CREATED = 1;
    protected static final int CTX_PROFILE_COMPAT = 2;
    protected static final int CTX_PROFILE_CORE = 4;
    protected static final int CTX_PROFILE_ES = 8;
    protected static final int CTX_OPTION_FORWARD = 16;
    protected static final int CTX_OPTION_ANY = 32;
    public static final int CTX_OPTION_DEBUG = 64;
    protected static final int CTX_PROFILE_ES2_COMPAT = 256;
    protected static final int CTX_IMPL_ACCEL_SOFT = 1;
    protected static final int CTX_IMPL_ACCEL_HARD = 2;
    private static ThreadLocal<GLContext> currentContext;
    private HashMap<String, Object> attachedObjectsByString = new HashMap();
    private IntObjectHashMap attachedObjectsByInt = new IntObjectHashMap();
    protected long contextHandle;
    protected int ctxMajorVersion;
    protected int ctxMinorVersion;
    protected int ctxOptions;
    protected String ctxVersionString;
    protected int currentSwapInterval = -1;
    protected int currentSwapGroup = -1;
    public static final int[][] GL_VERSIONS;
    protected static HashMap<String, Integer> deviceVersionAvailable;
    private static HashSet<String> deviceVersionsAvailableSet;

    protected GLContext() {
        this.resetStates();
    }

    protected void resetStates() {
        this.ctxMajorVersion = -1;
        this.ctxMinorVersion = -1;
        this.ctxOptions = 0;
        this.ctxVersionString = null;
        this.attachedObjectsByString.clear();
        this.attachedObjectsByInt.clear();
        this.contextHandle = 0L;
    }

    public abstract GLDrawable getGLDrawable();

    public abstract boolean isGLReadDrawableAvailable();

    public abstract void setGLReadDrawable(GLDrawable var1);

    public abstract GLDrawable getGLReadDrawable();

    public abstract int makeCurrent() throws GLException;

    public abstract void release() throws GLException;

    public abstract void copy(GLContext var1, int var2) throws GLException;

    public static GL getCurrentGL() throws GLException {
        GLContext gLContext = GLContext.getCurrent();
        if (null == gLContext) {
            throw new GLException("No OpenGL context current on this thread");
        }
        return gLContext.getGL();
    }

    public static GLContext getCurrent() {
        return currentContext.get();
    }

    public final boolean isCurrent() {
        return GLContext.getCurrent() == this;
    }

    public final void validateCurrent() throws GLException {
        if (GLContext.getCurrent() != this) {
            throw new GLException("Given GL context not current");
        }
    }

    protected static void setCurrent(GLContext gLContext) {
        currentContext.set(gLContext);
    }

    public abstract void destroy();

    public abstract boolean isSynchronized();

    public abstract void setSynchronized(boolean var1);

    public abstract GL getGL();

    public abstract GL setGL(GL var1);

    public final long getHandle() {
        return this.contextHandle;
    }

    public final boolean isCreated() {
        return 0L != this.contextHandle;
    }

    public final Object getAttachedObject(int n) {
        return this.attachedObjectsByInt.get(n);
    }

    public final Object getAttachedObject(String string) {
        return this.attachedObjectsByString.get(string);
    }

    public final Object attachObject(int n, Object object) {
        return this.attachedObjectsByInt.put(n, object);
    }

    public final Object detachObject(int n) {
        return this.attachedObjectsByInt.remove(n);
    }

    public final Object attachObject(String string, Object object) {
        return this.attachedObjectsByString.put(string, object);
    }

    public final Object detachObject(String string) {
        return this.attachedObjectsByString.remove(string);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getClass().getSimpleName());
        stringBuffer.append(" [");
        this.append(stringBuffer);
        stringBuffer.append("] ");
        return stringBuffer.toString();
    }

    public final StringBuffer append(StringBuffer stringBuffer) {
        stringBuffer.append("OpenGL ");
        stringBuffer.append(this.getGLVersionMajor());
        stringBuffer.append(".");
        stringBuffer.append(this.getGLVersionMinor());
        stringBuffer.append(", options 0x");
        stringBuffer.append(Integer.toHexString(this.ctxOptions));
        stringBuffer.append(", ");
        stringBuffer.append(this.getGLVersion());
        stringBuffer.append(", handle ");
        stringBuffer.append(GLContext.toHexString(this.contextHandle));
        stringBuffer.append(", ");
        stringBuffer.append(this.getGL());
        if (this.getGLDrawable() != this.getGLReadDrawable()) {
            stringBuffer.append(",\n\tRead Drawable : ");
            stringBuffer.append(this.getGLReadDrawable());
            stringBuffer.append(",\n\tWrite Drawable: ");
            stringBuffer.append(this.getGLDrawable());
        } else {
            stringBuffer.append(",\n\tDrawable: ");
            stringBuffer.append(this.getGLDrawable());
        }
        return stringBuffer;
    }

    public abstract String getPlatformExtensionsString();

    public abstract String getGLExtensionsString();

    public final int getGLVersionMajor() {
        return this.ctxMajorVersion;
    }

    public final int getGLVersionMinor() {
        return this.ctxMinorVersion;
    }

    public final boolean isGLCompatibilityProfile() {
        return 0 != (2 & this.ctxOptions);
    }

    public final boolean isGLCoreProfile() {
        return 0 != (4 & this.ctxOptions);
    }

    public final boolean isGLForwardCompatible() {
        return 0 != (0x10 & this.ctxOptions);
    }

    public final boolean isGLDebugEnabled() {
        return 0 != (0x40 & this.ctxOptions);
    }

    public final boolean isCreatedWithARBMethod() {
        return 0 != (1 & this.ctxOptions);
    }

    public abstract int getContextCreationFlags();

    public abstract void setContextCreationFlags(int var1);

    public final String getGLVersion() {
        return this.ctxVersionString;
    }

    public final boolean isGL4bc() {
        return this.ctxMajorVersion >= 4 && 0 != (this.ctxOptions & 1) && 0 != (this.ctxOptions & 2);
    }

    public final boolean isGL4() {
        return this.ctxMajorVersion >= 4 && 0 != (this.ctxOptions & 1) && 0 != (this.ctxOptions & 6);
    }

    public final boolean isGL3bc() {
        return (this.ctxMajorVersion > 3 || this.ctxMajorVersion == 3 && this.ctxMinorVersion >= 1) && 0 != (this.ctxOptions & 1) && 0 != (this.ctxOptions & 2);
    }

    public final boolean isGL3() {
        return (this.ctxMajorVersion > 3 || this.ctxMajorVersion == 3 && this.ctxMinorVersion >= 1) && 0 != (this.ctxOptions & 1) && 0 != (this.ctxOptions & 6);
    }

    public final boolean isGL2() {
        return this.ctxMajorVersion >= 1 && 0 != (this.ctxOptions & 2);
    }

    public final boolean isGL2GL3() {
        return this.isGL2() || this.isGL3();
    }

    public final boolean isGLES1() {
        return this.ctxMajorVersion == 1 && 0 != (this.ctxOptions & 8);
    }

    public final boolean isGLES2() {
        return this.ctxMajorVersion == 2 && 0 != (this.ctxOptions & 8);
    }

    public final boolean isGLES() {
        return 0 != (8 & this.ctxOptions);
    }

    public final boolean isGL2ES1() {
        return this.isGL2() || this.isGLES1();
    }

    public final boolean isGL2ES2() {
        return this.isGL2GL3() || this.isGLES2();
    }

    public final boolean isGLES2Compatible() {
        return 0 != (this.ctxOptions & 0x100);
    }

    public final boolean hasGLSL() {
        return this.isGL2ES2();
    }

    public final void setSwapInterval(int n) {
        if (!this.isCurrent()) {
            throw new GLException("This context is not current. Current context: " + GLContext.getCurrent() + ", this context " + this);
        }
        this.setSwapIntervalImpl(n);
    }

    protected void setSwapIntervalImpl(int n) {
    }

    public int getSwapInterval() {
        return this.currentSwapInterval;
    }

    public final boolean queryMaxSwapGroups(int[] nArray, int n, int[] nArray2, int n2) {
        if (!this.isCurrent()) {
            throw new GLException("This context is not current. Current context: " + GLContext.getCurrent() + ", this context " + this);
        }
        return this.queryMaxSwapGroupsImpl(nArray, n, nArray2, n2);
    }

    protected boolean queryMaxSwapGroupsImpl(int[] nArray, int n, int[] nArray2, int n2) {
        return false;
    }

    public final boolean joinSwapGroup(int n) {
        if (!this.isCurrent()) {
            throw new GLException("This context is not current. Current context: " + GLContext.getCurrent() + ", this context " + this);
        }
        return this.joinSwapGroupImpl(n);
    }

    protected boolean joinSwapGroupImpl(int n) {
        return false;
    }

    public int getSwapGroup() {
        return this.currentSwapGroup;
    }

    public final boolean bindSwapBarrier(int n, int n2) {
        if (!this.isCurrent()) {
            throw new GLException("This context is not current. Current context: " + GLContext.getCurrent() + ", this context " + this);
        }
        return this.bindSwapBarrierImpl(n, n2);
    }

    protected boolean bindSwapBarrierImpl(int n, int n2) {
        return false;
    }

    public abstract String getGLDebugMessageExtension();

    public abstract boolean isGLDebugSynchronous();

    public abstract void setGLDebugSynchronous(boolean var1);

    public abstract boolean isGLDebugMessageEnabled();

    public abstract void enableGLDebugMessage(boolean var1) throws GLException;

    public abstract void addGLDebugListener(GLDebugListener var1);

    public abstract void removeGLDebugListener(GLDebugListener var1);

    public abstract void glDebugMessageControl(int var1, int var2, int var3, int var4, IntBuffer var5, boolean var6);

    public abstract void glDebugMessageControl(int var1, int var2, int var3, int var4, int[] var5, int var6, boolean var7);

    public abstract void glDebugMessageInsert(int var1, int var2, int var3, int var4, String var5);

    public static final int getMaxMajor() {
        return GL_VERSIONS.length - 1;
    }

    public static final int getMaxMinor(int n) {
        if (1 > n || n >= GL_VERSIONS.length) {
            return -1;
        }
        return GL_VERSIONS[n].length - 1;
    }

    public static final boolean isValidGLVersion(int n, int n2) {
        if (1 > n || n >= GL_VERSIONS.length) {
            return false;
        }
        return 0 <= n2 && n2 < GL_VERSIONS[n].length;
    }

    public static final boolean decrementGLVersion(int[] nArray, int[] nArray2) {
        if (null == nArray || nArray.length < 1 || null == nArray2 || nArray2.length < 1) {
            throw new GLException("invalid array arguments");
        }
        int n = nArray[0];
        int n2 = nArray2[0];
        if (!GLContext.isValidGLVersion(n, n2)) {
            return false;
        }
        if (--n2 < 0) {
            n2 = GL_VERSIONS[--n].length - 1;
        }
        if (!GLContext.isValidGLVersion(n, n2)) {
            return false;
        }
        nArray[0] = n;
        nArray2[0] = n2;
        return true;
    }

    protected static int compose8bit(int n, int n2, int n3, int n4) {
        return (n & 0xFF) << 24 | (n2 & 0xFF) << 16 | (n3 & 0xFF) << 8 | n4 & 0xFF;
    }

    protected static int getComposed8bit(int n, int n2) {
        switch (n2) {
            case 1: {
                return (n & 0xFF000000) >> 24;
            }
            case 2: {
                return (n & 0xFF0000) >> 16;
            }
            case 3: {
                return (n & 0xFF00) >> 8;
            }
            case 4: {
                return n & 0xFF0000FF;
            }
        }
        throw new GLException("argument which out of range: " + n2);
    }

    protected static String composed8BitToString(int n, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        int n2 = GLContext.getComposed8bit(n, 1);
        int n3 = GLContext.getComposed8bit(n, 2);
        int n4 = GLContext.getComposed8bit(n, 3);
        int n5 = GLContext.getComposed8bit(n, 4);
        return "[" + GLContext.toString(n2, bl) + ", " + GLContext.toString(n3, bl2) + ", " + GLContext.toString(n4, bl3) + ", " + GLContext.toString(n5, bl4) + "]";
    }

    private static void validateProfileBits(int n, String string) {
        int n2 = 0;
        if (0 != (2 & n)) {
            ++n2;
        }
        if (0 != (4 & n)) {
            ++n2;
        }
        if (0 != (8 & n)) {
            ++n2;
        }
        if (1 != n2) {
            throw new GLException("Internal Error: " + string + ": 1 != num-profiles: " + n2);
        }
    }

    protected static String getDeviceVersionAvailableKey(AbstractGraphicsDevice abstractGraphicsDevice, int n, int n2) {
        return abstractGraphicsDevice.getUniqueID() + "-" + GLContext.toHexString(GLContext.compose8bit(n, n2, 0, 0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static boolean getAvailableGLVersionsSet(AbstractGraphicsDevice abstractGraphicsDevice) {
        HashSet<String> hashSet = deviceVersionsAvailableSet;
        synchronized (hashSet) {
            return deviceVersionsAvailableSet.contains(abstractGraphicsDevice.getUniqueID());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void setAvailableGLVersionsSet(AbstractGraphicsDevice abstractGraphicsDevice) {
        HashSet<String> hashSet = deviceVersionsAvailableSet;
        synchronized (hashSet) {
            String string = abstractGraphicsDevice.getUniqueID();
            if (deviceVersionsAvailableSet.contains(string)) {
                throw new InternalError("Already set: " + string);
            }
            deviceVersionsAvailableSet.add(string);
            if (DEBUG) {
                System.err.println(GLContext.getThreadName() + ": !!! createContextARB: SET mappedVersionsAvailableSet " + string);
            }
        }
    }

    protected static void shutdown() {
        deviceVersionAvailable.clear();
        deviceVersionsAvailableSet.clear();
        GLContextImpl.shutdownImpl();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static Integer mapAvailableGLVersion(AbstractGraphicsDevice abstractGraphicsDevice, int n, int n2, int n3, int n4, int n5) {
        GLContext.validateProfileBits(n2, "profile");
        GLContext.validateProfileBits(n5, "resCtp");
        String string = GLContext.getDeviceVersionAvailableKey(abstractGraphicsDevice, n, n2);
        Integer n6 = new Integer(GLContext.compose8bit(n3, n4, n5, 0));
        HashMap<String, Integer> hashMap = deviceVersionAvailable;
        synchronized (hashMap) {
            n6 = deviceVersionAvailable.put(string, n6);
        }
        return n6;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static Integer getAvailableGLVersion(AbstractGraphicsDevice abstractGraphicsDevice, int n, int n2) {
        Integer n3;
        String string = GLContext.getDeviceVersionAvailableKey(abstractGraphicsDevice, n, n2);
        HashMap<String, Integer> hashMap = deviceVersionAvailable;
        synchronized (hashMap) {
            n3 = deviceVersionAvailable.get(string);
        }
        return n3;
    }

    protected static boolean getAvailableGLVersion(AbstractGraphicsDevice abstractGraphicsDevice, int n, int n2, int[] nArray, int[] nArray2, int[] nArray3) {
        Integer n3 = GLContext.getAvailableGLVersion(abstractGraphicsDevice, n, n2);
        if (null == n3) {
            return false;
        }
        int n4 = n3;
        if (null != nArray) {
            nArray[0] = GLContext.getComposed8bit(n4, 1);
        }
        if (null != nArray2) {
            nArray2[0] = GLContext.getComposed8bit(n4, 2);
        }
        if (null != nArray3) {
            nArray3[0] = GLContext.getComposed8bit(n4, 3);
        }
        return true;
    }

    public static boolean isGLVersionAvailable(AbstractGraphicsDevice abstractGraphicsDevice, int n, int n2) {
        return null != GLContext.getAvailableGLVersion(abstractGraphicsDevice, n, n2);
    }

    public static boolean isGLES1Available(AbstractGraphicsDevice abstractGraphicsDevice) {
        return GLContext.isGLVersionAvailable(abstractGraphicsDevice, 1, 8);
    }

    public static boolean isGLES2Available(AbstractGraphicsDevice abstractGraphicsDevice) {
        return GLContext.isGLVersionAvailable(abstractGraphicsDevice, 2, 8);
    }

    public static boolean isGL4bcAvailable(AbstractGraphicsDevice abstractGraphicsDevice) {
        return GLContext.isGLVersionAvailable(abstractGraphicsDevice, 4, 2);
    }

    public static boolean isGL4Available(AbstractGraphicsDevice abstractGraphicsDevice) {
        return GLContext.isGLVersionAvailable(abstractGraphicsDevice, 4, 4);
    }

    public static boolean isGL3bcAvailable(AbstractGraphicsDevice abstractGraphicsDevice) {
        return GLContext.isGLVersionAvailable(abstractGraphicsDevice, 3, 2);
    }

    public static boolean isGL3Available(AbstractGraphicsDevice abstractGraphicsDevice) {
        return GLContext.isGLVersionAvailable(abstractGraphicsDevice, 3, 4);
    }

    public static boolean isGL2Available(AbstractGraphicsDevice abstractGraphicsDevice) {
        return GLContext.isGLVersionAvailable(abstractGraphicsDevice, 2, 2);
    }

    public static String getAvailableGLVersionAsString(AbstractGraphicsDevice abstractGraphicsDevice, int n, int n2) {
        int[] nArray = new int[]{0};
        int[] nArray2 = new int[]{0};
        int[] nArray3 = new int[]{0};
        if (GLContext.getAvailableGLVersion(abstractGraphicsDevice, n, n2, nArray, nArray2, nArray3)) {
            return GLContext.getGLVersion(nArray[0], nArray2[0], nArray3[0], null);
        }
        return null;
    }

    public static String getGLVersion(int n, int n2, int n3, String string) {
        boolean bl = false;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(n);
        stringBuilder.append(".");
        stringBuilder.append(n2);
        stringBuilder.append(" (");
        bl = GLContext.appendString(stringBuilder, "ES", bl, 0 != (8 & n3));
        bl = GLContext.appendString(stringBuilder, "ES2 compatible", bl, 0 != (0x100 & n3));
        bl = GLContext.appendString(stringBuilder, "compatibility profile", bl, 0 != (2 & n3));
        bl = GLContext.appendString(stringBuilder, "core profile", bl, 0 != (4 & n3));
        bl = GLContext.appendString(stringBuilder, "forward compatible", bl, 0 != (0x10 & n3));
        bl = GLContext.appendString(stringBuilder, "debug", bl, 0 != (0x40 & n3));
        bl = GLContext.appendString(stringBuilder, "any", bl, 0 != (0x20 & n3));
        bl = GLContext.appendString(stringBuilder, "new", bl, 0 != (1 & n3));
        bl = GLContext.appendString(stringBuilder, "old", bl, 0 == (1 & n3));
        stringBuilder.append(")");
        if (null != string) {
            stringBuilder.append(" - ");
            stringBuilder.append(string);
        }
        return stringBuilder.toString();
    }

    protected static String toString(int n, boolean bl) {
        if (bl) {
            return "0x" + Integer.toHexString(n);
        }
        return String.valueOf(n);
    }

    protected static String toHexString(int n) {
        return "0x" + Integer.toHexString(n);
    }

    protected static String toHexString(long l) {
        return "0x" + Long.toHexString(l);
    }

    private static boolean appendString(StringBuilder stringBuilder, String string, boolean bl, boolean bl2) {
        if (bl2) {
            if (bl) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(string);
            bl = true;
        }
        return bl;
    }

    protected static String getThreadName() {
        return Thread.currentThread().getName();
    }

    static {
        AccessControlContext accessControlContext = AccessController.getContext();
        DEBUG_GL = Debug.isPropertyDefined("jogl.debug.DebugGL", true, accessControlContext);
        TRACE_GL = Debug.isPropertyDefined("jogl.debug.TraceGL", true, accessControlContext);
        currentContext = new ThreadLocal();
        GL_VERSIONS = new int[][]{{-1}, {0, 1, 2, 3, 4, 5}, {0, 1}, {0, 1, 2, 3}, {0, 1, 2}};
        deviceVersionAvailable = new HashMap();
        deviceVersionsAvailableSet = new HashSet();
    }
}

