/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.util.glsl;

import com.jogamp.common.nio.Buffers;
import com.jogamp.common.util.IOUtil;
import com.jogamp.opengl.util.glsl.ShaderUtil;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.net.URL;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.security.AccessController;
import java.util.Iterator;
import javax.media.opengl.GL2ES2;
import javax.media.opengl.GLException;
import jogamp.opengl.Debug;

public class ShaderCode {
    public static final boolean DEBUG = Debug.debug("GLSLCode");
    public static final boolean DEBUG_CODE = Debug.isPropertyDefined("jogl.debug.GLSLCode", true, AccessController.getContext());
    public static final String SUFFIX_VERTEX_SOURCE = "vp";
    public static final String SUFFIX_VERTEX_BINARY = "bvp";
    public static final String SUFFIX_FRAGMENT_SOURCE = "fp";
    public static final String SUFFIX_FRAGMENT_BINARY = "bfp";
    public static final String SUB_PATH_NVIDIA = "nvidia";
    protected String[][] shaderSource = null;
    protected Buffer shaderBinary = null;
    protected int shaderBinaryFormat = -1;
    protected IntBuffer shader = null;
    protected int shaderType = -1;
    protected int id = -1;
    protected boolean valid = false;
    protected static int nextID = 1;

    public ShaderCode(int n, int n2, String[][] stringArray) {
        switch (n) {
            case 35632: 
            case 35633: {
                break;
            }
            default: {
                throw new GLException("Unknown shader type: " + n);
            }
        }
        this.shaderSource = stringArray;
        this.shaderBinaryFormat = -1;
        this.shaderBinary = null;
        this.shaderType = n;
        this.shader = Buffers.newDirectIntBuffer((int)n2);
        this.id = ShaderCode.getNextID();
        if (DEBUG_CODE) {
            System.out.println("Created: " + this.toString());
        }
    }

    public ShaderCode(int n, int n2, int n3, Buffer buffer) {
        switch (n) {
            case 35632: 
            case 35633: {
                break;
            }
            default: {
                throw new GLException("Unknown shader type: " + n);
            }
        }
        this.shaderSource = null;
        this.shaderBinaryFormat = n3;
        this.shaderBinary = buffer;
        this.shaderType = n;
        this.shader = Buffers.newDirectIntBuffer((int)n2);
        this.id = ShaderCode.getNextID();
    }

    public static ShaderCode create(GL2ES2 gL2ES2, int n, int n2, Class<?> clazz, String[] stringArray) {
        if (!ShaderUtil.isShaderCompilerAvailable(gL2ES2)) {
            return null;
        }
        String[][] stringArray2 = null;
        if (null != stringArray) {
            stringArray2 = new String[stringArray.length][1];
            for (int i = 0; null != stringArray2 && i < stringArray.length; ++i) {
                stringArray2[i][0] = ShaderCode.readShaderSource(clazz, stringArray[i]);
                if (null != stringArray2[i][0]) continue;
                stringArray2 = null;
            }
        }
        if (null == stringArray2) {
            return null;
        }
        return new ShaderCode(n, n2, stringArray2);
    }

    public static ShaderCode create(int n, int n2, Class<?> clazz, int n3, String string) {
        ByteBuffer byteBuffer = null;
        if (null != string && 0 <= n3 && null == (byteBuffer = ShaderCode.readShaderBinary(clazz, string))) {
            n3 = -1;
        }
        if (null == byteBuffer) {
            return null;
        }
        return new ShaderCode(n, n2, n3, byteBuffer);
    }

    public static String getFileSuffix(boolean bl, int n) {
        switch (n) {
            case 35633: {
                return bl ? SUFFIX_VERTEX_BINARY : SUFFIX_VERTEX_SOURCE;
            }
            case 35632: {
                return bl ? SUFFIX_FRAGMENT_BINARY : SUFFIX_FRAGMENT_SOURCE;
            }
        }
        throw new GLException("illegal shader type: " + n);
    }

    public static String getBinarySubPath(int n) {
        switch (n) {
            case 35083: {
                return SUB_PATH_NVIDIA;
            }
        }
        throw new GLException("unsupported binary format: " + n);
    }

    public static ShaderCode create(GL2ES2 gL2ES2, int n, int n2, Class<?> clazz, String string, String string2, String string3) {
        Object object;
        ShaderCode shaderCode = null;
        String string4 = null;
        String string5 = null;
        if (ShaderUtil.isShaderCompilerAvailable(gL2ES2)) {
            object = new String[1];
            string4 = string + '/' + string3 + "." + ShaderCode.getFileSuffix(false, n);
            object[0] = string4;
            shaderCode = ShaderCode.create(gL2ES2, n, n2, clazz, (String[])object);
            if (null != shaderCode) {
                return shaderCode;
            }
        }
        object = ShaderUtil.getShaderBinaryFormats(gL2ES2);
        Iterator iterator = object.iterator();
        while (null == shaderCode && iterator.hasNext()) {
            int n3 = (Integer)iterator.next();
            String string6 = ShaderCode.getBinarySubPath(n3);
            if (null == string6) continue;
            string5 = string2 + '/' + string6 + '/' + string3 + "." + ShaderCode.getFileSuffix(true, n);
            shaderCode = ShaderCode.create(n, n2, clazz, n3, string5);
        }
        if (null == shaderCode) {
            throw new GLException("No shader code found (source nor binary) for src: " + string4 + ", bin: " + string5);
        }
        return shaderCode;
    }

    public int id() {
        return this.id;
    }

    public int shaderType() {
        return this.shaderType;
    }

    public String shaderTypeStr() {
        return ShaderCode.shaderTypeStr(this.shaderType);
    }

    public static String shaderTypeStr(int n) {
        switch (n) {
            case 35633: {
                return "VERTEX_SHADER";
            }
            case 35632: {
                return "FRAGMENT_SHADER";
            }
        }
        return "UNKNOWN_SHADER";
    }

    public int shaderBinaryFormat() {
        return this.shaderBinaryFormat;
    }

    public Buffer shaderBinary() {
        return this.shaderBinary;
    }

    public String[][] shaderSource() {
        return this.shaderSource;
    }

    public boolean isValid() {
        return this.valid;
    }

    public IntBuffer shader() {
        return this.shader;
    }

    public boolean compile(GL2ES2 gL2ES2) {
        return this.compile(gL2ES2, null);
    }

    public boolean compile(GL2ES2 gL2ES2, PrintStream printStream) {
        if (this.isValid()) {
            return true;
        }
        if (null != this.shaderSource) {
            this.valid = ShaderUtil.createAndCompileShader(gL2ES2, this.shader, this.shaderType, this.shaderSource, printStream);
        } else if (null != this.shaderBinary) {
            this.valid = ShaderUtil.createAndLoadShader(gL2ES2, this.shader, this.shaderType, this.shaderBinaryFormat, this.shaderBinary, printStream);
        } else {
            throw new GLException("no code (source or binary)");
        }
        return this.valid;
    }

    public void destroy(GL2ES2 gL2ES2) {
        if (this.isValid()) {
            if (null != gL2ES2) {
                ShaderUtil.deleteShader(gL2ES2, this.shader());
            }
            this.valid = false;
        }
        if (null != this.shaderBinary) {
            this.shaderBinary.clear();
            this.shaderBinary = null;
        }
        this.shaderSource = null;
        this.shaderBinaryFormat = -1;
        this.shaderType = -1;
        this.id = -1;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof ShaderCode) {
            return this.id() == ((ShaderCode)object).id();
        }
        return false;
    }

    public int hashCode() {
        return this.id;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("ShaderCode[id=" + this.id + ", type=" + this.shaderTypeStr() + ", valid=" + this.valid + ", shader: ");
        for (int i = 0; i < this.shader.remaining(); ++i) {
            stringBuffer.append(" " + this.shader.get(i));
        }
        if (null != this.shaderSource) {
            stringBuffer.append(", source]");
        } else if (null != this.shaderBinary) {
            stringBuffer.append(", binary " + this.shaderBinary + "]");
        }
        return stringBuffer.toString();
    }

    public void dumpShaderSource(PrintStream printStream) {
        if (null == this.shaderSource) {
            printStream.println("<no shader source>");
            return;
        }
        int n = null != this.shaderSource ? this.shaderSource.length : 0;
        int n2 = null != this.shader ? this.shader.capacity() : 0;
        for (int i = 0; i < n2; ++i) {
            printStream.println("");
            printStream.println("Shader #" + i + "/" + n2 + " name " + this.shader.get(i));
            printStream.println("--------------------------------------------------------------");
            if (i >= n) {
                printStream.println("<no shader source>");
            } else {
                String[] stringArray = this.shaderSource[i];
                for (int j = 0; j < stringArray.length; ++j) {
                    printStream.println("Segment " + j + "/" + stringArray.length + " :");
                    printStream.println(stringArray[j]);
                    printStream.println("");
                }
            }
            printStream.println("--------------------------------------------------------------");
        }
    }

    private static int readShaderSource(Class<?> clazz, URL uRL, StringBuffer stringBuffer, int n) {
        try {
            if (DEBUG_CODE) {
                System.err.printf("%3d: // %s\n", n, uRL);
            }
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(uRL.openStream()));
            String string = null;
            while ((string = bufferedReader.readLine()) != null) {
                ++n;
                if (DEBUG_CODE) {
                    System.err.printf("%3d: %s\n", n, string);
                }
                if (string.startsWith("#include ")) {
                    String string2 = string.substring(9).trim();
                    URL uRL2 = null;
                    String string3 = IOUtil.getRelativeOf((URL)uRL, (String)string2);
                    if (null != string3) {
                        uRL2 = IOUtil.getResource(clazz, (String)string3);
                    }
                    if (uRL2 == null) {
                        uRL2 = IOUtil.getResource(clazz, (String)string2);
                    }
                    if (uRL2 == null) {
                        throw new FileNotFoundException("Can't find include file " + string2);
                    }
                    n = ShaderCode.readShaderSource(clazz, uRL2, stringBuffer, n);
                    continue;
                }
                stringBuffer.append(string + "\n");
            }
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
        return n;
    }

    public static void readShaderSource(Class<?> clazz, URL uRL, StringBuffer stringBuffer) {
        if (DEBUG_CODE) {
            System.err.println();
            System.err.println("// -----------------------------------------------------------");
        }
        ShaderCode.readShaderSource(clazz, uRL, stringBuffer, 0);
        if (DEBUG_CODE) {
            System.err.println("// -----------------------------------------------------------");
            System.err.println();
        }
    }

    public static String readShaderSource(Class<?> clazz, String string) {
        URL uRL = IOUtil.getResource(clazz, (String)string);
        if (uRL == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        ShaderCode.readShaderSource(clazz, uRL, stringBuffer);
        return stringBuffer.toString();
    }

    public static ByteBuffer readShaderBinary(Class<?> clazz, String string) {
        try {
            URL uRL = IOUtil.getResource(clazz, (String)string);
            if (uRL == null) {
                return null;
            }
            return IOUtil.copyStream2ByteBuffer((InputStream)new BufferedInputStream(uRL.openStream()));
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    private static synchronized int getNextID() {
        return nextID++;
    }
}

