/*
 * Decompiled with CFR 0.152.
 */
package com.js.test.terra.area.chunks.provider.impl;

import com.js.test.terra.area.chunks.provider.Chunk;
import com.js.test.terra.area.chunks.provider.MegaChunk;
import com.js.test.terra.area.chunks.provider.impl.ContiniousChunkProvider;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class WorldSaver {
    public static void saveMegaChunk(MegaChunk theMegaChunkToSave, String theWorldName) {
        block21: {
            AbstractInterruptibleChannel fc = null;
            try {
                try {
                    String aSaveFileName;
                    File aSaveToFile;
                    String aDirName = "saves/" + theWorldName + "/";
                    File aDirFile = new File(aDirName);
                    if (!aDirFile.exists()) {
                        aDirFile.mkdir();
                    }
                    if ((aSaveToFile = new File(aSaveFileName = "saves/" + theWorldName + "/" + theWorldName + "_" + theMegaChunkToSave.myXPos + "_" + theMegaChunkToSave.myYPos + "_" + theMegaChunkToSave.myZPos + ".data")).exists()) {
                        aSaveToFile.delete();
                    }
                    fc = new FileOutputStream(aSaveToFile, false).getChannel();
                    ArrayList<Integer> nonNullChunks = new ArrayList<Integer>();
                    int aNumberOfNonNull = 0;
                    int aNumberOfEmpty = 0;
                    int i = 0;
                    while (i < theMegaChunkToSave.myChunks.length) {
                        if (theMegaChunkToSave.myChunks[i] != null) {
                            nonNullChunks.add(i);
                            ++aNumberOfNonNull;
                            if (theMegaChunkToSave.myChunks[i].isEmpty) {
                                ++aNumberOfEmpty;
                                nonNullChunks.add(1);
                            } else {
                                nonNullChunks.add(0);
                            }
                        }
                        ++i;
                    }
                    int listSizeOfNonNullChunks = aNumberOfNonNull * 8;
                    int aSizeOfNonNullChunk = 12 + theMegaChunkToSave.myChunkSize * theMegaChunkToSave.myChunkSize * theMegaChunkToSave.myChunkSize * 4;
                    int aSizeOfNonNullChunkThatIsEmpty = 12;
                    ByteBuffer anotherBuffer = ByteBuffer.allocateDirect(20 + listSizeOfNonNullChunks + aSizeOfNonNullChunk * (aNumberOfNonNull - aNumberOfEmpty) + aSizeOfNonNullChunkThatIsEmpty * aNumberOfEmpty);
                    IntBuffer anIntBuffer = anotherBuffer.asIntBuffer();
                    anIntBuffer.put(theMegaChunkToSave.myMegaX);
                    anIntBuffer.put(theMegaChunkToSave.myMegaY);
                    anIntBuffer.put(theMegaChunkToSave.myMegaZ);
                    anIntBuffer.put(theMegaChunkToSave.myChunkSize);
                    anIntBuffer.put(aNumberOfNonNull);
                    for (Integer anIndex : nonNullChunks) {
                        anIntBuffer.put(anIndex);
                    }
                    int i2 = 0;
                    while (i2 < aNumberOfNonNull) {
                        int anIndex = (Integer)nonNullChunks.get(i2 * 2);
                        int isEmpty = (Integer)nonNullChunks.get(i2 * 2 + 1);
                        int aXpos = theMegaChunkToSave.myChunks[anIndex].myChunkX;
                        int aYpos = theMegaChunkToSave.myChunks[anIndex].myChunkY;
                        int aZpos = theMegaChunkToSave.myChunks[anIndex].myChunkZ;
                        anIntBuffer.put(aXpos);
                        anIntBuffer.put(aYpos);
                        anIntBuffer.put(aZpos);
                        if (isEmpty == 0) {
                            anIntBuffer.put(theMegaChunkToSave.myChunks[anIndex].myBlocks, 0, theMegaChunkToSave.myChunks[anIndex].myBlocks.length);
                        }
                        ++i2;
                    }
                    ((FileChannel)fc).write(anotherBuffer);
                    fc.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    if (fc == null) break block21;
                    try {
                        fc.close();
                    }
                    catch (IOException e2) {
                        e2.printStackTrace();
                    }
                }
            }
            finally {
                if (fc != null) {
                    try {
                        fc.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    public static MegaChunk loadMegaChunk(String theWorldName, int theXPos, int theYPos, int theZPos, ContiniousChunkProvider theProvider) {
        String aSaveFileName = "saves/" + theWorldName + "/" + theWorldName + "_" + theXPos + "_" + theYPos + "_" + theZPos + ".data";
        File aSaveToFile = new File(aSaveFileName);
        if (!aSaveToFile.exists()) {
            return null;
        }
        FileChannel fc = null;
        try {
            fc = new FileInputStream(aSaveToFile).getChannel();
            ByteBuffer aBufferToReadTo = ByteBuffer.allocate((int)aSaveToFile.length());
            int read = 0;
            while ((long)(read += fc.read(aBufferToReadTo)) < aSaveToFile.length()) {
                System.out.println("read: " + read);
            }
            aBufferToReadTo.flip();
            IntBuffer aIntBuffer = aBufferToReadTo.asIntBuffer();
            int xRes = aIntBuffer.get();
            int yRes = aIntBuffer.get();
            int zRes = aIntBuffer.get();
            int chunkSize = aIntBuffer.get();
            int amountOfChunks = aIntBuffer.get();
            MegaChunk aMegaChunkToBuild = new MegaChunk(xRes, yRes, zRes, chunkSize, theXPos, theYPos, theZPos, theProvider);
            if (amountOfChunks > 0) {
                int[] listOfChunkIds = new int[amountOfChunks * 2];
                aIntBuffer.get(listOfChunkIds);
                int i = 0;
                while (i < listOfChunkIds.length) {
                    int aXpos = aIntBuffer.get();
                    int aYpos = aIntBuffer.get();
                    int aZpos = aIntBuffer.get();
                    Chunk aNewChunk = new Chunk(chunkSize, aXpos, aYpos, aZpos, aMegaChunkToBuild);
                    int isEmpty = listOfChunkIds[i + 1];
                    if (isEmpty == 0) {
                        aNewChunk.myBlocks = new int[chunkSize * chunkSize * chunkSize];
                        aIntBuffer.get(aNewChunk.myBlocks);
                        aNewChunk.isEmpty = false;
                    } else {
                        aNewChunk.isEmpty = true;
                    }
                    aNewChunk.isInitialized = true;
                    aMegaChunkToBuild.myChunks[listOfChunkIds[i]] = aNewChunk;
                    i += 2;
                }
            }
            fc.close();
            MegaChunk megaChunk = aMegaChunkToBuild;
            return megaChunk;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (fc != null) {
                try {
                    fc.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return null;
    }

    public static void saveMetadataFor(ContiniousChunkProvider theProvider) {
        FileOutputStream file = null;
        OutputStream buffer = null;
        ObjectOutput output = null;
        try {
            try {
                file = new FileOutputStream("saves/" + theProvider.getMyMapName() + "/" + theProvider.getMyMapName() + "_metadata.data");
                buffer = new BufferedOutputStream(file);
                output = new ObjectOutputStream(buffer);
                output.writeObject(theProvider.getMySeed());
                output.writeObject(theProvider.getMetaDataMap());
                output.writeObject(theProvider.getInventoriesMap());
                output.writeObject(theProvider.getBlockMakersMap());
                output.writeObject(theProvider.getDrillersMap());
                output.writeObject(theProvider.getGrindersMap());
                output.writeObject(theProvider.getItemMakersMap());
                output.writeObject(theProvider.getTimersMap());
            }
            catch (Exception e) {
                e.printStackTrace();
                try {
                    output.close();
                    buffer.close();
                }
                catch (Exception e2) {
                    e2.printStackTrace();
                }
            }
        }
        finally {
            try {
                output.close();
                buffer.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static void loadMetadataFor(ContiniousChunkProvider theProvider) {
        FileInputStream file = null;
        InputStream buffer = null;
        ObjectInput input = null;
        try {
            try {
                file = new FileInputStream("saves/" + theProvider.getMyMapName() + "/" + theProvider.getMyMapName() + "_metadata.data");
                buffer = new BufferedInputStream(file);
                input = new ObjectInputStream(buffer);
                theProvider.setMySeed((Long)input.readObject());
                theProvider.setMetaDataMap((Map)input.readObject());
                theProvider.setInventoriesMap((Map)input.readObject());
                theProvider.setBlockMakersMap((Map)input.readObject());
                theProvider.setDrillersMap((Map)input.readObject());
                theProvider.setGrindersMap((Map)input.readObject());
                theProvider.setItemMakersMap((Map)input.readObject());
                theProvider.setTimersMap((Map)input.readObject());
            }
            catch (Exception e) {
                e.printStackTrace();
                try {
                    input.close();
                    buffer.close();
                }
                catch (Exception e2) {
                    e2.printStackTrace();
                }
            }
        }
        finally {
            try {
                input.close();
                buffer.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static void writeInfoAbout(String theSaveGame, HashMap<String, String> writeThis) {
        FileOutputStream file = null;
        OutputStream buffer = null;
        ObjectOutput output = null;
        try {
            try {
                file = new FileOutputStream("saves/" + theSaveGame + "/" + theSaveGame + "_info.data");
                buffer = new BufferedOutputStream(file);
                output = new ObjectOutputStream(buffer);
                output.writeObject(writeThis);
            }
            catch (Exception e) {
                e.printStackTrace();
                try {
                    output.close();
                    buffer.close();
                }
                catch (Exception e2) {
                    e2.printStackTrace();
                }
            }
        }
        finally {
            try {
                output.close();
                buffer.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static HashMap<String, String> loadInfoAbout(String theSavedGame) {
        FileInputStream file = null;
        InputStream buffer = null;
        ObjectInput input = null;
        HashMap aReturnMap = null;
        try {
            try {
                file = new FileInputStream("saves/" + theSavedGame + "/" + theSavedGame + "_info.data");
                buffer = new BufferedInputStream(file);
                input = new ObjectInputStream(buffer);
                aReturnMap = (HashMap)input.readObject();
            }
            catch (Exception e) {
                e.printStackTrace();
                try {
                    input.close();
                    buffer.close();
                }
                catch (Exception e2) {
                    e2.printStackTrace();
                }
            }
        }
        finally {
            try {
                input.close();
                buffer.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return aReturnMap;
    }
}

