/*
 * Decompiled with CFR 0.152.
 */
package com.js.test.terra.area.chunks.provider.impl;

import com.js.test.engine.player.BlockMaker;
import com.js.test.engine.player.Driller;
import com.js.test.engine.player.Grinder;
import com.js.test.engine.player.Inventory;
import com.js.test.engine.player.ItemMaker;
import com.js.test.engine.player.Timer;
import com.js.test.terra.area.chunks.generators.VoxelGenerator;
import com.js.test.terra.area.chunks.provider.BlockMetaData;
import com.js.test.terra.area.chunks.provider.Chunk;
import com.js.test.terra.area.chunks.provider.ChunkProvider;
import com.js.test.terra.area.chunks.provider.MegaChunk;
import com.js.test.terra.area.chunks.provider.MetaDataRemovedListener;
import com.js.test.terra.area.chunks.provider.impl.Coord;
import com.js.test.terra.area.chunks.provider.impl.WorldSaver;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ContiniousChunkProvider
extends ChunkProvider {
    public VoxelGenerator myVoxelGenerator;
    private Map<String, MegaChunk> myMegaChunks;
    private Map<String, BlockMetaData> myMetaDataBlocks;
    private Map<String, Inventory> myInventories;
    private Map<String, Grinder> myGrinders;
    private Map<String, BlockMaker> myBlockMakers;
    private Map<String, ItemMaker> myItemMakers;
    private Map<String, Driller> myDrillersMap;
    private Map<String, Timer> myTimersMap;
    private List<MetaDataRemovedListener> myMetaDataListners;
    private String myMapName;

    public ContiniousChunkProvider(int theMegaX, int theMegaY, int theMegaZ, int theChunkSize, VoxelGenerator theGenerator, int theSeed, String theMapName) {
        super(theMegaX, theMegaY, theMegaZ, theChunkSize, theSeed);
        this.myVoxelGenerator = theGenerator;
        this.myMapName = theMapName;
        this.myMegaChunks = new HashMap<String, MegaChunk>();
        this.myMetaDataBlocks = new HashMap<String, BlockMetaData>();
        this.myInventories = new HashMap<String, Inventory>();
        this.myGrinders = new HashMap<String, Grinder>();
        this.myBlockMakers = new HashMap<String, BlockMaker>();
        this.myItemMakers = new HashMap<String, ItemMaker>();
        this.myDrillersMap = new HashMap<String, Driller>();
        this.myTimersMap = new HashMap<String, Timer>();
        this.myMetaDataListners = new ArrayList<MetaDataRemovedListener>();
    }

    @Override
    public Coord fromWorldToMegaChunk(int worldX, int worldY, int worldZ) {
        int worldXOffset = worldX + this.myMegaSizeX / 2;
        int worldYOffset = worldY + this.myMegaSizeY / 2;
        int worldZOffset = worldZ + this.myMegaSizeZ / 2;
        int chunkZ = 0;
        int chunkX = worldXOffset < 0 ? -1 - -worldXOffset / this.myMegaSizeX : worldXOffset / this.myMegaSizeX;
        int chunkY = worldYOffset < 0 ? -1 - -worldYOffset / this.myMegaSizeY : worldYOffset / this.myMegaSizeY;
        chunkZ = worldZOffset < 0 ? -1 - -worldZOffset / this.myMegaSizeZ : worldZOffset / this.myMegaSizeZ;
        Coord aReturnCoord = new Coord(chunkX, chunkY, chunkZ);
        return aReturnCoord;
    }

    public Coord fromWorldToMegaChunkCoords(int worldX, int worldY, int worldZ) {
        int worldXOffset = worldX + this.myMegaSizeX / 2;
        int worldYOffset = worldY + this.myMegaSizeY / 2;
        int worldZOffset = worldZ + this.myMegaSizeZ / 2;
        worldYOffset %= this.myMegaSizeY;
        worldZOffset %= this.myMegaSizeZ;
        if ((worldXOffset %= this.myMegaSizeX) < 0) {
            worldXOffset = this.myMegaSizeX + worldXOffset;
        }
        if (worldYOffset < 0) {
            worldYOffset = this.myMegaSizeY + worldYOffset;
        }
        if (worldZOffset < 0) {
            worldZOffset = this.myMegaSizeZ + worldZOffset;
        }
        return new Coord(worldXOffset, worldYOffset, worldZOffset);
    }

    @Override
    public Coord fromWorldToChunkCoord(int worldX, int worldY, int worldZ) {
        int worldXOffset = worldX + this.myMegaSizeX / 2;
        int worldYOffset = worldY + this.myMegaSizeY / 2;
        int worldZOffset = worldZ + this.myMegaSizeZ / 2;
        worldYOffset %= this.myMegaSizeY;
        worldZOffset %= this.myMegaSizeZ;
        if ((worldXOffset %= this.myMegaSizeX) < 0) {
            worldXOffset = this.myMegaSizeX + worldXOffset;
        }
        if (worldYOffset < 0) {
            worldYOffset = this.myMegaSizeY + worldYOffset;
        }
        if (worldZOffset < 0) {
            worldZOffset = this.myMegaSizeZ + worldZOffset;
        }
        int chunkX = worldXOffset / this.myChunkSize;
        int chunkY = worldYOffset / this.myChunkSize;
        int chunkZ = worldZOffset / this.myChunkSize;
        return new Coord(chunkX, chunkY, chunkZ);
    }

    @Override
    public MegaChunk getMegaChunkAt(int mcx, int mcy, int mcz) {
        MegaChunk aMegaChunk = this.myMegaChunks.get(String.valueOf(mcx) + "|" + mcy + "|" + mcz);
        if (aMegaChunk == null) {
            aMegaChunk = WorldSaver.loadMegaChunk(this.myMapName, mcx, mcy, mcz, this);
            if (aMegaChunk == null) {
                aMegaChunk = new MegaChunk(this.myMegaSizeX, this.myMegaSizeY, this.myMegaSizeZ, this.myChunkSize, mcx, mcy, mcz, this);
            }
            this.myMegaChunks.put(String.valueOf(mcx) + "|" + mcy + "|" + mcz, aMegaChunk);
        }
        return aMegaChunk;
    }

    @Override
    public Chunk getChunkAt(int mcx, int mcy, int mcz, int cx, int cy, int cz) {
        MegaChunk aMegaChunk = this.getMegaChunkAt(mcx, mcy, mcz);
        return aMegaChunk.getChunkAt(cx, cy, cz);
    }

    @Override
    public Chunk getChunkAt(int worldX, int worldY, int worldZ) {
        Coord aMegaCoord = this.fromWorldToMegaChunk(worldX, worldY, worldZ);
        MegaChunk aMegaChunk = this.getMegaChunkAt(aMegaCoord.x, aMegaCoord.y, aMegaCoord.z);
        Coord myLocalCoord = this.fromWorldToMegaChunkCoords(worldX, worldY, worldZ);
        int chunkX = myLocalCoord.x / this.myChunkSize;
        int chunkY = myLocalCoord.y / this.myChunkSize;
        int chunkZ = myLocalCoord.z / this.myChunkSize;
        int x = myLocalCoord.x % this.myChunkSize;
        int y = myLocalCoord.y % this.myChunkSize;
        int z = myLocalCoord.z % this.myChunkSize;
        Chunk aChunk = aMegaChunk.getChunkAt(chunkX, chunkY, chunkZ);
        return aChunk;
    }

    public int getValueAt(int worldX, int worldY, int worldZ) {
        Coord aMegaCoord = this.fromWorldToMegaChunk(worldX, worldY, worldZ);
        MegaChunk aMegaChunk = this.getMegaChunkAt(aMegaCoord.x, aMegaCoord.y, aMegaCoord.z);
        Coord myLocalCoord = this.fromWorldToMegaChunkCoords(worldX, worldY, worldZ);
        int chunkX = myLocalCoord.x / this.myChunkSize;
        int chunkY = myLocalCoord.y / this.myChunkSize;
        int chunkZ = myLocalCoord.z / this.myChunkSize;
        int x = myLocalCoord.x % this.myChunkSize;
        int y = myLocalCoord.y % this.myChunkSize;
        int z = myLocalCoord.z % this.myChunkSize;
        Chunk aChunk = aMegaChunk.getChunkAt(chunkX, chunkY, chunkZ);
        return aChunk.getValueAt(x, y, z);
    }

    public void setValueAt(int worldX, int worldY, int worldZ, int value) {
        Coord aMegaCoord = this.fromWorldToMegaChunk(worldX, worldY, worldZ);
        MegaChunk aMegaChunk = this.getMegaChunkAt(aMegaCoord.x, aMegaCoord.y, aMegaCoord.z);
        Coord myLocalCoord = this.fromWorldToMegaChunkCoords(worldX, worldY, worldZ);
        int chunkX = myLocalCoord.x / this.myChunkSize;
        int chunkY = myLocalCoord.y / this.myChunkSize;
        int chunkZ = myLocalCoord.z / this.myChunkSize;
        int x = myLocalCoord.x % this.myChunkSize;
        int y = myLocalCoord.y % this.myChunkSize;
        int z = myLocalCoord.z % this.myChunkSize;
        Chunk aChunk = aMegaChunk.getChunkAt(chunkX, chunkY, chunkZ);
        if (aChunk.isEmpty) {
            aChunk.fillWithAir();
        }
        aChunk.myBlocks[x + y * this.myChunkSize + z * this.myChunkSizePo2] = value;
    }

    @Override
    public Chunk getChunkByWorldCoord(int worldX, int worldY, int worldZ) {
        return null;
    }

    @Override
    public boolean canBeVisible(int worldX, int worldY, int worldZ) {
        int blockValue = this.getValueAt(worldX, worldY, worldZ);
        if ((blockValue & 0xFFFF) == 0) {
            return false;
        }
        if ((this.getValueAt(worldX, worldY, worldZ - 1) & 0x10000000) > 0) {
            return true;
        }
        if ((this.getValueAt(worldX, worldY, worldZ + 1) & 0x10000000) > 0) {
            return true;
        }
        if ((this.getValueAt(worldX - 1, worldY, worldZ) & 0x10000000) > 0) {
            return true;
        }
        if ((this.getValueAt(worldX + 1, worldY, worldZ) & 0x10000000) > 0) {
            return true;
        }
        if ((this.getValueAt(worldX, worldY + 1, worldZ) & 0x10000000) > 0) {
            return true;
        }
        return (this.getValueAt(worldX, worldY - 1, worldZ) & 0x10000000) > 0;
    }

    @Override
    public void addLightAt(int worldX, int worldY, int worldZ, int lightVal) {
        int blockValue = this.getValueAt(worldX, worldY, worldZ);
        int oldValueLightValue = blockValue >> 16 & 0xFFF;
        int newValue = oldValueLightValue + lightVal;
        if (newValue > 255) {
            newValue = 255;
        }
        this.setValueAt(worldX, worldY, worldZ, (blockValue & 0xF000FFFF) + (newValue << 16));
    }

    @Override
    public void removeLightAt(int worldX, int worldY, int worldZ, int lightVal) {
        int blockValue = this.getValueAt(worldX, worldY, worldZ);
        int oldValueLightValue = blockValue >> 16 & 0xFFF;
        int newValue = oldValueLightValue - lightVal;
        if (newValue < 0) {
            newValue = 0;
        }
        this.setValueAt(worldX, worldY, worldZ, (blockValue & 0xF000FFFF) + (newValue << 16));
    }

    @Override
    public void setLightAt(int worldX, int worldY, int worldZ, int lightVal, int component) {
        int blockValue = this.getValueAt(worldX, worldY, worldZ);
        int myOldValue = blockValue >> 16 & 0xFFF;
        int mask = 15 << component * 4;
        int myOldComponent = myOldValue & mask;
        this.setValueAt(worldX, worldY, worldZ, (blockValue & 0xF000FFFF) + ((myOldValue -= myOldComponent) + (lightVal << component * 4) << 16));
    }

    @Override
    public int getLightAt(int worldX, int worldY, int worldZ, int component) {
        int blockValue = this.getValueAt(worldX, worldY, worldZ);
        int mask = 15 << component * 4;
        return ((blockValue & 0xFFF0000) >> 16 & mask) >> component * 4;
    }

    @Override
    public int getBlockAt(int worldX, int worldY, int worldZ) {
        int blockValue = this.getValueAt(worldX, worldY, worldZ);
        return blockValue & 0xFFFF;
    }

    @Override
    public int getTransparencyAt(int worldX, int worldY, int worldZ) {
        int blockValue = this.getValueAt(worldX, worldY, worldZ);
        return blockValue & 0x10000000;
    }

    @Override
    public int getDirectionAt(int worldX, int worldY, int worldZ) {
        int blockValue = this.getValueAt(worldX, worldY, worldZ);
        return blockValue & 0x20000000;
    }

    @Override
    public int getActiveAt(int worldX, int worldY, int worldZ) {
        int blockValue = this.getValueAt(worldX, worldY, worldZ);
        return blockValue & 0x40000000;
    }

    @Override
    public int getMetaDataAt(int worldX, int worldY, int worldZ) {
        int blockValue = this.getValueAt(worldX, worldY, worldZ);
        return blockValue & Integer.MIN_VALUE;
    }

    @Override
    public void setActiveAt(int worldX, int worldY, int worldZ, int active) {
        int blockValue = this.getValueAt(worldX, worldY, worldZ);
        int myClearedValue = blockValue & 0xBFFFFFFF;
        int myActiveMask = 0;
        if (active > 0) {
            myActiveMask = 0x40000000;
        }
        this.setValueAt(worldX, worldY, worldZ, myClearedValue + myActiveMask);
    }

    @Override
    public void setBlockAt(int worldX, int worldY, int worldZ, int blockId, boolean transparent, int direction, boolean hasMetaData) {
        String key;
        BlockMetaData amb;
        int blockValue = this.getValueAt(worldX, worldY, worldZ);
        if ((blockValue & Integer.MIN_VALUE) != 0 && (amb = this.myMetaDataBlocks.get(key = String.valueOf(worldX) + "|" + worldY + "|" + worldZ)) != null) {
            for (MetaDataRemovedListener aMdr : this.myMetaDataListners) {
                aMdr.metaDataRemoved(worldX, worldY, worldZ, amb.metaData);
            }
            this.myMetaDataBlocks.remove(String.valueOf(worldX) + "|" + worldY + "|" + worldZ);
        }
        int oldValueLightValue = blockValue & 0xFFF0000;
        int transMask = 0x10000000;
        int directionMask = 0;
        int metadataMask = 0;
        if (direction > 0) {
            directionMask = 0x20000000;
        }
        if (hasMetaData) {
            metadataMask = Integer.MIN_VALUE;
        }
        if (blockId == 0 || transparent) {
            this.setValueAt(worldX, worldY, worldZ, blockId + oldValueLightValue + transMask + directionMask + metadataMask);
        } else {
            this.setValueAt(worldX, worldY, worldZ, blockId + directionMask + metadataMask);
        }
    }

    @Override
    public void setBlockAt(int worldX, int worldY, int worldZ, int blockId, boolean transparent) {
        this.setBlockAt(worldX, worldY, worldZ, blockId, transparent, 0, false);
    }

    @Override
    public void setBlockAtNoLightUpdate(int worldX, int worldY, int worldZ, int blockId, boolean transparent, int direction, boolean hasMetaData) {
        int blockValue = this.getValueAt(worldX, worldY, worldZ);
        if ((blockValue & Integer.MIN_VALUE) != 0) {
            this.myMetaDataBlocks.remove(String.valueOf(worldX) + "|" + worldY + "|" + worldZ);
        }
        int transMask = 0;
        int directionMask = 0;
        int metadataMask = 0;
        if (transparent) {
            transMask = 0x10000000;
        }
        if (direction > 0) {
            directionMask = 0x20000000;
        }
        if (hasMetaData) {
            metadataMask = Integer.MIN_VALUE;
        }
        int oldValueLightValue = blockValue & 0xFFF0000;
        this.setValueAt(worldX, worldY, worldZ, blockId + oldValueLightValue + transMask + directionMask + metadataMask);
    }

    @Override
    public void setBlockAtNoLightUpdate(int worldX, int worldY, int worldZ, int blockId, boolean transparent) {
        this.setBlockAtNoLightUpdate(worldX, worldY, worldZ, blockId, transparent, 0, false);
    }

    @Override
    public void save() {
        for (MegaChunk aMegaToSave : this.myMegaChunks.values()) {
            WorldSaver.saveMegaChunk(aMegaToSave, this.myMapName);
        }
        WorldSaver.saveMetadataFor(this);
        HashMap<String, String> infoMap = new HashMap<String, String>();
        infoMap.put("size", Integer.toString(this.myMegaSizeX));
        WorldSaver.writeInfoAbout(this.getMyMapName(), infoMap);
    }

    @Override
    public Map<String, BlockMetaData> getMetaDataMap() {
        return this.myMetaDataBlocks;
    }

    @Override
    public void addMetaDataBlock(BlockMetaData theBlockToAdd) {
        this.myMetaDataBlocks.put(String.valueOf(theBlockToAdd.x) + "|" + theBlockToAdd.y + "|" + theBlockToAdd.z, theBlockToAdd);
        if (theBlockToAdd.metaData.equals("grinder")) {
            Grinder aNewGrinder = new Grinder(theBlockToAdd.x, theBlockToAdd.y, theBlockToAdd.z);
            this.myGrinders.put(String.valueOf(theBlockToAdd.x) + "|" + theBlockToAdd.y + "|" + theBlockToAdd.z, aNewGrinder);
        } else if (theBlockToAdd.metaData.equals("blockmaker")) {
            BlockMaker aNewBlockMaker = new BlockMaker(theBlockToAdd.x, theBlockToAdd.y, theBlockToAdd.z);
            this.myBlockMakers.put(String.valueOf(theBlockToAdd.x) + "|" + theBlockToAdd.y + "|" + theBlockToAdd.z, aNewBlockMaker);
        } else if (theBlockToAdd.metaData.equals("itemmaker")) {
            ItemMaker aNewItemMaker = new ItemMaker(theBlockToAdd.x, theBlockToAdd.y, theBlockToAdd.z);
            this.myItemMakers.put(String.valueOf(theBlockToAdd.x) + "|" + theBlockToAdd.y + "|" + theBlockToAdd.z, aNewItemMaker);
        } else if (theBlockToAdd.metaData.equals("driller_down")) {
            Inventory anInventory = new Inventory(15, 4);
            this.setInventoryFor(theBlockToAdd.x, theBlockToAdd.y, theBlockToAdd.z, anInventory);
            Driller aNewDriller = new Driller(theBlockToAdd.x, theBlockToAdd.y, theBlockToAdd.z);
            this.myDrillersMap.put(String.valueOf(theBlockToAdd.x) + "|" + theBlockToAdd.y + "|" + theBlockToAdd.z, aNewDriller);
        } else if (theBlockToAdd.metaData.equals("timer")) {
            Timer aNewTimer = new Timer(theBlockToAdd.x, theBlockToAdd.y, theBlockToAdd.z);
            this.myTimersMap.put(String.valueOf(theBlockToAdd.x) + "|" + theBlockToAdd.y + "|" + theBlockToAdd.z, aNewTimer);
        }
    }

    @Override
    public Inventory getInventoryFor(int worldX, int worldY, int worldZ) {
        return this.myInventories.get(String.valueOf(worldX) + "|" + worldY + "|" + worldZ);
    }

    @Override
    public void removeInventoryFor(int worldX, int worldY, int worldZ) {
        this.myInventories.remove(String.valueOf(worldX) + "|" + worldY + "|" + worldZ);
    }

    @Override
    public void setInventoryFor(int worldX, int worldY, int worldZ, Inventory theInventory) {
        this.myInventories.put(String.valueOf(worldX) + "|" + worldY + "|" + worldZ, theInventory);
    }

    @Override
    public Map<String, Inventory> getInventoriesMap() {
        return this.myInventories;
    }

    @Override
    public Map<String, Grinder> getGrindersMap() {
        return this.myGrinders;
    }

    @Override
    public void removeGrinderFor(int worldX, int worldY, int worldZ) {
        this.myGrinders.remove(String.valueOf(worldX) + "|" + worldY + "|" + worldZ);
    }

    @Override
    public Grinder getGrinderFor(int worldX, int worldY, int worldZ) {
        return this.myGrinders.get(String.valueOf(worldX) + "|" + worldY + "|" + worldZ);
    }

    @Override
    public Map<String, BlockMaker> getBlockMakersMap() {
        return this.myBlockMakers;
    }

    @Override
    public BlockMaker getBlockMakerFor(int worldX, int worldY, int worldZ) {
        return this.myBlockMakers.get(String.valueOf(worldX) + "|" + worldY + "|" + worldZ);
    }

    @Override
    public void removeBlockMakerFor(int worldX, int worldY, int worldZ) {
        this.myBlockMakers.remove(String.valueOf(worldX) + "|" + worldY + "|" + worldZ);
    }

    @Override
    public Map<String, ItemMaker> getItemMakersMap() {
        return this.myItemMakers;
    }

    @Override
    public ItemMaker getItemMakerFor(int worldX, int worldY, int worldZ) {
        return this.myItemMakers.get(String.valueOf(worldX) + "|" + worldY + "|" + worldZ);
    }

    @Override
    public void removeItemMakerFor(int worldX, int worldY, int worldZ) {
        this.myItemMakers.remove(String.valueOf(worldX) + "|" + worldY + "|" + worldZ);
    }

    @Override
    public Map<String, Driller> getDrillersMap() {
        return this.myDrillersMap;
    }

    @Override
    public Driller getDrillerFor(int worldX, int worldY, int worldZ) {
        return this.myDrillersMap.get(String.valueOf(worldX) + "|" + worldY + "|" + worldZ);
    }

    @Override
    public void removeDrillerFor(int worldX, int worldY, int worldZ) {
        this.myDrillersMap.remove(String.valueOf(worldX) + "|" + worldY + "|" + worldZ);
    }

    @Override
    public Map<String, Timer> getTimersMap() {
        return this.myTimersMap;
    }

    @Override
    public Timer getTimerFor(int worldX, int worldY, int worldZ) {
        return this.myTimersMap.get(String.valueOf(worldX) + "|" + worldY + "|" + worldZ);
    }

    @Override
    public void removeTimerFor(int worldX, int worldY, int worldZ) {
        this.myTimersMap.remove(String.valueOf(worldX) + "|" + worldY + "|" + worldZ);
    }

    @Override
    public void moveMetaDataBlock(int fromX, int fromY, int fromZ, int toX, int toY, int toZ) {
        String fromKey = String.valueOf(fromX) + "|" + fromY + "|" + fromZ;
        BlockMetaData aMeta = this.myMetaDataBlocks.get(fromKey);
        if (aMeta != null) {
            Timer aTimer;
            this.myMetaDataBlocks.remove(fromKey);
            aMeta.x = toX;
            aMeta.y = toY;
            aMeta.z = toZ;
            String toKey = String.valueOf(toX) + "|" + toY + "|" + toZ;
            this.myMetaDataBlocks.put(toKey, aMeta);
            if (aMeta.metaData.equals("grinder")) {
                Grinder aGrinder = this.myGrinders.get(fromKey);
                if (aGrinder != null) {
                    this.myGrinders.remove(fromKey);
                    aGrinder.setX(toX);
                    aGrinder.setY(toY);
                    aGrinder.setZ(toZ);
                    this.myGrinders.put(toKey, aGrinder);
                }
            } else if (aMeta.metaData.equals("blockmaker")) {
                BlockMaker aBlockMaker = this.myBlockMakers.get(fromKey);
                if (aBlockMaker != null) {
                    this.myBlockMakers.remove(fromKey);
                    aBlockMaker.setX(toX);
                    aBlockMaker.setY(toY);
                    aBlockMaker.setZ(toZ);
                    this.myBlockMakers.put(toKey, aBlockMaker);
                }
            } else if (aMeta.metaData.equals("itemmaker")) {
                ItemMaker anItemMaker = this.myItemMakers.get(fromKey);
                if (anItemMaker != null) {
                    this.myItemMakers.remove(fromKey);
                    anItemMaker.setX(toX);
                    anItemMaker.setY(toY);
                    anItemMaker.setZ(toZ);
                    this.myItemMakers.put(toKey, anItemMaker);
                }
            } else if (aMeta.metaData.equals("timer") && (aTimer = this.myTimersMap.get(fromKey)) != null) {
                this.myTimersMap.remove(fromKey);
                aTimer.setX(toX);
                aTimer.setY(toY);
                aTimer.setZ(toZ);
                this.myTimersMap.put(toKey, aTimer);
            }
        }
    }

    @Override
    public int getValueNonLightAt(int rx, int ry, int rz) {
        int blockValue = this.getValueAt(rx, ry, rz);
        return blockValue & 0xF000FFFF;
    }

    @Override
    public void setValueNonLightAt(int rx, int ry, int rz, int value) {
        this.setValueAt(rx, ry, rz, value);
    }

    @Override
    public String getMyMapName() {
        return this.myMapName;
    }

    @Override
    public void setMyMapName(String myMapName) {
        this.myMapName = myMapName;
    }

    @Override
    public void loadMetadataRelated() {
        WorldSaver.loadMetadataFor(this);
    }

    @Override
    public void addMetaDataRemovedListener(MetaDataRemovedListener mdr) {
        this.myMetaDataListners.add(mdr);
    }

    @Override
    public void setMetaDataMap(Map<String, BlockMetaData> theMap) {
        this.myMetaDataBlocks = theMap;
    }

    @Override
    public void setInventoriesMap(Map<String, Inventory> theMap) {
        this.myInventories = theMap;
    }

    @Override
    public void setBlockMakersMap(Map<String, BlockMaker> theMap) {
        this.myBlockMakers = theMap;
    }

    @Override
    public void setDrillersMap(Map<String, Driller> theMap) {
        this.myDrillersMap = theMap;
    }

    @Override
    public void setGrindersMap(Map<String, Grinder> theMap) {
        this.myGrinders = theMap;
    }

    @Override
    public void setItemMakersMap(Map<String, ItemMaker> theMap) {
        this.myItemMakers = theMap;
    }

    @Override
    public void setTimersMap(Map<String, Timer> theMap) {
        this.myTimersMap = theMap;
    }
}

