/*
 * Decompiled with CFR 0.152.
 */
package com.js.test.terra.area.chunks.provider;

import com.js.test.terra.area.chunks.provider.Chunk;
import com.js.test.terra.area.chunks.provider.impl.ContiniousChunkProvider;

public class MegaChunk {
    public Chunk[] myChunks;
    public int myChunkListWidth;
    public int myChunkListHeight;
    public int myChunkListDepth;
    public int myChunkSize;
    public int myXPos;
    public int myYPos;
    public int myZPos;
    public int myMegaX;
    public int myMegaY;
    public int myMegaZ;
    public boolean isSpace;
    private ContiniousChunkProvider myProvider;

    public MegaChunk(int theMegaX, int theMegaY, int theMegaZ, int theChunkSize, int theXPos, int theYPos, int theZPos, ContiniousChunkProvider theProvider) {
        this.myChunkListWidth = theMegaX / theChunkSize;
        this.myChunkListHeight = theMegaY / theChunkSize;
        this.myChunkListDepth = theMegaZ / theChunkSize;
        this.myChunks = new Chunk[this.myChunkListWidth * this.myChunkListHeight * this.myChunkListDepth];
        this.myXPos = theXPos;
        this.myYPos = theYPos;
        this.myZPos = theZPos;
        this.myMegaX = theMegaX;
        this.myMegaY = theMegaY;
        this.myMegaZ = theMegaZ;
        this.isSpace = false;
        this.myChunkSize = theChunkSize;
        this.myProvider = theProvider;
    }

    public boolean checkFreeToTop(int theCX, int theCY, int theCZ, int x, int y, int z) {
        int cy = theCY;
        while (cy < this.myChunkListHeight) {
            Chunk aChunkToInvestigate = this.getChunkAt(theCX, cy, theCZ);
            if (aChunkToInvestigate.isInitialized && !aChunkToInvestigate.isEmpty) {
                int cly = y;
                while (cly < this.myChunkSize) {
                    int aTrans = aChunkToInvestigate.getTransparencyAt(x, cly, z);
                    if (aTrans == 0) {
                        return false;
                    }
                    ++cly;
                }
                y = 0;
            }
            ++cy;
        }
        return true;
    }

    public Chunk getChunkAt(int theCX, int theCY, int theCZ) {
        if (theCX >= 0 && theCX < this.myChunkListWidth && theCY >= 0 && theCY < this.myChunkListHeight && theCZ >= 0 && theCZ < this.myChunkListDepth) {
            int chunkIndex = theCX + theCY * this.myChunkListWidth + theCZ * this.myChunkListHeight * this.myChunkListWidth;
            Chunk aChunk = this.myChunks[chunkIndex];
            if (aChunk == null) {
                aChunk = new Chunk(this.myChunkSize, theCX, theCY, theCZ, this);
                int genForX = this.myXPos * this.myMegaX + theCX * this.myChunkSize;
                int genForY = this.myYPos * this.myMegaY + theCY * this.myChunkSize;
                int genForZ = this.myZPos * this.myMegaZ + theCZ * this.myChunkSize;
                this.myProvider.myVoxelGenerator.createGenerationJob(aChunk, this.myXPos, this.myYPos, this.myZPos, this.myChunkSize, this.myChunkSize, this.myChunkSize, genForX, genForY, genForZ, this.myProvider.getMySeed());
                this.myChunks[chunkIndex] = aChunk;
            }
            return aChunk;
        }
        int modX = 0;
        int modY = 0;
        int modZ = 0;
        if (theCX < 0) {
            modX = -1;
        }
        if (theCX >= this.myChunkListWidth) {
            modX = 1;
        }
        if (theCY < 0) {
            modY = -1;
        }
        if (theCY >= this.myChunkListHeight) {
            modY = 1;
        }
        if (theCZ < 0) {
            modZ = -1;
        }
        if (theCZ >= this.myChunkListDepth) {
            modZ = 1;
        }
        MegaChunk aBorderMegaChunk = this.myProvider.getMegaChunkAt(this.myXPos + modX, this.myYPos + modY, this.myZPos + modZ);
        return aBorderMegaChunk.getChunkAt((this.myChunkListWidth + theCX % this.myChunkListWidth) % this.myChunkListWidth, (this.myChunkListHeight + theCY % this.myChunkListHeight) % this.myChunkListHeight, (this.myChunkListDepth + theCZ % this.myChunkListDepth) % this.myChunkListDepth);
    }
}

