/*
 * Decompiled with CFR 0.152.
 */
package com.js.test.terra.area.chunks.provider;

import com.js.test.terra.area.chunks.provider.MegaChunk;

public class Chunk {
    public int[] myBlocks;
    public int myChunkSize;
    public int myChunkSizePo2;
    public boolean isInitialized;
    public boolean isInQueue;
    public boolean isEmpty;
    public int myChunkX;
    public int myChunkY;
    public int myChunkZ;
    public MegaChunk myMegaChunk;

    public Chunk(int theChunkSize, int chunkX, int chunkY, int chunkZ, MegaChunk theMegaChunk) {
        this.myChunkSize = theChunkSize;
        this.myChunkSizePo2 = theChunkSize * theChunkSize;
        this.isInitialized = false;
        this.isInQueue = false;
        this.isEmpty = true;
        this.myChunkX = chunkX;
        this.myChunkY = chunkY;
        this.myChunkZ = chunkZ;
        this.myMegaChunk = theMegaChunk;
    }

    public void fillWithAir() {
        this.myBlocks = new int[this.myChunkSize * this.myChunkSizePo2];
        this.isEmpty = false;
        int i = 0;
        while (i < this.myBlocks.length) {
            this.myBlocks[i] = 0x10000000;
            ++i;
        }
    }

    public int getValueAt(int x, int y, int z) {
        if (this.isEmpty || !this.isInitialized) {
            return 0x10000000;
        }
        if (x >= 0 && x < this.myChunkSize && y >= 0 && y < this.myChunkSize && z >= 0 && z < this.myChunkSize) {
            return this.myBlocks[x + y * this.myChunkSize + z * this.myChunkSizePo2];
        }
        int modX = 0;
        int modY = 0;
        int modZ = 0;
        if (x < 0) {
            modX = -1;
        }
        if (x >= this.myChunkSize) {
            modX = 1;
        }
        if (y < 0) {
            modY = -1;
        }
        if (y >= this.myChunkSize) {
            modY = 1;
        }
        if (z < 0) {
            modZ = -1;
        }
        if (z >= this.myChunkSize) {
            modZ = 1;
        }
        Chunk aBorderChunk = this.myMegaChunk.getChunkAt(this.myChunkX + modX, this.myChunkY + modY, this.myChunkZ + modZ);
        return aBorderChunk.getValueAt((this.myChunkSize + x % this.myChunkSize) % this.myChunkSize, (this.myChunkSize + y % this.myChunkSize) % this.myChunkSize, (this.myChunkSize + z % this.myChunkSize) % this.myChunkSize);
    }

    public boolean getFreeToTop(int x, int y, int z) {
        return this.myMegaChunk.checkFreeToTop(this.myChunkX, this.myChunkY, this.myChunkZ, x, y, z);
    }

    public boolean canBeVisible(int x, int y, int z) {
        int blockValue = this.getValueAt(x, y, z);
        if ((blockValue & 0xFFFF) == 0) {
            return false;
        }
        if ((this.getValueAt(x, y, z - 1) & 0x10000000) > 0) {
            return true;
        }
        if ((this.getValueAt(x, y, z + 1) & 0x10000000) > 0) {
            return true;
        }
        if ((this.getValueAt(x - 1, y, z) & 0x10000000) > 0) {
            return true;
        }
        if ((this.getValueAt(x + 1, y, z) & 0x10000000) > 0) {
            return true;
        }
        if ((this.getValueAt(x, y + 1, z) & 0x10000000) > 0) {
            return true;
        }
        return (this.getValueAt(x, y - 1, z) & 0x10000000) > 0;
    }

    public int getLightAt(int worldX, int worldY, int worldZ, int component) {
        int blockValue = this.getValueAt(worldX, worldY, worldZ);
        int mask = 15 << component * 4;
        return ((blockValue & 0xFFF0000) >> 16 & mask) >> component * 4;
    }

    public int getFullLightAt(int worldX, int worldY, int worldZ) {
        int blockValue = this.getValueAt(worldX, worldY, worldZ);
        return (blockValue & 0xFFF0000) >> 16;
    }

    public int getBlockAt(int worldX, int worldY, int worldZ) {
        int blockValue = this.getValueAt(worldX, worldY, worldZ);
        return blockValue & 0xFFFF;
    }

    public int getDirectionAt(int worldX, int worldY, int worldZ) {
        int blockValue = this.getValueAt(worldX, worldY, worldZ);
        return blockValue & 0x20000000;
    }

    public int getTransparencyAt(int worldX, int worldY, int worldZ) {
        int blockValue = this.getValueAt(worldX, worldY, worldZ);
        return blockValue & 0x10000000;
    }

    public int getActiveAt(int worldX, int worldY, int worldZ) {
        int blockValue = this.getValueAt(worldX, worldY, worldZ);
        return blockValue & 0x40000000;
    }

    public int getMetaDataAt(int worldX, int worldY, int worldZ) {
        int blockValue = this.getValueAt(worldX, worldY, worldZ);
        return blockValue & Integer.MIN_VALUE;
    }
}

