/*
 * Decompiled with CFR 0.152.
 */
package com.js.test.terra.area.chunks;

import com.jogamp.opengl.util.GLBuffers;
import com.js.test.engine.gui.OverlayHandler;
import com.js.test.engine.gui.impl.BlockMakerOverlay;
import com.js.test.engine.gui.impl.ContainerOverlay;
import com.js.test.engine.gui.impl.GrinderOverlay;
import com.js.test.engine.gui.impl.ItemMakerOverlay;
import com.js.test.engine.gui.impl.MetaValueOverlay;
import com.js.test.engine.player.BlockMaker;
import com.js.test.engine.player.Driller;
import com.js.test.engine.player.Grinder;
import com.js.test.engine.player.Inventory;
import com.js.test.engine.player.ItemMaker;
import com.js.test.engine.player.Player;
import com.js.test.engine.player.Timer;
import com.js.test.terra.area.blocks.Block;
import com.js.test.terra.area.blocks.BlockLoader;
import com.js.test.terra.area.chunks.ChunkDataWrapper;
import com.js.test.terra.area.chunks.LightNode;
import com.js.test.terra.area.chunks.provider.BlockMetaData;
import com.js.test.terra.area.chunks.provider.Chunk;
import com.js.test.terra.area.chunks.provider.ChunkProvider;
import com.js.test.terra.area.chunks.provider.MetaDataRemovedListener;
import com.js.test.terra.area.chunks.provider.impl.Coord;
import com.js.test.terra.area.movables.BigBoomMovable;
import com.js.test.terra.area.movables.CloudMovable;
import com.js.test.terra.area.movables.ExplosionMovable;
import com.js.test.terra.area.movables.MovableHandler;
import com.js.test.terra.area.util.ObjectData;
import com.js.test.terra.area.util.SplitterData;
import com.js.test.terra.math.Vector3;
import java.nio.Buffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.Stack;
import javax.media.opengl.GL2;
import javax.media.opengl.glu.GLU;

public class BigChunkDataGrid
implements MetaDataRemovedListener {
    private Map<String, ChunkDataWrapper> myChunks = new HashMap<String, ChunkDataWrapper>();
    private List<ChunkDataWrapper> myRenderedLastFrame;
    private int myChunkSize;
    private int[] myBoundingBoxVerticesVBO;
    private int[] myBoundingBoxIndexVBO;
    private GL2 myGl;
    private GLU myGlu;
    private ChunkProvider myProvider;
    private Set<ChunkDataWrapper> aSetOfChunksToRebuild;

    public BigChunkDataGrid(GL2 theGl, GLU theGlu, ChunkProvider theProvider) {
        this.myProvider = theProvider;
        this.myChunkSize = this.myProvider.getMyChunkSize();
        this.myGl = theGl;
        this.myGlu = theGlu;
        this.buildVboForBoundingBox(theGl);
        this.aSetOfChunksToRebuild = new HashSet<ChunkDataWrapper>();
    }

    public ChunkDataWrapper getWrapperAt(int mcx, int mcy, int mcz, int cx, int cy, int cz, GL2 theGl) {
        String aKey = String.valueOf(mcx) + "|" + mcy + "|" + mcz + "|" + cx + "|" + cy + "|" + cz;
        ChunkDataWrapper aWrapper = this.myChunks.get(aKey);
        if (aWrapper == null) {
            aWrapper = new ChunkDataWrapper(this.myProvider.getMyChunkSize(), theGl);
            aWrapper.myXCpos = cx;
            aWrapper.myYCpos = cy;
            aWrapper.myZCpos = cz;
            aWrapper.myXMCpos = mcx;
            aWrapper.myYMCpos = mcy;
            aWrapper.myZMCpos = mcz;
            this.myChunks.put(aKey, aWrapper);
        }
        return aWrapper;
    }

    public Collection<ChunkDataWrapper> getMyChunksAsArray() {
        return this.myChunks.values();
    }

    public void renderAsBoundingBox(GL2 theGl, GLU theGlu, float x, float y, float z) {
        theGl.glBindBuffer(34962, this.myBoundingBoxVerticesVBO[0]);
        theGl.glEnableClientState(32884);
        theGl.glVertexPointer(3, 5126, 0, 0L);
        theGl.glBindBuffer(34963, this.myBoundingBoxIndexVBO[0]);
        theGl.glPushMatrix();
        theGl.glTranslatef(x, y, z);
        theGl.glDrawElements(4, 36, 5125, 0L);
        theGl.glPopMatrix();
    }

    public void rebuildWrapperList(Set<ChunkDataWrapper> theSetToUpdate) {
        for (ChunkDataWrapper aChunkToUpdate : theSetToUpdate) {
            this.rebuildVBOForChunk(this.myGl, this.myGlu, aChunkToUpdate);
        }
    }

    private void rebuildVBOForChunk(GL2 theGl, GLU theGlu, ChunkDataWrapper theWrapper) {
        if (theWrapper != null) {
            this.aSetOfChunksToRebuild.add(theWrapper);
        }
    }

    private void rebuildVBOForChunk(GL2 theGl, GLU theGlu, int x, int y, int z) {
        ChunkDataWrapper aWrapper = this.getChunkAt(x, y, z, theGl);
        if (aWrapper != null) {
            this.rebuildVBOForChunk(theGl, theGlu, aWrapper);
        }
    }

    public void rebuildVBOsFromList(GL2 theGl, GLU theGlu) {
        for (ChunkDataWrapper aWrapper : this.aSetOfChunksToRebuild) {
            if (aWrapper.myTextureIdList != null && aWrapper.myTextureIdList.length > 0) {
                theGl.glDeleteBuffers(aWrapper.myColorVboList.length, aWrapper.myColorVboList, 0);
                theGl.glDeleteBuffers(aWrapper.myIndexVboList.length, aWrapper.myIndexVboList, 0);
                theGl.glDeleteBuffers(aWrapper.myTextureCoordVboList.length, aWrapper.myTextureCoordVboList, 0);
                theGl.glDeleteBuffers(aWrapper.myVertexVboList.length, aWrapper.myVertexVboList, 0);
            }
            this.buildVBOForChunk(theGl, theGlu, aWrapper);
        }
        this.aSetOfChunksToRebuild.clear();
    }

    private void buildVboForBoundingBox(GL2 theGl) {
        this.myBoundingBoxVerticesVBO = new int[1];
        this.myBoundingBoxIndexVBO = new int[1];
        theGl.glGenBuffers(1, this.myBoundingBoxVerticesVBO, 0);
        theGl.glGenBuffers(1, this.myBoundingBoxIndexVBO, 0);
        float[] aScaledCube = this.generateScaledCube(this.myChunkSize);
        theGl.glBindBuffer(34962, this.myBoundingBoxVerticesVBO[0]);
        FloatBuffer fb = GLBuffers.newDirectFloatBuffer((float[])aScaledCube);
        theGl.glBufferData(34962, (long)(aScaledCube.length * 4), (Buffer)fb, 35044);
        theGl.glBindBuffer(34963, this.myBoundingBoxIndexVBO[0]);
        IntBuffer ib = GLBuffers.newDirectIntBuffer((int[])ObjectData.myIndicesVboData[0]);
        theGl.glBufferData(34963, (long)(ObjectData.myIndicesVboData[0].length * 4), (Buffer)ib, 35044);
    }

    private float[] generateScaledCube(float size) {
        float[] aReturnArray = new float[72];
        int i = 0;
        while (i < 72) {
            aReturnArray[i] = ObjectData.myObjectVertexData[0][i] * size;
            ++i;
        }
        return aReturnArray;
    }

    public void buildVBOForChunk(GL2 theGl, GLU theGlu, ChunkDataWrapper theChunk) {
        long gTime = System.currentTimeMillis();
        Chunk aChunkToDo = this.myProvider.getChunkAt(theChunk.myXMCpos, theChunk.myYMCpos, theChunk.myZMCpos, theChunk.myXCpos, theChunk.myYCpos, theChunk.myZCpos);
        if (!aChunkToDo.isInitialized) {
            return;
        }
        if (aChunkToDo.isEmpty) {
            theChunk.isEmpty = true;
            theChunk.isJustAir = true;
            theChunk.isInitialized = true;
            return;
        }
        HashMap<Integer, Integer> myCountedMap = new HashMap<Integer, Integer>();
        int airCount = 0;
        int i = 0;
        while (i < this.myChunkSize) {
            int j = 0;
            while (j < this.myChunkSize) {
                int k = 0;
                while (k < this.myChunkSize) {
                    int blockTexture = aChunkToDo.getBlockAt(i, j, k);
                    if (blockTexture == 0) {
                        ++airCount;
                    }
                    if (aChunkToDo.canBeVisible(i, j, k)) {
                        Integer myCount = (Integer)myCountedMap.get(blockTexture);
                        if (myCount == null) {
                            myCountedMap.put(blockTexture, 0);
                            myCount = (Integer)myCountedMap.get(blockTexture);
                        }
                        myCountedMap.put(blockTexture, myCount + 1);
                    }
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        int aNumberOfUniqueTextures = myCountedMap.size();
        theChunk.myVertexVboList = new int[aNumberOfUniqueTextures];
        theChunk.myIndexVboList = new int[aNumberOfUniqueTextures];
        theChunk.myTextureCoordVboList = new int[aNumberOfUniqueTextures];
        theChunk.myTextureIdList = new int[aNumberOfUniqueTextures];
        theChunk.myColorVboList = new int[aNumberOfUniqueTextures];
        if (airCount < this.myChunkSize * this.myChunkSize * this.myChunkSize) {
            theChunk.isJustAir = false;
            Object[] mcmArray = myCountedMap.keySet().toArray();
            float[][] vboVertexes = new float[aNumberOfUniqueTextures][];
            int[] vboVertexesWritten = new int[aNumberOfUniqueTextures];
            float[][] vboColors = new float[aNumberOfUniqueTextures][];
            float[][] vboTexCoords = new float[aNumberOfUniqueTextures][];
            int[] vboTexCoordsWritten = new int[aNumberOfUniqueTextures];
            int l = 0;
            while (l < mcmArray.length) {
                Block aBlock = BlockLoader.getInstance().getMyBlocksAsArray()[(Integer)mcmArray[l]];
                int blockCount = (Integer)myCountedMap.get(mcmArray[l]);
                int vertexCount = 0;
                vertexCount = aBlock.getObjectType() == 99 || aBlock.getObjectType() == 100 ? SplitterData.getInstance().splitterVertices[63].length : ObjectData.myObjectVertexData[aBlock.getObjectType()].length;
                vboVertexes[l] = new float[blockCount * vertexCount];
                vboColors[l] = new float[blockCount * vertexCount];
                int texCoordCount = vertexCount / 3 * 2;
                vboTexCoords[l] = new float[blockCount * texCoordCount];
                ++l;
            }
            int[][] vboIndexes = new int[aNumberOfUniqueTextures][];
            int[] vboIndexesWritten = new int[aNumberOfUniqueTextures];
            int l2 = 0;
            while (l2 < mcmArray.length) {
                Block aBlock = BlockLoader.getInstance().getMyBlocksAsArray()[(Integer)mcmArray[l2]];
                int blockCount = (Integer)myCountedMap.get(mcmArray[l2]);
                int indexCount = 0;
                indexCount = aBlock.getObjectType() == 99 || aBlock.getObjectType() == 100 ? SplitterData.getInstance().splitterIndices[63].length : ObjectData.myIndicesVboData[aBlock.getObjectType()].length;
                vboIndexes[l2] = new int[blockCount * indexCount];
                ++l2;
            }
            HashMap<Integer, Integer> myIndexCountMap = new HashMap<Integer, Integer>();
            int i2 = 0;
            while (i2 < this.myChunkSize) {
                int j = 0;
                while (j < this.myChunkSize) {
                    int k = 0;
                    while (k < this.myChunkSize) {
                        if (aChunkToDo.canBeVisible(i2, j, k)) {
                            int blockTexture = aChunkToDo.getBlockAt(i2, j, k);
                            Block aBlockInfo = BlockLoader.getInstance().getMyBlocksAsArray()[blockTexture];
                            int anObjectType = aBlockInfo.getObjectType();
                            int anIndexAmount = 0;
                            int anVerticesAmount = 0;
                            int neighbourNumber = 0;
                            boolean isSplitterObject = false;
                            if (anObjectType == 99 || anObjectType == 100) {
                                isSplitterObject = true;
                            }
                            if (isSplitterObject) {
                                neighbourNumber = anObjectType == 99 ? this.getNeighbourNumber(i2, j, k, aChunkToDo) : this.getNeighbourNumberOnlySelf(i2, j, k, aChunkToDo, blockTexture);
                                anIndexAmount = SplitterData.getInstance().splitterIndices[neighbourNumber].length;
                                anVerticesAmount = SplitterData.getInstance().splitterVertices[neighbourNumber].length;
                            } else {
                                anIndexAmount = ObjectData.myIndicesVboData[anObjectType].length;
                                anVerticesAmount = ObjectData.myObjectVertexData[anObjectType].length;
                            }
                            int aTextureIndexAmount = anVerticesAmount / 3 * 2;
                            int anIndexOffsetAmount = anVerticesAmount / 3;
                            Integer count = (Integer)myIndexCountMap.get(blockTexture);
                            if (count == null) {
                                myIndexCountMap.put(blockTexture, 0);
                                count = 0;
                            }
                            int blockTextureMapIndex = 0;
                            int cpC = 0;
                            int l3 = 0;
                            while (l3 < myCountedMap.keySet().toArray().length) {
                                if ((Integer)myCountedMap.keySet().toArray()[l3] == blockTexture) break;
                                ++cpC;
                                ++l3;
                            }
                            blockTextureMapIndex = cpC;
                            float[] vertexListToAdd = null;
                            int[] indexListToAdd = null;
                            float[] colorsToAdd = null;
                            if (isSplitterObject) {
                                vertexListToAdd = this.getSplitterVertexesWithOffset((float)i2 - (float)this.myChunkSize / 2.0f, (float)j - (float)this.myChunkSize / 2.0f, (float)k - (float)this.myChunkSize / 2.0f, neighbourNumber);
                                indexListToAdd = this.getSplitterIndexesWithOffset(vboVertexesWritten[blockTextureMapIndex] / 3, neighbourNumber);
                                colorsToAdd = this.getSplitterLight(neighbourNumber, aChunkToDo, i2, j, k);
                            } else {
                                vertexListToAdd = this.getVertexesWithOffset((float)i2 - (float)this.myChunkSize / 2.0f, (float)j - (float)this.myChunkSize / 2.0f, (float)k - (float)this.myChunkSize / 2.0f, anObjectType);
                                indexListToAdd = this.getIndexesWithOffset(vboVertexesWritten[blockTextureMapIndex] / 3, anObjectType);
                                colorsToAdd = this.getStrangeLight(i2, j, k, 1, 1, aChunkToDo, anObjectType);
                            }
                            int c = vboVertexesWritten[blockTextureMapIndex];
                            int lI = 0;
                            while (c < vboVertexesWritten[blockTextureMapIndex] + anVerticesAmount) {
                                vboVertexes[blockTextureMapIndex][c] = vertexListToAdd[lI];
                                ++c;
                                ++lI;
                            }
                            c = vboVertexesWritten[blockTextureMapIndex];
                            lI = 0;
                            while (c < vboVertexesWritten[blockTextureMapIndex] + anVerticesAmount) {
                                vboColors[blockTextureMapIndex][c] = colorsToAdd[lI];
                                ++c;
                                ++lI;
                            }
                            int n = blockTextureMapIndex;
                            vboVertexesWritten[n] = vboVertexesWritten[n] + anVerticesAmount;
                            c = vboIndexesWritten[blockTextureMapIndex];
                            lI = 0;
                            while (c < vboIndexesWritten[blockTextureMapIndex] + anIndexAmount) {
                                vboIndexes[blockTextureMapIndex][c] = indexListToAdd[lI];
                                ++c;
                                ++lI;
                            }
                            int n2 = blockTextureMapIndex;
                            vboIndexesWritten[n2] = vboIndexesWritten[n2] + anIndexAmount;
                            float[] textureCoordListToUse = null;
                            if (isSplitterObject) {
                                textureCoordListToUse = SplitterData.getInstance().splitterTextureCoords[neighbourNumber];
                            } else {
                                textureCoordListToUse = ObjectData.myObjectTexCoordData[anObjectType];
                                int active = aChunkToDo.getActiveAt(i2, j, k);
                                if (active > 0) {
                                    active = 1;
                                }
                                if (aBlockInfo.isMultisided()) {
                                    int index;
                                    int direction = aChunkToDo.getDirectionAt(i2, j, k);
                                    int n3 = index = direction == 0 ? 0 : 1;
                                    textureCoordListToUse = aBlockInfo.isActivatable() ? ObjectData.myObjectTexCoordMultisidedDataDirectionActive[0][index + active * 2] : ObjectData.myObjectTexCoordMultisidedDataDirection[0][index];
                                } else if (aBlockInfo.isActivatable()) {
                                    textureCoordListToUse = ObjectData.myObjectTexCoordDataActive[0][active];
                                }
                            }
                            c = vboTexCoordsWritten[blockTextureMapIndex];
                            lI = 0;
                            while (c < vboTexCoordsWritten[blockTextureMapIndex] + aTextureIndexAmount) {
                                vboTexCoords[blockTextureMapIndex][c] = textureCoordListToUse[lI];
                                ++c;
                                ++lI;
                            }
                            int n4 = blockTextureMapIndex;
                            vboTexCoordsWritten[n4] = vboTexCoordsWritten[n4] + aTextureIndexAmount;
                            myIndexCountMap.put(blockTexture, (Integer)myIndexCountMap.get(blockTexture) + 1);
                        }
                        ++k;
                    }
                    ++j;
                }
                ++i2;
            }
            if (aNumberOfUniqueTextures > 0) {
                theChunk.isEmpty = false;
                theChunk.isInitialized = true;
                theChunk.myNumberOfVertices = new int[aNumberOfUniqueTextures];
                if (myCountedMap.keySet() == null) {
                    System.out.println("the keyset was null");
                }
                if (myCountedMap.keySet().toArray() == null) {
                    System.out.println("the array was null");
                }
                try {
                    int l4 = 0;
                    while (l4 < myIndexCountMap.keySet().toArray().length) {
                        theChunk.myNumberOfVertices[l4] = vboIndexesWritten[l4];
                        ++l4;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                theGl.glGenBuffers(aNumberOfUniqueTextures, theChunk.myVertexVboList, 0);
                theGl.glGenBuffers(aNumberOfUniqueTextures, theChunk.myIndexVboList, 0);
                theGl.glGenBuffers(aNumberOfUniqueTextures, theChunk.myTextureCoordVboList, 0);
                theGl.glGenBuffers(aNumberOfUniqueTextures, theChunk.myColorVboList, 0);
                int vboIndex = 0;
                while (vboIndex < aNumberOfUniqueTextures) {
                    theGl.glBindBuffer(34962, theChunk.myVertexVboList[vboIndex]);
                    FloatBuffer fb = GLBuffers.newDirectFloatBuffer((float[])vboVertexes[vboIndex]);
                    theGl.glBufferData(34962, (long)(vboVertexesWritten[vboIndex] * 4), (Buffer)fb, 35044);
                    theGl.glBindBuffer(34962, theChunk.myColorVboList[vboIndex]);
                    FloatBuffer fbc = GLBuffers.newDirectFloatBuffer((float[])vboColors[vboIndex]);
                    theGl.glBufferData(34962, (long)(vboVertexesWritten[vboIndex] * 4), (Buffer)fbc, 35044);
                    theGl.glBindBuffer(34963, theChunk.myIndexVboList[vboIndex]);
                    IntBuffer ib = GLBuffers.newDirectIntBuffer((int[])vboIndexes[vboIndex]);
                    theGl.glBufferData(34963, (long)(vboIndexesWritten[vboIndex] * 4), (Buffer)ib, 35044);
                    theGl.glBindBuffer(34962, theChunk.myTextureCoordVboList[vboIndex]);
                    FloatBuffer ftb = GLBuffers.newDirectFloatBuffer((float[])vboTexCoords[vboIndex]);
                    theGl.glBufferData(34962, (long)(vboTexCoordsWritten[vboIndex] * 4), (Buffer)ftb, 35044);
                    ++vboIndex;
                }
                int l5 = 0;
                while (l5 < myCountedMap.keySet().toArray().length) {
                    theChunk.myTextureIdList[l5] = (Integer)myCountedMap.keySet().toArray()[l5];
                    ++l5;
                }
            }
        } else {
            theChunk.isEmpty = true;
            theChunk.isJustAir = true;
            theChunk.isInitialized = true;
        }
        theChunk.isInitialized = true;
    }

    private float[] getVertexesWithOffset(float x, float y, float z, int objectType) {
        float[] returnArray = new float[ObjectData.myObjectVertexData[objectType].length];
        int i = 0;
        while (i < returnArray.length) {
            if (i % 3 == 0) {
                returnArray[i] = ObjectData.myObjectVertexData[objectType][i] + x;
            }
            if (i % 3 == 1) {
                returnArray[i] = ObjectData.myObjectVertexData[objectType][i] + y;
            }
            if (i % 3 == 2) {
                returnArray[i] = ObjectData.myObjectVertexData[objectType][i] + z;
            }
            ++i;
        }
        return returnArray;
    }

    private float[] getSplitterVertexesWithOffset(float x, float y, float z, int neighbourNumber) {
        float[] returnArray = new float[SplitterData.getInstance().splitterVertices[neighbourNumber].length];
        float[] tempList = SplitterData.getInstance().splitterVertices[neighbourNumber];
        int i = 0;
        while (i < returnArray.length) {
            if (i % 3 == 0) {
                returnArray[i] = tempList[i] + x;
            }
            if (i % 3 == 1) {
                returnArray[i] = tempList[i] + y;
            }
            if (i % 3 == 2) {
                returnArray[i] = tempList[i] + z;
            }
            ++i;
        }
        return returnArray;
    }

    private int getNeighbourNumber(int x, int y, int z, Chunk theChunkToDo) {
        int hasLeft = theChunkToDo.getBlockAt(x - 1, y, z) > 0 ? 1 : 0;
        int hasRight = theChunkToDo.getBlockAt(x + 1, y, z) > 0 ? 1 : 0;
        int hasTop = theChunkToDo.getBlockAt(x, y + 1, z) > 0 ? 1 : 0;
        int hasBottom = theChunkToDo.getBlockAt(x, y - 1, z) > 0 ? 1 : 0;
        int hasFront = theChunkToDo.getBlockAt(x, y, z - 1) > 0 ? 1 : 0;
        int hasBack = theChunkToDo.getBlockAt(x, y, z + 1) > 0 ? 1 : 0;
        int retVal = hasLeft + (hasRight << 1) + (hasTop << 2) + (hasBottom << 3) + (hasFront << 4) + (hasBack << 5);
        return retVal;
    }

    private int getNeighbourNumberOnlySelf(int x, int y, int z, Chunk theChunkToDo, int theBlockId) {
        int hasLeft = theChunkToDo.getBlockAt(x - 1, y, z) == theBlockId ? 1 : 0;
        int hasRight = theChunkToDo.getBlockAt(x + 1, y, z) == theBlockId ? 1 : 0;
        int hasTop = theChunkToDo.getBlockAt(x, y + 1, z) == theBlockId ? 1 : 0;
        int hasBottom = theChunkToDo.getBlockAt(x, y - 1, z) == theBlockId ? 1 : 0;
        int hasFront = theChunkToDo.getBlockAt(x, y, z - 1) == theBlockId ? 1 : 0;
        int hasBack = theChunkToDo.getBlockAt(x, y, z + 1) == theBlockId ? 1 : 0;
        int retVal = hasLeft + (hasRight << 1) + (hasTop << 2) + (hasBottom << 3) + (hasFront << 4) + (hasBack << 5);
        return retVal;
    }

    private float[] getStrangeLight(int x, int y, int z, int itterations, int spread, Chunk theChunkToDo, int anObjectType) {
        if (anObjectType == 0) {
            float[] returnArray = new float[72];
            float lightMod = 0.2f;
            float[][][] singleList = new float[2][2][2];
            float[] freeTo = new float[6];
            int i = 0;
            while (i < 6) {
                freeTo[i] = 1.0f;
                ++i;
            }
            singleList[0][0][0] = (float)this.checkCube(x, y, z, -1, -1, -1, theChunkToDo) / 7.0f;
            singleList[1][0][0] = (float)this.checkCube(x, y, z, 1, -1, -1, theChunkToDo) / 7.0f;
            singleList[0][1][0] = (float)this.checkCube(x, y, z, -1, 1, -1, theChunkToDo) / 7.0f;
            singleList[1][1][0] = (float)this.checkCube(x, y, z, 1, 1, -1, theChunkToDo) / 7.0f;
            singleList[0][0][1] = (float)this.checkCube(x, y, z, -1, -1, 1, theChunkToDo) / 7.0f;
            singleList[1][0][1] = (float)this.checkCube(x, y, z, 1, -1, 1, theChunkToDo) / 7.0f;
            singleList[0][1][1] = (float)this.checkCube(x, y, z, -1, 1, 1, theChunkToDo) / 7.0f;
            singleList[1][1][1] = (float)this.checkCube(x, y, z, 1, 1, 1, theChunkToDo) / 7.0f;
            float[] fArray = singleList[0][0];
            fArray[0] = fArray[0] * (singleList[0][0][0] * lightMod + 0.2f);
            float[] fArray2 = singleList[1][0];
            fArray2[0] = fArray2[0] * (singleList[1][0][0] * lightMod + 0.2f);
            float[] fArray3 = singleList[0][1];
            fArray3[0] = fArray3[0] * (singleList[0][1][0] * lightMod + 0.2f);
            float[] fArray4 = singleList[1][1];
            fArray4[0] = fArray4[0] * (singleList[1][1][0] * lightMod + 0.2f);
            float[] fArray5 = singleList[0][0];
            fArray5[1] = fArray5[1] * (singleList[0][0][1] * lightMod + 0.2f);
            float[] fArray6 = singleList[1][0];
            fArray6[1] = fArray6[1] * (singleList[1][0][1] * lightMod + 0.2f);
            float[] fArray7 = singleList[0][1];
            fArray7[1] = fArray7[1] * (singleList[0][1][1] * lightMod + 0.2f);
            float[] fArray8 = singleList[1][1];
            fArray8[1] = fArray8[1] * (singleList[1][1][1] * lightMod + 0.2f);
            float yMod = 0.3f;
            if (!theChunkToDo.getFreeToTop(x, y, z + 1)) {
                freeTo[0] = yMod;
            }
            if (!theChunkToDo.getFreeToTop(x + 1, y, z)) {
                freeTo[1] = yMod;
            }
            if (!theChunkToDo.getFreeToTop(x, y, z - 1)) {
                freeTo[2] = yMod;
            }
            if (!theChunkToDo.getFreeToTop(x - 1, y, z)) {
                freeTo[3] = yMod;
            }
            if (theChunkToDo.getFreeToTop(x, y + 1, z)) {
                freeTo[4] = 4.4f;
            }
            freeTo[5] = yMod;
            float[] dynLightValR = new float[6];
            float[] dynLightValG = new float[6];
            float[] dynLightValB = new float[6];
            dynLightValR[0] = (float)theChunkToDo.getLightAt(x, y, z + 1, 0) / 15.0f;
            dynLightValR[0] = dynLightValR[0] * dynLightValR[0];
            dynLightValR[1] = (float)theChunkToDo.getLightAt(x + 1, y, z, 0) / 15.0f;
            dynLightValR[1] = dynLightValR[1] * dynLightValR[1];
            dynLightValR[2] = (float)theChunkToDo.getLightAt(x, y, z - 1, 0) / 15.0f;
            dynLightValR[2] = dynLightValR[2] * dynLightValR[2];
            dynLightValR[3] = (float)theChunkToDo.getLightAt(x - 1, y, z, 0) / 15.0f;
            dynLightValR[3] = dynLightValR[3] * dynLightValR[3];
            dynLightValR[4] = (float)theChunkToDo.getLightAt(x, y + 1, z, 0) / 15.0f;
            dynLightValR[4] = dynLightValR[4] * dynLightValR[4];
            dynLightValR[5] = (float)theChunkToDo.getLightAt(x, y - 1, z, 0) / 15.0f;
            dynLightValR[5] = dynLightValR[5] * dynLightValR[5];
            dynLightValG[0] = (float)theChunkToDo.getLightAt(x, y, z + 1, 1) / 15.0f;
            dynLightValG[0] = dynLightValG[0] * dynLightValG[0];
            dynLightValG[1] = (float)theChunkToDo.getLightAt(x + 1, y, z, 1) / 15.0f;
            dynLightValG[1] = dynLightValG[1] * dynLightValG[1];
            dynLightValG[2] = (float)theChunkToDo.getLightAt(x, y, z - 1, 1) / 15.0f;
            dynLightValG[2] = dynLightValG[2] * dynLightValG[2];
            dynLightValG[3] = (float)theChunkToDo.getLightAt(x - 1, y, z, 1) / 15.0f;
            dynLightValG[3] = dynLightValG[3] * dynLightValG[3];
            dynLightValG[4] = (float)theChunkToDo.getLightAt(x, y + 1, z, 1) / 15.0f;
            dynLightValG[4] = dynLightValG[4] * dynLightValG[4];
            dynLightValG[5] = (float)theChunkToDo.getLightAt(x, y - 1, z, 1) / 15.0f;
            dynLightValG[5] = dynLightValG[5] * dynLightValG[5];
            dynLightValB[0] = (float)theChunkToDo.getLightAt(x, y, z + 1, 2) / 15.0f;
            dynLightValB[0] = dynLightValB[0] * dynLightValB[0];
            dynLightValB[1] = (float)theChunkToDo.getLightAt(x + 1, y, z, 2) / 15.0f;
            dynLightValB[1] = dynLightValB[1] * dynLightValB[1];
            dynLightValB[2] = (float)theChunkToDo.getLightAt(x, y, z - 1, 2) / 15.0f;
            dynLightValB[2] = dynLightValB[2] * dynLightValB[2];
            dynLightValB[3] = (float)theChunkToDo.getLightAt(x - 1, y, z, 2) / 15.0f;
            dynLightValB[3] = dynLightValB[3] * dynLightValB[3];
            dynLightValB[4] = (float)theChunkToDo.getLightAt(x, y + 1, z, 2) / 15.0f;
            dynLightValB[4] = dynLightValB[4] * dynLightValB[4];
            dynLightValB[5] = (float)theChunkToDo.getLightAt(x, y - 1, z, 2) / 15.0f;
            dynLightValB[5] = dynLightValB[5] * dynLightValB[5];
            float[] vertexes = ObjectData.myObjectVertexData[0];
            int i2 = 0;
            int si = 0;
            while (i2 < 6) {
                int j = 0;
                while (j < 4) {
                    int vertexIndex = j * 3 + i2 * 12;
                    float[] averageVals = new float[3];
                    float xv = vertexes[vertexIndex];
                    float yv = vertexes[vertexIndex + 1];
                    float zv = vertexes[vertexIndex + 2];
                    int ix = xv < 0.0f ? 0 : 1;
                    int iy = yv < 0.0f ? 0 : 1;
                    int iz = zv < 0.0f ? 0 : 1;
                    averageVals[0] = dynLightValR[i2];
                    averageVals[1] = dynLightValG[i2];
                    averageVals[2] = dynLightValB[i2];
                    averageVals[0] = averageVals[0] + singleList[ix][iy][iz] * freeTo[i2];
                    averageVals[1] = averageVals[1] + singleList[ix][iy][iz] * freeTo[i2];
                    averageVals[2] = averageVals[2] + singleList[ix][iy][iz] * freeTo[i2];
                    int k = 0;
                    while (k < 3) {
                        float retVal = averageVals[k];
                        if (retVal > 1.0f) {
                            retVal = 1.0f;
                        }
                        returnArray[si] = retVal;
                        ++k;
                        ++si;
                    }
                    ++j;
                }
                ++i2;
            }
            return returnArray;
        }
        float[] returnArray = new float[ObjectData.myObjectVertexData[anObjectType].length];
        float r = (float)theChunkToDo.getLightAt(x, y, z, 0) / 15.0f;
        float g = (float)theChunkToDo.getLightAt(x, y, z, 1) / 15.0f;
        float b = (float)theChunkToDo.getLightAt(x, y, z, 2) / 15.0f;
        r *= r;
        g *= g;
        b *= b;
        r += 0.5f;
        g += 0.5f;
        b += 0.5f;
        if (r > 1.0f) {
            r = 1.0f;
        }
        if (g > 1.0f) {
            g = 1.0f;
        }
        if (b > 1.0f) {
            b = 1.0f;
        }
        int i = 0;
        while (i < returnArray.length) {
            if (i % 3 == 0) {
                returnArray[i] = r;
            }
            if (i % 3 == 1) {
                returnArray[i] = g;
            }
            if (i % 3 == 2) {
                returnArray[i] = b;
            }
            ++i;
        }
        return returnArray;
    }

    private float[] getSplitterLight(int neighbourNumber, Chunk theChunkToDo, int x, int y, int z) {
        float[] returnArray = new float[SplitterData.getInstance().splitterVertices[neighbourNumber].length];
        float r = (float)theChunkToDo.getLightAt(x, y, z, 0) / 15.0f;
        float g = (float)theChunkToDo.getLightAt(x, y, z, 1) / 15.0f;
        float b = (float)theChunkToDo.getLightAt(x, y, z, 2) / 15.0f;
        r *= r;
        g *= g;
        b *= b;
        r += 0.5f;
        g += 0.5f;
        b += 0.5f;
        if (r > 1.0f) {
            r = 1.0f;
        }
        if (g > 1.0f) {
            g = 1.0f;
        }
        if (b > 1.0f) {
            b = 1.0f;
        }
        int i = 0;
        while (i < returnArray.length) {
            if (i % 3 == 0) {
                returnArray[i] = r;
            }
            if (i % 3 == 1) {
                returnArray[i] = g;
            }
            if (i % 3 == 2) {
                returnArray[i] = b;
            }
            ++i;
        }
        return returnArray;
    }

    private int checkSideX(int x, int y, int z, int dir, int itterations, int spread, Chunk theChunkToDo) {
        int c = 0;
        int solidCount = 0;
        int i = x + dir;
        while (c < itterations) {
            int j = y - spread;
            while (j <= y + spread) {
                int k = z - spread;
                while (k <= z + spread) {
                    int blockId = theChunkToDo.getTransparencyAt(i, j, k);
                    if (blockId == 0) {
                        ++solidCount;
                    }
                    ++k;
                }
                ++j;
            }
            i += dir;
            ++c;
        }
        return solidCount;
    }

    private int checkSideY(int x, int y, int z, int dir, int itterations, int spread, Chunk theChunkToDo) {
        int c = 0;
        int solidCount = 0;
        int j = y + dir;
        while (c < itterations) {
            int i = x - spread;
            while (i <= x + spread) {
                int k = z - spread;
                while (k <= z + spread) {
                    int blockId = theChunkToDo.getTransparencyAt(i, j, k);
                    if (blockId == 0) {
                        ++solidCount;
                    }
                    ++k;
                }
                ++i;
            }
            j += dir;
            ++c;
        }
        return solidCount;
    }

    private int checkSideZ(int x, int y, int z, int dir, int itterations, int spread, Chunk theChunkToDo) {
        int c = 0;
        int solidCount = 0;
        int k = z + dir;
        while (c < itterations) {
            int j = y - spread;
            while (j <= y + spread) {
                int i = x - spread;
                while (i <= x + spread) {
                    int blockId = theChunkToDo.getTransparencyAt(i, j, k);
                    if (blockId == 0) {
                        ++solidCount;
                    }
                    ++i;
                }
                ++j;
            }
            k += dir;
            ++c;
        }
        return solidCount;
    }

    private int checkCube(int x, int y, int z, int modx, int mody, int modz, Chunk theChunkToDo) {
        int val7;
        int val6;
        int val5;
        int val4;
        int val3;
        int val2;
        boolean solidCount = false;
        int val1 = theChunkToDo.getTransparencyAt(x + modx, y, z) > 0 ? 1 : 0;
        int retVal = val1 + (val2 = theChunkToDo.getTransparencyAt(x + modx, y + mody, z) > 0 ? 1 : 0) + (val3 = theChunkToDo.getTransparencyAt(x, y + mody, z) > 0 ? 1 : 0) + (val4 = theChunkToDo.getTransparencyAt(x, y, z + modz) > 0 ? 1 : 0) + (val5 = theChunkToDo.getTransparencyAt(x + modx, y, z + modz) > 0 ? 1 : 0) + (val6 = theChunkToDo.getTransparencyAt(x + modx, y + mody, z + modz) > 0 ? 1 : 0) + (val7 = theChunkToDo.getTransparencyAt(x, y + mody, z + modz) > 0 ? 1 : 0);
        if (retVal > 6) {
            retVal = 6;
        }
        return retVal;
    }

    private int[] getIndexesWithOffset(int offset, int objectType) {
        int[] returnArray = new int[ObjectData.myIndicesVboData[objectType].length];
        int i = 0;
        while (i < returnArray.length) {
            returnArray[i] = ObjectData.myIndicesVboData[objectType][i] + offset;
            ++i;
        }
        return returnArray;
    }

    private int[] getSplitterIndexesWithOffset(int offset, int neighbourNumber) {
        int[] tempArray = SplitterData.getInstance().splitterIndices[neighbourNumber];
        int[] returnArray = new int[tempArray.length];
        int i = 0;
        while (i < returnArray.length) {
            returnArray[i] = tempArray[i] + offset;
            ++i;
        }
        return returnArray;
    }

    public int getHighestNeighbourLight(int x, int y, int z, int component) {
        int aHighestValue = 0;
        int currentLightVal = 0;
        currentLightVal = this.myProvider.getLightAt(x - 1, y, z, component);
        if (currentLightVal > aHighestValue) {
            aHighestValue = currentLightVal;
        }
        if ((currentLightVal = this.myProvider.getLightAt(x + 1, y, z, component)) > aHighestValue) {
            aHighestValue = currentLightVal;
        }
        if ((currentLightVal = this.myProvider.getLightAt(x, y - 1, z, component)) > aHighestValue) {
            aHighestValue = currentLightVal;
        }
        if ((currentLightVal = this.myProvider.getLightAt(x, y + 1, z, component)) > aHighestValue) {
            aHighestValue = currentLightVal;
        }
        if ((currentLightVal = this.myProvider.getLightAt(x, y, z - 1, component)) > aHighestValue) {
            aHighestValue = currentLightVal;
        }
        if ((currentLightVal = this.myProvider.getLightAt(x, y, z + 1, component)) > aHighestValue) {
            aHighestValue = currentLightVal;
        }
        return aHighestValue;
    }

    public Set<ChunkDataWrapper> addLightSourceFill(int x, int y, int z, int lightlevel, GL2 theGl, GLU theGlu, boolean getChunks, int component) {
        Stack<LightNode> aStack = new Stack<LightNode>();
        HashSet<ChunkDataWrapper> aSetOfChunks = new HashSet<ChunkDataWrapper>();
        LightNode aStartNode = new LightNode(x, y, z, lightlevel);
        aStack.push(aStartNode);
        long count = 0L;
        while (!aStack.isEmpty()) {
            int aBlockLightLevel;
            LightNode aNodeToExamine = (LightNode)aStack.pop();
            ++count;
            int aBlockId = this.myProvider.getBlockAt(aNodeToExamine.x, aNodeToExamine.y, aNodeToExamine.z);
            if (!BlockLoader.getInstance().isLightOrTransparent(aBlockId) || aNodeToExamine.lightVal <= (aBlockLightLevel = this.myProvider.getLightAt(aNodeToExamine.x, aNodeToExamine.y, aNodeToExamine.z, component))) continue;
            this.myProvider.setLightAt(aNodeToExamine.x, aNodeToExamine.y, aNodeToExamine.z, aNodeToExamine.lightVal, component);
            if (getChunks) {
                ChunkDataWrapper aWrapper = this.getChunkAt(aNodeToExamine.x, aNodeToExamine.y, aNodeToExamine.z, theGl);
                aSetOfChunks.add(aWrapper);
                aSetOfChunks.addAll(this.getBorderingChunks(aNodeToExamine.x, aNodeToExamine.y, aNodeToExamine.z, theGl));
            }
            if (aNodeToExamine.lightVal <= 1) continue;
            int newLightLevel = aNodeToExamine.lightVal - 1;
            aStack.add(new LightNode(aNodeToExamine.x - 1, aNodeToExamine.y, aNodeToExamine.z, newLightLevel));
            aStack.add(new LightNode(aNodeToExamine.x + 1, aNodeToExamine.y, aNodeToExamine.z, newLightLevel));
            aStack.add(new LightNode(aNodeToExamine.x, aNodeToExamine.y - 1, aNodeToExamine.z, newLightLevel));
            aStack.add(new LightNode(aNodeToExamine.x, aNodeToExamine.y + 1, aNodeToExamine.z, newLightLevel));
            aStack.add(new LightNode(aNodeToExamine.x, aNodeToExamine.y, aNodeToExamine.z - 1, newLightLevel));
            aStack.add(new LightNode(aNodeToExamine.x, aNodeToExamine.y, aNodeToExamine.z + 1, newLightLevel));
        }
        return aSetOfChunks;
    }

    public void explode(int x, int y, int z, int strength, GL2 theGl, GLU theGlu) {
        HashSet<ChunkDataWrapper> aSetOfChunks = new HashSet<ChunkDataWrapper>();
        HashMap<String, Boolean> examined = new HashMap<String, Boolean>();
        LinkedList<LightNode> aStack = new LinkedList<LightNode>();
        Random aRandom = new Random();
        LightNode aStartNode = new LightNode(x, y, z, strength);
        int[] blockList = new int[]{6, 9};
        aStack.add(aStartNode);
        while (!aStack.isEmpty()) {
            int newStrength;
            LightNode aNodeToExamine = (LightNode)aStack.remove();
            int aBlockId = this.myProvider.getBlockAt(aNodeToExamine.x, aNodeToExamine.y, aNodeToExamine.z);
            Block aBlock = BlockLoader.getInstance().getMyBlocksAsArray()[aBlockId];
            if (aBlockId > 0 && aBlock.getBlockStrength() < aNodeToExamine.lightVal) {
                Block gBlock = BlockLoader.getInstance().getMyBlocksAsArray()[blockList[aRandom.nextInt(blockList.length)]];
                aSetOfChunks.addAll(this.addBlockWithoutVBOUpdates(aNodeToExamine.x, aNodeToExamine.y, aNodeToExamine.z, gBlock, theGl, theGlu, 0, true));
            }
            if (aNodeToExamine.lightVal <= 0 || (newStrength = aNodeToExamine.lightVal - aBlock.getBlockStrength()) <= 0) continue;
            if (examined.get(String.valueOf(aNodeToExamine.x - 1) + "|" + aNodeToExamine.y + "|" + aNodeToExamine.z) == null && aRandom.nextInt(100) > 40) {
                aStack.add(new LightNode(aNodeToExamine.x - 1, aNodeToExamine.y, aNodeToExamine.z, newStrength));
                examined.put(String.valueOf(aNodeToExamine.x - 1) + "|" + aNodeToExamine.y + "|" + aNodeToExamine.z, true);
            }
            if (examined.get(String.valueOf(aNodeToExamine.x + 1) + "|" + aNodeToExamine.y + "|" + aNodeToExamine.z) == null && aRandom.nextInt(100) > 40) {
                aStack.add(new LightNode(aNodeToExamine.x + 1, aNodeToExamine.y, aNodeToExamine.z, newStrength));
                examined.put(String.valueOf(aNodeToExamine.x + 1) + "|" + aNodeToExamine.y + "|" + aNodeToExamine.z, true);
            }
            if (examined.get(String.valueOf(aNodeToExamine.x) + "|" + (aNodeToExamine.y - 1) + "|" + aNodeToExamine.z) == null && aRandom.nextInt(100) > 40) {
                aStack.add(new LightNode(aNodeToExamine.x, aNodeToExamine.y - 1, aNodeToExamine.z, newStrength));
                examined.put(String.valueOf(aNodeToExamine.x) + "|" + (aNodeToExamine.y - 1) + "|" + aNodeToExamine.z, true);
            }
            if (examined.get(String.valueOf(aNodeToExamine.x) + "|" + (aNodeToExamine.y + 1) + "|" + aNodeToExamine.z) == null && aRandom.nextInt(100) > 40) {
                aStack.add(new LightNode(aNodeToExamine.x, aNodeToExamine.y + 1, aNodeToExamine.z, newStrength));
                examined.put(String.valueOf(aNodeToExamine.x) + "|" + (aNodeToExamine.y + 1) + "|" + aNodeToExamine.z, true);
            }
            if (examined.get(String.valueOf(aNodeToExamine.x) + "|" + aNodeToExamine.y + "|" + (aNodeToExamine.z - 1)) == null && aRandom.nextInt(100) > 40) {
                aStack.add(new LightNode(aNodeToExamine.x, aNodeToExamine.y, aNodeToExamine.z - 1, newStrength));
                examined.put(String.valueOf(aNodeToExamine.x) + "|" + aNodeToExamine.y + "|" + (aNodeToExamine.z - 1), true);
            }
            if (examined.get(String.valueOf(aNodeToExamine.x) + "|" + aNodeToExamine.y + "|" + (aNodeToExamine.z + 1)) != null || aRandom.nextInt(100) <= 40) continue;
            aStack.add(new LightNode(aNodeToExamine.x, aNodeToExamine.y, aNodeToExamine.z + 1, newStrength));
            examined.put(String.valueOf(aNodeToExamine.x) + "|" + aNodeToExamine.y + "|" + (aNodeToExamine.z + 1), true);
        }
        examined = null;
        for (ChunkDataWrapper aChunkToUpdate : aSetOfChunks) {
            this.rebuildVBOForChunk(theGl, theGlu, aChunkToUpdate);
        }
    }

    public void realExplode(int x, int y, int z, int strength, GL2 theGl, GLU theGlu) {
        HashSet<ChunkDataWrapper> aSetOfChunks = new HashSet<ChunkDataWrapper>();
        HashMap<String, Boolean> examined = new HashMap<String, Boolean>();
        LinkedList<LightNode> aStack = new LinkedList<LightNode>();
        Random aRandom = new Random();
        LightNode aStartNode = new LightNode(x, y, z, strength);
        int[] blockList = new int[]{6, 9};
        aStack.add(aStartNode);
        while (!aStack.isEmpty()) {
            int newStrength;
            LightNode aNodeToExamine = (LightNode)aStack.remove();
            int aBlockId = this.myProvider.getBlockAt(aNodeToExamine.x, aNodeToExamine.y, aNodeToExamine.z);
            Block aBlock = BlockLoader.getInstance().getMyBlocksAsArray()[aBlockId];
            if (aBlockId > 0 && aBlock.getBlockStrength() < aNodeToExamine.lightVal) {
                aSetOfChunks.addAll(this.removeBlockWithoutVBOUpdates(aNodeToExamine.x, aNodeToExamine.y, aNodeToExamine.z, theGl, theGlu, false, true));
            }
            if (aNodeToExamine.lightVal <= 0 || (newStrength = aNodeToExamine.lightVal - aBlock.getBlockStrength()) <= 0) continue;
            if (examined.get(String.valueOf(aNodeToExamine.x - 1) + "|" + aNodeToExamine.y + "|" + aNodeToExamine.z) == null && aRandom.nextInt(100) > 40) {
                aStack.add(new LightNode(aNodeToExamine.x - 1, aNodeToExamine.y, aNodeToExamine.z, newStrength));
                examined.put(String.valueOf(aNodeToExamine.x - 1) + "|" + aNodeToExamine.y + "|" + aNodeToExamine.z, true);
            }
            if (examined.get(String.valueOf(aNodeToExamine.x + 1) + "|" + aNodeToExamine.y + "|" + aNodeToExamine.z) == null && aRandom.nextInt(100) > 40) {
                aStack.add(new LightNode(aNodeToExamine.x + 1, aNodeToExamine.y, aNodeToExamine.z, newStrength));
                examined.put(String.valueOf(aNodeToExamine.x + 1) + "|" + aNodeToExamine.y + "|" + aNodeToExamine.z, true);
            }
            if (examined.get(String.valueOf(aNodeToExamine.x) + "|" + (aNodeToExamine.y - 1) + "|" + aNodeToExamine.z) == null && aRandom.nextInt(100) > 40) {
                aStack.add(new LightNode(aNodeToExamine.x, aNodeToExamine.y - 1, aNodeToExamine.z, newStrength));
                examined.put(String.valueOf(aNodeToExamine.x) + "|" + (aNodeToExamine.y - 1) + "|" + aNodeToExamine.z, true);
            }
            if (examined.get(String.valueOf(aNodeToExamine.x) + "|" + (aNodeToExamine.y + 1) + "|" + aNodeToExamine.z) == null && aRandom.nextInt(100) > 40) {
                aStack.add(new LightNode(aNodeToExamine.x, aNodeToExamine.y + 1, aNodeToExamine.z, newStrength));
                examined.put(String.valueOf(aNodeToExamine.x) + "|" + (aNodeToExamine.y + 1) + "|" + aNodeToExamine.z, true);
            }
            if (examined.get(String.valueOf(aNodeToExamine.x) + "|" + aNodeToExamine.y + "|" + (aNodeToExamine.z - 1)) == null && aRandom.nextInt(100) > 40) {
                aStack.add(new LightNode(aNodeToExamine.x, aNodeToExamine.y, aNodeToExamine.z - 1, newStrength));
                examined.put(String.valueOf(aNodeToExamine.x) + "|" + aNodeToExamine.y + "|" + (aNodeToExamine.z - 1), true);
            }
            if (examined.get(String.valueOf(aNodeToExamine.x) + "|" + aNodeToExamine.y + "|" + (aNodeToExamine.z + 1)) != null || aRandom.nextInt(100) <= 40) continue;
            aStack.add(new LightNode(aNodeToExamine.x, aNodeToExamine.y, aNodeToExamine.z + 1, newStrength));
            examined.put(String.valueOf(aNodeToExamine.x) + "|" + aNodeToExamine.y + "|" + (aNodeToExamine.z + 1), true);
        }
        examined = null;
        for (ChunkDataWrapper aChunkToUpdate : aSetOfChunks) {
            this.rebuildVBOForChunk(theGl, theGlu, aChunkToUpdate);
        }
    }

    public Set<ChunkDataWrapper> removeLightSourceFill(int x, int y, int z, GL2 theGl, GLU theGlu, boolean getChunks, boolean skipCenter, int component) {
        HashSet<ChunkDataWrapper> aSetOfChunks = new HashSet<ChunkDataWrapper>();
        int aStartBlockLightLevel = this.myProvider.getLightAt(x, y, z, component);
        if (aStartBlockLightLevel > 0) {
            LinkedList<LightNode> aStack = new LinkedList<LightNode>();
            ArrayList<LightNode> aRelightFrom = new ArrayList<LightNode>();
            ArrayList aListToZero = new ArrayList();
            LightNode aStartNode = new LightNode(x, y, z, aStartBlockLightLevel);
            if (!skipCenter) {
                aStack.add(aStartNode);
            } else {
                aStack.add(new LightNode(aStartNode.x - 1, aStartNode.y, aStartNode.z, aStartNode.lightVal - 1));
                aStack.add(new LightNode(aStartNode.x + 1, aStartNode.y, aStartNode.z, aStartNode.lightVal - 1));
                aStack.add(new LightNode(aStartNode.x, aStartNode.y - 1, aStartNode.z, aStartNode.lightVal - 1));
                aStack.add(new LightNode(aStartNode.x, aStartNode.y + 1, aStartNode.z, aStartNode.lightVal - 1));
                aStack.add(new LightNode(aStartNode.x, aStartNode.y, aStartNode.z - 1, aStartNode.lightVal - 1));
                aStack.add(new LightNode(aStartNode.x, aStartNode.y, aStartNode.z + 1, aStartNode.lightVal - 1));
            }
            long count = 0L;
            while (!aStack.isEmpty()) {
                LightNode aNodeToExamine = (LightNode)aStack.remove();
                ++count;
                int aBlockId = this.myProvider.getBlockAt(aNodeToExamine.x, aNodeToExamine.y, aNodeToExamine.z);
                if (!BlockLoader.getInstance().isLightOrTransparent(aBlockId)) continue;
                int aBlockLightLevel = this.myProvider.getLightAt(aNodeToExamine.x, aNodeToExamine.y, aNodeToExamine.z, component);
                if (aBlockLightLevel <= aNodeToExamine.lightVal && aBlockLightLevel > 0) {
                    this.myProvider.setLightAt(aNodeToExamine.x, aNodeToExamine.y, aNodeToExamine.z, 0, component);
                    if (getChunks) {
                        ChunkDataWrapper aWrapper = this.getChunkAt(aNodeToExamine.x, aNodeToExamine.y, aNodeToExamine.z, theGl);
                        aSetOfChunks.add(aWrapper);
                        aSetOfChunks.addAll(this.getBorderingChunks(aNodeToExamine.x, aNodeToExamine.y, aNodeToExamine.z, theGl));
                    }
                    if (aNodeToExamine.lightVal <= 1) continue;
                    int newLightLevel = aNodeToExamine.lightVal - 1;
                    aStack.add(new LightNode(aNodeToExamine.x - 1, aNodeToExamine.y, aNodeToExamine.z, newLightLevel));
                    aStack.add(new LightNode(aNodeToExamine.x + 1, aNodeToExamine.y, aNodeToExamine.z, newLightLevel));
                    aStack.add(new LightNode(aNodeToExamine.x, aNodeToExamine.y - 1, aNodeToExamine.z, newLightLevel));
                    aStack.add(new LightNode(aNodeToExamine.x, aNodeToExamine.y + 1, aNodeToExamine.z, newLightLevel));
                    aStack.add(new LightNode(aNodeToExamine.x, aNodeToExamine.y, aNodeToExamine.z - 1, newLightLevel));
                    aStack.add(new LightNode(aNodeToExamine.x, aNodeToExamine.y, aNodeToExamine.z + 1, newLightLevel));
                    continue;
                }
                this.myProvider.setLightAt(aNodeToExamine.x, aNodeToExamine.y, aNodeToExamine.z, 0, component);
                if (aBlockLightLevel <= 0) continue;
                aRelightFrom.add(new LightNode(aNodeToExamine.x, aNodeToExamine.y, aNodeToExamine.z, aBlockLightLevel));
            }
            for (LightNode aNode : aRelightFrom) {
                aSetOfChunks.addAll(this.addLightSourceFill(aNode.x, aNode.y, aNode.z, aNode.lightVal, theGl, theGlu, getChunks, component));
            }
        }
        return aSetOfChunks;
    }

    public ChunkDataWrapper getChunkAt(int rx, int ry, int rz, GL2 theGl) {
        Coord megaChunkCoord = this.myProvider.fromWorldToMegaChunk(rx, ry, rz);
        Coord chunkCoord = this.myProvider.fromWorldToChunkCoord(rx, ry, rz);
        return this.getWrapperAt(megaChunkCoord.x, megaChunkCoord.y, megaChunkCoord.z, chunkCoord.x, chunkCoord.y, chunkCoord.z, theGl);
    }

    public Vector3 intersectRay(float startX, float startY, float startZ, float dirX, float dirY, float dirZ) {
        boolean found = false;
        float rx = startX;
        float ry = startY;
        float rz = startZ;
        float dirXPrec = dirX / 4.0f;
        float dirYPrec = dirY / 4.0f;
        float dirZPrec = dirZ / 4.0f;
        while (!found) {
            if (this.myProvider.getBlockAt(Math.round(rx += dirXPrec), Math.round(ry += dirYPrec), Math.round(rz += dirZPrec)) <= 0) continue;
            return new Vector3(rx, ry, rz);
        }
        return null;
    }

    public Vector3 intersectRay(float startX, float startY, float startZ, float dirX, float dirY, float dirZ, float maxDist) {
        boolean found = false;
        float rx = startX;
        float ry = startY;
        float rz = startZ;
        float dirXPrec = dirX / 4.0f;
        float dirYPrec = dirY / 4.0f;
        float dirZPrec = dirZ / 4.0f;
        int count = 0;
        while (!found) {
            if (this.myProvider.getBlockAt(Math.round(rx + dirXPrec), Math.round(ry), Math.round(rz)) > 2) {
                return new Vector3(rx + dirXPrec, ry, rz);
            }
            if (this.myProvider.getBlockAt(Math.round(rx), Math.round(ry + dirYPrec), Math.round(rz)) > 2) {
                return new Vector3(rx, ry + dirYPrec, rz);
            }
            if (this.myProvider.getBlockAt(Math.round(rx), Math.round(ry), Math.round(rz + dirZPrec)) > 2) {
                return new Vector3(rx, ry, rz + dirZPrec);
            }
            rx += dirXPrec;
            ry += dirYPrec;
            rz += dirZPrec;
            if ((float)count > maxDist * 4.0f) {
                return null;
            }
            ++count;
        }
        return null;
    }

    public Vector3 intersectRayGetInfront(float startX, float startY, float startZ, float dirX, float dirY, float dirZ) {
        boolean found = false;
        float rx = startX;
        float ry = startY;
        float rz = startZ;
        float dirXPrec = dirX / 4.0f;
        float dirYPrec = dirY / 4.0f;
        float dirZPrec = dirZ / 4.0f;
        while (!found) {
            if (this.myProvider.getBlockAt(Math.round(rx += dirXPrec), Math.round(ry += dirYPrec), Math.round(rz += dirZPrec)) <= 0) continue;
            return new Vector3(rx - dirXPrec, ry - dirYPrec, rz - dirZPrec);
        }
        return null;
    }

    public Vector3 intersectRayGetInfront(float startX, float startY, float startZ, float dirX, float dirY, float dirZ, float maxDist) {
        boolean found = false;
        float rx = startX;
        float ry = startY;
        float rz = startZ;
        float dirXPrec = dirX / 4.0f;
        float dirYPrec = dirY / 4.0f;
        float dirZPrec = dirZ / 4.0f;
        int count = 0;
        while (!found) {
            if (this.myProvider.getBlockAt(Math.round(rx += dirXPrec), Math.round(ry += dirYPrec), Math.round(rz += dirZPrec)) > 0) {
                return new Vector3(rx - dirXPrec, ry - dirYPrec, rz - dirZPrec);
            }
            if ((float)count > maxDist * 4.0f) {
                return null;
            }
            ++count;
        }
        return null;
    }

    public Vector3 intersectRaySkipTransparentAndLightsGetInfront(float startX, float startY, float startZ, float dirX, float dirY, float dirZ, float maxDist) {
        boolean found = false;
        float rx = startX;
        float ry = startY;
        float rz = startZ;
        float dirXPrec = dirX / 4.0f;
        float dirYPrec = dirY / 4.0f;
        float dirZPrec = dirZ / 4.0f;
        int count = 0;
        while (!found) {
            int aBlockId = this.myProvider.getBlockAt(Math.round(rx += dirXPrec), Math.round(ry += dirYPrec), Math.round(rz += dirZPrec));
            if (aBlockId > 0 && !BlockLoader.getInstance().isLightOrTransparent(aBlockId)) {
                return new Vector3(rx - dirXPrec, ry - dirYPrec, rz - dirZPrec);
            }
            if ((float)count > maxDist * 4.0f) {
                return null;
            }
            ++count;
        }
        return null;
    }

    public List<ChunkDataWrapper> getBorderingChunks(int rx, int ry, int rz, GL2 theGl) {
        ChunkDataWrapper aWrapper;
        ArrayList<ChunkDataWrapper> aReturnList = new ArrayList<ChunkDataWrapper>();
        if (rx >= 0) {
            if (rx % this.myChunkSize == 0) {
                aWrapper = this.getChunkAt(rx - 1, ry, rz, theGl);
                if (aWrapper != null) {
                    aReturnList.add(aWrapper);
                }
            } else if (rx % this.myChunkSize == this.myChunkSize - 1 && (aWrapper = this.getChunkAt(rx + 1, ry, rz, theGl)) != null) {
                aReturnList.add(aWrapper);
            }
        } else if (rx % this.myChunkSize == -1) {
            aWrapper = this.getChunkAt(rx + 1, ry, rz, theGl);
            if (aWrapper != null) {
                aReturnList.add(aWrapper);
            }
        } else if (rx % this.myChunkSize == 0 && (aWrapper = this.getChunkAt(rx - 1, ry, rz, theGl)) != null) {
            aReturnList.add(aWrapper);
        }
        if (ry >= 0) {
            if (ry % this.myChunkSize == 0) {
                aWrapper = this.getChunkAt(rx, ry - 1, rz, theGl);
                if (aWrapper != null) {
                    aReturnList.add(aWrapper);
                }
            } else if (ry % this.myChunkSize == this.myChunkSize - 1 && (aWrapper = this.getChunkAt(rx, ry + 1, rz, theGl)) != null) {
                aReturnList.add(aWrapper);
            }
        } else if (ry % this.myChunkSize == -1) {
            aWrapper = this.getChunkAt(rx, ry + 1, rz, theGl);
            if (aWrapper != null) {
                aReturnList.add(aWrapper);
            }
        } else if (ry % this.myChunkSize == 0 && (aWrapper = this.getChunkAt(rx, ry - 1, rz, theGl)) != null) {
            aReturnList.add(aWrapper);
        }
        if (rz >= 0) {
            if (rz % this.myChunkSize == 0) {
                aWrapper = this.getChunkAt(rx, ry, rz - 1, theGl);
                if (aWrapper != null) {
                    aReturnList.add(aWrapper);
                }
            } else if (rz % this.myChunkSize == this.myChunkSize - 1 && (aWrapper = this.getChunkAt(rx, ry, rz + 1, theGl)) != null) {
                aReturnList.add(aWrapper);
            }
        } else if (rz % this.myChunkSize == -1) {
            aWrapper = this.getChunkAt(rx, ry, rz + 1, theGl);
            if (aWrapper != null) {
                aReturnList.add(aWrapper);
            }
        } else if (ry % this.myChunkSize == 0 && (aWrapper = this.getChunkAt(rx, ry, rz - 1, theGl)) != null) {
            aReturnList.add(aWrapper);
        }
        return aReturnList;
    }

    public void rebuildBorderingChunks(GL2 theGl, GLU theGlu, int rx, int ry, int rz) {
        List<ChunkDataWrapper> aList = this.getBorderingChunks(rx, ry, rz, theGl);
        if (aList != null) {
            for (ChunkDataWrapper aWrapper : aList) {
                this.rebuildVBOForChunk(theGl, theGlu, aWrapper);
            }
        }
    }

    public void insertGeometry(int[] theListToInsert, int w, int h, int d, int x, int y, int z, GL2 theGl, GLU theGlu) {
        int index = 0;
        HashSet<ChunkDataWrapper> aSetOfChunks = new HashSet<ChunkDataWrapper>();
        int k = 0;
        while (k < d) {
            int j = 0;
            while (j > -h) {
                int i = 0;
                while (i < w) {
                    this.myProvider.setBlockAt(x + i, y + j, z + k, theListToInsert[index], false);
                    ChunkDataWrapper aChunk = this.getChunkAt(x + i, y + j, z + k, theGl);
                    if (aChunk != null) {
                        aSetOfChunks.add(aChunk);
                    }
                    ++index;
                    ++i;
                }
                --j;
            }
            ++k;
        }
        for (ChunkDataWrapper aRebuild : aSetOfChunks) {
            this.rebuildVBOForChunk(theGl, theGlu, aRebuild);
        }
    }

    public void insertGeometrySkipAirAndOnlySetInAir(int[] theListToInsert, int w, int h, int d, int x, int y, int z, GL2 theGl, GLU theGlu, boolean isTransparent) {
        int index = 0;
        HashSet<ChunkDataWrapper> aSetOfChunks = new HashSet<ChunkDataWrapper>();
        int k = 0;
        while (k < d) {
            int j = 0;
            while (j > -h) {
                int i = 0;
                while (i < w) {
                    int blockToSet = theListToInsert[index];
                    if (blockToSet > 0 && this.myProvider.getBlockAt(x + i, y + j, z + k) == 0) {
                        this.myProvider.setBlockAt(x + i, y + j, z + k, blockToSet, isTransparent);
                        ChunkDataWrapper aChunk = this.getChunkAt(x + i, y + j, z + k, theGl);
                        if (aChunk != null) {
                            aSetOfChunks.add(aChunk);
                        }
                    }
                    ++index;
                    ++i;
                }
                --j;
            }
            ++k;
        }
        for (ChunkDataWrapper aRebuild : aSetOfChunks) {
            this.rebuildVBOForChunk(theGl, theGlu, aRebuild);
        }
    }

    public void insertGeometrySkipAir(int[] theListToInsert, int w, int h, int d, int x, int y, int z, GL2 theGl, GLU theGlu, boolean isTransparent) {
        int index = 0;
        HashSet<ChunkDataWrapper> aSetOfChunks = new HashSet<ChunkDataWrapper>();
        int k = 0;
        while (k < d) {
            int j = 0;
            while (j > -h) {
                int i = 0;
                while (i < w) {
                    int blockToSet = theListToInsert[index];
                    if (blockToSet > 0) {
                        this.myProvider.setBlockAt(x + i, y + j, z + k, blockToSet, isTransparent);
                        ChunkDataWrapper aChunk = this.getChunkAt(x + i, y + j, z + k, theGl);
                        if (aChunk != null) {
                            aSetOfChunks.add(aChunk);
                        }
                    }
                    ++index;
                    ++i;
                }
                --j;
            }
            ++k;
        }
        for (ChunkDataWrapper aRebuild : aSetOfChunks) {
            this.rebuildVBOForChunk(theGl, theGlu, aRebuild);
        }
    }

    public Vector3[] getBoundingBox(int w, int h, int d, int x, int y, int z) {
        Vector3[] aReturnList = new Vector3[]{new Vector3(x, y, z), new Vector3(x + w - 1, y, z), new Vector3(x + w - 1, y - h + 1, z), new Vector3(x, y - h + 1, z), new Vector3(x, y, z + d - 1), new Vector3(x + w - 1, y, z + d - 1), new Vector3(x + w - 1, y - h + 1, z + d - 1), new Vector3(x, y - h + 1, z + d - 1)};
        return aReturnList;
    }

    public int getMyChunkSize() {
        return this.myChunkSize;
    }

    public void setMyChunkSize(int myChunkSize) {
        this.myChunkSize = myChunkSize;
    }

    public int getBlockAt(int x, int y, int z) {
        return this.myProvider.getBlockAt(x, y, z);
    }

    public int removeBlockWithUpdates(int aXToDo, int aYToDo, int aZToDo, GL2 myGl, GLU myGlu) {
        return this.removeBlockWithUpdates(aXToDo, aYToDo, aZToDo, myGl, myGlu, false, true);
    }

    public int removeBlockWithUpdates(int aXToDo, int aYToDo, int aZToDo, GL2 myGl, GLU myGlu, boolean withExplosion, boolean withSourceAnimation) {
        int theIdToRemove = this.myProvider.getBlockAt(aXToDo, aYToDo, aZToDo);
        Block aBlockToRemove = BlockLoader.getInstance().getMyBlocksAsArray()[theIdToRemove];
        if (aBlockToRemove.isLight()) {
            Set<ChunkDataWrapper> aSetToUpdate = this.removeLightSourceFill(aXToDo, aYToDo, aZToDo, myGl, myGlu, true, false, 0);
            aSetToUpdate.addAll(this.removeLightSourceFill(aXToDo, aYToDo, aZToDo, myGl, myGlu, true, false, 1));
            aSetToUpdate.addAll(this.removeLightSourceFill(aXToDo, aYToDo, aZToDo, myGl, myGlu, true, false, 2));
            this.myProvider.setBlockAt(aXToDo, aYToDo, aZToDo, 0, true);
            for (ChunkDataWrapper aChunkToUpdate : aSetToUpdate) {
                this.rebuildVBOForChunk(myGl, myGlu, aChunkToUpdate);
            }
        } else if (aBlockToRemove.isTransparent()) {
            this.myProvider.setBlockAt(aXToDo, aYToDo, aZToDo, 0, true);
            this.rebuildVBOForChunk(myGl, myGlu, aXToDo, aYToDo, aZToDo);
            this.rebuildBorderingChunks(myGl, myGlu, aXToDo, aYToDo, aZToDo);
        } else {
            int aNewLightValueR = this.getHighestNeighbourLight(aXToDo, aYToDo, aZToDo, 0);
            int aNewLightValueG = this.getHighestNeighbourLight(aXToDo, aYToDo, aZToDo, 1);
            int aNewLightValueB = this.getHighestNeighbourLight(aXToDo, aYToDo, aZToDo, 2);
            if (aNewLightValueR > 1 || aNewLightValueG > 1 || aNewLightValueB > 1) {
                this.myProvider.setBlockAt(aXToDo, aYToDo, aZToDo, 0, true);
                Set<ChunkDataWrapper> aSetToUpdate = new HashSet<ChunkDataWrapper>();
                if (aNewLightValueR > 1) {
                    aSetToUpdate = this.addLightSourceFill(aXToDo, aYToDo, aZToDo, aNewLightValueR - 1, myGl, myGlu, true, 0);
                }
                if (aNewLightValueG > 1) {
                    aSetToUpdate.addAll(this.addLightSourceFill(aXToDo, aYToDo, aZToDo, aNewLightValueG - 1, myGl, myGlu, true, 1));
                }
                if (aNewLightValueB > 1) {
                    aSetToUpdate.addAll(this.addLightSourceFill(aXToDo, aYToDo, aZToDo, aNewLightValueB - 1, myGl, myGlu, true, 2));
                }
                if (aSetToUpdate.size() > 0) {
                    for (ChunkDataWrapper aChunkToUpdate : aSetToUpdate) {
                        this.rebuildVBOForChunk(myGl, myGlu, aChunkToUpdate);
                    }
                } else {
                    this.rebuildVBOForChunk(myGl, myGlu, aXToDo, aYToDo, aZToDo);
                    this.rebuildBorderingChunks(myGl, myGlu, aXToDo, aYToDo, aZToDo);
                }
            } else {
                this.myProvider.setBlockAt(aXToDo, aYToDo, aZToDo, 0, true);
                this.rebuildVBOForChunk(myGl, myGlu, aXToDo, aYToDo, aZToDo);
                this.rebuildBorderingChunks(myGl, myGlu, aXToDo, aYToDo, aZToDo);
            }
        }
        if (withSourceAnimation) {
            ExplosionMovable aDestruction = new ExplosionMovable(new Vector3(aXToDo, aYToDo, aZToDo), new Vector3(0.0, 0.0, 0.0), 0.0f, 0.5f, false, 0);
            MovableHandler.getInstance().addMovable(aDestruction);
        }
        if (withExplosion) {
            Random aRandom = new Random();
            int i = 0;
            while (i < 10) {
                Vector3 randomDir = new Vector3(aRandom.nextDouble() - 0.5, aRandom.nextDouble() - 0.5, aRandom.nextDouble() - 0.5);
                randomDir.normalize();
                randomDir.scale(5.0);
                CloudMovable aExplosion = new CloudMovable(new Vector3(aXToDo, aYToDo, aZToDo), randomDir, 0.0f, 1.0f, true, 0);
                MovableHandler.getInstance().addMovable(aExplosion);
                ++i;
            }
        }
        return theIdToRemove;
    }

    public Set<ChunkDataWrapper> removeBlockWithoutVBOUpdates(int aXToDo, int aYToDo, int aZToDo, GL2 myGl, GLU myGlu, boolean withExplosion, boolean withSourceAnimation) {
        int theIdToRemove = this.myProvider.getBlockAt(aXToDo, aYToDo, aZToDo);
        Block aBlockToRemove = BlockLoader.getInstance().getMyBlocksAsArray()[theIdToRemove];
        Set<Object> aSetToReturn = new HashSet();
        if (aBlockToRemove.isLight()) {
            aSetToReturn = this.removeLightSourceFill(aXToDo, aYToDo, aZToDo, myGl, myGlu, true, false, 0);
            aSetToReturn.addAll(this.removeLightSourceFill(aXToDo, aYToDo, aZToDo, myGl, myGlu, true, false, 1));
            aSetToReturn.addAll(this.removeLightSourceFill(aXToDo, aYToDo, aZToDo, myGl, myGlu, true, false, 2));
            this.myProvider.setBlockAt(aXToDo, aYToDo, aZToDo, 0, true);
        } else if (aBlockToRemove.isTransparent()) {
            this.myProvider.setBlockAt(aXToDo, aYToDo, aZToDo, 0, true);
            aSetToReturn.add(this.getChunkAt(aXToDo, aYToDo, aZToDo, myGl));
            aSetToReturn.addAll(this.getBorderingChunks(aXToDo, aYToDo, aZToDo, myGl));
        } else {
            int aNewLightValueR = this.getHighestNeighbourLight(aXToDo, aYToDo, aZToDo, 0);
            int aNewLightValueG = this.getHighestNeighbourLight(aXToDo, aYToDo, aZToDo, 1);
            int aNewLightValueB = this.getHighestNeighbourLight(aXToDo, aYToDo, aZToDo, 2);
            if (aNewLightValueR > 1 || aNewLightValueG > 1 || aNewLightValueB > 1) {
                this.myProvider.setBlockAt(aXToDo, aYToDo, aZToDo, 0, true);
                if (aNewLightValueR > 1) {
                    aSetToReturn = this.addLightSourceFill(aXToDo, aYToDo, aZToDo, aNewLightValueR - 1, myGl, myGlu, true, 0);
                }
                if (aNewLightValueG > 1) {
                    aSetToReturn.addAll(this.addLightSourceFill(aXToDo, aYToDo, aZToDo, aNewLightValueG - 1, myGl, myGlu, true, 1));
                }
                if (aNewLightValueB > 1) {
                    aSetToReturn.addAll(this.addLightSourceFill(aXToDo, aYToDo, aZToDo, aNewLightValueB - 1, myGl, myGlu, true, 2));
                }
            } else {
                this.myProvider.setBlockAt(aXToDo, aYToDo, aZToDo, 0, true);
                aSetToReturn.add(this.getChunkAt(aXToDo, aYToDo, aZToDo, myGl));
                aSetToReturn.addAll(this.getBorderingChunks(aXToDo, aYToDo, aZToDo, myGl));
            }
        }
        if (withSourceAnimation) {
            ExplosionMovable aDestruction = new ExplosionMovable(new Vector3(aXToDo, aYToDo, aZToDo), new Vector3(0.0, 0.0, 0.0), 0.0f, 0.5f, false, 0);
            MovableHandler.getInstance().addMovable(aDestruction);
        }
        if (withExplosion) {
            Random aRandom = new Random();
            int i = 0;
            while (i < 10) {
                Vector3 randomDir = new Vector3(aRandom.nextDouble() - 0.5, aRandom.nextDouble() - 0.5, aRandom.nextDouble() - 0.5);
                randomDir.normalize();
                randomDir.scale(5.0);
                CloudMovable aExplosion = new CloudMovable(new Vector3(aXToDo, aYToDo, aZToDo), randomDir, 0.0f, 1.0f, true, 0);
                MovableHandler.getInstance().addMovable(aExplosion);
                ++i;
            }
        }
        return aSetToReturn;
    }

    public void triggerTunable(int aXToDo, int aYToDo, int aZToDo, GL2 myGl, GLU myGlu, boolean recursive, Player thePlayer, boolean remote) {
        int theIdWithMetadata = this.myProvider.getBlockAt(aXToDo, aYToDo, aZToDo);
        Block aBlock = BlockLoader.getInstance().getMyBlocksAsArray()[theIdWithMetadata];
        if (aBlock.getMetaData() != null) {
            String aBlockKey = String.valueOf(aXToDo) + "|" + aYToDo + "|" + aZToDo;
            if (aBlock.getMetaData().equals("remote_activator")) {
                BlockMetaData aMetaDataFor = this.myProvider.getMetaDataMap().get(aBlockKey);
                MetaValueOverlay aMetaValueOverlay = (MetaValueOverlay)OverlayHandler.getInstance().getOverlay("metavalue");
                aMetaValueOverlay.setMyPropertyToSet("freq");
                aMetaValueOverlay.setMyMinVal(0);
                aMetaValueOverlay.setMyMaxVal(9999);
                aMetaValueOverlay.newMetaDataValue(aMetaDataFor);
                OverlayHandler.getInstance().addActiveOverlay("inventory");
                OverlayHandler.getInstance().addActiveOverlay("metavalue");
                thePlayer.setInInventory(true);
                thePlayer.setInInventoryStateChange(true);
            } else if (aBlock.getMetaData().equals("remote_receiver")) {
                BlockMetaData aMetaDataFor = this.myProvider.getMetaDataMap().get(aBlockKey);
                MetaValueOverlay aMetaValueOverlay = (MetaValueOverlay)OverlayHandler.getInstance().getOverlay("metavalue");
                aMetaValueOverlay.setMyPropertyToSet("freq");
                aMetaValueOverlay.setMyMinVal(0);
                aMetaValueOverlay.setMyMaxVal(9999);
                aMetaValueOverlay.newMetaDataValue(aMetaDataFor);
                OverlayHandler.getInstance().addActiveOverlay("inventory");
                OverlayHandler.getInstance().addActiveOverlay("metavalue");
                thePlayer.setInInventory(true);
                thePlayer.setInInventoryStateChange(true);
            } else if (aBlock.getMetaData().equals("pusher_up")) {
                BlockMetaData aMetaDataFor = this.myProvider.getMetaDataMap().get(aBlockKey);
                MetaValueOverlay aMetaValueOverlay = (MetaValueOverlay)OverlayHandler.getInstance().getOverlay("metavalue");
                aMetaValueOverlay.setMyPropertyToSet("length");
                aMetaValueOverlay.setMyMinVal(0);
                aMetaValueOverlay.setMyMaxVal(9999);
                aMetaValueOverlay.newMetaDataValue(aMetaDataFor);
                OverlayHandler.getInstance().addActiveOverlay("inventory");
                OverlayHandler.getInstance().addActiveOverlay("metavalue");
                thePlayer.setInInventory(true);
                thePlayer.setInInventoryStateChange(true);
            } else if (aBlock.getMetaData().equals("driller_down")) {
                Inventory anInventoryToShow = this.myProvider.getInventoryFor(aXToDo, aYToDo, aZToDo);
                ContainerOverlay aCrateOverlay = (ContainerOverlay)OverlayHandler.getInstance().getOverlay("container");
                aCrateOverlay.newInventory(anInventoryToShow);
                OverlayHandler.getInstance().addActiveOverlay("inventory");
                OverlayHandler.getInstance().addActiveOverlay("container");
                thePlayer.setInInventory(true);
                thePlayer.setInInventoryStateChange(true);
            } else if (aBlock.getMetaData().equals("timer")) {
                BlockMetaData aMetaDataFor = this.myProvider.getMetaDataMap().get(aBlockKey);
                MetaValueOverlay aMetaValueOverlay = (MetaValueOverlay)OverlayHandler.getInstance().getOverlay("metavalue");
                aMetaValueOverlay.setMyPropertyToSet("interval");
                aMetaValueOverlay.setMyMinVal(2);
                aMetaValueOverlay.setMyMaxVal(1000);
                aMetaValueOverlay.newMetaDataValue(aMetaDataFor);
                OverlayHandler.getInstance().addActiveOverlay("inventory");
                OverlayHandler.getInstance().addActiveOverlay("metavalue");
                thePlayer.setInInventory(true);
                thePlayer.setInInventoryStateChange(true);
            }
        }
    }

    public Set<ChunkDataWrapper> toggleActiveWithUpdates(int aXToDo, int aYToDo, int aZToDo, GL2 myGl, GLU myGlu, boolean recursive, Player thePlayer, boolean remote) {
        HashSet<ChunkDataWrapper> aSetToUpdate = new HashSet<ChunkDataWrapper>();
        int active = this.myProvider.getActiveAt(aXToDo, aYToDo, aZToDo);
        int aValueToSet = 0;
        if (active == 0) {
            aValueToSet = 1;
        }
        this.myProvider.setActiveAt(aXToDo, aYToDo, aZToDo, aValueToSet);
        if (this.myProvider.getMetaDataAt(aXToDo, aYToDo, aZToDo) != 0) {
            int theIdWithMetadata = this.myProvider.getBlockAt(aXToDo, aYToDo, aZToDo);
            Block aBlock = BlockLoader.getInstance().getMyBlocksAsArray()[theIdWithMetadata];
            if (aBlock.getMetaData().equals("explode") && aValueToSet == 1) {
                Random aRandom = new Random();
                BigBoomMovable aDestruction = new BigBoomMovable(new Vector3(aXToDo, aYToDo, aZToDo), new Vector3(0.0, 0.0, 0.0), 0.0f, 3.0f + aRandom.nextFloat() * 2.0f, false, 0);
                MovableHandler.getInstance().addMovable(aDestruction);
            } else if (aBlock.getMetaData().equals("activator") && recursive) {
                int i = -1;
                while (i < 2) {
                    int j = -1;
                    while (j < 2) {
                        int k = -1;
                        while (k < 2) {
                            if (i != 0 || j != 0 || k != 0) {
                                aSetToUpdate.addAll(this.toggleActiveWithUpdates(aXToDo + i, aYToDo + j, aZToDo + k, myGl, myGlu, false, thePlayer, true));
                            }
                            ++k;
                        }
                        ++j;
                    }
                    ++i;
                }
            } else if (aBlock.getMetaData().equals("remote_activator") && recursive) {
                BlockMetaData anActivator = this.myProvider.getMetaDataMap().get(String.valueOf(aXToDo) + "|" + aYToDo + "|" + aZToDo);
                int aFrequency = 0;
                if (anActivator.extraData.get("freq") != null) {
                    aFrequency = Integer.parseInt(anActivator.extraData.get("freq"));
                }
                for (BlockMetaData aMetaData : this.myProvider.getMetaDataMap().values()) {
                    if (!aMetaData.metaData.equals("remote_receiver")) continue;
                    int receiverFreq = 0;
                    if (aMetaData.extraData.get("freq") != null) {
                        receiverFreq = Integer.parseInt(aMetaData.extraData.get("freq"));
                    }
                    if (aFrequency != receiverFreq) continue;
                    int i = -1;
                    while (i < 2) {
                        int j = -1;
                        while (j < 2) {
                            int k = -1;
                            while (k < 2) {
                                if (i != 0 || j != 0 || k != 0) {
                                    aSetToUpdate.addAll(this.toggleActiveWithUpdates(aMetaData.x + i, aMetaData.y + j, aMetaData.z + k, myGl, myGlu, false, thePlayer, true));
                                }
                                ++k;
                            }
                            ++j;
                        }
                        ++i;
                    }
                }
            } else if (aBlock.getMetaData().equals("forcefield_generator")) {
                int myDir = this.myProvider.getDirectionAt(aXToDo, aYToDo, aZToDo);
                if (aValueToSet == 1) {
                    if (myDir != 0) {
                        int aBlockId;
                        Block aForcefieldBlock = BlockLoader.getInstance().getMyBlocksAsArray()[27];
                        int i = -1;
                        while (i > -6) {
                            aBlockId = this.myProvider.getBlockAt(aXToDo + i, aYToDo, aZToDo);
                            if (aBlockId != 0) break;
                            aSetToUpdate.addAll(this.addBlockWithoutVBOUpdates(aXToDo + i, aYToDo, aZToDo, aForcefieldBlock, myGl, myGlu, 0));
                            --i;
                        }
                        i = 1;
                        while (i < 6) {
                            aBlockId = this.myProvider.getBlockAt(aXToDo + i, aYToDo, aZToDo);
                            if (aBlockId == 0) {
                                aSetToUpdate.addAll(this.addBlockWithoutVBOUpdates(aXToDo + i, aYToDo, aZToDo, aForcefieldBlock, myGl, myGlu, 0));
                                ++i;
                                continue;
                            }
                            break;
                        }
                    } else {
                        int aBlockId;
                        Block aForcefieldBlock = BlockLoader.getInstance().getMyBlocksAsArray()[28];
                        int i = -1;
                        while (i > -6) {
                            aBlockId = this.myProvider.getBlockAt(aXToDo, aYToDo, aZToDo + i);
                            if (aBlockId != 0) break;
                            aSetToUpdate.addAll(this.addBlockWithoutVBOUpdates(aXToDo, aYToDo, aZToDo + i, aForcefieldBlock, myGl, myGlu, 0));
                            --i;
                        }
                        i = 1;
                        while (i < 6) {
                            aBlockId = this.myProvider.getBlockAt(aXToDo, aYToDo, aZToDo + i);
                            if (aBlockId == 0) {
                                aSetToUpdate.addAll(this.addBlockWithoutVBOUpdates(aXToDo, aYToDo, aZToDo + i, aForcefieldBlock, myGl, myGlu, 0));
                                ++i;
                                continue;
                            }
                            break;
                        }
                    }
                } else if (myDir != 0) {
                    int aBlockId;
                    int i = -1;
                    while (i > -6) {
                        aBlockId = this.myProvider.getBlockAt(aXToDo + i, aYToDo, aZToDo);
                        if (aBlockId != 27) break;
                        aSetToUpdate.addAll(this.removeBlockWithoutVBOUpdates(aXToDo + i, aYToDo, aZToDo, myGl, myGlu, false, false));
                        --i;
                    }
                    i = 1;
                    while (i < 6) {
                        aBlockId = this.myProvider.getBlockAt(aXToDo + i, aYToDo, aZToDo);
                        if (aBlockId == 27) {
                            aSetToUpdate.addAll(this.removeBlockWithoutVBOUpdates(aXToDo + i, aYToDo, aZToDo, myGl, myGlu, false, false));
                            ++i;
                            continue;
                        }
                        break;
                    }
                } else {
                    int aBlockId;
                    int i = -1;
                    while (i > -6) {
                        aBlockId = this.myProvider.getBlockAt(aXToDo, aYToDo, aZToDo + i);
                        if (aBlockId != 28) break;
                        aSetToUpdate.addAll(this.removeBlockWithoutVBOUpdates(aXToDo, aYToDo, aZToDo + i, myGl, myGlu, false, false));
                        --i;
                    }
                    i = 1;
                    while (i < 6) {
                        aBlockId = this.myProvider.getBlockAt(aXToDo, aYToDo, aZToDo + i);
                        if (aBlockId == 28) {
                            aSetToUpdate.addAll(this.removeBlockWithoutVBOUpdates(aXToDo, aYToDo, aZToDo + i, myGl, myGlu, false, false));
                            ++i;
                            continue;
                        }
                        break;
                    }
                }
            } else if (aBlock.getMetaData().equals("container") && !remote) {
                Inventory anInventoryToShow = this.myProvider.getInventoryFor(aXToDo, aYToDo, aZToDo);
                if (anInventoryToShow == null) {
                    anInventoryToShow = new Inventory(15, 4);
                    this.myProvider.setInventoryFor(aXToDo, aYToDo, aZToDo, anInventoryToShow);
                }
                ContainerOverlay aCrateOverlay = (ContainerOverlay)OverlayHandler.getInstance().getOverlay("container");
                aCrateOverlay.newInventory(anInventoryToShow);
                OverlayHandler.getInstance().addActiveOverlay("inventory");
                OverlayHandler.getInstance().addActiveOverlay("container");
                thePlayer.setInInventory(true);
                thePlayer.setInInventoryStateChange(true);
            } else if (aBlock.getMetaData().equals("grinder") && !remote) {
                Grinder aGrinderToActivate = this.myProvider.getGrinderFor(aXToDo, aYToDo, aZToDo);
                GrinderOverlay aGrinderOverlay = (GrinderOverlay)OverlayHandler.getInstance().getOverlay("grinder");
                aGrinderOverlay.newGrinder(aGrinderToActivate);
                OverlayHandler.getInstance().addActiveOverlay("inventory");
                OverlayHandler.getInstance().addActiveOverlay("grinder");
                thePlayer.setInInventory(true);
                thePlayer.setInInventoryStateChange(true);
            } else if (aBlock.getMetaData().equals("blockmaker") && !remote) {
                BlockMaker aMakerToActivate = this.myProvider.getBlockMakerFor(aXToDo, aYToDo, aZToDo);
                BlockMakerOverlay aBlockMakerOverlay = (BlockMakerOverlay)OverlayHandler.getInstance().getOverlay("blockmaker");
                aBlockMakerOverlay.newBlockMaker(aMakerToActivate);
                OverlayHandler.getInstance().addActiveOverlay("inventory");
                OverlayHandler.getInstance().addActiveOverlay("blockmaker");
                thePlayer.setInInventory(true);
                thePlayer.setInInventoryStateChange(true);
            } else if (aBlock.getMetaData().equals("itemmaker") && !remote) {
                ItemMaker aMakerToActivate = this.myProvider.getItemMakerFor(aXToDo, aYToDo, aZToDo);
                ItemMakerOverlay aItemMakerOverlay = (ItemMakerOverlay)OverlayHandler.getInstance().getOverlay("itemmaker");
                aItemMakerOverlay.newItemMaker(aMakerToActivate);
                OverlayHandler.getInstance().addActiveOverlay("inventory");
                OverlayHandler.getInstance().addActiveOverlay("itemmaker");
                thePlayer.setInInventory(true);
                thePlayer.setInInventoryStateChange(true);
            } else if (aBlock.getMetaData().equals("powercell1")) {
                BlockMetaData aMetaData;
                int aBlockToCheck = this.myProvider.getBlockAt(aXToDo - 1, aYToDo, aZToDo);
                Block aBlockTypeToCheck = BlockLoader.getInstance().getMyBlocksAsArray()[aBlockToCheck];
                if (aBlockTypeToCheck.isCanBePowered()) {
                    aMetaData = this.myProvider.getMetaDataMap().get(String.valueOf(aXToDo - 1) + "|" + aYToDo + "|" + aZToDo);
                    aMetaData.extraData.put(String.valueOf(aXToDo) + "|" + aYToDo + "|" + aZToDo, "" + aValueToSet);
                }
                aBlockToCheck = this.myProvider.getBlockAt(aXToDo + 1, aYToDo, aZToDo);
                aBlockTypeToCheck = BlockLoader.getInstance().getMyBlocksAsArray()[aBlockToCheck];
                if (aBlockTypeToCheck.isCanBePowered()) {
                    aMetaData = this.myProvider.getMetaDataMap().get(String.valueOf(aXToDo + 1) + "|" + aYToDo + "|" + aZToDo);
                    aMetaData.extraData.put(String.valueOf(aXToDo) + "|" + aYToDo + "|" + aZToDo, "" + aValueToSet);
                }
                aBlockToCheck = this.myProvider.getBlockAt(aXToDo, aYToDo - 1, aZToDo);
                aBlockTypeToCheck = BlockLoader.getInstance().getMyBlocksAsArray()[aBlockToCheck];
                if (aBlockTypeToCheck.isCanBePowered()) {
                    aMetaData = this.myProvider.getMetaDataMap().get(String.valueOf(aXToDo) + "|" + (aYToDo - 1) + "|" + aZToDo);
                    aMetaData.extraData.put(String.valueOf(aXToDo) + "|" + aYToDo + "|" + aZToDo, "" + aValueToSet);
                }
                aBlockToCheck = this.myProvider.getBlockAt(aXToDo, aYToDo + 1, aZToDo);
                aBlockTypeToCheck = BlockLoader.getInstance().getMyBlocksAsArray()[aBlockToCheck];
                if (aBlockTypeToCheck.isCanBePowered()) {
                    aMetaData = this.myProvider.getMetaDataMap().get(String.valueOf(aXToDo) + "|" + (aYToDo + 1) + "|" + aZToDo);
                    aMetaData.extraData.put(String.valueOf(aXToDo) + "|" + aYToDo + "|" + aZToDo, "" + aValueToSet);
                }
                aBlockToCheck = this.myProvider.getBlockAt(aXToDo, aYToDo, aZToDo - 1);
                aBlockTypeToCheck = BlockLoader.getInstance().getMyBlocksAsArray()[aBlockToCheck];
                if (aBlockTypeToCheck.isCanBePowered()) {
                    aMetaData = this.myProvider.getMetaDataMap().get(String.valueOf(aXToDo) + "|" + aYToDo + "|" + (aZToDo - 1));
                    aMetaData.extraData.put(String.valueOf(aXToDo) + "|" + aYToDo + "|" + aZToDo, "" + aValueToSet);
                }
                aBlockToCheck = this.myProvider.getBlockAt(aXToDo, aYToDo, aZToDo + 1);
                aBlockTypeToCheck = BlockLoader.getInstance().getMyBlocksAsArray()[aBlockToCheck];
                if (aBlockTypeToCheck.isCanBePowered()) {
                    aMetaData = this.myProvider.getMetaDataMap().get(String.valueOf(aXToDo) + "|" + aYToDo + "|" + (aZToDo + 1));
                    aMetaData.extraData.put(String.valueOf(aXToDo) + "|" + aYToDo + "|" + aZToDo, "" + aValueToSet);
                }
            } else if (aBlock.getMetaData().equals("pusher_up")) {
                int index;
                if (aValueToSet == 1) {
                    BlockMetaData aMetaData = this.myProvider.getMetaDataMap().get(String.valueOf(aXToDo) + "|" + aYToDo + "|" + aZToDo);
                    int length = 3;
                    String aVal = aMetaData.extraData.get("length");
                    if (aVal != null && aVal.length() > 0) {
                        length = Integer.parseInt(aVal);
                    }
                    boolean isOkToShove = true;
                    int i = aYToDo + length + 1;
                    while (i < aYToDo + length + length + 1) {
                        if (this.myProvider.getBlockAt(aXToDo, i, aZToDo) > 0) {
                            isOkToShove = false;
                            break;
                        }
                        ++i;
                    }
                    if (isOkToShove) {
                        int[] oldBlocks = new int[length];
                        int i2 = aYToDo + 1;
                        index = 0;
                        while (i2 < aYToDo + length + 1) {
                            oldBlocks[index] = this.myProvider.getValueNonLightAt(aXToDo, i2, aZToDo);
                            this.myProvider.moveMetaDataBlock(aXToDo, i2, aZToDo, aXToDo, i2 + length, aZToDo);
                            aSetToUpdate.addAll(this.removeBlockWithoutVBOUpdates(aXToDo, i2, aZToDo, myGl, myGlu, false, false));
                            ++i2;
                            ++index;
                        }
                        Block anExtension = BlockLoader.getInstance().getMyBlocksAsArray()[53];
                        int i3 = aYToDo + 1;
                        while (i3 < aYToDo + length + 1) {
                            aSetToUpdate.addAll(this.addBlockWithoutVBOUpdates(aXToDo, i3, aZToDo, anExtension, myGl, myGlu, 0));
                            ++i3;
                        }
                        i3 = aYToDo + length + 1;
                        int index2 = 0;
                        while (i3 < aYToDo + length + length + 1) {
                            Block aBlockToSet = BlockLoader.getInstance().getMyBlocksAsArray()[oldBlocks[index2] & 0xFFFF];
                            int dir = (oldBlocks[index2] & 0x20000000) > 0 ? 1 : 0;
                            aSetToUpdate.addAll(this.addBlockWithoutVBOUpdates(aXToDo, i3, aZToDo, aBlockToSet, myGl, myGlu, dir, false));
                            ++i3;
                            ++index2;
                        }
                    }
                } else {
                    BlockMetaData aMetaData = this.myProvider.getMetaDataMap().get(String.valueOf(aXToDo) + "|" + aYToDo + "|" + aZToDo);
                    int length = 3;
                    String aVal = aMetaData.extraData.get("length");
                    if (aVal != null && aVal.length() > 0) {
                        length = Integer.parseInt(aVal);
                    }
                    boolean isOkToRetract = true;
                    int i = aYToDo + 1;
                    while (i < aYToDo + length + 1) {
                        if (this.myProvider.getBlockAt(aXToDo, i, aZToDo) != 53) {
                            isOkToRetract = false;
                            break;
                        }
                        ++i;
                    }
                    if (isOkToRetract) {
                        int[] oldBlocks = new int[length];
                        int i4 = aYToDo + length + 1;
                        index = 0;
                        while (i4 < aYToDo + length + length + 1) {
                            oldBlocks[index] = this.myProvider.getValueNonLightAt(aXToDo, i4, aZToDo);
                            this.myProvider.moveMetaDataBlock(aXToDo, i4, aZToDo, aXToDo, i4 - length, aZToDo);
                            aSetToUpdate.addAll(this.removeBlockWithoutVBOUpdates(aXToDo, i4, aZToDo, myGl, myGlu, false, false));
                            ++i4;
                            ++index;
                        }
                        i4 = aYToDo + 1;
                        index = 0;
                        while (i4 < aYToDo + length + 1) {
                            Block aBlockToSet = BlockLoader.getInstance().getMyBlocksAsArray()[oldBlocks[index] & 0xFFFF];
                            int dir = (oldBlocks[index] & 0x20000000) > 0 ? 1 : 0;
                            aSetToUpdate.addAll(this.addBlockWithoutVBOUpdates(aXToDo, i4, aZToDo, aBlockToSet, myGl, myGlu, dir, false));
                            ++i4;
                            ++index;
                        }
                    }
                }
            } else if (aBlock.getMetaData().equals("driller_down")) {
                Driller aDriller = this.myProvider.getDrillerFor(aXToDo, aYToDo, aZToDo);
                aDriller.setActive(aValueToSet == 1);
            } else if (aBlock.getMetaData().equals("timer")) {
                Timer aTimer = this.myProvider.getTimerFor(aXToDo, aYToDo, aZToDo);
                aTimer.setActive(aValueToSet == 1);
            }
        }
        if (recursive) {
            this.rebuildVBOForChunk(myGl, myGlu, aXToDo, aYToDo, aZToDo);
            for (ChunkDataWrapper aChunkToUpdate : aSetToUpdate) {
                this.rebuildVBOForChunk(myGl, myGlu, aChunkToUpdate);
            }
        } else {
            aSetToUpdate.add(this.getChunkAt(aXToDo, aYToDo, aZToDo, myGl));
        }
        return aSetToUpdate;
    }

    public void removeMetadata(int aXToDo, int aYToDo, int aZToDo, String aMetadataName) {
        HashSet<ChunkDataWrapper> aSetToUpdate = new HashSet<ChunkDataWrapper>();
        if (aMetadataName.equals("forcefield_generator")) {
            int myDir = this.myProvider.getDirectionAt(aXToDo, aYToDo, aZToDo);
            if (myDir != 0) {
                int aBlockId;
                int i = -1;
                while (i > -6) {
                    aBlockId = this.myProvider.getBlockAt(aXToDo + i, aYToDo, aZToDo);
                    if (aBlockId != 27) break;
                    aSetToUpdate.addAll(this.removeBlockWithoutVBOUpdates(aXToDo + i, aYToDo, aZToDo, this.myGl, this.myGlu, false, false));
                    --i;
                }
                i = 1;
                while (i < 6) {
                    aBlockId = this.myProvider.getBlockAt(aXToDo + i, aYToDo, aZToDo);
                    if (aBlockId == 27) {
                        aSetToUpdate.addAll(this.removeBlockWithoutVBOUpdates(aXToDo + i, aYToDo, aZToDo, this.myGl, this.myGlu, false, false));
                        ++i;
                        continue;
                    }
                    break;
                }
            } else {
                int aBlockId;
                int i = -1;
                while (i > -6) {
                    aBlockId = this.myProvider.getBlockAt(aXToDo, aYToDo, aZToDo + i);
                    if (aBlockId != 28) break;
                    aSetToUpdate.addAll(this.removeBlockWithoutVBOUpdates(aXToDo, aYToDo, aZToDo + i, this.myGl, this.myGlu, false, false));
                    --i;
                }
                i = 1;
                while (i < 6) {
                    aBlockId = this.myProvider.getBlockAt(aXToDo, aYToDo, aZToDo + i);
                    if (aBlockId == 28) {
                        aSetToUpdate.addAll(this.removeBlockWithoutVBOUpdates(aXToDo, aYToDo, aZToDo + i, this.myGl, this.myGlu, false, false));
                        ++i;
                        continue;
                    }
                    break;
                }
            }
        } else if (aMetadataName.equals("container")) {
            this.myProvider.removeInventoryFor(aXToDo, aYToDo, aZToDo);
        } else if (aMetadataName.equals("powercell1")) {
            BlockMetaData aMetaData;
            int aBlockToCheck = this.myProvider.getBlockAt(aXToDo - 1, aYToDo, aZToDo);
            Block aBlockTypeToCheck = BlockLoader.getInstance().getMyBlocksAsArray()[aBlockToCheck];
            if (aBlockTypeToCheck.isCanBePowered()) {
                aMetaData = this.myProvider.getMetaDataMap().get(String.valueOf(aXToDo - 1) + "|" + aYToDo + "|" + aZToDo);
                aMetaData.extraData.remove(String.valueOf(aXToDo) + "|" + aYToDo + "|" + aZToDo);
            }
            aBlockToCheck = this.myProvider.getBlockAt(aXToDo + 1, aYToDo, aZToDo);
            aBlockTypeToCheck = BlockLoader.getInstance().getMyBlocksAsArray()[aBlockToCheck];
            if (aBlockTypeToCheck.isCanBePowered()) {
                aMetaData = this.myProvider.getMetaDataMap().get(String.valueOf(aXToDo + 1) + "|" + aYToDo + "|" + aZToDo);
                aMetaData.extraData.remove(String.valueOf(aXToDo) + "|" + aYToDo + "|" + aZToDo);
            }
            aBlockToCheck = this.myProvider.getBlockAt(aXToDo, aYToDo - 1, aZToDo);
            aBlockTypeToCheck = BlockLoader.getInstance().getMyBlocksAsArray()[aBlockToCheck];
            if (aBlockTypeToCheck.isCanBePowered()) {
                aMetaData = this.myProvider.getMetaDataMap().get(String.valueOf(aXToDo) + "|" + (aYToDo - 1) + "|" + aZToDo);
                aMetaData.extraData.remove(String.valueOf(aXToDo) + "|" + aYToDo + "|" + aZToDo);
            }
            aBlockToCheck = this.myProvider.getBlockAt(aXToDo, aYToDo + 1, aZToDo);
            aBlockTypeToCheck = BlockLoader.getInstance().getMyBlocksAsArray()[aBlockToCheck];
            if (aBlockTypeToCheck.isCanBePowered()) {
                aMetaData = this.myProvider.getMetaDataMap().get(String.valueOf(aXToDo) + "|" + (aYToDo + 1) + "|" + aZToDo);
                aMetaData.extraData.remove(String.valueOf(aXToDo) + "|" + aYToDo + "|" + aZToDo);
            }
            aBlockToCheck = this.myProvider.getBlockAt(aXToDo, aYToDo, aZToDo - 1);
            aBlockTypeToCheck = BlockLoader.getInstance().getMyBlocksAsArray()[aBlockToCheck];
            if (aBlockTypeToCheck.isCanBePowered()) {
                aMetaData = this.myProvider.getMetaDataMap().get(String.valueOf(aXToDo) + "|" + aYToDo + "|" + (aZToDo - 1));
                aMetaData.extraData.remove(String.valueOf(aXToDo) + "|" + aYToDo + "|" + aZToDo);
            }
            aBlockToCheck = this.myProvider.getBlockAt(aXToDo, aYToDo, aZToDo + 1);
            aBlockTypeToCheck = BlockLoader.getInstance().getMyBlocksAsArray()[aBlockToCheck];
            if (aBlockTypeToCheck.isCanBePowered()) {
                aMetaData = this.myProvider.getMetaDataMap().get(String.valueOf(aXToDo) + "|" + aYToDo + "|" + (aZToDo + 1));
                aMetaData.extraData.remove(String.valueOf(aXToDo) + "|" + aYToDo + "|" + aZToDo);
            }
        } else if (aMetadataName.equals("grinder")) {
            this.myProvider.removeGrinderFor(aXToDo, aYToDo, aZToDo);
        } else if (aMetadataName.equals("blockmaker")) {
            this.myProvider.removeBlockMakerFor(aXToDo, aYToDo, aZToDo);
        } else if (aMetadataName.equals("itemmaker")) {
            this.myProvider.removeItemMakerFor(aXToDo, aYToDo, aZToDo);
        } else if (aMetadataName.equals("driller_down")) {
            Driller aDriller = this.myProvider.getDrillerFor(aXToDo, aYToDo, aZToDo);
            int i = aDriller.getY() - 1;
            while (i > aDriller.getY() - aDriller.getLength() - 1) {
                int aBlockId = this.myProvider.getBlockAt(aXToDo, i, aZToDo);
                if (aBlockId == 55) {
                    aSetToUpdate.addAll(this.removeBlockWithoutVBOUpdates(aXToDo, i, aZToDo, this.myGl, this.myGlu, false, false));
                }
                --i;
            }
            this.myProvider.removeInventoryFor(aXToDo, aYToDo, aZToDo);
            this.myProvider.removeDrillerFor(aXToDo, aYToDo, aZToDo);
        } else if (aMetadataName.equals("timer")) {
            this.myProvider.removeTimerFor(aXToDo, aYToDo, aZToDo);
        }
        for (ChunkDataWrapper aChunkToUpdate : aSetToUpdate) {
            this.rebuildVBOForChunk(this.myGl, this.myGlu, aChunkToUpdate);
        }
    }

    public void addBlockWithUpdates(int aXToDo, int aYToDo, int aZToDo, Block aBlockToPlace, GL2 myGl, GLU myGlu, int direction) {
        Set<ChunkDataWrapper> aSetToUpdate;
        if (aBlockToPlace.isLight()) {
            aSetToUpdate = this.addLightSourceFill(aXToDo, aYToDo, aZToDo, aBlockToPlace.getMyLightR(), myGl, myGlu, true, 0);
            aSetToUpdate.addAll(this.addLightSourceFill(aXToDo, aYToDo, aZToDo, aBlockToPlace.getMyLightG(), myGl, myGlu, true, 1));
            aSetToUpdate.addAll(this.addLightSourceFill(aXToDo, aYToDo, aZToDo, aBlockToPlace.getMyLightB(), myGl, myGlu, true, 2));
            this.myProvider.setBlockAtNoLightUpdate(aXToDo, aYToDo, aZToDo, aBlockToPlace.getMyId(), aBlockToPlace.isTransparent(), direction, aBlockToPlace.isHasMetaData());
            for (ChunkDataWrapper aChunkToUpdate : aSetToUpdate) {
                this.rebuildVBOForChunk(myGl, myGlu, aChunkToUpdate);
            }
        } else if (aBlockToPlace.isTransparent()) {
            this.myProvider.setBlockAtNoLightUpdate(aXToDo, aYToDo, aZToDo, aBlockToPlace.getMyId(), true, direction, aBlockToPlace.isHasMetaData());
            this.rebuildVBOForChunk(myGl, myGlu, aXToDo, aYToDo, aZToDo);
            this.rebuildBorderingChunks(myGl, myGlu, aXToDo, aYToDo, aZToDo);
        } else {
            this.myProvider.setBlockAtNoLightUpdate(aXToDo, aYToDo, aZToDo, aBlockToPlace.getMyId(), false, direction, aBlockToPlace.isHasMetaData());
            aSetToUpdate = this.removeLightSourceFill(aXToDo, aYToDo, aZToDo, myGl, myGlu, true, true, 0);
            aSetToUpdate.addAll(this.removeLightSourceFill(aXToDo, aYToDo, aZToDo, myGl, myGlu, true, true, 1));
            aSetToUpdate.addAll(this.removeLightSourceFill(aXToDo, aYToDo, aZToDo, myGl, myGlu, true, true, 2));
            this.myProvider.setLightAt(aXToDo, aYToDo, aZToDo, 0, 0);
            this.myProvider.setLightAt(aXToDo, aYToDo, aZToDo, 0, 1);
            this.myProvider.setLightAt(aXToDo, aYToDo, aZToDo, 0, 2);
            if (aSetToUpdate.size() > 0) {
                for (ChunkDataWrapper aChunkToUpdate : aSetToUpdate) {
                    this.rebuildVBOForChunk(myGl, myGlu, aChunkToUpdate);
                }
            } else {
                this.myProvider.setBlockAt(aXToDo, aYToDo, aZToDo, aBlockToPlace.getMyId(), false, direction, aBlockToPlace.isHasMetaData());
                this.rebuildVBOForChunk(myGl, myGlu, aXToDo, aYToDo, aZToDo);
                this.rebuildBorderingChunks(myGl, myGlu, aXToDo, aYToDo, aZToDo);
            }
        }
        if (aBlockToPlace.isHasMetaData()) {
            BlockMetaData aMetaData = new BlockMetaData(aXToDo, aYToDo, aZToDo, aBlockToPlace.getMetaData());
            this.myProvider.addMetaDataBlock(aMetaData);
        }
    }

    public Set<ChunkDataWrapper> addBlockWithoutVBOUpdates(int aXToDo, int aYToDo, int aZToDo, Block aBlockToPlace, GL2 myGl, GLU myGlu, int direction) {
        return this.addBlockWithoutVBOUpdates(aXToDo, aYToDo, aZToDo, aBlockToPlace, myGl, myGlu, direction, true);
    }

    public Set<ChunkDataWrapper> addBlockWithoutVBOUpdates(int aXToDo, int aYToDo, int aZToDo, Block aBlockToPlace, GL2 myGl, GLU myGlu, int direction, boolean setMetaData) {
        Set<Object> aSetToReturn = new HashSet();
        if (aBlockToPlace.isLight()) {
            aSetToReturn = this.addLightSourceFill(aXToDo, aYToDo, aZToDo, aBlockToPlace.getMyLightR(), myGl, myGlu, true, 0);
            aSetToReturn.addAll(this.addLightSourceFill(aXToDo, aYToDo, aZToDo, aBlockToPlace.getMyLightG(), myGl, myGlu, true, 1));
            aSetToReturn.addAll(this.addLightSourceFill(aXToDo, aYToDo, aZToDo, aBlockToPlace.getMyLightB(), myGl, myGlu, true, 2));
            this.myProvider.setBlockAtNoLightUpdate(aXToDo, aYToDo, aZToDo, aBlockToPlace.getMyId(), aBlockToPlace.isTransparent(), direction, aBlockToPlace.isHasMetaData());
        } else if (aBlockToPlace.isTransparent()) {
            this.myProvider.setBlockAtNoLightUpdate(aXToDo, aYToDo, aZToDo, aBlockToPlace.getMyId(), true, direction, aBlockToPlace.isHasMetaData());
            aSetToReturn.add(this.getChunkAt(aXToDo, aYToDo, aZToDo, myGl));
            aSetToReturn.addAll(this.getBorderingChunks(aXToDo, aYToDo, aZToDo, myGl));
        } else {
            this.myProvider.setBlockAtNoLightUpdate(aXToDo, aYToDo, aZToDo, aBlockToPlace.getMyId(), false, direction, aBlockToPlace.isHasMetaData());
            aSetToReturn = this.removeLightSourceFill(aXToDo, aYToDo, aZToDo, myGl, myGlu, true, true, 0);
            aSetToReturn.addAll(this.removeLightSourceFill(aXToDo, aYToDo, aZToDo, myGl, myGlu, true, true, 1));
            aSetToReturn.addAll(this.removeLightSourceFill(aXToDo, aYToDo, aZToDo, myGl, myGlu, true, true, 2));
            this.myProvider.setLightAt(aXToDo, aYToDo, aZToDo, 0, 0);
            this.myProvider.setLightAt(aXToDo, aYToDo, aZToDo, 0, 1);
            this.myProvider.setLightAt(aXToDo, aYToDo, aZToDo, 0, 2);
            if (aSetToReturn.size() <= 0) {
                this.myProvider.setBlockAt(aXToDo, aYToDo, aZToDo, aBlockToPlace.getMyId(), false, direction, aBlockToPlace.isHasMetaData());
                aSetToReturn.add(this.getChunkAt(aXToDo, aYToDo, aZToDo, myGl));
                aSetToReturn.addAll(this.getBorderingChunks(aXToDo, aYToDo, aZToDo, myGl));
            }
        }
        if (aBlockToPlace.isHasMetaData() && setMetaData) {
            BlockMetaData aMetaData = new BlockMetaData(aXToDo, aYToDo, aZToDo, aBlockToPlace.getMetaData());
            this.myProvider.addMetaDataBlock(aMetaData);
        }
        return aSetToReturn;
    }

    @Override
    public void metaDataRemoved(int x, int y, int z, String metaData) {
        this.removeMetadata(x, y, z, metaData);
    }
}

