/*
 * Decompiled with CFR 0.152.
 */
package com.js.test.terra.area.animatedgenerator;

import com.js.test.terra.area.animatedgenerator.AnimatedGenerator;
import com.js.test.terra.area.blocks.Block;
import com.js.test.terra.area.blocks.BlockLoader;
import com.js.test.terra.area.chunks.BigChunkDataGrid;
import com.js.test.terra.math.Vector3;
import java.util.List;
import java.util.Random;
import javax.media.opengl.GL2;
import javax.media.opengl.glu.GLU;

public class WormAnimatedGenerator
extends AnimatedGenerator {
    private BigChunkDataGrid myGrid;
    private List<Vector3> centers;
    private long lastBlobTick;
    private int count;
    private int myDirectionX;
    private int myDirectionY;

    public WormAnimatedGenerator(int w, int h, int d, int x, int y, int z, int blockId, BigChunkDataGrid theGrid, GL2 theGl, int directionX, int directionY) {
        super(w, h, d);
        this.myBlockId = blockId;
        this.myGrid = theGrid;
        this.myDirectionX = directionX;
        this.myDirectionY = directionY;
        this.myCenter = new Vector3(0.0, 0.0, 0.0);
        this.myCenter.x = x;
        this.myCenter.y = y;
        this.myCenter.z = z;
        this.myRenderCenter = new Vector3(0.0, 0.0, 0.0);
        this.count = 0;
    }

    private void fillCube(BigChunkDataGrid theGrid) {
        this.myAmountOfBlocks = 100;
    }

    @Override
    public boolean doTick(GL2 theGl, GLU theGlu, float time, BigChunkDataGrid theGrid) {
        int lenght;
        block8: {
            long now = System.currentTimeMillis();
            int[] blockList = new int[]{12};
            Random aRandom = new Random();
            lenght = 50;
            if (now <= this.lastBlobTick + 500L) break block8;
            this.lastBlobTick = now;
            ++this.count;
            int size = lenght / 2 - this.count / 2;
            int ofs1 = (int)(Math.sin((double)this.count * 0.3) * 5.0);
            int ofs2 = (int)(Math.cos((double)this.count * 0.3) * 5.0);
            if (this.myDirectionX != 0) {
                int y = -size;
                while (y < size + 1) {
                    int z = -size;
                    while (z < size + 1) {
                        int dist = y * y + z * z;
                        if (dist < size * size) {
                            Block aBlock = BlockLoader.getInstance().getMyBlocksAsArray()[blockList[aRandom.nextInt(blockList.length)]];
                            this.myGrid.addBlockWithUpdates((int)(this.myCenter.x + (double)(this.count * this.myDirectionX)), (int)(this.myCenter.y + (double)y + (double)ofs1), (int)(this.myCenter.z + (double)z + (double)ofs2), aBlock, theGl, theGlu, 0);
                        }
                        ++z;
                    }
                    ++y;
                }
            } else {
                int y = -size;
                while (y < size + 1) {
                    int x = -size;
                    while (x < size + 1) {
                        int dist = y * y + x * x;
                        if (dist < size * size) {
                            Block aBlock = BlockLoader.getInstance().getMyBlocksAsArray()[blockList[aRandom.nextInt(blockList.length)]];
                            this.myGrid.addBlockWithUpdates((int)(this.myCenter.x + (double)x + (double)ofs1), (int)(this.myCenter.y + (double)y + (double)ofs2), (int)(this.myCenter.z + (double)(this.count * this.myDirectionY)), aBlock, theGl, theGlu, 0);
                        }
                        ++x;
                    }
                    ++y;
                }
            }
        }
        return this.count > lenght;
    }
}

