/*
 * Decompiled with CFR 0.152.
 */
package com.js.test.terra.area;

import com.jogamp.opengl.util.GLBuffers;
import com.js.test.engine.camera.Camera;
import com.js.test.engine.camera.CameraHandler;
import com.js.test.engine.material.TextureHandler;
import com.js.test.terra.area.animatedgenerator.AnimatedGenerator;
import com.js.test.terra.area.animatedgenerator.AnimatedGeneratorHandler;
import com.js.test.terra.area.chunks.BigChunkDataGrid;
import com.js.test.terra.area.chunks.CameraToChunkComparator;
import com.js.test.terra.area.chunks.ChunkDataWrapper;
import com.js.test.terra.area.movables.Movable;
import com.js.test.terra.area.movables.MovableHandler;
import com.js.test.terra.area.quadtree.MegaQuadTreeContainer;
import com.js.test.terra.area.quadtree.QuadTreeNode;
import com.js.test.terra.area.quadtree.Statistics;
import com.js.test.terra.area.util.ObjectData;
import com.js.test.terra.math.Vector3;
import java.nio.Buffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.Collections;
import javax.media.opengl.GL2;
import javax.media.opengl.glu.GLU;
import javax.media.opengl.glu.GLUquadric;

public class QuadTreeRenderer {
    private int[] myMarkingCubeVertexVbo = new int[1];
    private int[] myMarkingCubeIndexVbo = new int[1];

    public QuadTreeRenderer(GL2 theGl, GLU theGlu) {
        theGl.glGenBuffers(1, this.myMarkingCubeVertexVbo, 0);
        theGl.glGenBuffers(1, this.myMarkingCubeIndexVbo, 0);
        float[] aScaledCube = ObjectData.scaleCube(1.05f);
        theGl.glBindBuffer(34962, this.myMarkingCubeVertexVbo[0]);
        FloatBuffer fb = GLBuffers.newDirectFloatBuffer((float[])aScaledCube);
        theGl.glBufferData(34962, (long)(aScaledCube.length * 4), (Buffer)fb, 35044);
        theGl.glBindBuffer(34963, this.myMarkingCubeIndexVbo[0]);
        IntBuffer ib = GLBuffers.newDirectIntBuffer((int[])ObjectData.myIndicesVboData[0]);
        theGl.glBufferData(34963, (long)(ObjectData.myIndicesVboData[0].length * 4), (Buffer)ib, 35044);
    }

    private void renderMarkingBox(GL2 theGl, GLU theGlu, BigChunkDataGrid theGrid, float x, float y, float z) {
        theGl.glBindBuffer(34962, this.myMarkingCubeVertexVbo[0]);
        theGl.glEnableClientState(32884);
        theGl.glVertexPointer(3, 5126, 0, 0L);
        float aXc = Math.round(x);
        float aYc = Math.round(y);
        float aZc = Math.round(z);
        theGl.glBindBuffer(34963, this.myMarkingCubeIndexVbo[0]);
        theGl.glColor3f(0.2f, 0.2f, 0.2f);
        theGl.glEnable(3042);
        theGl.glBlendFunc(1, 1);
        theGl.glPushMatrix();
        theGl.glTranslatef(aXc, aYc, aZc);
        theGl.glDrawElements(4, 36, 5125, 0L);
        theGl.glPopMatrix();
        theGl.glDisable(3042);
        theGl.glColor3f(1.0f, 1.0f, 1.0f);
    }

    public float[] getFrustrumMatrix(GL2 theGl) {
        float[] proj = new float[16];
        float[] modl = new float[16];
        float[] clip = new float[16];
        theGl.glGetFloatv(2983, proj, 0);
        theGl.glGetFloatv(2982, modl, 0);
        clip[0] = modl[0] * proj[0] + modl[1] * proj[4] + modl[2] * proj[8] + modl[3] * proj[12];
        clip[1] = modl[0] * proj[1] + modl[1] * proj[5] + modl[2] * proj[9] + modl[3] * proj[13];
        clip[2] = modl[0] * proj[2] + modl[1] * proj[6] + modl[2] * proj[10] + modl[3] * proj[14];
        clip[3] = modl[0] * proj[3] + modl[1] * proj[7] + modl[2] * proj[11] + modl[3] * proj[15];
        clip[4] = modl[4] * proj[0] + modl[5] * proj[4] + modl[6] * proj[8] + modl[7] * proj[12];
        clip[5] = modl[4] * proj[1] + modl[5] * proj[5] + modl[6] * proj[9] + modl[7] * proj[13];
        clip[6] = modl[4] * proj[2] + modl[5] * proj[6] + modl[6] * proj[10] + modl[7] * proj[14];
        clip[7] = modl[4] * proj[3] + modl[5] * proj[7] + modl[6] * proj[11] + modl[7] * proj[15];
        clip[8] = modl[8] * proj[0] + modl[9] * proj[4] + modl[10] * proj[8] + modl[11] * proj[12];
        clip[9] = modl[8] * proj[1] + modl[9] * proj[5] + modl[10] * proj[9] + modl[11] * proj[13];
        clip[10] = modl[8] * proj[2] + modl[9] * proj[6] + modl[10] * proj[10] + modl[11] * proj[14];
        clip[11] = modl[8] * proj[3] + modl[9] * proj[7] + modl[10] * proj[11] + modl[11] * proj[15];
        clip[12] = modl[12] * proj[0] + modl[13] * proj[4] + modl[14] * proj[8] + modl[15] * proj[12];
        clip[13] = modl[12] * proj[1] + modl[13] * proj[5] + modl[14] * proj[9] + modl[15] * proj[13];
        clip[14] = modl[12] * proj[2] + modl[13] * proj[6] + modl[14] * proj[10] + modl[15] * proj[14];
        clip[15] = modl[12] * proj[3] + modl[13] * proj[7] + modl[14] * proj[11] + modl[15] * proj[15];
        return clip;
    }

    private void enableSunLight(GL2 theGl) {
        theGl.glPushMatrix();
        theGl.glLoadIdentity();
        float SHINE_ALL_DIRECTIONS = 1.0f;
        float[] lightPos = new float[]{0.0f, 1.0f, 0.0f, 0.0f};
        float[] lightColorAmbient = new float[]{0.3f, 0.3f, 0.2f, 1.0f};
        float[] lightColorSpecular = new float[]{1.0f, 1.0f, 1.0f, 1.0f};
        theGl.glLightfv(16385, 4611, lightPos, 0);
        theGl.glLightfv(16385, 4608, lightColorAmbient, 0);
        theGl.glLightfv(16385, 4610, lightColorSpecular, 0);
        theGl.glLightModeli(2897, 1);
        theGl.glEnable(16385);
        theGl.glEnable(2896);
        theGl.glPopMatrix();
    }

    private void disableSunLight(GL2 theGl) {
        theGl.glDisable(16385);
        theGl.glDisable(2896);
    }

    public void renderSkysphere(GL2 theGl, GLU theGlu, double vx, double vy, double vz) {
        theGl.glPushMatrix();
        theGl.glLoadIdentity();
        theGlu.gluLookAt(0.0, 0.0, 0.0, vx, vy, vz, 0.0, 1.0, 0.0);
        theGl.glDisable(2929);
        theGl.glColor4f(1.0f, 1.0f, 1.0f, 1.0f);
        TextureHandler.getInstance().bindTextureWithClamp("skysphere", theGl);
        GLUquadric aSphere = theGlu.gluNewQuadric();
        theGlu.gluQuadricTexture(aSphere, true);
        theGlu.gluSphere(aSphere, 4.0, 100, 100);
        theGlu.gluDeleteQuadric(aSphere);
        TextureHandler.getInstance().unbindTextureWithClamp("skysphere", theGl);
        theGl.glEnable(2929);
        theGl.glPopMatrix();
    }

    public void renderNode(MegaQuadTreeContainer theContainer, BigChunkDataGrid theGrid, double theTime, GL2 theGl, GLU theGlu, int frame) {
        Camera aCamera = CameraHandler.getInstance().getCamera("player");
        theGl.glColorMask(true, true, true, true);
        this.renderSkysphere(theGl, theGlu, aCamera.getVx(), aCamera.getVy(), aCamera.getVz());
        theGlu.gluLookAt(aCamera.getX(), aCamera.getY(), aCamera.getZ(), aCamera.getLookX(), aCamera.getLookY(), aCamera.getLookZ(), 0.0, 1.0, 0.0);
        theGl.glEnable(2884);
        theGl.glShadeModel(7425);
        aCamera.getFrustrum().createFrustrum(this.getFrustrumMatrix(theGl));
        Statistics.getInstance().getMyStats().put("rendered", 0);
        long startTime = System.currentTimeMillis();
        ArrayList<QuadTreeNode> evaluateThese = new ArrayList<QuadTreeNode>();
        ArrayList<ChunkDataWrapper> aVisibleList = new ArrayList<ChunkDataWrapper>();
        ArrayList<ChunkDataWrapper> aOccludedList = new ArrayList<ChunkDataWrapper>();
        if (frame > 0) {
            for (ChunkDataWrapper aWrapperToCheck : theGrid.getMyChunksAsArray()) {
                int[] response = new int[1];
                theGl.glGetQueryObjectuiv(aWrapperToCheck.myQueryList[0], 34918, response, 0);
                int amountOfPixelsDrawn = response[0];
                aWrapperToCheck.isVisibleByOcclusion = amountOfPixelsDrawn != 0;
            }
        }
        theContainer.checkVisibilityOnNodes();
        theContainer.checkEmptyOnNodes();
        for (QuadTreeNode aNode : theContainer.getNodesToEvaluate()) {
            aNode.recursiveSearch(0, aCamera, evaluateThese);
        }
        for (QuadTreeNode aNodeToEvaluate : evaluateThese) {
            ChunkDataWrapper aWrapper = theGrid.getWrapperAt(aNodeToEvaluate.worldCoord.x, aNodeToEvaluate.worldCoord.y, aNodeToEvaluate.worldCoord.z, aNodeToEvaluate.chunkCoord.x, aNodeToEvaluate.chunkCoord.y, aNodeToEvaluate.chunkCoord.z, theGl);
            aWrapper.myCenter = aNodeToEvaluate.center;
            if (!aWrapper.isInitialized) {
                aWrapper.myCenter = aNodeToEvaluate.center;
                if (aWrapper.isVisibleByOcclusion) {
                    theGrid.buildVBOForChunk(theGl, theGlu, aWrapper);
                    aVisibleList.add(aWrapper);
                } else {
                    aOccludedList.add(aWrapper);
                }
            } else if (!aWrapper.isEmpty) {
                if (aWrapper.isVisibleByOcclusion) {
                    aVisibleList.add(aWrapper);
                } else {
                    aOccludedList.add(aWrapper);
                }
            }
            aNodeToEvaluate.isVisible = aWrapper.isVisibleByOcclusion;
        }
        Collections.sort(aVisibleList, new CameraToChunkComparator(aCamera.getX(), aCamera.getY(), aCamera.getZ()));
        Collections.sort(aOccludedList, new CameraToChunkComparator(aCamera.getX(), aCamera.getY(), aCamera.getZ()));
        theGl.glEnableClientState(32884);
        theGl.glEnableClientState(32888);
        theGl.glEnableClientState(32886);
        theGl.glEnable(3008);
        theGl.glAlphaFunc(516, 0.5f);
        for (ChunkDataWrapper aVisibleWrapper : aVisibleList) {
            theGl.glBeginQuery(35092, aVisibleWrapper.myQueryList[0]);
            aVisibleWrapper.renderSolids(theGl, theGlu, (int)(theTime * 3.0));
            theGl.glEndQuery(35092);
        }
        theGl.glDisable(3008);
        for (AnimatedGenerator aGenerator : AnimatedGeneratorHandler.getInstance().getAnimatedGenerators()) {
            aGenerator.render(theGl, theGlu, (int)(theTime * 3.0));
        }
        theGl.glDisableClientState(32888);
        theGl.glDisableClientState(32886);
        for (Movable aMovable : MovableHandler.getInstance().getMyMovables()) {
            aMovable.render(theGl, theGlu, aCamera);
        }
        theGl.glDisable(3553);
        double myTransCamX = aCamera.getX();
        double myTransCamY = aCamera.getY();
        double myTransCamZ = aCamera.getZ();
        Vector3 hit = theGrid.intersectRay((float)myTransCamX, (float)myTransCamY, (float)myTransCamZ, (float)aCamera.getVx(), (float)aCamera.getVy(), (float)aCamera.getVz(), 4.0f);
        if (hit != null) {
            this.renderMarkingBox(theGl, theGlu, theGrid, (float)hit.x, (float)hit.y, (float)hit.z);
        }
        theGl.glShadeModel(7424);
        theGl.glColorMask(false, false, false, false);
        theGl.glDepthMask(true);
        for (ChunkDataWrapper aOccludedWrapper : aOccludedList) {
            theGl.glBeginQuery(35092, aOccludedWrapper.myQueryList[0]);
            if (!aOccludedWrapper.isInitialized) {
                theGrid.renderAsBoundingBox(theGl, theGlu, (float)aOccludedWrapper.myCenter.x, (float)aOccludedWrapper.myCenter.y, (float)aOccludedWrapper.myCenter.z);
            } else {
                aOccludedWrapper.renderForOcclusion(theGl, theGlu);
            }
            theGl.glEndQuery(35092);
        }
        theGl.glDisable(2884);
        theGl.glDepthMask(true);
        theGl.glColorMask(true, true, true, true);
    }
}

