/*
 * Decompiled with CFR 0.152.
 */
package com.js.test.engine.gui;

import com.js.test.engine.gui.Component;
import com.js.test.engine.gui.GuiKeyEvent;
import com.js.test.engine.gui.GuiMouseEvent;
import com.js.test.engine.material.TextureHandler;
import com.js.test.terra.math.Vector3;
import java.util.ArrayList;
import java.util.List;
import javax.media.opengl.GL2;
import javax.media.opengl.glu.GLU;

public class GuiPanel
extends Component {
    private List<Component> myComponents = new ArrayList<Component>();
    private Vector3 myColor;
    private float myAlpha;
    private boolean useBg;
    private String bgAsset;
    private Component myLastMouseOver;

    public GuiPanel(int x, int y, int w, int h, Vector3 color, float alpha) {
        super(x, y, w, h);
        this.myColor = color;
        this.myAlpha = alpha;
        this.useBg = false;
        this.bgAsset = null;
        this.isVisible = true;
    }

    public GuiPanel(int x, int y, int w, int h, String bgAsset) {
        super(x, y, w, h);
        this.myColor = new Vector3(0.0, 0.0, 0.0);
        this.myAlpha = 0.0f;
        this.useBg = true;
        this.bgAsset = bgAsset;
    }

    @Override
    public void render(GL2 theGl, GLU theGlu) {
        if (this.isVisible) {
            if (this.useBg) {
                theGl.glColor4f(1.0f, 1.0f, 1.0f, 1.0f);
                TextureHandler.getInstance().bindTextureAsTransparent(this.bgAsset, theGl);
                theGl.glBegin(7);
                theGl.glTexCoord2f(0.0f, 1.0f);
                theGl.glVertex2f(this.myBox.x, this.myBox.y);
                theGl.glTexCoord2f(0.0f, 0.0f);
                theGl.glVertex2f(this.myBox.x, this.myBox.y + this.myBox.h);
                theGl.glTexCoord2f(1.0f, 0.0f);
                theGl.glVertex2f(this.myBox.x + this.myBox.w, this.myBox.y + this.myBox.h);
                theGl.glTexCoord2f(1.0f, 1.0f);
                theGl.glVertex2f(this.myBox.x + this.myBox.w, this.myBox.y);
                theGl.glEnd();
                TextureHandler.getInstance().unbindTextureAsTransparent(this.bgAsset, theGl);
            } else {
                theGl.glColor4f((float)this.myColor.x, (float)this.myColor.y, (float)this.myColor.z, this.myAlpha);
                theGl.glEnable(3042);
                theGl.glBlendFunc(770, 771);
                theGl.glBegin(7);
                theGl.glVertex2f(this.myBox.x, this.myBox.y);
                theGl.glVertex2f(this.myBox.x, this.myBox.y + this.myBox.h);
                theGl.glVertex2f(this.myBox.x + this.myBox.w, this.myBox.y + this.myBox.h);
                theGl.glVertex2f(this.myBox.x + this.myBox.w, this.myBox.y);
                theGl.glEnd();
                theGl.glDisable(3042);
            }
            for (Component aComponent : this.myComponents) {
                aComponent.render(theGl, theGlu);
            }
        }
    }

    @Override
    public void click(GuiMouseEvent e) {
        for (Component aComponent : this.myComponents) {
            if (!aComponent.isVisible() || !aComponent.getBox().isInside(e.x, e.y)) continue;
            aComponent.click(e);
            break;
        }
    }

    @Override
    public void mouseOver(GuiMouseEvent e) {
        boolean wasOver = false;
        for (Component aComponent : this.myComponents) {
            if (!aComponent.isVisible() || !aComponent.getBox().isInside(e.x, e.y)) continue;
            aComponent.mouseOver(e);
            if (this.myLastMouseOver != null && this.myLastMouseOver != aComponent) {
                this.myLastMouseOver.mouseLeave(e);
            }
            this.myLastMouseOver = aComponent;
            wasOver = true;
            break;
        }
        if (!wasOver && this.myLastMouseOver != null) {
            this.myLastMouseOver.mouseLeave(e);
            this.myLastMouseOver = null;
        }
    }

    @Override
    public void mouseLeave(GuiMouseEvent e) {
    }

    @Override
    public void keyEvent(GuiKeyEvent e) {
    }

    public void addComponent(Component addThis) {
        this.myComponents.add(addThis);
    }

    public List<Component> getMyComponents() {
        return this.myComponents;
    }

    public void setMyComponents(List<Component> myComponents) {
        this.myComponents = myComponents;
    }

    @Override
    public void mousePressed(GuiMouseEvent e) {
        for (Component aComponent : this.myComponents) {
            if (!aComponent.isVisible() || !aComponent.getBox().isInside(e.x, e.y)) continue;
            aComponent.mousePressed(e);
            break;
        }
    }

    @Override
    public void mouseReleased(GuiMouseEvent e) {
        for (Component aComponent : this.myComponents) {
            if (!aComponent.isVisible() || !aComponent.getBox().isInside(e.x, e.y)) continue;
            aComponent.mouseReleased(e);
            break;
        }
    }

    @Override
    public void mouseMove(GuiMouseEvent e) {
        for (Component aComponent : this.myComponents) {
            if (!aComponent.isVisible() || !aComponent.getBox().isInside(e.x, e.y)) continue;
            aComponent.mouseMove(e);
            break;
        }
    }

    @Override
    public void draggedNotHandeled() {
    }
}

