/*
 * Decompiled with CFR 0.152.
 */
package com.js.test.engine.gui;

import com.js.test.engine.gui.Component;
import com.js.test.engine.gui.Draggable;
import com.js.test.engine.gui.GuiKeyEvent;
import com.js.test.engine.gui.GuiMouseEvent;
import com.js.test.engine.gui.OverlayHandler;
import com.js.test.engine.material.TextureHandler;
import com.js.test.engine.player.Inventory;
import com.js.test.engine.text.TextEntry;
import com.js.test.engine.text.TextHandler;
import com.js.test.terra.area.blocks.Block;
import com.js.test.terra.area.blocks.BlockLoader;
import com.js.test.terra.area.item.BaseItem;
import com.js.test.terra.area.item.BaseItemLoader;
import com.js.test.terra.area.item.ItemStack;
import javax.media.opengl.GL2;
import javax.media.opengl.glu.GLU;

public class GuiItemContainer
extends Component {
    private Inventory myInventory;
    private int myItemSize;
    private int myOffset;
    private boolean isDragging;
    private int origX;
    private int origY;
    private int mouseAtX;
    private int mouseAtY;
    private int realMouseAtX;
    private int realMouseAtY;

    public GuiItemContainer(int x, int y, int w, int h, int itemSize, int offset, Inventory theInventory) {
        super(x, y, w, h);
        this.myInventory = theInventory;
        this.myItemSize = itemSize;
        this.myOffset = offset;
        this.mouseAtX = -1;
        this.mouseAtY = -1;
    }

    @Override
    public void render(GL2 theGl, GLU theGlu) {
        if (this.myInventory == null) {
            return;
        }
        int index = 0;
        int y = 0;
        while (y < this.myInventory.getMyH()) {
            int x = 0;
            while (x < this.myInventory.getMyW()) {
                ItemStack aStack = this.myInventory.getMyItems()[index++];
                this.renderSquareAt(x, y, theGl, theGlu);
                if (aStack != null) {
                    if (aStack.getMyItem().isBlock) {
                        this.renderBlockAt(x, y, theGl, theGlu, aStack.getMyItem().blockId);
                        TextHandler.getInstance().addEntry(new TextEntry("" + aStack.getMyAmount(), (int)this.myBox.x + x * this.myItemSize + this.myOffset + 12, (int)this.myBox.y + y * this.myItemSize + this.myItemSize));
                        if (this.mouseAtX == x && this.mouseAtY == y) {
                            Block aBlockToName = BlockLoader.getInstance().getMyBlocksAsArray()[aStack.getMyItem().blockId];
                            TextHandler.getInstance().addEntry(new TextEntry(aBlockToName.getMyName(), this.realMouseAtX, this.realMouseAtY + 64));
                        }
                    } else {
                        BaseItem aItemToName;
                        this.renderItemAt(x, y, theGl, theGlu, aStack.getMyItem().itemId);
                        if (aStack.isMyCanBeMultiple()) {
                            TextHandler.getInstance().addEntry(new TextEntry("" + aStack.getMyAmount(), (int)this.myBox.x + x * this.myItemSize + this.myOffset + 12, (int)this.myBox.y + y * this.myItemSize + this.myItemSize));
                        } else {
                            aItemToName = BaseItemLoader.getInstance().getMyItems().get(aStack.getMyItem().itemId);
                            if (aItemToName.getMyUsages() != 9999) {
                                this.renderUsageBarAt(x, y, theGl, theGlu, aStack.getMyAmount(), aItemToName.getMyUsages());
                            }
                        }
                        if (this.mouseAtX == x && this.mouseAtY == y) {
                            aItemToName = BaseItemLoader.getInstance().getMyItems().get(aStack.getMyItem().itemId);
                            TextHandler.getInstance().addEntry(new TextEntry(aItemToName.getMyFancyName(), this.realMouseAtX, this.realMouseAtY + 64));
                        }
                    }
                }
                ++x;
            }
            ++y;
        }
    }

    private void renderUsageBarAt(int x, int y, GL2 theGl, GLU theGlu, int usages, int maxUsages) {
        int startX = (int)this.myBox.x + x * this.myItemSize + this.myOffset + 2;
        int startY = (int)this.myBox.y + y * this.myItemSize + this.myItemSize - this.myItemSize / 8;
        int w = (int)((float)(this.myItemSize - 4) * (1.0f - (float)usages / (float)maxUsages));
        int w2 = this.myItemSize - 4 - w;
        int h = this.myItemSize / 8;
        theGl.glColor4f(0.0f, 1.0f, 0.0f, 1.0f);
        theGl.glBegin(7);
        theGl.glVertex2f((float)startX, (float)startY);
        theGl.glVertex2f((float)startX, (float)(startY + h));
        theGl.glVertex2f((float)(startX + w), (float)(startY + h));
        theGl.glVertex2f((float)(startX + w), (float)startY);
        theGl.glEnd();
        theGl.glColor4f(1.0f, 0.0f, 0.0f, 1.0f);
        theGl.glBegin(7);
        theGl.glVertex2f((float)(startX + w), (float)startY);
        theGl.glVertex2f((float)(startX + w), (float)(startY + h));
        theGl.glVertex2f((float)(startX + w + w2), (float)(startY + h));
        theGl.glVertex2f((float)(startX + w + w2), (float)startY);
        theGl.glEnd();
    }

    private void renderSquareAt(int x, int y, GL2 theGl, GLU theGlu) {
        int startX = (int)this.myBox.x + x * this.myItemSize + this.myOffset + 2;
        int startY = (int)this.myBox.y + y * this.myItemSize + 2;
        int w = this.myItemSize - 4;
        int h = this.myItemSize - 4;
        theGl.glColor4f(1.0f, 1.0f, 1.0f, 1.0f);
        TextureHandler.getInstance().bindTextureAsTransparent("ui_box", theGl);
        theGl.glBegin(7);
        theGl.glTexCoord2f(0.0f, 1.0f);
        theGl.glVertex2f((float)startX, (float)startY);
        theGl.glTexCoord2f(0.0f, 0.0f);
        theGl.glVertex2f((float)startX, (float)(startY + h));
        theGl.glTexCoord2f(1.0f, 0.0f);
        theGl.glVertex2f((float)(startX + w), (float)(startY + h));
        theGl.glTexCoord2f(1.0f, 1.0f);
        theGl.glVertex2f((float)(startX + w), (float)startY);
        theGl.glEnd();
        TextureHandler.getInstance().unbindTextureAsTransparent("ui_box", theGl);
    }

    private void renderBlockAt(int x, int y, GL2 theGl, GLU theGlu, int blockId) {
        int startX = (int)this.myBox.x + x * this.myItemSize + this.myOffset + 12;
        int startY = (int)this.myBox.y + y * this.myItemSize + 12;
        int w = this.myItemSize - 24;
        int h = this.myItemSize - 24;
        theGl.glColor3f(0.6f, 0.6f, 0.6f);
        theGl.glEnable(3553);
        TextureHandler.getInstance().bindBlockTexture(blockId, theGl, 0);
        theGl.glBegin(7);
        theGl.glTexCoord2f(0.0f, 1.0f);
        theGl.glVertex2f((float)startX, (float)startY);
        theGl.glTexCoord2f(0.0f, 0.0f);
        theGl.glVertex2f((float)startX, (float)(startY + h));
        theGl.glTexCoord2f(1.0f, 0.0f);
        theGl.glVertex2f((float)(startX + w), (float)(startY + h));
        theGl.glTexCoord2f(1.0f, 1.0f);
        theGl.glVertex2f((float)(startX + w), (float)startY);
        theGl.glEnd();
        theGl.glDisable(3553);
    }

    private void renderItemAt(int x, int y, GL2 theGl, GLU theGlu, int itemId) {
        int startX = (int)this.myBox.x + x * this.myItemSize + this.myOffset + 12;
        int startY = (int)this.myBox.y + y * this.myItemSize + 12;
        int w = this.myItemSize - 24;
        int h = this.myItemSize - 24;
        theGl.glColor3f(0.6f, 0.6f, 0.6f);
        theGl.glEnable(3553);
        TextureHandler.getInstance().bindItemTexture(itemId, theGl);
        theGl.glBegin(7);
        theGl.glTexCoord2f(0.0f, 1.0f);
        theGl.glVertex2f((float)startX, (float)startY);
        theGl.glTexCoord2f(0.0f, 0.0f);
        theGl.glVertex2f((float)startX, (float)(startY + h));
        theGl.glTexCoord2f(1.0f, 0.0f);
        theGl.glVertex2f((float)(startX + w), (float)(startY + h));
        theGl.glTexCoord2f(1.0f, 1.0f);
        theGl.glVertex2f((float)(startX + w), (float)startY);
        theGl.glEnd();
        TextureHandler.getInstance().unbindItemTexture(itemId, theGl);
        theGl.glDisable(3553);
    }

    @Override
    public void click(GuiMouseEvent e) {
    }

    @Override
    public void mouseOver(GuiMouseEvent e) {
    }

    @Override
    public void mouseLeave(GuiMouseEvent e) {
        this.mouseAtX = -1;
        this.mouseAtY = -1;
    }

    @Override
    public void keyEvent(GuiKeyEvent e) {
    }

    public int getMyItemSize() {
        return this.myItemSize;
    }

    public void setMyItemSize(int myItemSize) {
        this.myItemSize = myItemSize;
    }

    public int getMyOffset() {
        return this.myOffset;
    }

    public void setMyOffset(int myOffset) {
        this.myOffset = myOffset;
    }

    public Inventory getMyInventory() {
        return this.myInventory;
    }

    public void setMyInventory(Inventory myInventory) {
        this.myInventory = myInventory;
    }

    @Override
    public void mousePressed(GuiMouseEvent e) {
        if (this.myInventory == null) {
            return;
        }
        int inX = 0;
        int inY = 0;
        inX = e.x - (int)this.myBox.x - this.myOffset;
        inY = e.y - (int)this.myBox.y;
        if (inX >= 0 && inX < this.myInventory.getMyW() * this.myItemSize) {
            inX -= inX % this.myItemSize;
            inY -= inY % this.myItemSize;
            ItemStack aStack = this.myInventory.getMyItems()[(inX /= this.myItemSize) + (inY /= this.myItemSize) * this.myInventory.getMyW()];
            if (aStack != null) {
                this.origX = inX;
                this.origY = inY;
                Draggable draggable = new Draggable(this, this.myInventory.getMyItems()[inX + inY * this.myInventory.getMyW()]);
                this.myInventory.getMyItems()[inX + inY * this.myInventory.getMyW()] = null;
                OverlayHandler.getInstance().setMyDraggable(draggable);
            }
        }
    }

    @Override
    public void mouseReleased(GuiMouseEvent e) {
        if (this.myInventory == null) {
            return;
        }
        Draggable aDragged = OverlayHandler.getInstance().getMyDraggable();
        if (aDragged != null && ItemStack.class == aDragged.getDataDragged().getClass()) {
            ItemStack aData = (ItemStack)aDragged.getDataDragged();
            int inX = 0;
            int inY = 0;
            inX = e.x - (int)this.myBox.x - this.myOffset;
            inY = e.y - (int)this.myBox.y;
            if (inX >= 0 && inX < this.myInventory.getMyW() * this.myItemSize) {
                inX -= inX % this.myItemSize;
                inY -= inY % this.myItemSize;
                ItemStack aStack = this.myInventory.getMyItems()[(inX /= this.myItemSize) + (inY /= this.myItemSize) * this.myInventory.getMyW()];
                if (aStack == null) {
                    this.myInventory.getMyItems()[inX + inY * this.myInventory.getMyW()] = aData;
                    OverlayHandler.getInstance().setMyDraggable(null);
                } else if (aDragged.getOriginalComponent() == this) {
                    ItemStack stackAtOriginalPoint = this.myInventory.getMyItems()[this.origX + this.origY * this.myInventory.getMyW()];
                    if (stackAtOriginalPoint != null) {
                        this.myInventory.getMyItems()[inX + inY * this.myInventory.getMyW()] = aData;
                        this.myInventory.addStack(aStack);
                    } else if (aStack.getMyItem().isBlock && aData.getMyItem().isBlock && aStack.getMyItem().blockId == aData.getMyItem().blockId) {
                        this.myInventory.getMyItems()[inX + inY * this.myInventory.getMyW()].setMyAmount(aData.getMyAmount() + aStack.getMyAmount());
                    } else if (aStack.getMyItem().isItem && aData.getMyItem().isItem && aStack.getMyItem().itemId == aData.getMyItem().itemId && aData.getMyItem().isStackable) {
                        this.myInventory.getMyItems()[inX + inY * this.myInventory.getMyW()].setMyAmount(aData.getMyAmount() + aStack.getMyAmount());
                    } else {
                        this.myInventory.getMyItems()[inX + inY * this.myInventory.getMyW()] = aData;
                        this.myInventory.getMyItems()[this.origX + this.origY * this.myInventory.getMyW()] = aStack;
                    }
                    OverlayHandler.getInstance().setMyDraggable(null);
                }
            }
        }
    }

    @Override
    public void mouseMove(GuiMouseEvent e) {
        int inX = 0;
        int inY = 0;
        inX = e.x - (int)this.myBox.x - this.myOffset;
        inY = e.y - (int)this.myBox.y;
        if (inX >= 0 && inX < this.myInventory.getMyW() * this.myItemSize) {
            inX -= inX % this.myItemSize;
            inY -= inY % this.myItemSize;
            this.mouseAtX = inX /= this.myItemSize;
            this.mouseAtY = inY /= this.myItemSize;
            this.realMouseAtX = e.x;
            this.realMouseAtY = e.y;
        }
    }

    @Override
    public void draggedNotHandeled() {
        if (this.myInventory == null) {
            return;
        }
        Draggable aDragged = OverlayHandler.getInstance().getMyDraggable();
        if (aDragged != null && ItemStack.class == aDragged.getDataDragged().getClass()) {
            ItemStack aData = (ItemStack)aDragged.getDataDragged();
            ItemStack inOrigSpot = this.myInventory.getMyItems()[this.origX + this.origY * this.myInventory.getMyW()];
            if (inOrigSpot != null) {
                this.myInventory.addStack(aData);
            } else {
                this.myInventory.getMyItems()[this.origX + this.origY * this.myInventory.getMyW()] = aData;
            }
            OverlayHandler.getInstance().setMyDraggable(null);
        }
    }
}

