/*
 * Decompiled with CFR 0.152.
 */
package com.js.test.engine.gui;

import com.js.test.engine.gui.Component;
import com.js.test.engine.gui.Draggable;
import com.js.test.engine.gui.GuiKeyEvent;
import com.js.test.engine.gui.GuiMouseEvent;
import com.js.test.engine.gui.OverlayHandler;
import com.js.test.engine.material.TextureHandler;
import com.js.test.engine.player.Inventory;
import com.js.test.engine.text.TextEntry;
import com.js.test.engine.text.TextHandler;
import com.js.test.terra.area.item.BaseItem;
import com.js.test.terra.area.item.BaseItemLoader;
import com.js.test.terra.area.item.ItemStack;
import javax.media.opengl.GL2;
import javax.media.opengl.glu.GLU;

public class GuiHotbar
extends Component {
    private Inventory myInventory;
    private int myItemSize;
    private int myOffset;
    private int origX;

    public GuiHotbar(int x, int y, int w, int h, int itemSize, int offset, Inventory theInventory) {
        super(x, y, w, h);
        this.myInventory = theInventory;
        this.myItemSize = itemSize;
        this.myOffset = offset;
    }

    @Override
    public void render(GL2 theGl, GLU theGlu) {
        boolean index = false;
        int x = 0;
        while (x < this.myInventory.getMyHotbar().getItems().length) {
            ItemStack aStack = this.myInventory.getMyHotbar().getItems()[x];
            TextHandler.getInstance().addEntry(new TextEntry("" + (x + 1) % 10, (int)this.myBox.x + x * this.myItemSize + this.myOffset + this.myItemSize / 2, (int)this.myBox.y + this.myItemSize + 12));
            this.renderSquareAt(x, 0, theGl, theGlu);
            if (x == this.myInventory.getMyHotbar().getActiveLeftHand()) {
                this.renderMarkerSquare(x, 0, theGl, theGlu, "ui_selector");
            } else if (x == this.myInventory.getMyHotbar().getActiveRightHand()) {
                this.renderMarkerSquare(x, 0, theGl, theGlu, "ui_selector_2");
            }
            if (aStack != null) {
                if (aStack.getMyItem().isBlock) {
                    this.renderBlockAt(x, 0, theGl, theGlu, aStack.getMyItem().blockId);
                    TextHandler.getInstance().addEntry(new TextEntry("" + aStack.getMyAmount(), (int)this.myBox.x + x * this.myItemSize + this.myOffset + 16, (int)this.myBox.y + this.myItemSize));
                } else {
                    this.renderItemAt(x, 0, theGl, theGlu, aStack.getMyItem().itemId);
                    if (aStack.isMyCanBeMultiple()) {
                        TextHandler.getInstance().addEntry(new TextEntry("" + aStack.getMyAmount(), (int)this.myBox.x + x * this.myItemSize + this.myOffset + 16, (int)this.myBox.y + this.myItemSize));
                    } else {
                        BaseItem aItemToName = BaseItemLoader.getInstance().getMyItems().get(aStack.getMyItem().itemId);
                        if (aItemToName.getMyUsages() != 9999) {
                            this.renderUsageBarAt(x, 0, theGl, theGlu, aStack.getMyAmount(), aItemToName.getMyUsages());
                        }
                    }
                }
            }
            ++x;
        }
    }

    private void renderUsageBarAt(int x, int y, GL2 theGl, GLU theGlu, int usages, int maxUsages) {
        int startX = (int)this.myBox.x + x * this.myItemSize + this.myOffset + 2;
        int startY = (int)this.myBox.y + y * this.myItemSize + this.myItemSize - this.myItemSize / 8;
        int w = (int)((float)(this.myItemSize - 4) * (1.0f - (float)usages / (float)maxUsages));
        int w2 = this.myItemSize - 4 - w;
        int h = this.myItemSize / 8;
        theGl.glColor4f(0.0f, 1.0f, 0.0f, 1.0f);
        theGl.glBegin(7);
        theGl.glVertex2f((float)startX, (float)startY);
        theGl.glVertex2f((float)startX, (float)(startY + h));
        theGl.glVertex2f((float)(startX + w), (float)(startY + h));
        theGl.glVertex2f((float)(startX + w), (float)startY);
        theGl.glEnd();
        theGl.glColor4f(1.0f, 0.0f, 0.0f, 1.0f);
        theGl.glBegin(7);
        theGl.glVertex2f((float)(startX + w), (float)startY);
        theGl.glVertex2f((float)(startX + w), (float)(startY + h));
        theGl.glVertex2f((float)(startX + w + w2), (float)(startY + h));
        theGl.glVertex2f((float)(startX + w + w2), (float)startY);
        theGl.glEnd();
    }

    private void renderMarkerSquare(int x, int y, GL2 theGl, GLU theGlu, String asset) {
        int startX = (int)this.myBox.x + x * this.myItemSize + this.myOffset;
        int startY = (int)this.myBox.y + y * this.myItemSize;
        int w = this.myItemSize;
        int h = this.myItemSize;
        theGl.glColor4f(1.0f, 1.0f, 1.0f, 1.0f);
        TextureHandler.getInstance().bindTextureAsTransparent(asset, theGl);
        theGl.glBegin(7);
        theGl.glTexCoord2f(0.0f, 1.0f);
        theGl.glVertex2f((float)startX, (float)startY);
        theGl.glTexCoord2f(0.0f, 0.0f);
        theGl.glVertex2f((float)startX, (float)(startY + h));
        theGl.glTexCoord2f(1.0f, 0.0f);
        theGl.glVertex2f((float)(startX + w), (float)(startY + h));
        theGl.glTexCoord2f(1.0f, 1.0f);
        theGl.glVertex2f((float)(startX + w), (float)startY);
        theGl.glEnd();
        TextureHandler.getInstance().unbindTextureAsTransparent(asset, theGl);
    }

    private void renderSquareAt(int x, int y, GL2 theGl, GLU theGlu) {
        int startX = (int)this.myBox.x + x * this.myItemSize + this.myOffset + 2;
        int startY = (int)this.myBox.y + y * this.myItemSize + 2;
        int w = this.myItemSize - 4;
        int h = this.myItemSize - 4;
        theGl.glColor4f(1.0f, 1.0f, 1.0f, 1.0f);
        TextureHandler.getInstance().bindTextureAsTransparent("ui_box", theGl);
        theGl.glBegin(7);
        theGl.glTexCoord2f(0.0f, 1.0f);
        theGl.glVertex2f((float)startX, (float)startY);
        theGl.glTexCoord2f(0.0f, 0.0f);
        theGl.glVertex2f((float)startX, (float)(startY + h));
        theGl.glTexCoord2f(1.0f, 0.0f);
        theGl.glVertex2f((float)(startX + w), (float)(startY + h));
        theGl.glTexCoord2f(1.0f, 1.0f);
        theGl.glVertex2f((float)(startX + w), (float)startY);
        theGl.glEnd();
        TextureHandler.getInstance().unbindTextureAsTransparent("ui_box", theGl);
    }

    private void renderBlockAt(int x, int y, GL2 theGl, GLU theGlu, int blockId) {
        int startX = (int)this.myBox.x + x * this.myItemSize + this.myOffset + 12;
        int startY = (int)this.myBox.y + y * this.myItemSize + 12;
        int w = this.myItemSize - 24;
        int h = this.myItemSize - 24;
        theGl.glColor3f(0.6f, 0.6f, 0.6f);
        theGl.glEnable(3553);
        TextureHandler.getInstance().bindBlockTexture(blockId, theGl, 0);
        theGl.glBegin(7);
        theGl.glTexCoord2f(0.0f, 1.0f);
        theGl.glVertex2f((float)startX, (float)startY);
        theGl.glTexCoord2f(0.0f, 0.0f);
        theGl.glVertex2f((float)startX, (float)(startY + h));
        theGl.glTexCoord2f(1.0f, 0.0f);
        theGl.glVertex2f((float)(startX + w), (float)(startY + h));
        theGl.glTexCoord2f(1.0f, 1.0f);
        theGl.glVertex2f((float)(startX + w), (float)startY);
        theGl.glEnd();
        theGl.glDisable(3553);
    }

    private void renderItemAt(int x, int y, GL2 theGl, GLU theGlu, int itemId) {
        int startX = (int)this.myBox.x + x * this.myItemSize + this.myOffset + 12;
        int startY = (int)this.myBox.y + y * this.myItemSize + 12;
        int w = this.myItemSize - 24;
        int h = this.myItemSize - 24;
        theGl.glColor3f(0.6f, 0.6f, 0.6f);
        theGl.glEnable(3553);
        TextureHandler.getInstance().bindItemTexture(itemId, theGl);
        theGl.glBegin(7);
        theGl.glTexCoord2f(0.0f, 1.0f);
        theGl.glVertex2f((float)startX, (float)startY);
        theGl.glTexCoord2f(0.0f, 0.0f);
        theGl.glVertex2f((float)startX, (float)(startY + h));
        theGl.glTexCoord2f(1.0f, 0.0f);
        theGl.glVertex2f((float)(startX + w), (float)(startY + h));
        theGl.glTexCoord2f(1.0f, 1.0f);
        theGl.glVertex2f((float)(startX + w), (float)startY);
        theGl.glEnd();
        TextureHandler.getInstance().unbindItemTexture(itemId, theGl);
        theGl.glDisable(3553);
    }

    @Override
    public void click(GuiMouseEvent e) {
    }

    @Override
    public void mouseOver(GuiMouseEvent e) {
    }

    @Override
    public void mouseLeave(GuiMouseEvent e) {
    }

    @Override
    public void keyEvent(GuiKeyEvent e) {
    }

    public int getMyItemSize() {
        return this.myItemSize;
    }

    public void setMyItemSize(int myItemSize) {
        this.myItemSize = myItemSize;
    }

    public int getMyOffset() {
        return this.myOffset;
    }

    public void setMyOffset(int myOffset) {
        this.myOffset = myOffset;
    }

    @Override
    public void mousePressed(GuiMouseEvent e) {
        if (this.myInventory == null) {
            return;
        }
        int inX = 0;
        inX = e.x - (int)this.myBox.x - this.myOffset;
        if (inX >= 0 && inX < this.myInventory.getMyW() * this.myItemSize) {
            ItemStack aStack;
            inX -= inX % this.myItemSize;
            if ((inX /= this.myItemSize) >= 0 && inX < this.myInventory.getMyHotbar().getItems().length && (aStack = this.myInventory.getMyHotbar().getItems()[inX]) != null) {
                this.origX = inX;
                Draggable draggable = new Draggable(this, this.myInventory.getMyHotbar().getItems()[inX]);
                this.myInventory.getMyHotbar().getItems()[inX] = null;
                OverlayHandler.getInstance().setMyDraggable(draggable);
            }
        }
    }

    @Override
    public void mouseReleased(GuiMouseEvent e) {
        Draggable aDragged = OverlayHandler.getInstance().getMyDraggable();
        if (aDragged != null && ItemStack.class == aDragged.getDataDragged().getClass()) {
            ItemStack aData = (ItemStack)aDragged.getDataDragged();
            int inX = 0;
            boolean inY = false;
            inX = e.x - (int)this.myBox.x - this.myOffset;
            inX -= inX % this.myItemSize;
            if (this.myInventory.getMyHotbar().getItems()[inX /= this.myItemSize] == null) {
                this.myInventory.getMyHotbar().getItems()[inX] = aData;
            }
            OverlayHandler.getInstance().setMyDraggable(null);
        }
    }

    @Override
    public void mouseMove(GuiMouseEvent e) {
    }

    @Override
    public void draggedNotHandeled() {
        if (this.myInventory == null) {
            return;
        }
        Draggable aDragged = OverlayHandler.getInstance().getMyDraggable();
        if (aDragged != null && ItemStack.class == aDragged.getDataDragged().getClass()) {
            ItemStack aData = (ItemStack)aDragged.getDataDragged();
            ItemStack inOrigSpot = this.myInventory.getMyHotbar().getItems()[this.origX];
            if (inOrigSpot != null) {
                int i = 0;
                while (i < this.myInventory.getMyHotbar().getItems().length) {
                    if (this.myInventory.getMyHotbar().getItems()[i] == null) {
                        this.myInventory.getMyHotbar().getItems()[i] = aData;
                        break;
                    }
                    ++i;
                }
            } else {
                this.myInventory.getMyHotbar().getItems()[this.origX] = aData;
            }
            OverlayHandler.getInstance().setMyDraggable(null);
        }
    }
}

