/*
 * Decompiled with CFR 0.152.
 */
package com.js.test.engine.gui;

import com.js.test.engine.gui.Component;
import com.js.test.engine.gui.GuiKeyEvent;
import com.js.test.engine.gui.GuiMouseEvent;
import com.js.test.engine.gui.GuiMouseListener;
import com.js.test.engine.text.TextEntry;
import com.js.test.engine.text.TextHandler;
import com.js.test.terra.math.Vector3;
import java.awt.geom.Rectangle2D;
import javax.media.opengl.GL2;
import javax.media.opengl.glu.GLU;

public class GuiButton
extends Component {
    private String myText;
    private boolean isMouseOver;
    private Vector3 myColor;
    private Vector3 myMouseOverColor;
    private int myTextW = 0;
    private int myTextH = 0;

    public GuiButton(int x, int y, int w, int h, String text, Vector3 color, Vector3 moColor) {
        super(x, y, w, h);
        this.myText = text;
        this.isMouseOver = false;
        this.myColor = color;
        this.myMouseOverColor = moColor;
        Rectangle2D aDimension = TextHandler.getInstance().getBounds(this.myText);
        this.myTextW = (int)aDimension.getWidth();
        this.myTextH = (int)aDimension.getHeight();
    }

    @Override
    public void render(GL2 theGl, GLU theGlu) {
        if (this.isMouseOver) {
            theGl.glColor3f((float)this.myMouseOverColor.x, (float)this.myMouseOverColor.y, (float)this.myMouseOverColor.z);
        } else {
            theGl.glColor3f((float)this.myColor.x, (float)this.myColor.y, (float)this.myColor.z);
        }
        TextHandler.getInstance().addEntry(new TextEntry(this.myText, (int)(this.myBox.x + this.myBox.w / 2.0f - (float)(this.myTextW / 2)), (int)(this.myBox.y + this.myBox.h / 2.0f + (float)(this.myTextH / 2))));
        theGl.glBegin(7);
        theGl.glVertex2f(this.myBox.x, this.myBox.y);
        theGl.glVertex2f(this.myBox.x, this.myBox.y + this.myBox.h);
        theGl.glVertex2f(this.myBox.x + this.myBox.w, this.myBox.y + this.myBox.h);
        theGl.glVertex2f(this.myBox.x + this.myBox.w, this.myBox.y);
        theGl.glEnd();
    }

    @Override
    public void click(GuiMouseEvent e) {
        System.out.println("I was clicked");
        for (GuiMouseListener gml : this.myMouseListeners) {
            gml.click(e, this);
        }
    }

    @Override
    public void mouseOver(GuiMouseEvent e) {
        this.isMouseOver = true;
    }

    @Override
    public void mouseLeave(GuiMouseEvent e) {
        this.isMouseOver = false;
    }

    @Override
    public void keyEvent(GuiKeyEvent e) {
    }

    @Override
    public void mousePressed(GuiMouseEvent e) {
    }

    @Override
    public void mouseReleased(GuiMouseEvent e) {
    }

    @Override
    public void mouseMove(GuiMouseEvent e) {
    }

    @Override
    public void draggedNotHandeled() {
    }

    public String getMyText() {
        return this.myText;
    }

    public void setMyText(String myText) {
        this.myText = myText;
        Rectangle2D aDimension = TextHandler.getInstance().getBounds(myText);
        this.myTextW = (int)aDimension.getWidth();
        this.myTextH = (int)aDimension.getHeight();
    }

    public Vector3 getMyColor() {
        return this.myColor;
    }

    public void setMyColor(Vector3 myColor) {
        this.myColor = myColor;
    }

    public Vector3 getMyMouseOverColor() {
        return this.myMouseOverColor;
    }

    public void setMyMouseOverColor(Vector3 myMouseOverColor) {
        this.myMouseOverColor = myMouseOverColor;
    }

    public int getMyTextW() {
        return this.myTextW;
    }

    public void setMyTextW(int myTextW) {
        this.myTextW = myTextW;
    }

    public int getMyTextH() {
        return this.myTextH;
    }

    public void setMyTextH(int myTextH) {
        this.myTextH = myTextH;
    }
}

