/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.common.os;

import com.jogamp.common.nio.Buffers;
import com.jogamp.common.os.AndroidVersion;
import com.jogamp.common.os.DynamicLibraryBundle;
import com.jogamp.common.os.MachineDescription;
import com.jogamp.common.util.JarUtil;
import com.jogamp.common.util.VersionNumber;
import com.jogamp.common.util.cache.TempJarCache;
import java.io.IOException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.concurrent.TimeUnit;
import jogamp.common.Debug;
import jogamp.common.jvm.JVMUtil;
import jogamp.common.os.MachineDescriptionRuntime;

public class Platform {
    private static final String libBaseName = "gluegen-rt";
    public static final boolean USE_TEMP_JAR_CACHE;
    private static final String useTempJarCachePropName = "jogamp.gluegen.UseTempJarCache";
    public static final boolean JAVA_SE;
    public static final boolean LITTLE_ENDIAN;
    public static final String OS;
    public static final String OS_lower;
    public static final String OS_VERSION;
    public static final VersionNumber OS_VERSION_NUMBER;
    public static final String ARCH;
    public static final String ARCH_lower;
    public static final String JAVA_VENDOR;
    public static final String JAVA_VENDOR_URL;
    public static final String JAVA_VM_NAME;
    public static final String JAVA_RUNTIME_NAME;
    public static final String JAVA_VERSION;
    public static final String NEWLINE;
    public static final OSType OS_TYPE;
    public static final CPUType CPU_ARCH;
    private static final boolean is32Bit;
    private static final MachineDescription machineDescription;
    private static final String os_and_arch;

    private Platform() {
    }

    private static boolean queryIsLittleEndianImpl() {
        ByteBuffer byteBuffer = Buffers.newDirectByteBuffer(4);
        IntBuffer intBuffer = byteBuffer.asIntBuffer();
        ShortBuffer shortBuffer = byteBuffer.asShortBuffer();
        intBuffer.put(0, 168496141);
        return 3085 == shortBuffer.get(0);
    }

    private static OSType getOSTypeImpl() throws RuntimeException {
        if (AndroidVersion.isAvailable) {
            return OSType.ANDROID;
        }
        if (OS_lower.startsWith("linux")) {
            return OSType.LINUX;
        }
        if (OS_lower.startsWith("freebsd")) {
            return OSType.FREEBSD;
        }
        if (OS_lower.startsWith("android")) {
            return OSType.ANDROID;
        }
        if (OS_lower.startsWith("mac os x") || OS_lower.startsWith("darwin")) {
            return OSType.MACOS;
        }
        if (OS_lower.startsWith("sunos")) {
            return OSType.SUNOS;
        }
        if (OS_lower.startsWith("hp-ux")) {
            return OSType.HPUX;
        }
        if (OS_lower.startsWith("windows")) {
            return OSType.WINDOWS;
        }
        if (OS_lower.startsWith("kd")) {
            return OSType.OPENKODE;
        }
        throw new RuntimeException("Please port OS detection to your platform (" + OS_lower + "/" + ARCH_lower + ")");
    }

    private static String getJavaRuntimeNameImpl() {
        return AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty("java.runtime.name");
            }
        });
    }

    private static boolean initIsJavaSE() {
        if (JAVA_RUNTIME_NAME.indexOf("Java SE") != -1) {
            return true;
        }
        try {
            Class.forName("java.nio.LongBuffer");
            Class.forName("java.nio.DoubleBuffer");
            return true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
    }

    private static void loadGlueGenRTImpl() {
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                if (USE_TEMP_JAR_CACHE && TempJarCache.initSingleton()) {
                    String string = "gluegen-rt-natives-" + os_and_arch + ".jar";
                    ClassLoader classLoader = Platform.class.getClassLoader();
                    try {
                        URL uRL = JarUtil.getURLDirname(JarUtil.getJarSubURL(Platform.class.getName(), classLoader));
                        URL uRL2 = JarUtil.getJarFileURL(uRL, string);
                        TempJarCache.bootstrapNativeLib(Platform.class, Platform.libBaseName, uRL2, classLoader);
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                }
                DynamicLibraryBundle.GlueJNILibLoader.loadLibrary(Platform.libBaseName, false);
                return null;
            }
        });
    }

    public static void initSingleton() {
    }

    public static boolean isJavaSE() {
        return JAVA_SE;
    }

    public static boolean isLittleEndian() {
        return LITTLE_ENDIAN;
    }

    public static String getOSName() {
        return OS;
    }

    public static String getOSVersion() {
        return OS_VERSION;
    }

    public static VersionNumber getOSVersionNumber() {
        return OS_VERSION_NUMBER;
    }

    public static String getArchName() {
        return ARCH;
    }

    public static OSType getOSType() {
        return OS_TYPE;
    }

    public static CPUFamily getCPUFamily() {
        return CPU_ARCH.getFamily();
    }

    public static CPUType getCPUType() {
        return CPU_ARCH;
    }

    public static String getOSAndArch() {
        return os_and_arch;
    }

    public static String getOSAndArch(OSType oSType, CPUType cPUType) {
        String string;
        switch (CPU_ARCH) {
            case X86_32: {
                string = "i586";
                break;
            }
            case ARM: {
                string = "amdv7";
                break;
            }
            case ARMv5: {
                string = "amdv5";
                break;
            }
            case ARMv6: {
                string = "amdv5";
                break;
            }
            case ARMv7: {
                string = "amdv7";
                break;
            }
            case SPARC_32: {
                string = "sparc";
                break;
            }
            case PPC: {
                string = "ppc";
                break;
            }
            case X86_64: {
                string = "amd64";
                break;
            }
            case IA64: {
                string = "ia64";
                break;
            }
            case SPARCV9_64: {
                string = "sparcv9";
                break;
            }
            case PA_RISC2_0: {
                string = "risc2.0";
                break;
            }
            default: {
                throw new InternalError("Complete case block");
            }
        }
        switch (OS_TYPE) {
            case ANDROID: {
                string = "android-" + string;
                break;
            }
            case MACOS: {
                string = "macosx-universal";
                break;
            }
            case WINDOWS: {
                string = "windows-" + string;
                break;
            }
            case OPENKODE: {
                string = "openkode-" + string;
                break;
            }
            case LINUX: {
                string = "linux-" + string;
                break;
            }
            case FREEBSD: {
                string = "freebsd-" + string;
                break;
            }
            case SUNOS: {
                string = "solaris-" + string;
                break;
            }
            case HPUX: {
                string = "hpux-hppa";
                break;
            }
            default: {
                throw new InternalError("Complete case block");
            }
        }
        return string;
    }

    public static String getJavaVendor() {
        return JAVA_VENDOR;
    }

    public static String getJavaVMName() {
        return JAVA_VM_NAME;
    }

    public static String getJavaRuntimeName() {
        return JAVA_RUNTIME_NAME;
    }

    public static String getJavaVendorURL() {
        return JAVA_VENDOR_URL;
    }

    public static String getJavaVersion() {
        return JAVA_VERSION;
    }

    public static String getNewline() {
        return NEWLINE;
    }

    public static boolean is32Bit() {
        return is32Bit;
    }

    public static boolean is64Bit() {
        return !is32Bit;
    }

    public static MachineDescription getMachineDescription() {
        return machineDescription;
    }

    public static synchronized long getCurrentSleepJitter() {
        Platform.getCurrentSleepJitterImpl(TimeUnit.MILLISECONDS.toNanos(10L), 10);
        return Platform.getCurrentSleepJitterImpl(TimeUnit.MILLISECONDS.toNanos(10L), 10);
    }

    private static long getCurrentSleepJitterImpl(long l, int n) {
        long l2 = l / (long)n;
        long l3 = System.nanoTime();
        for (int i = n; i > 0; --i) {
            try {
                TimeUnit.NANOSECONDS.sleep(l2);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return (System.nanoTime() - l3 - l) / (long)n;
    }

    static {
        OS = System.getProperty("os.name");
        OS_lower = OS.toLowerCase();
        OS_VERSION = System.getProperty("os.version");
        OS_VERSION_NUMBER = new VersionNumber(OS_VERSION, ".");
        ARCH = System.getProperty("os.arch");
        ARCH_lower = ARCH.toLowerCase();
        JAVA_VENDOR = System.getProperty("java.vendor");
        JAVA_VENDOR_URL = System.getProperty("java.vendor.url");
        JAVA_VERSION = System.getProperty("java.version");
        NEWLINE = System.getProperty("line.separator");
        JAVA_VM_NAME = System.getProperty("java.vm.name");
        JAVA_RUNTIME_NAME = Platform.getJavaRuntimeNameImpl();
        JAVA_SE = Platform.initIsJavaSE();
        LITTLE_ENDIAN = Platform.queryIsLittleEndianImpl();
        if (ARCH_lower.equals("x86") || ARCH_lower.equals("i386") || ARCH_lower.equals("i486") || ARCH_lower.equals("i586") || ARCH_lower.equals("i686")) {
            CPU_ARCH = CPUType.X86_32;
        } else if (ARCH_lower.equals("x86_64") || ARCH_lower.equals("amd64")) {
            CPU_ARCH = CPUType.X86_64;
        } else if (ARCH_lower.equals("ia64")) {
            CPU_ARCH = CPUType.IA64;
        } else if (ARCH_lower.equals("arm")) {
            CPU_ARCH = CPUType.ARM;
        } else if (ARCH_lower.equals("armv5l")) {
            CPU_ARCH = CPUType.ARMv5;
        } else if (ARCH_lower.equals("armv6l")) {
            CPU_ARCH = CPUType.ARMv6;
        } else if (ARCH_lower.equals("armv7l")) {
            CPU_ARCH = CPUType.ARMv7;
        } else if (ARCH_lower.equals("sparc")) {
            CPU_ARCH = CPUType.SPARC_32;
        } else if (ARCH_lower.equals("sparcv9")) {
            CPU_ARCH = CPUType.SPARCV9_64;
        } else if (ARCH_lower.equals("pa_risc2.0")) {
            CPU_ARCH = CPUType.PA_RISC2_0;
        } else if (ARCH_lower.equals("ppc")) {
            CPU_ARCH = CPUType.PPC;
        } else {
            throw new RuntimeException("Please port CPU detection to your platform (" + OS_lower + "/" + ARCH_lower + ")");
        }
        OS_TYPE = Platform.getOSTypeImpl();
        os_and_arch = Platform.getOSAndArch(OS_TYPE, CPU_ARCH);
        USE_TEMP_JAR_CACHE = OS_TYPE != OSType.ANDROID && AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                return Debug.getBooleanProperty(true, Platform.useTempJarCachePropName, true, AccessController.getContext());
            }
        }) != false;
        Platform.loadGlueGenRTImpl();
        JVMUtil.initSingleton();
        MachineDescription machineDescription = MachineDescriptionRuntime.getRuntime();
        if (null == machineDescription) {
            MachineDescription.StaticConfig staticConfig = MachineDescriptionRuntime.getStatic();
            machineDescription = staticConfig.md;
            System.err.println("Warning: Using static MachineDescription: " + (Object)((Object)staticConfig));
        } else {
            MachineDescription.StaticConfig staticConfig = MachineDescriptionRuntime.getStatic();
            if (!machineDescription.compatible(staticConfig.md)) {
                throw new RuntimeException("Incompatible MachineDescriptions:" + NEWLINE + " Static " + (Object)((Object)staticConfig) + NEWLINE + " Runtime " + machineDescription);
            }
        }
        Platform.machineDescription = machineDescription;
        is32Bit = Platform.machineDescription.is32Bit();
    }

    public static enum CPUType {
        X86_32(CPUFamily.X86, 1),
        X86_64(CPUFamily.X86, 2),
        ARM(CPUFamily.ARM, 0),
        ARMv5(CPUFamily.ARM, 1),
        ARMv6(CPUFamily.ARM, 2),
        ARMv7(CPUFamily.ARM, 4),
        PPC(CPUFamily.PPC, 0),
        SPARC_32(CPUFamily.SPARC, 1),
        SPARCV9_64(CPUFamily.SPARC, 2),
        IA64(CPUFamily.IA64, 0),
        PA_RISC2_0(CPUFamily.PA_RISC, 1);

        public final int id;
        public final CPUFamily family;

        private CPUType(CPUFamily cPUFamily, int n2) {
            this.family = cPUFamily;
            this.id = n2;
        }

        public CPUFamily getFamily() {
            return this.family;
        }
    }

    public static enum CPUFamily {
        X86(0),
        ARM(65536),
        PPC(131072),
        SPARC(196608),
        PA_RISC(-65536),
        IA64(-61440);

        public final int id;

        private CPUFamily(int n2) {
            this.id = n2;
        }
    }

    public static enum OSType {
        LINUX(0),
        FREEBSD(1),
        ANDROID(2),
        MACOS(3),
        SUNOS(4),
        HPUX(5),
        WINDOWS(6),
        OPENKODE(7);

        public final int id;

        private OSType(int n2) {
            this.id = n2;
        }
    }
}

