/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.common.os;

import com.jogamp.common.os.DynamicLinker;
import com.jogamp.common.os.DynamicLookupHelper;
import com.jogamp.common.os.Platform;
import com.jogamp.common.util.IOUtil;
import java.io.File;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import jogamp.common.Debug;
import jogamp.common.os.MacOSXDynamicLinkerImpl;
import jogamp.common.os.UnixDynamicLinkerImpl;
import jogamp.common.os.WindowsDynamicLinkerImpl;

public class NativeLibrary
implements DynamicLookupHelper {
    protected static final boolean DEBUG = Debug.debug("NativeLibrary");
    protected static final boolean DEBUG_LOOKUP = Debug.debug("NativeLibrary.Lookup");
    private static DynamicLinker dynLink;
    private static String[] prefixes;
    private static String[] suffixes;
    private long libraryHandle;
    private String libraryPath;
    private boolean global;
    private static boolean initializedFindLibraryMethod;
    private static Method findLibraryMethod;

    private NativeLibrary(long l, String string, boolean bl) {
        this.libraryHandle = l;
        this.libraryPath = string;
        this.global = bl;
        if (DEBUG) {
            System.err.println("NativeLibrary.open(): Successfully loaded: " + this);
        }
    }

    public String toString() {
        return "NativeLibrary[" + this.libraryPath + ", 0x" + Long.toHexString(this.libraryHandle) + ", global " + this.global + "]";
    }

    public static NativeLibrary open(String string, ClassLoader classLoader) {
        return NativeLibrary.open(string, string, string, true, classLoader, true);
    }

    public static NativeLibrary open(String string, ClassLoader classLoader, boolean bl) {
        return NativeLibrary.open(string, string, string, true, classLoader, bl);
    }

    public static NativeLibrary open(String string, String string2, String string3, boolean bl, ClassLoader classLoader) {
        return NativeLibrary.open(string, string2, string3, bl, classLoader, true);
    }

    public static NativeLibrary open(String string, String string2, String string3, boolean bl, ClassLoader classLoader, boolean bl2) {
        List<String> list = NativeLibrary.enumerateLibraryPaths(string, string2, string3, bl, classLoader);
        for (String string4 : list) {
            if (DEBUG) {
                System.err.println("NativeLibrary.open(): Trying to load " + string4);
            }
            Platform.initSingleton();
            long l = bl2 ? dynLink.openLibraryGlobal(string4, DEBUG) : dynLink.openLibraryLocal(string4, DEBUG);
            if (l == 0L) continue;
            return new NativeLibrary(l, string4, bl2);
        }
        if (DEBUG) {
            System.err.println("NativeLibrary.open(): Did not succeed in loading (" + string + ", " + string2 + ", " + string3 + ")");
        }
        return null;
    }

    @Override
    public long dynamicLookupFunction(String string) {
        if (this.libraryHandle == 0L) {
            throw new RuntimeException("Library is not open");
        }
        return dynLink.lookupSymbol(this.libraryHandle, string);
    }

    public static long dynamicLookupFunctionGlobal(String string) {
        return dynLink.lookupSymbolGlobal(string);
    }

    public long getLibraryHandle() {
        return this.libraryHandle;
    }

    public String getLibraryPath() {
        return this.libraryPath;
    }

    public void close() {
        if (DEBUG) {
            System.err.println("NativeLibrary.close(): closing " + this);
        }
        if (this.libraryHandle == 0L) {
            throw new RuntimeException("Library already closed");
        }
        long l = this.libraryHandle;
        this.libraryHandle = 0L;
        dynLink.closeLibrary(l);
        if (DEBUG) {
            System.err.println("NativeLibrary.close(): Successfully closed " + this);
            Thread.dumpStack();
        }
    }

    public static String isValidNativeLibraryName(String string, boolean bl) {
        string = IOUtil.getBasename(string);
        String string2 = bl ? string : string.toLowerCase();
        for (int i = 0; i < prefixes.length; ++i) {
            if (!string2.startsWith(prefixes[i])) continue;
            for (int j = 0; j < suffixes.length; ++j) {
                if (!string2.endsWith(suffixes[j])) continue;
                int n = prefixes[i].length();
                int n2 = suffixes[j].length();
                return string.substring(n, string.length() - n2);
            }
        }
        return null;
    }

    private static List<String> enumerateLibraryPaths(String string, String string2, String string3, boolean bl, ClassLoader classLoader) {
        Object object;
        String string4;
        ArrayList<String> arrayList = new ArrayList<String>();
        String string5 = NativeLibrary.selectName(string, string2, string3);
        if (string5 == null) {
            return arrayList;
        }
        File file = new File(string5);
        if (file.isAbsolute()) {
            arrayList.add(string5);
            return arrayList;
        }
        String[] stringArray = NativeLibrary.buildNames(string5);
        if (bl) {
            for (int i = 0; i < stringArray.length; ++i) {
                arrayList.add(stringArray[i]);
            }
        }
        String string6 = NativeLibrary.getPathFromClassLoader(string5, classLoader);
        if (DEBUG) {
            System.err.println("NativeLibrary Class loader path to " + string5 + ": " + string6);
        }
        if (string6 != null) {
            arrayList.add(string6);
        }
        if ((string4 = AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty("java.library.path");
            }
        })) != null) {
            object = new StringTokenizer(string4, File.pathSeparator);
            while (((StringTokenizer)object).hasMoreTokens()) {
                NativeLibrary.addPaths(((StringTokenizer)object).nextToken(), stringArray, arrayList);
            }
        }
        object = AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty("user.dir");
            }
        });
        NativeLibrary.addPaths((String)object, stringArray, arrayList);
        if (!bl) {
            for (int i = 0; i < stringArray.length; ++i) {
                arrayList.add(stringArray[i]);
            }
        }
        if (Platform.OS_TYPE == Platform.OSType.MACOS) {
            NativeLibrary.addPaths("/Library/Frameworks/" + string5 + ".Framework", stringArray, arrayList);
            NativeLibrary.addPaths("/System/Library/Frameworks/" + string5 + ".Framework", stringArray, arrayList);
        }
        return arrayList;
    }

    private static String selectName(String string, String string2, String string3) {
        switch (Platform.OS_TYPE) {
            case WINDOWS: {
                return string;
            }
            case MACOS: {
                return string3;
            }
        }
        return string2;
    }

    private static String[] buildNames(String string) {
        int n;
        int n2;
        int n3;
        if (string.startsWith(prefixes[0])) {
            if (string.endsWith(suffixes[0])) {
                return new String[]{string};
            }
            int n4 = string.indexOf(suffixes[0]);
            n3 = 1;
            if (n4 >= 0) {
                for (n2 = n4 + suffixes[0].length(); n2 < string.length(); ++n2) {
                    n = string.charAt(n2);
                    if (n == 46 || n >= 48 && n <= 57) continue;
                    n3 = 0;
                    break;
                }
                if (n3 != 0) {
                    return new String[]{string};
                }
            }
        }
        String[] stringArray = new String[prefixes.length * suffixes.length + (Platform.OS_TYPE == Platform.OSType.MACOS ? 1 : 0)];
        n3 = 0;
        for (n2 = 0; n2 < prefixes.length; ++n2) {
            for (n = 0; n < suffixes.length; ++n) {
                stringArray[n3++] = prefixes[n2] + string + suffixes[n];
            }
        }
        if (Platform.OS_TYPE == Platform.OSType.MACOS) {
            stringArray[n3++] = string;
        }
        return stringArray;
    }

    private static void addPaths(String string, String[] stringArray, List<String> list) {
        for (int i = 0; i < stringArray.length; ++i) {
            list.add(string + File.separator + stringArray[i]);
        }
    }

    private static String getPathFromClassLoader(final String string, final ClassLoader classLoader) {
        block5: {
            if (classLoader == null) {
                return null;
            }
            if (!initializedFindLibraryMethod) {
                AccessController.doPrivileged(new PrivilegedAction<Object>(){

                    @Override
                    public Object run() {
                        try {
                            findLibraryMethod = ClassLoader.class.getDeclaredMethod("findLibrary", String.class);
                            findLibraryMethod.setAccessible(true);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        initializedFindLibraryMethod = true;
                        return null;
                    }
                });
            }
            if (findLibraryMethod != null) {
                try {
                    return AccessController.doPrivileged(new PrivilegedAction<String>(){

                        @Override
                        public String run() {
                            try {
                                return (String)findLibraryMethod.invoke((Object)classLoader, string);
                            }
                            catch (Exception exception) {
                                throw new RuntimeException(exception);
                            }
                        }
                    });
                }
                catch (Exception exception) {
                    if (!DEBUG) break block5;
                    exception.printStackTrace();
                }
            }
        }
        return null;
    }

    static {
        switch (Platform.OS_TYPE) {
            case WINDOWS: {
                dynLink = new WindowsDynamicLinkerImpl();
                prefixes = new String[]{""};
                suffixes = new String[]{".dll"};
                break;
            }
            case MACOS: {
                dynLink = new MacOSXDynamicLinkerImpl();
                prefixes = new String[]{"lib"};
                suffixes = new String[]{".dylib", ".jnilib"};
                break;
            }
            default: {
                dynLink = new UnixDynamicLinkerImpl();
                prefixes = new String[]{"lib"};
                suffixes = new String[]{".so"};
            }
        }
        initializedFindLibraryMethod = false;
        findLibraryMethod = null;
    }
}

