/**
 * Handler de menu utilis par les TimingWindow et EscapeWindow
 *
 * Il gre l'affichage et les actions utilisateur, mais pas le positionnement
 * des lments de menu, ni leur arrive  l'cran.
 *  - les flches haut et bas dplacent la slection
 *  - espace et entre valident la slection
 *  - escape slectionne et valide une option dfinie par l'cran utilisateur
 *
 * Il est destin  tre encapsul dans un cran qui grera ces lments.
 */

 /**
  * Cration du gestionnaire du menu, hors la partie graphique
  *  - container : l'objet DIV qui contiendra les lments DHTML crs
  *  - fader : le fader sur le container (tat In, i.e. affichage normal, en entre)
  *  - imageFx : l'outil pour effectuer les oprations graphiques (texte dtour)
  *  - count : le nombre d'entres dans le menu
  * 
  */
 function MenuDriver(container, fader, imageFx, count)
 {
	this.container = container;
	this.fader = fader;
	this.imageFx = imageFx;

	this.optionCount = count;
	
	this.menuControls = new Array(count);
	this.optionAvailable = new Array(count);

 }
 
 
  MenuDriver.prototype = {
  
  
    /**
	 * Initialization / remise  zro des paramtres 
	 *  - premier lment de menu slectionn
	 */
	initialize : function() {
		this.selectedOption = 0;
		this.userAcknowledged = false;
		this.escapeOption = 2;
		
		for (var i=0; i<this.optionCount; ++i)
		{
			this.menuControls[i] = this.imageFx.createOutlinedTextPanel(this.container, "timing_user_controls", "loader_text", "white");
			this.optionAvailable[i] = true;
		}
	},
	
	/**
	 * Renvoie le n-ieme contrle de menu (pour action sur son style par exemple)
	 */
	getControl : function(index) {
		return this.menuControls[index];
	},
	
	/**
	 * Renvoie l'index de l'option slectionne
	 */
	getSelectedOption : function() {
		return this.selectedOption;
	},
	
	/**
	 * Dfinit si une option est accessible ou non
	 */
	setOptionAvailable : function(index, avail) {
		this.optionAvailable[index] = avail;
		this.menuControls[index].style.display = (avail ? "block" : "none");
	},
	
	/**
	 * Dfinit le texte d'une option de menu
	 */
	setOptionText : function(index, text) {
		this.imageFx.outlinedWrite(this.menuControls[index], text);
	},
	
	/**
	 * Dfinit l'option slectionne (ou par dfaut, si appel avant la premire utilisation
	 */
	setSelectedOption : function(index) {
		this.selectedOption = index;
	},
	
	/**
	 * Dfinit l'option correspondant  la touche ESCAPE
	 */
	setEscapeOption : function(index) {
		this.escapeOption = index;
	},
	
	/**
	 *	Ferme et dtruit les lments DHTML de la fentre
	 */
	terminate : function() {
		for (var i=0; i<this.optionCount; ++i)
		{
			this.container.removeChild(this.menuControls[i]);
			this.menuControls[i] = 0;
		}
	},

	/**
	 *  Affiche le texte des menus et en anime la couleur
	 */
	repaint : function(timer) {
		var glitter = Math.cos(0.05*timer);
		var red = Math.round(255+(glitter<0 ? 80*glitter : 0));
		var green = Math.round(255+(glitter>0 ? 80*glitter : 0));
		var blue = Math.round(255+(glitter>0 ? 80*glitter : 0));
		var highlightColor = "rgb("+red+", "+green+", "+blue+")";
		if ((timer%3)==0 && ((Math.floor(timer/50)&1)==0) && !this.userAcknowledged) {
			highlightColor = "#FF8080";
		}
		var blurredColor = "#A0A0A0";
		for (var i=0; i<this.optionCount; ++i)
		{
			this.imageFx.setHighlightColor(this.menuControls[i], (this.selectedOption==i ? highlightColor : blurredColor));
		}	
	 },
	
	/**
	 * Handler des vnements onkeydown (touche clavier presse)
	 * Choix de l'option du menu s'il s'agit d'une flche verticale, en ignorant les options non disponibles.
	 * Renvoie true si l'vnement doit continuer  tre propag (i.e. non trait ici), false sinon
	 */
	onKeyDown : function(event) {
		var handled = this.keyControl(event, true);
		if (this.upKeyPressed && !this.downKeyPressed) {
			var delta = 1;
			var deltaFound = 0;
			while (this.selectedOption-delta>=0 && deltaFound==0) {
				if (this.optionAvailable[this.selectedOption-delta]) {
					deltaFound = delta;
				}
				++delta;
			}
			this.selectedOption -= deltaFound;
		}
		if (!this.upKeyPressed && this.downKeyPressed) {
			var delta = 1;
			var deltaFound = 0;
			while (this.selectedOption+delta<this.optionCount && deltaFound==0) {
				if (this.optionAvailable[this.selectedOption+delta]) {
					deltaFound = delta;
				}
				++delta;
			}
			this.selectedOption += deltaFound;
		}
		return !handled;
	},
	
	/**
	 * Handler des vnements onkeyup (touche clavier relche)
	 */
	onKeyUp : function(event) {
		this.keyControl(event, false);
	},
	
	/**
	 * Handler dlgu pour les vnements clavier.
	 * Enregistre les appuis et les relchements des flches
	 * et de la touche Escape.
	 * Renvoie true si l'vnement est gr, false sinon
	 */
	keyControl : function(event, value)
	{
		var handled = true;
		var key = 0;
		if (window.event) { // IE
			key = window.event.keyCode;
		} else { // FF, Opera,...
			key = event.which;
		}

		switch (key) {
			case 38 : // fleche haut
				this.upKeyPressed = value;
				break;
			case 40 : // fleche bas
				this.downKeyPressed = value;
				break;
			case 27 : // escape
				this.selectedOption = this.escapeOption;
				this.userAcknowledged |= value;
				break;
			case 13 : // entre
			case 32 : // espace
				this.userAcknowledged |= value;
				break;
			default :
				handled = false;
		}
		return handled;
	}	
	
}
	