function IntroViewer(container, application)
{
	this.container = container;
	this.application = application;
	this.frameDelay = 40;
	this.timer = 0;
	this.imageLocation = "";
	this.imageCount = 0;
	this.callback=false;
	
	this.imageA = document.createElement('img');
	this.imageA.setAttribute("class", "intro_text");
	this.imageA.style.display="none";
	this.container.appendChild(this.imageA);
	this.imageB = document.createElement('img');
	this.imageB.setAttribute("class", "intro_text");
	this.imageB.style.display="none";
	this.container.appendChild(this.imageB);
	this.imageC = document.createElement('img');
	this.imageC.setAttribute("class", "intro_text");
	this.imageC.style.display="none";
	this.container.appendChild(this.imageC);
}

 IntroViewer.prototype = {
 
 
	launch : function(location, count,callback) {
		this.imageLocation=location;
		this.imageCount=count;
		this.callback = callback;
		this.mainLoop();
	},
	
	mainLoop : function() {
		if ((this.timer%this.frameDelay)==0) {
			var filename = this.imageLocation+(1+this.timer/this.frameDelay)+".svg";
			this.imageA.style.display="none";
			this.imageB.style.display="none";
			this.imageC.style.display="none";
			this.imageA.setAttribute("src", filename);
			this.imageB.setAttribute("src", filename);
			this.imageC.setAttribute("src", filename);
		}
		var step = this.timer%this.frameDelay;
		this.imageA.style.opacity = 1-step/this.frameDelay;
		this.imageB.style.opacity = 1-step/this.frameDelay;
		this.imageC.style.opacity = 1-step/this.frameDelay;
		
		var w = Math.round(480*(1+0.3*step/this.frameDelay));
		var h = Math.round(240*(1+0.3*step/this.frameDelay));
		this.imageA.style.width=w+"px";
		this.imageB.style.width=w+"px";
		this.imageC.style.width=w+"px";
		this.imageA.style.height=h+"px";
		this.imageB.style.height=h+"px";
		this.imageC.style.height=h+"px";
		this.imageA.style.left=Math.round(.5*(480-w))+"px";
		this.imageB.style.left=Math.round(.5*(480-w))+"px";
		this.imageC.style.left=Math.round(.5*(480-w))+"px";
		this.imageA.style.top=Math.round(.5*(240-h))+"px";
		this.imageB.style.top=Math.round(.5*(240-h))+"px";
		this.imageC.style.top=Math.round(.5*(240-h))+"px";
			this.imageA.style.display="block";
			this.imageB.style.display="block";
			this.imageC.style.display="block";
		
		++this.timer;
		if (this.timer<= (this.imageCount-1)*this.frameDelay) {
			setTimeout("introMainLoop()", 40);
		} else {
			this.finish();
		}
		
	},
	
	finish : function() {
		this.imageA.style.display="none";
		this.imageB.style.display="none";
		this.imageC.style.display="none";
		if (this.callback) {
			this.application.afterIntro();
		}
	}
	
}
	
	
function introMainLoop()
{
	lotus.intro.mainLoop();
}	