/**
 * La classe Fader ralise un effet de transition, avec passage d'un rideau opaque
 * en premier plan, ce qui permet de modifier le contenu de l'cran
 * "derrire" le rideau et voir le nouveau contenu apparatre au lever du rideau
 */
 
 function Fader(container, width, height)
 {
	this.container = container;
	this.width = width;
	this.height = height;
	
	this.checkerBoxSize = 40;
	this.checkerBoxMarksX = 2+width/this.checkerBoxSize;
	this.checkerBoxMarksY = 2+height/this.checkerBoxSize;
	this.checkerBoxCount = this.checkerBoxMarksX*this.checkerBoxMarksY/2;
	
	this.rightCurtain = document.createElement('div');
	this.rightCurtain.setAttribute("class","fader_curtain");
	this.rightCurtain.style.top="0px";
	container.appendChild(this.rightCurtain);
	this.leftCurtain = document.createElement('div');
	this.leftCurtain.setAttribute("class","fader_curtain");
	this.leftCurtain.style.top="1px";
	container.appendChild(this.leftCurtain);

	this.checkerBoardContainer = document.createElement('div');
	this.checkerBoardContainer.setAttribute("class","fader_checkerboard");
	this.checkerBoard = new Array(this.checkerBoxCount);
	for (var i=0;i<this.checkerBoxCount;++i) {
		this.checkerBoard[i]=document.createElement('div');
		this.checkerBoardContainer.appendChild(this.checkerBoard[i]);
	}
	container.appendChild(this.checkerBoardContainer);
	
	this.fading = false;
	this.faded = false;
	this.time = 0;
	this.maxTime = 20;
	this.step = this.width / this.maxTime;
 }
 
 Fader.prototype = {
 
	drawInterleaveDawn : function(time) {
		var curtainWidth = Math.round(time*this.step);
		this.rightCurtain.style.left = "0px";
		this.rightCurtain.style.width = (this.width-curtainWidth)+"px";
		this.leftCurtain.style.left = curtainWidth+"px";
		this.leftCurtain.style.width = (this.width-curtainWidth)+"px";
	},
	
 	drawInterleaveDusk : function(time) {
		var curtainWidth = Math.round(time*this.step);
		this.rightCurtain.style.left = (this.width-curtainWidth)+"px";
		this.rightCurtain.style.width = curtainWidth+"px";
		this.leftCurtain.style.left = "0px";
		this.leftCurtain.style.width = curtainWidth+"px";
	},
 
	drawCheckerboardDawn : function(time) {
		var index=0;
		for (var y=-1;y<this.checkerBoxMarksY-1;++y) for (x=-1; x<this.checkerBoxMarksX-1;++x) {
			if ((x+y)&1) {
				var size=2*this.checkerBoxSize*time/this.maxTime;
				var left=Math.max(0,this.checkerBoxSize*x+(this.checkerBoxSize-size)/2);
				var right=Math.min(this.width,this.checkerBoxSize*x+(this.checkerBoxSize+size)/2);
				var top=Math.max(0,this.checkerBoxSize*y+(this.checkerBoxSize-size)/2);
				var bottom=Math.min(this.height,this.checkerBoxSize*y+(this.checkerBoxSize+size)/2);
				this.checkerBoard[index].style.left=left+"px";
				this.checkerBoard[index].style.top=top+"px";
				this.checkerBoard[index].style.width=(right-left)+"px";
				this.checkerBoard[index++].style.height=(bottom-top)+"px";
			}
		}
	},

	drawCheckerboardDusk : function(time) {
		var index=0;
		for (var y=-1;y<this.checkerBoxMarksY-1;++y) for (x=-1; x<this.checkerBoxMarksX-1;++x) {
			if ((x+y)&1) {
				var size=2*this.checkerBoxSize*(1-time/this.maxTime);
				var left=Math.max(0,this.checkerBoxSize*x+(this.checkerBoxSize-size)/2);
				var right=Math.min(this.width,this.checkerBoxSize*x+(this.checkerBoxSize+size)/2);
				var top=Math.max(0,this.checkerBoxSize*y+(this.checkerBoxSize-size)/2);
				var bottom=Math.min(this.height,this.checkerBoxSize*y+(this.checkerBoxSize+size)/2);
				this.checkerBoard[index].style.left=left+"px";
				this.checkerBoard[index].style.top=top+"px";
				this.checkerBoard[index].style.width=(right-left)+"px";
				this.checkerBoard[index++].style.height=(bottom-top)+"px";
			}
		}
	},

	
	fadeOut : function() {
		if (!this.fading) {
			this.fading = true;
			this.time = 0;
		}
		++this.time;
		this.drawCheckerboardDawn(this.time);
		
		if (this.time < this.maxTime) {
			setTimeout("fadeOut(fader)", 20);
		} else {
			this.fading = false;
			this.faded = true;
		}
	},
	
	fadeIn : function() {
		if (!this.fading) {
			this.fading = true;
			this.time = 0;
		}
		++this.time;
		this.drawCheckerboardDusk(this.time);
		
		if (this.time < this.maxTime) {
			setTimeout("fadeIn(fader)", 20);
		} else {
			this.fading = false;
			this.faded = false;
		}
	}
 
}
 
function fadeOut(fader) {
	fader.fadeOut();
}

function fadeIn(fader) {
	fader.fadeIn();
}