;SID-WIZARD MAIN MENU
;====================
;------------------------------------------------------------------------------------------------------
.if COMPILEDAPP=1 ;coming part is only needed for editor

runmenup ;run selected menupoint (jumped here from main loop)
		lda menupoint
		asl ;multiply by 2 to get word-jumpaddress for menupoint
		tay
		lda menujmp,y
		sta mjumper+1
		lda menujmp+1,y
		sta mjumper+2
		lda #0
		sta menupoint 
		sta defawin+1 ;filename-typer is default subwindow in filer (but changeable with TAB)
		sta editauth ;init author-editing possibility (disable by default)
mjumper	jmp $1111 ;self-written

menujmp	.word dummymp,savetun,loadtun,saveins,loadins,seldriv,initunt,dummymp,iniinsc,bcktoe2 ;...
;-------------------------------------------------------------------------------------------------------
savetun	inc editauth ;switch on author-editing for saver
		jsr moduledial ;read directory, typing filename, return filename in 'namebuf', abort-signal is Carry-bit=1
		bcs retoedi ;if Carry=1 on exit, return to editor
		jsr packtun ;pack tune, end of compressed data (to save) is stored in 'compzptr'
		lda compzptr ;preserve end-pointer of packed data to get back tune by in-place depacking
		sta getback+1
		lda compzptr+1
		sta czptemp+1 
;save tune (check and ask about existing file)
		jsr iniwfn ;init workfile name pointer and length, bank, and device,file,channel
		lda #<TUNEHEADER ;Set Start Address
		ldx #>TUNEHEADER
		jsr inidptr ;set decozptr as startaddress (by A and X)
        ldx compzptr  ;Get compzptr as End Address
		ldy compzptr+1
		lda #<decozptr ;pointer of start-address
		jsr SAVE
		bcc getback ;if no error, back-depack tune
		jmp fexists ;if file exists, ask for confirmation to overwrite
getback	lda #0 ;self-written (restore packed tune's end-address to compzptr
czptemp	ldx #0 ;self-written (restore packed tune's end-address to compzptr
		jsr inicptr ;set compzptr
		jsr depackt ;depack tune - input needed: compzptr (end of packed tune) 
retoedi sei ;restart editor (abort file-dialog)
		inc clearmenu
		jsr dispmenu ;clear menu area
		ldy #0 
		sty $d011 ;cover GUI-drawing
		sty fspdctr+1 ;we must start with singleplayer after getting back to IRQ
		sty clearmenu
		sty menumode
		inc inirequ+1 ;perform re-displaying all GUI
		inc insrefr+1 ;perform instrument-table refresh too
		jmp started 

;----------------------------------
saveins ;save instrument menupoint - might be a good idea to sign version of instrument!
		lda #"I"
		jsr filedialog ;read directory, typing filename, return filename in 'namebuf'
		bcs retoedi ;if Carry=1 on exit, return to editor
;pack & save selected instrument (packer should check/handle different instrument-sizes between versions)
		lda #<dirvmem ;use screen as packer packed data destination (compzptr)
		ldx #>dirvmem 
		jsr inicptr ;init pointers
		jsr setidptr ;set starting source-address in decozptr, set bank, disable IRQ
		jsr packinst ;pack instrument for saving, set compzptr to end of data
		jsr iniwfn  ;init workfile name pointer and length, bank, and device,file,channel
		lda #<dirvmem ;packed data start-address (used screen as packed data storage (decozptr))
		ldx #>dirvmem
		jsr inidptr ;set decozptr as startaddress (by A and X)
        ldx compzptr  ;Get compzptr as End Address
		ldy compzptr+1
		lda #<decozptr ;pointer of start-address
		jsr SAVE
		bcc retoedi ;if no error, return to editor
fexists ldy #28 ;display 'file exists'  (and later ask for overwrite-confirmation)
-		lda filexists,y
		sta lowvidram+40*24,y
		dey
		bpl -
		jsr YesOrNo ;wait for Y/N and set Carry accordingly (1 if Y) 
		bcc retoedi ;if answered NO, return to editor
		jmp mjumper ;if yes, try other name (maybe better not to start all over again if mistake by user)
;------;(To retrieve and display the device status, one could code: OPEN 1,8,15:INPUT#1,E,E$,T,S:PRINT E,E$,T,S:CLOSE 1 )
;display error based on code in Accu (A = $05 (DEVICE NOT PRESENT) ; A = $04 (FILE NOT FOUND) ; A = $1D (LOAD ERROR ; A = $00 (BREAK, RUN/STOP has been pressed during loading))

;--------------------------------------
loadtun	;load tune (workfile) menupoint - should check if SWM module version matches
		inc defawin+1 ;file-selector is preferred default subwindow in filer (but changeable with TAB)
		jsr moduledial ;read directory, typing filename, return filename in 'namebuf'
		bcs retoedi ;if Carry=1 on exit, return to editor
;load tune (notify if unsuccessful) - fastloader may fit in memory (and could be selected with Shift+Return)
		jsr iniwfn  ;(secondary address inside = 0 ensures load-address forcing)
		jsr OPEN ;open file for checking version in its beginning
		jsr READST ;read drive status
		cmp #0 ;if status is 0, no error
		beq chSWVer ;check if file exists, if exists, go to check filetype/version
		jsr clsfile ;in case of error, close to allow further trials
		jmp fnotfnd
ChSWVer	jsr CheckSWM ;check filetype version of SWM module in 1st 4 bytes, if different version, refuse the tune and init SWM1 
		bcc SWverOK ;if carry is 0, no version mismatch, go to loader
		jsr clsfile ;in case of version-mismatch, close to allow further trials
		ldy #28 ;if carry was 1, filetype or version is not OK!
-		lda vermismatch,y
		sta lowvidram+40*24,y
		dey
		bpl -
		lda readver ;display selected file's version or 1st mismatching character
		sta lowvidram+40*24+14
		jmp wtspace
SWverOK	jsr clsfile ;quit testing, start fresh loading
		jsr iniwfn  ;(secondary address inside = 0 ensures load-address forcing)
		ldx #<TUNEHEADER ;set load-address
        ldy #>TUNEHEADER
        lda #$00      ; $00 means: load to memory (not verify)
        jsr LOAD      ; call LOAD, outputs last loaded address to X/Y in case of success
        bcc +         ; if carry set, a load error has happened
fnotfnd	ldy #28 ;Display 'file not found' message and wait for SPACE
-		lda fnotfound,y
		sta lowvidram+40*24,y
		dey
		bpl -
wtspace	lda #$7f ;check SPACE
		sta $dc00
-		lda $dc01
		cmp #$ff
		beq -
-		lda $dc01 ;wait to release SPACE
		cmp #$ff
		bne -
		jmp mjumper
+		stx compzptr  ;end of data is important info for depacker to start in-place backwards-decompression
		sty compzptr+1
		jsr depackt
retsubt	ldy #0
		sty selsubt+1 ;point to subtune 0
		iny
		sty selinst+1 ;poit to 1st instrument, chord and tempo
		sty selchor+1
		sty seltemp+1
		jmp retoedi

;---------------------------------
loadins ;load instrument menupoint  - might be a good idea to check version of instrument, if saved!
		inc defawin+1 ;file-selector is preferred default subwindow in filer (but changeable with TAB)
		lda #"I"
		jsr filedialog ;read directory, typing filename, return filename in 'namebuf'
		bcc +
		jmp retoedi ;if Carry=1 abort file-dialog, return to editor
;load and depack instrument to replace actual instrument (depacker should handle length between versions)
+		jsr iniwfn ;init workfile name pointer and length, bank, and device,file,channel
		ldx #<dirvmem ;use screen for packed data (compzptr)
		ldy #>dirvmem 
        lda #$00      ; $00 means: load to memory (not verify)
        jsr LOAD      ; call LOAD, outputs last loaded address to X/Y in case of success
        bcs fnotfnd ; if carry set, a load error has happened
        stx compzptr  ;end of data is important info for depacker to start in-place backwards-decompression
        sty compzptr+1
		jsr setidptr ;set decozptr to actual instrument, set bank, disable IRQ
		jsr depkins ;depack instrument to selected destination instrument
		jmp retoedi ;return to editor

;---------------------------------
seldriv	;select disk drive (8..11)
		ldy devicen+1
		iny
		cpy #11+1 ;max. device number
		bne +
		ldy #8 ;min. device-number
+		sty devicen+1
		jsr dispdev
		jmp mainloop
		
;----------------------------------------
initunt ;tune & tempotable init menupoint
		sei
		jsr RyouSur ;Ask 'are you sure', wait for Y/N and set Carry accordingly (1 if Y) 
		bcs +
		jmp backtoe
+		jsr CINITUN 
		jmp retsubt ;retoedi
		
CINITUN	ldy #0 ;clear and init tune
		sty TUNEHEADER+PTAMOUPOS ;init all patterns
		sty TUNEHEADER+TMPLENPOS ;init all tempo-programs
		sty TUNEHEADER+SEQAMOPOS ;init all sequences
		jsr depkptseq
		jsr depktempo
		;create a default subtune with pattern 1..3
		lda #<SEQUENCES
		ldx #>SEQUENCES
		jsr inidptr
		ldx #1 
-		ldy #0
		txa ;set pattern 1..3 te sequence 1..3
		sta (decozptr),y
		iny
		lda #$FE ;sequence-endsignal for sequence 1..3
		sta (decozptr),y
		lda #seqbound
		jsr incopt2
		cpx #3+1
		bne -
		ldy #1
		jmp isttemp ;init subtune 0 tempo
		
;-----------------------------------------
iniinsc ;instrument & chords init menupoint
		sei
		jsr RyouSur ;Ask 'are you sure', wait for Y/N and set Carry accordingly (1 if Y) 
		bcc backtoe
		jsr CININST
		jmp retoedi
		
CININST	lda #0
		sta TUNEHEADER+INSTAMPOS ;init all instruments
		sta TUNEHEADER+CHRDLEPOS ;init all chords
		jmp depkinsch ;init instruments and chords
		
;--------------------------------------------
backtoe	;'Back to editor' menupoint
		sei
bcktoe2	inc clearmenu
		jsr dispmenu
		jsr menuback
		cli
dummymp	jmp mainloop

;---------------------------------------------------------------------------------------------------------
menuback ;resume menuless state
		ldy #2
		jsr mutesolodisp
		ldy #1
		jsr mutesolodisp
		ldy #0 
		sty clearmenu
		sty menumode
		jsr mutesolodisp
		jsr ptndisp ;display selected patterns
		jsr stpdisp ;display step-highlighted bars for track 1..3
		rts

RyouSur ;Ask 'are you sure', wait for Y/N and set Carry accordingly (1 if Y) 
RyouXpos=menuxpos+1
RyouYpos=menuypos+(menuysize/2)-2
RyouCol=1
		ldy #16
-		lda #"*" ;DECOR
		sta vidram+40*(RyouYpos+0)+RyouXpos,y
		sta vidram+40*(RyouYpos+3)+RyouXpos,y
		lda #RyouCol
		sta $d800+40*(RyouYpos+0)+RyouXpos,y
		sta $d800+40*(RyouYpos+1)+RyouXpos,y
		sta $d800+40*(RyouYpos+2)+RyouXpos,y
		sta $d800+40*(RyouYpos+3)+RyouXpos,y
		lda RyouSurTx,y
		sta vidram+40*(RyouYpos+1)+RyouXpos,y
		lda RyouSurT2,y
		sta vidram+40*(RyouYpos+2)+RyouXpos,y
		dey
		bpl -
		jmp YesOrNo

;============================================================================
;draw main menu
;=========================================
menumemp = menuypos*40+menuxpos

dispmenu ;clear-flag is set by Accu (input parameter)
		lda #<menutxt
		ldx #>menutxt
		jsr inicptr ;init text-source poiters
		lda #<(vidram+menumemp)
		ldx #>(vidram+menumemp)
		jsr inidptr ;inint videoram-pointers
		sta menucol+1
		lda #>(COLRPOS+menumemp)
		sta menucol+2
		ldx #0 ;counts rows of menu
menudlo	ldy #menuxsize-1 ;column-counter for menu
-		lda clearmenu
		beq +
		lda #$bd ;clear menu
		sta (decozptr),y
		lda #fxcol ;set back normal colours under menu
		jmp menucol
+		lda (compzptr),y
putmchr	sta (decozptr),y
		lda #menubgcol
		cpx menucurpos 
		bne menucol ;if in display is cursor position, use cursor colour
		lda #menucurcol
menucol	sta $d800,y ;self-written code
		dey
		bpl -
		lda #40 ;increase videoram-pointer by 
		ldy #menuxsize ;increase textdata-pointer by 
		jsr incopt2 ;increase pointers and and inx
		lda menucol+1
		clc
		adc #40
		sta menucol+1
		bcc +
		inc menucol+2
+		cpx #menuysize ;number of rows for menu
		bne menudlo
		lda clearmenu
		bne +
		lda defptlen ;display default pattern-length
		jsr hexdis2
		sta ptlentx
		stx ptlentx+1
dispdev	ldy devicen+1
		lda hexchar,y
		sta drivetx ;display hexa device-number in menu
+		rts
		
menutxt .text "*******************"
		.text "*  - MAIN MENU -  *"
		.text "* --------------- *"
		.TEXT "*                 *"
		.text "*    SAVE TUNE    *"
		.TEXT "*    LOAD TUNE    *"
		.TEXT "* SAVE INSTRUMENT *"
		.TEXT "* LOAD INSTRUMENT *"
		.TEXT "* SELECT DRIVE: " 
drivetx	.byte "8"
		.TEXT " *"
		.TEXT "* INIT TUNE&TEMPO *"
		.TEXT "* DEF.PATT.LEN:"
ptlentx	.text "00 *"
		.TEXT "* INIT INST&CHORD *"
		.TEXT "*  BACK TO EDITOR *"
		.TEXT "*                 *" ;shift+RETURN/Space - turbo load/save option? (no real room for it)
		.TEXT "*-----------------*"
		.TEXT "*2011 HERMIT SOFT.*"
		.TEXT "*******************"

clearmenu .byte 0 ;flag - signs for main loop if menu to be deleted
menucurpos .byte firstcpos+0 ;cursorposition in menu
menupoint .byte 0 ;selected menupoint - for main loop - if 0, nothing done, otherwise jump depending on value

.FI ;end of part that's not included in SID-Maker

;-----------
YesOrNo ;wait for Y/N and set Carry accordingly (1 if Y)
		lda #$e7
		sta $dc00
-		lda $dc01
		cmp #$ff-2 ;Y key (or I key)?
		bne +
		sec
		rts
+		cmp #$ff-$80 ;N (or V) key?
		bne - ;key-testing loop
		clc
-		cmp $dc01 ;wait to release key 
		beq -
		rts
;----------
CheckSWM ;check filetype version of SWM module in 1st 4 bytes, if different version, refuse the tune and init SWM1 
		;setting FILE-descriptor (SETLFS in 'iniwfn') and OPEN must have happened before 
		ldx #$01                ;   file #1
		jsr CHKIN               ; - call chkin to set input file #.
		jsr CHRIN ;skip load-address lo-byte
		jsr CHRIN ;skip load-address hi-byte
		ldx #0 
-		jsr CHRIN
		cmp filetyp,x ;compare opened filetype and version to actual tracker's version
		beq + ;if character matches
		sta readver ;the mismatching character/version-number of the file
		sec ;if there was character-mismatch in filetype/version field
		rts
+		inx
		cpx #4 ;summed length of filetype-string and version-character
		bne -
		clc ;all characters matched in filetype/version field
retchkv	rts ;Carry bit is set to 1 if there's a mismatch
		
;=======================================DISK OPERATIONS========================================================
filetx1	.text "FILENAME:             "
		.byte $75 ;the ruler between filename and extension display
		.text "(FILETYPE:*" ;....
swftype .text ".SWM)" ;SW-file type - string to search extension in filenames to filter on tune/instrument
		.byte SWversion ;show actual module-version in file-dialog
readver	.byte SWversion ;the read version-number of selected tune (for loading) - preset to actual version
filetx2	.text "DISK: .....................   FREE:...KB"
dirname .byte $24 ;.asc "$" ;$ is the name of disk-directory

;scratch .text "S0:" ;Scratch-signal (OPEN 15,8,15,"S0:file name":CLOSE 15) - will preceed filename when user want to overwrite a file (Save&Replace "@filename" is buggy in old 1541 drives) 
  namebuf .fill 16 ;filename-buffer (for extension-checking and for disk-operations)
		.fill 10 ;for safety reasons, if filename gets appended by commands
.if COMPILEDAPP=2 ;if SID-Maker is compiled
   SEQwriTxt .null ",S,W" ;the appended modifiers after the filename for SEQ-type outputs
   PRGwriTxt .null ",P,W" ;the appended modifiers after the filename for PRG-type outputs
.fi

sizebuf .fill 4 ;(byte 0 and 1) filesize-temp-storage, after reading dir., free blocks (last 2 bytes (row-pointers) not needed)
colutab	.byte maxnamelen+2,maxnamelen+1,maxnamelen+1 ;column-tabbing values (to get screenwidth as sum) (14+13+13=40)
filecnt .byte 0 ;amount of displayed files in directory
dirready .byte 0 ;value is 1 if directory is fully read
editauth .byte 0 ;0 - no author info display $ edition, 1 - autor info displayed & editable
filerwindow .byte 0 ;window in file-menu: 0-filename-typer , 1-authorinfo-typer, 2-file-selector
fkeybout .byte 0 ;keyboard-routine output of filer's keyboard handler - used by main loop to take some actions

;error messages in filer window, 29 character long each
nodevicep .text " NO DISK OR DRIVE PRESENT!!! "
fnotfound .text " FILE NOT FOUND! PRESS SPACE."
filexists .text " NAME EXISTS! TRY OTHER? Y/N "
vermismatch .text " WRONG VERSION0! PRESS SPACE."
saveerror .text " SAVING ERROR 0! PRESS SPACE. "
RyouSurTx .text "* ARE YOU SURE? *"
RyouSurT2 .text "*  (Y/N) (I/N)  *"

.IF COMPILEDAPP=1
moduledial ;start file-dialog for .SWM module (Accu preset for filedialog)
		lda #"M" ;for modules
filedialog ;input:Accu - extension read directory, typing filename, return filename in 'namebuf'	
		sta swftype+3 ;set .SWM (SID-Wizard module) or .SWI (instrument) extension
.FI		

reredir	sei ;init ROM $ VICbank and read disk directory to the screen
		lda #0
		sta $d418 ;mute for now
		lda #$36 ;enable KERNAL ROM (only)
		sta banksel
		lda #3
		sta $dd00
		jsr SCINIT
		ldy #39 ;draw UI base
-		lda filetx1,y
		sta lowvidram+0,y    ;filename and type (extension)
		lda #$62+$80  ;$78  ;$71 ;$68 
		sta lowvidram+40,y   ;separator line 1
		sta lowvidram+40*3,y ;separator line 2
		sta lowvidram+40*23,y ;separator line 3
.IF COMPILEDAPP=1
		lda swftype+3 ;extension 3rd letter
		cmp #"I" ;instrument?
		beq + ;don't display author info in instrument (might display instrument-name instead)
.FI		
		lda authorinfo,y
.IF COMPILEDAPP=2 ;if SID-Maker is being compiled
		ldx outputformat
		cpx #$ff ;if starting importer, display import-text
		bne skipaut 
		lda importxt,y
.FI
skipaut	sta authorip,y ;author info and title
+		lda filetx2,y
		sta lowvidram+40*24,y ;diskname and free space
		dey
		bpl -
		lda #$17 ;small character set
		sta $d018
		lda #0
		sta $d020
		
readdir	lda #$01                ;   filename-length is 1        
		ldx #<dirname           ;   lo byte pointer to file name. ("$")
		ldy #>dirname           ;   hi byte pointer to file name. ("$")
		jsr inifnam ;init filename memory position and length
		jsr OPEN                ; - call open
		bcc + ;if no error (device is present), just go forward
		jsr nodevic ;if error opening device, notify user
		jmp typesel ;and skip filelist-making, still give a chance to return to e.g. editor and change drive-number
+		ldx #$01                ;   file #1
		jsr CHKIN               ; - call chkin to set input file #.
;read and display disk-header
		ldx #7
-		jsr CHRIN ;read through some unneeded characters (amount given in X)
		dex
		bne -
		ldx #0    ;read diskname & ID
		stx dirready ;signs if directory fully read
-		jsr CHRIN
		beq listfil
		ora #$80
		cpx #24 ;don't allow too long diskheader to be displayed (crop beginning to max. length)
		bpl +
		sta disknam,x           ;standard 'jsr CHROUT' is not good for special display modes
+		inx
		bne -
;parse and display directory for filesizes and names
listfil jsr clrfsel	;clear file-selector area, init file-listing variables
flistlo	ldx #3 ;file-lister loop
-		jsr CHRIN ;get filesize (last one will be filesize in blocks)
		sta sizebuf,x ;sizebuf might be displayed or filesizes stored in a filesize-list to help user calculate
		dex
		bpl -
-		jsr CHRIN  ;check for beginning of filename (1st " delimiter)
		cmp #RETURNcode ;return/enter signal - check for end of dir/filelist
		beq closdir ;if end of filelist, close device
		cmp #namesep
		bne -    ;search for left " filename-delimiter
		ldy #0 ;start checking&copying filename
-		jsr CHRIN
		cmp #RETURNcode ;return/enter signal - check for end of dir/filelist
		beq closdir ;if end of filelist, close device
		cmp #namesep  ;check for filename end (right " filename-delimiter)
		beq frowend ;find $00 row-delimiter
		sta namebuf,y ;loads actual filename to buffer
		iny
		cpy #17 ;maximum allowed filename-length for C64 devices
		bne -
frowend	jsr CHRIN ;check for $00 - end of line of filename, then comes beginning of next line pointer and filesize/freeblocks info
		bne frowend
chekext	lda filecnt
		cmp #filelstmax ;check displayable filelist max. length
		bcs typesel ;if reached all displayable content, go to type/select name or read next dir. page
		;or bcs flistlo ;if reached, no further displaying, just checking rows for filesizes, etc.
		dey ;check name for .SWM/.SWI extension
		ldx #extlen-1 ;check 4 character long (with dot) filename-extension to filter on filetypes (.SWM/.SWI)
-		lda namebuf,y
		cmp swftype,x
		bne flistlo ;if there was any difference between extension and end of filename-string, don't display filename
		dey
		bmi flistlo ;if filename is empty (only extension), no point to display
		dex
		bpl -
dispnam	lda namebuf,y
		cmp #$20 ;is last character SPACE? -then sign it with a delimiter character
		bne dispnlp ;if not SPACE, simply display filename
		lda #$20+$40 ;the invisible space will sign real end of 'space-ended' filename to loader/saver routine
		bne + ;jump
dispnlp	lda namebuf,y ;filename-displayer loop
+		sta (compzptr),y
		dey
		bpl dispnlp
		inc filecnt ;count displayed filenames
nextrow	jsr cycfcol ;cycle filer-column counter, Y output is tabbing amount ;go to next screenplace for next filename
		jmp flistlo ;back to read next line
			
closdir inc dirready ;sign that directory fully read
		lda sizebuf+1 ;display free kilobytes on disk in decimal format (divide blocks by 4)
		lsr sizebuf+0;divide by 2
		ror
		lsr sizebuf+0 ;divide by 2 (4 in sequence)
		ror
		ldx #100 ;convert 
		jsr divideX
		sty diskfree+0
		ldx #10
		jsr divideX
		sty diskfree+1
		tax
		lda hexchar,x
		sta diskfree+2
		jsr clsfile

;-------type filename or author info / select file to load/save--------------
typesel	sei      ;type/select filename & description
		lda #$35
		sta banksel
		lda #$fe
		sta $dc00
-		lda $dc01 ;wait for keys to be released, especially RETURN
		cmp #$ff
		bne -
		lda #2 ;set filename-typer mode in key-handler
		sta namemode
defawin	lda #0 ;self-written - default filer-window (selector is preferred in case of loader)
		beq +
		jsr setsele ;set filename-selector subwindow as default for loader 
		jmp fkeylop
+		jsr setfnam ;set filename-typer subwindow by default
fkeylop	lda #$ff
		cmp $d012 ;constant 50Hz timing loop for keyboard-handler and cursor-displayer
		bne *-3
		lda #0
		sta fkeybout ;reset keyhandler output
		jsr keyer ;handles key-repeating and name-mode
		jsr disfcur ;display filer-cursors
		lda fkeybout ;keyhandler-output
		cmp #$f8 ;F1 key check
		bne + ;if F1 pressed, re-read directory
		jsr regauth ;clsfile ;close dir., save typed author-info to re-read filelist
		jmp reredir ;readdir ;re-read directory/file-list
+		cmp #$f9 ;F3/UP(PageDown) key check
		bne + ;if F3/Pagedown pressed, flip to next page of disk-directory (if exists)
		lda dirready ;check, if directory fully read
		bne lopover ;if directory read entirely, no further paging
		jmp listfil ;further read filelist
+		cmp #$fe ;if stop/esc pressed, returning to editor (abort file-operation)
		bne + ;$fe/$ff
		jsr regauth ;clsfile ;close directory-file - register author-text
		sec ;cause file-dialog abort in main routine (restart editor)
		rts
+		cmp #$ff ;if RETURN/Enter pressed, take action (load/save)
		bne lopover
		ldy filerwindow
		cpy #1
		beq +
		jsr regname ;register filename in 'namebuf' and author-info
		clc ;cause load/save in main routine, if return pressed window 1 or 2 (filename/file-selector)
		rts
+		jsr setfnam ;if window 1, go back to filename-typer
lopover	jmp fkeylop

;----------------------------------file-dialog subroutines----------------------------------
iniwfn  lda #$36 ;init workfile name pointer and length, bank, and device,file,channel
		sta banksel
bufnlen lda #0 ;self-written code - length of selected/typed filename
		ldx #<namebuf
		ldy #>namebuf
inifnam	jsr SETNAM   ;init filename pointer and length, and device,file,channel
devicen	ldx #ddevice  ;self-written, device # 8 is default (modifiable by user)
        lda hexchar,x
        sta $07c4
		lda #1                  ;   file # 1
		ldy #0                  ;   channel # 0 - (in case of LOAD: if 1, load to address automatically, if 0, address can be given in X/Y)
		jmp SETLFS              ; - call setlfs
		
;---------------------------------------------------------------		
clrfsel	;clear file-selector area, init file-listing variables
		lda #$36
		sta banksel
		lda #<dirvmem
		ldx #>dirvmem
		jsr inicptr ;set video-pointers
		ldx #0  ;clear filelist-area
		stx filecnt ;counts displayed filenames
		stx compzvar3 ;counts columns
fsclrlp	ldy #40-2
		lda #$20 ;Space character
-		sta (decozptr),y
		dey
		bpl -
		lda #40 ;one row forward
		jsr incptrs ;increase decozptr   ;iny -> Y=0 -> preserve compzptr
		cpx #filelistheight 
		bne fsclrlp
		rts
;-----------------------------------------------------------------------------
filenamer ;handles filename-typing/selection (called from keyer/nametyper routine in keyhandler.inc, char passed in Accu, keycode in Y)
		sta fkeybout ;for main routine
		cmp #$fa ;Control/TAB keys - cycle filer sub-windows
		bne filkeys
		ldy filerwindow
		bne + ;if filename-subwindow
		iny ;set Y to 1
		lda editauth ;if loader, no author-info editing, skipping that
		beq setsele ;if authorinfo editing disabled (=0) go straight to selector
		lda #authorilen-1
		sta compzvar4 ;length of input-field
		lda #<authorip
		ldx #>authorip
		jmp setyfld ;set typer field
+		cpy #1
		beq setsele ;if 1 set filename-selector subwindow
		clc
		jsr diselcu ;first clear selector-cursor
		jmp setfnam ;then cycle back to filename-typer window
setsele	lda filecnt ;set file-selector
		beq setfnam ;if filelist is empty, don't go to selector, go back to / stay at filename-typer instead
		lda #<dirvmem
		ldx #>dirvmem
		jsr inicptr ;set video-pointers
		sec ;set display-mode for cursor
		jsr diselcu ;display file-selector cursor
		ldy #2 ;set to 2
		bne setyfld ;jump
setfnam	lda #maxnamelen-1
		sta compzvar4 ;length of input-field
		lda #<filenamp
		ldx #>filenamp
		ldy #0
setyfld	sty filerwindow ;branched to here if filer-window was 2
setyfl2	jsr inidptr ;takes A , X
		lda #0
		sta compzvar2 ;reset cursor-position
		sta compzvar3 ;counts filename-selector columns
		rts
		
filkeys	ldx filerwindow ;handle keys depending on subwindow---------------------------------
		cpx #2
		bne typefld ;if not file-selector window, go to typer ;if file-selector subwindow, use cursor keys and Return only
		cmp #$fb ;cursor up/down
		bne +
		jsr fiselLR ;3 columns
		jsr fiselLR
		jmp fiselLR
+		cmp #$fc ;cursor left/right
		bne endfiln
fiselLR	clc ;clear cursor
		jsr diselcu ;clear file-selector-cursor
		jsr fiselec ;change cursor-pointer if possible
		sec ;draw cursor
		jmp diselcu ;draw file-selector-cursor
fiselec	lda shiftsi ;the effective algorithm itself to select file
		bne fselbwd
fselfwd	ldy compzvar2
		iny
		cpy filecnt
		bcs endfiln
		inc compzvar2
cycfcol	inc compzvar3 ;column-tabbing counter
		ldx compzvar3
		cpx #namecolums
		bne +
		ldx #0
		stx compzvar3
+		ldy colutab,x		
		jmp incompt
fselbwd	lda compzvar2 ;filename-count
		beq endfiln
		dec compzvar2
		ldx compzvar3
		ldy colutab,x
		dec compzvar3 ;cycle filer-column counter
		bpl +  ;if column-turnaround, compensate non-integer divisibility of screen width per filename-columns
		ldx #namecolums-1
		stx compzvar3
+		jmp decptrs

typefld	ldy compzvar2 ;handle typing fields------------------------------------------------
		cmp #$f5
		bne + ;Home-key?
		lda #0
		sta compzvar2
		rts
+		cmp #$f7 ;insert?
		beq +
		cmp #$fd ;backspace?
		bne cursidw
		lda shiftsi ;Insert? (Shift+Backspace)
		beq bkspclp
+		ldy compzvar4
-		cpy compzvar2
		beq clrcurp
		dey
		lda (decozptr),y ;shif letters forward
		iny
		sta (decozptr),y
		dey
		bpl -
clrcurp	lda #$20
		sta (decozptr),y
endfiln	rts
bkspclp	jsr fcurbwd
		ldy compzvar2
-		cpy compzvar4
		beq clrcurp ;BACKSPACE character to last cursorplace
		iny
		lda (decozptr),y ;shift letters back
		dey
		sta (decozptr),y
		iny
		jmp -
cursidw	cmp #$fc ;cursor-sideways keys?
		bne norchar
		lda shiftsi
		beq fcurfwd
fcurbwd	cpy #0 ;move cursor backwards in name-field
		beq endfiln
		dec compzvar2
		rts
norchar	cmp #0
		bmi endfiln ;avoid typing characters for remaining control characters
		sta (decozptr),y ;normal character branch
fcurfwd	cpy compzvar4 ;move cursor forward (if possible)
		bpl endfiln
		inc compzvar2
		rts

;--------------------------------------------------------------------------------
disfcur ;display cursor over typed data
		jsr clrcurs ;clear type-fields from cursor invertions
		lda filerwindow
		cmp #2 ;selector?
		beq +
		ldy compzvar2 ;display text-typer cursor
		lda (decozptr),y
		ora #$80
		sta (decozptr),y
+		rts
diselcu	ldy #maxnamelen-1 ;display/clear file-selector cursor (action depends on Carry-bit, displays if Carry=1, clears if Carry=0)
-		lda (compzptr),y
		and #$7f ;clear cursor
		bcc + ;if Carry bit set
		sta filenamp,y
		ora #$80 ;set cursor
+		sta (compzptr),y
		dey
		bpl -
		rts
clrcurs ldy #maxnamelen-1 ;clear type-fields from cursor invertions
-		lda filenamp,y
		and #$7f
		sta filenamp,y
		dey
		bpl -
		ldy #authorilen-1 ;clear cursor
-		lda authorip,y
		and #$7f
		sta authorip,y
		dey
		bpl -
		rts
		
;--------------------------	
regname	jsr clrcurs ;start by clearing type-fields from cursor invertions
		ldy #maxnamelen-1 ;copy/register typed/selected filename and author-info (latter only if editauth is on
-		lda filenamp,y ;loop search back to first non-Space character
		cmp #$20 ;check for spaces (if filename is 'spaced;, $60 Space will be noticed)
		bne + ;if not space coming, we found end of filename (without extension), and we can add the extension to it
		dey
		bpl - ;if not looped here, empty filename
+		iny
		sty compzvar3 ;copy filename before last space
		beq + ;zero filename
		ldy #0
-		lda filenamp,y 
		sta namebuf,y
		iny
		cpy compzvar3 ;stored length of filename
		bne -
+		ldx #0 ;add extension
-		lda swftype,x ;read extension-string
		sta namebuf,y ;add it to namebuf.
		iny
		inx
		cpx #extlen
		bne -
		sty bufnlen+1 ;register buffered name's length		
regauth	lda editauth
		beq clsfile ;if author-info being edited, register it in tune-header
		ldy #authorilen-1 ;hardwired author-info length
-		lda authorip,y
		sta authorinfo,y
		dey
		bpl -
clsfile	lda #$36
		sta banksel
		lda #1                  ;   file # to close
		jsr CLOSE               ; - so close it
		jmp CLRCHN              ; - clear all channels

nodevic	;if OPEN failed, warn user and ask for retrial
		ldy #28 ;display 'file exists'  (and later ask for overwrite-confirmation)
-		lda nodevicep,y
		sta lowvidram+40*24,y
		dey
		bpl -
		rts
		
;=============================================================================
;----------------------------------------------------------------------------------
nametyper ;subroutine which handles nametyping (instrument-naming or file-naming)
		lsr
		tay
		jsr repeat
		bne inmret1
		lda keychar,y ;(from datatables.inc)
		beq inmret1 ;no process if 0
		
		cpx #2 ;check if file-dialog is opened
		bne +
		jmp filenamer ;jump filename-typer (in menu.inc)
		+
.if COMPILEDAPP=1
		cmp #$fe ;signs if stop/esc pressed, returning to normal editing mode
		bcs +
		jmp typefld ;typing instrument-name
+		ldx #0
		stx namemode ;escape instrument-name typing without saving the result
		inc insrefr+1 ;display original instrument name
		cmp #$ff ;if this is Return, store the name
		bne inmret1
		;store to instrument		
		jsr setinsptr   ;load selected instrumet's basepointer to zeropage pointers
		ldy #maxinstsize-instnamelength		;display instrument-name
		ldx #0
-		lda vidram+$20,x
		sta (inszptr),y
		iny
		inx
		cpx #8
		bne -
.FI
inmret1	rts

;----------------------------------------------------------
shcbget	ldx #0  ;get status of SHIFT and CBM keys
		stx shiftsi
		stx cbmsig
		ldy #2
-		lda modkeyc,y
		sta $dc00
		lda $dc01
		and modkeyr,y
		bne +
		inc shiftsi,x
+		dey
		bne +
		inx
+		bpl -
		rts

;=====================================================================================
