;===============PATTERN HANDLING (INSERT/DELETE/COPY/CUT/PASTE/TRANSPOSE) ====================
;pattern operations

;=========================================INSERT===============================

insertpt ;this routine shifts the pattern-data to 1..3 byte higher (Y times) 
        ;in memory from position given in X
		;if patternlength exceeds 255 (in ptnlength) no process, and Y=$ff on return
		;if ACCU=1, one extra byte at shifting
		stx xposto2+1 ;store actual X position for later comparison
		dex
		stx xpostor+1 ;store actual X position for later comparison
		sty insamo2+1 ; amount of shift, used to init new empty place,bigFX affects it
		sta zeroval+1
		cmp #1 ;signs that bigFX needs one more byte
		bne +
		iny
+		sty insamou+1 ;insertion amount (how much the rest is moved)
		sty insamo3+1
		;----check if pattern is full or would be overloaded after insertion---
		ldy subwpos1+0 ;actual track
		ldx actptn1,y ;actual pattern
		lda ptnsize,x ;real size of pattern (maintained)
		cmp #maxptnlen
		bcs fullpt2 
		clc
insamou	adc #1 ;self-written , shifting amount from Y
		bcc + ;if carry bit reaches 1, end of pattern, no further writing to pattern
fullpt2	ldy #$ff ;pattern full signal
		rts
+		sta ptnsize,x ;otherwise change pattern size
		
		sec
		sbc ptn1pos,y ;y holds number of track (0..2)
		tax ;pointer/index to end of pattern - from where to start insertion
		clc
insamo3	adc #1 ;self-written
		tay ;pointer/index to the end of pattern plus shifing amount
		jsr movpfwd  ;move pattern-content forward, x and y holds source & target endpositions, X base-position is set in xpostor+1
		inx ;initial X position
		;zero out the new places
		inx
		lda #$00 ;the new value is 0 initially
		jsr instpt2
zeroval	ldy #0 ;self-written, 1 if bigfx, zero bigFX value
		beq insamo2
		inx
		jsr instpt2
		dex
insamo2	ldy #0  ;self-written from Y
newalop	dex
		dey
		beq + ;no empty $80 to fill?
		lda #$80
		jsr instpt2
		jmp newalop
+		
xposto2	ldx #0 ;self-written - get back to original position in X
fullptn	rts

movpfwd	;move pattern-content forward, x and y holds source & target endpositions, X base-position is set in xpostor+1
pattpt1	lda $1111,x ;self-written , read from patterndata
		sta (ptnzptr),y ;write to shifted data-area
		dey
		dex
xpostor	cpx #0 ;self-written
		bne pattpt1
		rts
		
;===================================DELETE=====================================
delbackpt ;delete Y bytes of pattern data from X position, rest moved back
		  ;used to clear up place when e.g. switching back to smallfx or zeroing fx/ins.
		stx xstodel+1
		stx xstode2+1
		sty ystodel+1
		sty ystode2+1
		sty ystode3+1
		ldx subwpos1+0 ;actual track
		ldy actptn1,x ;actual pattern
		lda ptnsize,y ;real size of pattern (maintained)
		sec
ystodel	sbc #0 ;self-written
		bcc xstode2 ;if zero has been exceeded, no process
		sta ptnsize,y
		    ;should check for zero patternlength? maybe enough at delete-key subroutine
		sec
		sbc ptn1pos,x 
		clc
ystode3	adc #0        ;set the amount Y bytes bigger to delete the rest after the reduced pattern
		sta lenstor+1 
		
xstodel	ldx #0 ;self-written
		txa
		clc
ystode2	adc #0 ;self-written
		tay
		jsr movpbwd ;move pattern-memory area backwards, X and Y are source/target basepositions, lenstor+1 is set to X endposition
xstode2	ldx #0 ;self-written - restore X
		rts 

movpbwd ;move pattern-memory area backwards, X and Y are source/target basepositions, lenstor+1 is set to X endposition
-		lda (ptnzptr),y
pattpt4	sta $1111,x ;self-written
		iny
		inx
lenstor	cpx #0 ;self-written , holds real end of pattern in memory
		bne -
		rts

;=======================================COPY===================================

copytobuf ;copy patterndata (from cursorposition) to buffer
		lda followp+1 ;don't allow any copying in followp+1lay-mode
		bne copyend
		;calculate real length (amount of rows) of pattern-data being copied to buffer 
		jsr compcur ;output: Accu holds patternposition under cursor, x-actual track, y-actual pattern
		beq copyend ;if cursor at end of pattern, no process
		ldx shiftsi
		bne copyends ;if shift also pressed for control+C, we define end of copying area
		sta copyrow+1 ;row position inside pattern (relative to patternstart) where copying was initiated
		sty copyptn+1 ;the pattern where copy was initiated
		eor #$ff ;multiply by -1 to perform a substraction with the addition
		sec
		adc ptnlength,y ;length of actual pattern
		sta bufflen+1
		
		jsr setptnptr ;set pattern pointers in advance based upon actual track/pattern position		
		ldx subwpos1+0 ;actual track
		lda ptncurs,x ;pattern memo-position at cursor (relative to patterndisplay)		
		tay
		clc
		adc ptn1pos,x
		sta copypos+1 ;the memory position inside pattern (relative to patternstart) where copying was initiated
		ldx #0 ;buffer starting at 0 always
		;stx wascrop+1 ;wascrop signs to cropper if there was buffer-crop already or not
bufloop	lda (ptnzptr),y ;adress of actual pattern has previously been set by setptnptr
		sta copybuffer,x
		cmp #$ff ;if pattern-end signal, finish copying to buffer
		beq setbsize ;if no endsignal yet, copy data inside pattern
		iny
		inx
		bne bufloop ;possibly never more than max. patternlength, but who knows
setbsize ;sign copied data size in bytes
		stx bufsize+1
copyend	rts 

copyends  ;used to sign a wished end of patterndata in the copy-buffer - only if we are in the same pattern as where copy was initiated
copyptn	cpy #1  ;self-written (copystartptn) ;the pattern where copy was initiated ;Y is set previously (above in copytobuf) in compcur
		bne cendend ;if we are not in the same pattern, do nothing, leave the buffer as it is
;wascrop	lda #0 ;self-written , nonzero, if crop was already performed on buffer
;		bne cendend
;		inc wascrop+1
		jsr compcur ;output: Accu holds pattern-row-position under cursor, x-actual track, y-actual pattern
		clc ;adds 1 - don't allow copy-enposition being the same as copy-startposition
copyrow	sbc #0 ;self-written (copystartrow) ;row position inside pattern (relative to patternstart) where copying was initiated
		bcc cendend  ;if new copyend position is smaller than initial copying position
		adc #0 ;C is 1 here, so this is addition of 1
		sta bufflen+1
		;ldx subwpos1+0 ;actual track - already set in compcur.
		lda ptncurs,x ;pattern memo-position at cursor (relative to patterndisplay)
		clc
		adc ptn1pos,x
		sec
copypos	sbc #0 ;self-written - ;the memory position inside pattern (relative to patternstart) where copying was initiated
		tay
		;lda #$ff
		;sta copybuffer,y
		sty bufsize+1
cendend	rts


;=======================================CUT====================================

cutandcopy  ;cut patterndata from cursorposition, copy cut data to buffer
		    ;patternlength should be intact - or not?    
		lda followp+1 ;don't allow any cutting in followp-play-mode
		bne cutcend
		jsr copytobuf ;first copy the data to the buffer
		jsr compcur ;output: Accu holds pattern-rowposition under cursor, x-actual track, y-actual pattern
		beq cutcend ;if cursor at end of pattern, no process
		jsr getcurnote ;Y stays intact
		txa ;memo-position at cursorposition
		clc
		ldx subwpos1+0 ;actual track
		adc ptn1pos,x  ;memo-position of pattern at 1st diplayrow
		adc bufflen+1 ;number of empty rows - equal with empty bytes
		adc #1 ;$ff signal's place
		sta ptnsize,y ;this is the size of data from cursor-position to pattern-endsignal
		
		ldx subwpos1+0 ;actual track
		ldy ptncurs,x ;pattern memo-position at cursor (relative to patterndisplay)
bufflen	ldx #1 ;self-written variable (bufferlength) ;length (amount of rows) of copied buffer
		lda #0
-		sta (ptnzptr),y
		iny
		dex
		bne -
		lda #$ff
		sta (ptnzptr),y
		;zero out the rest - maybe not needed
cutcend	rts


;======================================PASTE===================================
pastebuf		
		lda followp+1 ;don't allow any pasting in followp+1 play-mode
		beq +
		jmp pastend
+       jsr setptnptr
		jsr compcur ;output: Accu holds absolute pattern-rowposition under cursor, x-actual track, y-actual pattern
		beq cutcend ;pastend ;if cursor at end of pattern, no process
		sta xdetlo2+1
		clc ;accu holds absolute rownumber of cursor here
		adc bufflen+1 ;Accu holds end of paste in memory here ;sum can be larger than 255! 16 bit addition needed!
		;sta smpstor+1
		bcc + 
		jmp ovrpast ;if more than 255, overpasting for sure
+		sec ;needed for 16bit operation
		cmp ptnlength,y ;sbc ptnlength,y ;16 bit comparison if pattern is smaller than end of pasting
		bcc smallpa
		jmp ovrpast           ;if pasting exceeds patternlength, other pasting case & method
;----------------------------
smallpa	;branch, where pasting ends before end of pattern -rest needs to be handled (moved in memory)	
;smpstor	lda #0 ;self-written
		clc
		adc #1 ;?
		ldy subwpos1+0 ;track
		jsr detmemp  ;get memory position given (accu) row data to X - relative to displayposition
		txa
		stx intactpos1 ;original intact area mempos - relative to display
		;inc insrefr+1 -??? why did I do this ???
		
		;detect intact area size
		ldx subwpos1+0 ;actual track
		ldy actptn1,x ;actual pattern
		lda ptnsize,y
		sec
		sbc intactpos1
		sbc ptn1pos,x
		sta intactsize
		
		ldx subwpos1+0 ;actual track
bufsize	lda #1 ;self-written variable (buffersize) ;copied data size in bytes
		sta pastesize+1
		clc
		adc ptncurs,x
		sta intactpos2 ;new position of intact area - relative to display

		;calculate and check ptnsize = intactpos2+intactsize+ptn1pos,x
		lda intactpos2
		clc
		adc intactsize
		bcs pastend   ;16bit checking
		adc ptn1pos,x
		bcs pastend ;take 9bit result into consideration
		cmp #maxptnlen
		bcs pastend
		sta ptnsize,y

		;do the moving of intact area - direction depends on difference of pos 1 & 2 
		ldx intactpos1
		cpx intactpos2
		beq inpaste    ;if no need to move anything
		dex
		stx xpostor+1  ;sign for mover routine
		bcs movibak
movifwd	lda intactpos1
		clc
		adc intactsize
		tax
		lda intactpos2
		clc
		adc intactsize
		tay
		jsr movpfwd	;move pattern-content forward, x and y holds source & target endpositions, X base-position is set in xpostor+1
		jmp inpaste
movibak	ldy intactpos1
		ldx intactpos2
		txa
		clc
		adc intactsize
		sta lenstor+1
		jsr movpbwd
		
		;do the copying of pasted area
inpaste	ldx subwpos1+0 ;actual track
		ldy ptncurs,x
		jsr buftopt
		jmp pastadv
pastend	rts

intactpos1 .byte 0 ;original position of intact area
intactpos2 .byte 0 ;new position of intact area
intactsize .byte 0 ;size of intact area in bytes
;----------------------------
ovrpast	lda ptnlength,y   ;when pasting size is exceeding patternsize
		tay
		ldx #0 ;starts as 0, beginning of copybuffer, accumulates the mem-amount in X
xdetlo2 cpy #0
		beq dopaste
		lda copybuffer,x
		bpl decyerb
		inx
		lda copybuffer,x
		bpl decyerb
		inx
		lda copybuffer,x
		and #$e0
		bne decyerb
		inx
decyerb	inx
		dey
		jmp xdetlo2
		
dopaste	stx pastesize+1
		ldx subwpos1+0 ;actual track
		ldy actptn1,x ;actual pattern
		lda ptncurs,x ;pattern memo-position at cursor (relative to patterndisplay)
		clc
		adc ptn1pos,x
pastesize	adc #0 ;self-written variable 
		bcs pastend ;take 9bit result into consideration
		cmp #maxptnlen
		bcs pastend ;if pasting would oversize pattern
		adc #1
		sta ptnsize,y
		
		ldy ptncurs,x
		jsr buftopt	;copy buffer content into pattern memory position in Y. Pastesize+1 must be precalculated.
		lda #$ff
		sta (ptnzptr),y
		
pastadv lda autoadv
        beq pastend
        lda bufflen+1 ;go to next position after pasted area - maybe loop slows down, but needed for trackbinding
        cmp #maxadvancesteps ;don't advance for very much steps
        bcs pastend
        sta pascur
-		jsr godownp ;automatically ends when end of pattern
        dec pascur
        bne -
		rts
pascur .byte 0 ;counter for going down after paste

buftopt	;copy buffer content into pattern memory position in Y. Pastesize+1 must be precalculated.
		ldx #0
-       lda copybuffer,x
        ;cmp #$ff ;for safety
        ;beq pastadv
        sta (ptnzptr),y
        iny
		inx
		cpx pastesize+1
		bne -
		rts

;---------------------------------------------------------------------------------------------
transptn ;transpose actual pattern from cursorposition up/down, addition (or 2nd complement substraction) amount in X
		stx tranadd+1
		lda followp+1 ;don't allow any copying in followp+1lay-mode
		bne tranret
		jsr compcur ;output: Accu holds patternposition under cursor, x-actual track, y-actual pattern
		beq tranret ;if cursor at end of pattern, no process
		jsr setptnptr
		ldx subwpos1+0 ;actual track
		ldy ptncurs,x ;pattern memo-position at cursor (relative to patterndisplay)
translp	lda (ptnzptr),y
		cmp #$ff ;if reached endsignal
		beq tranret 
		and #$7f
		beq decidco ;NOP? Don't disturb
		cmp #$5f
		bcs decidco ;above note-range? - don't disturb
		lda (ptnzptr),y
		clc
tranadd	adc #1 ;self-written  , amount to add to note
		sta trstore+1
		and #$7f ;check if result inside limit
		cmp #$01 ;lower limit of notes
		bcc decidco ;don't go below/above limit
		cmp #$5f ;upper limit of notes
		bcs decidco
trstore	lda #0 ;self-written
		sta (ptnzptr),y
decidco	lda (ptnzptr),y
		bpl nextbyt  ;if only note in that row (no other column)
		iny
		lda (ptnzptr),y
		bpl nextbyt
		iny
		lda (ptnzptr),y
		and #$e0
		bne nextbyt
		iny
nextbyt	iny
		bne translp
tranret	rts
		
;==========================================================================================================
