;EDITOR part of SID-Wizard
;=====================================CONSTANTS===========================================
;CAUTION: SEQUENCE/PATTERN/TABLE DELIMITERS ($FE/$FF/$7E/$7F,TEMPOTABLE BIT7) ARE HARDWIRED, NEVER EVER TRY TO MODIFY THEM!!!

CHEATRASTERTIME=1 ;CHEAT WITH RASTERTIME TO COMPENSATE CPU-CYCLES STOLEN BY ORDERLIST-SPRITES - BETTER ESTIMATE OUTPUT

;====================================== VOLATILE DATA RANGE ===========================
*=$0340  ;here are the variables that are used by the program, and initially must be set zero. 
zerovar  ;They remain till program executes. (Displayer needs all these variables to be here for faster batch-indexing operations.)
actptn1 .fill 1 ;.byte $00 ;selected (or played in follow-mode) pattern 1
actptn2 .fill 1 ;.byte $00 ;selected (or played in follow-mode) pattern 2
actptn3 .fill 1 ;.byte $00 ;selected (or played in follow-mode) pattern 3
zerovar2
actwind .fill 1 ;.byte 0  ;actual window (0-patterneditor,1-orderlist,2-instrum,3-chord,4-tempo)

prowpos .fill 3 ;.byte $0,$0,$0  ;first display-row positions of the patterns (track1..3)
ptncurs .fill 3 ;.byte 0,0,0 ;memory index in patterns under cursor Y-position (displayer1 calculates) - in note column only

ptn1pos .fill 1 ;.byte $00 ;pattern1 display start-position in memory - calculated and used by displayer1
ptn2pos .fill 1 ;.byte $00 ;pattern2 display start-position in memory - calculated and used by displayer1
ptn4pos .fill 1 ;.byte $00 ;pattern3 display start-position in memory - calculated and used by displayer1

ptrdysi .fill 1 ;signal that notifies key-repeater to wait for pattern-redrawing

subwpos1 .fill 5 ;.byte $0,$0,$0,$0,$0 ;subwindow/position 1 in actual window
subwpos2 .fill 5 ;.byte $0,$0,$0,$0,$0 ;subwindow/position 2 in actual window
subwpos3 .fill 5 ;.byte $0,$0,$0,$0,$0 ;subwindow/position 3 in actual window

olstart .fill 3 ;.byte $00,$00,$00 ;orderlist F2key-playing startpositions

;these 5 bytes are index-handled some times, so leave them like this
wfarpos .fill 1 ;.byte 0 ;wfarp-table display-poisition
pwtbpos .fill 1 ;.byte 0 ;pwtable display-position
ctftpos .fill 1 ;.byte 0 ;ctftable display-position
chorpos .fill 1 ;.byte 0 ;chordtable display-position
temppos .fill 1 ;.byte 0 ;tempotable display-position
;---------------

songtime .fill 2 ;.word $0000  ;1st byte - minutes in BCD , 2nd byte - seconds in BCD
timeroff .fill 1 ;.byte 0  ;timer ON/OFF switch

namemode .fill 1 ;.byte 0  ;if value is nonzero, keyboard routine is typing characters instead of inst./pattern/etc. editing
                           ;if value is 2, filename-typing/selection mode
menumode .fill 1 ;.byte 0  ;if value is nonzero, the menu appears above music editor (display of musicdata stops)

dovetail .fill 1 ;.byte 0  ;if 1, cycling tracks on note entry/jam

OSC3Buffer .fill 12 ;storage for OSC3 SID output to display oscilloscope
;ENV3Buffer .fill 12 ;storage for ENV3 SID output to display oscilloscope

;------------------------------------------Video RAM is used for upper border, disappears when opening loader/saver/dir.display
.align $100 
ordlspr .fill $200  ;orderlist-spritedata, and other volatile data can be here
orlcurs .fill $40   ;orderlist-cursor sprite - copied here from RAM unde I/O


;================================= BASIC area start ===========================
*=$0801
		.word ss,2005
		.null $9e,^2064 ;Sys 2064
ss		.word 0

*=$080d ;SYS 2061 to safe-restart the editor, without initializing patterns/instruments
		jmp SafeRestart
;================================= Code part 1 ================================
*=$0810      ;INITIALIZATION AT PROGRAM START - set IRQ handlers, screen, and main VIC registers
		sei
		lda #0
		sta $d020
		sta $d011
		lda #$35
		sta banksel
		jsr CINITUN ;clear & initialize music data area in menu.inc
		jsr CININST ;clear & initialize instrument-data area
started	sei           ;we don't want lost cycles by IRQ calls :)
.include "include/initer.inc" ;set IRQ handlers, screen, and main VIC registers
		cli
;---------------------- display-refresher main loop (outside IRQ) ------------------
mainloop
inirequ	lda #1 ;self-written variable ;if not 0, signs tune initialization request for main routine
		beq + ;check init request from IRQ
initune	lda #0
		sta inirequ+1
		jsr inisubb  ;player-adapter version of initer ($1000) of player routine
		jsr ptndisp ;display selected patterns
		jsr stpdisp ;display step-highlighted bars for track 1..3
+		jsr display ;considers menu-display over patterns (based on 'menumode' variable)
		lda menupoint ;check selected menupoint (value is 0 if no menupoint was launched)
		beq mainloop ;if no menu was launched, main loop continues
		jmp runmenup

SafeRestart
		sei
		lda #$35
		sta banksel
		ldy #$fe
		;sty inirequ+1 ;ensure that player initialization happens at startup
		sty $dc00
		iny  ;wait for release of RETURN-key
		cpy $dc01
		bne *-3
		jmp retoedi ;started
;==============================================================================
.include "include/irq.inc" ;call keyhandler, cursordisplay, player routine, raster-tricks, followplay
 ;(don't move this area if possible, because code boundary-crossing can affect rastertiming)
;==============================================================================
.include "include/displayer1.inc" ;display pattern, step highlighting & numbering, etc.

;==============================================================================
;                             end of code part 1
;==============================================================================
.cerror *>PLAYERADDR,"TOO MUCH CODE BEFORE PLAYER DOESN'T FIT IN MEMORY. MOVE SOME CODE TO UPPER FREE AREAS!"

;************************ MUSICAL CODE AND DATA *******************************
*=PLAYERADDR  ;$1000
.include "include/player.asm"  ;the player/driver routine to produce the SIDDY sound
.include "include/playadapter.inc" ;subroutines connecting player and editor (jamming, follow-play, etc.)
;===============================
MUSICDATA ;musicdata-pointers reset relative to this address accordingly...preset music-data for editor------------------
;---------------------FIX pointer-tables-no need to save and recalculate on load-----------------------
*=SUBTUNES ;Subtune-orderlist-pointer table (max. 256 bytes, packer will crop unused areas)
		.FOR SUBTC=0,SUBTC<=maxsubtuneamount,SUBTC=SUBTC+1
		 .BYTE <(SEQUENCES+SUBTC*3*seqbound),>(SEQUENCES+SUBTC*3*seqbound)
         .BYTE <(SEQUENCES+SUBTC*3*seqbound+seqbound),>(SEQUENCES+SUBTC*3*seqbound+seqbound)
         .BYTE <(SEQUENCES+SUBTC*3*seqbound+seqbound*2),>(SEQUENCES+SUBTC*3*seqbound+seqbound*2)
         .BYTE defsubtempo1,defsubtempo2       ;DEFAULT FUNKSPEED FOR SUBTUNES
        .NEXT
*=PPTRLO  ;Pattern lo-pointer-table (max. 128 bytes, packer will crop unused areas)
		.BYTE <PTN0
		 .FOR PTPC=0,PTPC<maxptnamount,PTPC=PTPC+1  ;LO-BYTES OF PATTERN-POINTERS
         .BYTE <(RESTPTN+PTPC*PTNBOUND)
         .NEXT
*=PPTRHI  ;Pattern hi-pointer-table (max. 128 bytes, packer will crop unused areas)
		.BYTE >PTN0
		 .FOR PTPC=0,PTPC<maxptnamount,PTPC=PTPC+1  ;HI-BYTES OF PATTERN-POINTERS
         .BYTE >(RESTPTN+PTPC*PTNBOUND)
         .NEXT
*=INSPTLO+1 ;Instrument-data lo-Pointer Table ;(max. 128 bytes, packer will crop unused areas), instrument 0 unused
		.FOR INSCL=0,INSCL<maxinstamount,INSCL=INSCL+1 ;LO-BYTES OF INSTRUMENT-POINTERS
		.BYTE <(INSTRUMENTS+INSCL*maxinstsize)
		.NEXT
*=INSPTHI+1 ;Instrument-data hi-Pointer Table ;(max. 128 bytes, packer will crop unused areas)
		.FOR INSCH=0,INSCH<maxinstamount,INSCH=INSCH+1 ;HI-BYTES OF INSTRUMENT-POINTERS
		.BYTE >(INSTRUMENTS+INSCH*maxinstsize)
		.NEXT
;---------------------variable-pointer tables - not saved but need to be recalculated---------------------
*=CHDPTRLO   ;Chord-pointer Table (max. 64 bytes, packer will crop unused areas)
		.byte 0,1  ;unchanged chord-pointer of chord 0 and 1 
*=TEMPTRLO ;Pointers to specific tempo-programs in tempo-program table (max. 128 bytes, packer will crop unused areas)
		.byte 8,9
;...ptnlength - pattern length registry for faster operations and display  - JUST FOR EDITOR ;(max. 128 bytes, packer will crop unused areas)
;...ptnsize - real size of pattern in memory - JUST FOR EDITOR 
;=====================music data to save starts here - in the same order as saved file==============================
*=TUNEHEADER ;some basic tune-specific settings workfile/tune/subtune related settings (framespeed, etc.)
filetyp .text "SWM" ;3 BYTE FILETYPE-DESCRIPTION - abbreviation of 'SID-WIZARD MODULE'
version .text SWversion ; VERSION 1 of the module format
framesp .byte 1 ;framespeed of the music (1 singlespeed.. to 8 multispeed)
stpthck .byte $04 ;thick amount for step-highlighting
autoadv .byte 1 ;switch for autoadvance ON/OFF - saved with tune
bindtrk .byte 1 ;bind tracks ON/OFF - move track together wherever possible, or not at all
mutesolo .byte $FF,$FF,$FF ;the mute/solo indicators for the tracks (toggled by shift+1/2/3)
defptlen .byte DEFAULTPTNLEN ;default pattern-length (this info is needed for depacker to retain the status before saving)
;.............CALCULATED VALUES FOR PACKER/DEPACKER follow here (described in SWM-spec.src)
;.fill 5 ;bytes modified by packer/depacker (their positions are given in settings.cfg)
;...some bytes left for later additions (to keep compatibility)
*=authorinfo
		.text "AUTHOR NAME : TUNE-TITLE...             "
;...SEQUENCES - orderlists of subtunes ;maximum $2000 bytes ( $2000/3tracks*$80 = 20 SUBTUNES )
;...PATTERNS ;maximum $8000 bytes   ($7f00/$100 = $7f patterns)
*=PTN0  ;dummy pattern-data (in case f empty subtune-playback)
		.byte $00,$ff 
;...INSTRUMENTS ;maximum $1000 bytes. $1000/$3e = $42 (~64) bytes for each, but there
*=CHORDS ;Cordtable - dynamic memory management with aid of pointers (max. 256 bytes, packer will crop unused areas) 
		.byte $7f ;- ensure delimiter as chord0 
;...TEMPOTBL, TRKTEMPO, RESTEMP - tempo program-table (max. 256 bytes, packer will crop unused areas)
*=RESTEMP
		.byte $80 ;1st tempo if accidentally tempo-program 0 (at index 8) is selected
		;and the rest of tempoprograms coming here
*=endoftune


;==============================================================================
copybuffer ;a 256 byte buffer where the patterns are being copied
		.byte 0,$ff ;initial value (empty pattern)
		.fill ptnbound-2,0 ;zero out copybuffer area

;-------------------------code that had no room elsewhere---------------------------------------
;------------------------------pack/depack/(load/save if no BASIC-ROM needed)---------------------------
.include "include/menu.inc"  ;menu and file-dialog and file-operations
.include "include/packdepack.inc" ;compresses/decompresses the tune to prepare for loading/saving by wiping out empty area
.include "include/commonsubs.inc"  ;common/miscellaneous subroutines used by various parts of the program. pointer/index calculators, timer, etc.
.include "include/datatables.inc" ;tables/variables being displayed and used

;************************ CHARACTER SETS AND SCREEN DATA **********************
.cerror *>$D000,"TOO MUCH MUSICDATA DOESN'T FIT IN MEMORY. LESSEN PATTERNS OR INSTRUMENTS OR SUBTUNES!"
;==============================================================================
*=$d000 ;screendata - videoram and colour-ram initial GUI design, sprite pointers,sprites
.include "graph/graphics.inc"
;$d000 - c64 character set for SID-Wizard (binary file included)
;$d800 - Colour RAM (source in RAM under IO area, copied to colour-RAM at startup) -should generate by code, so 1k could get freed up
;$dc00 - extra 1k RAM under IO used for non-graphic, or grahpic-source content
 ;seqchtbl ;reference table (5X multiplier) for 5-pixel high chardata
 ;sprtable ;precalc.table for sprite-addresses of corresponding orderlist x-coordinates
 ;seqchar	;characters for orderlist patternvalues' display
 ;cursor-sprite in orderlist
 ;cursor-sprite
;$e000..$e400 VIDEO RAM initial and maintained content
;==============================================================================


;********************************** CODE PART 2 *******************************
;*=$e400
.include "include/displayer2.inc"  ;display cursor and textual content (mainly orderlist)
;==============================================================================
.include "include/keyhandler.inc"  ;handle the keypresses - the subroutine-names are found in the datatables.inc file ;callback subroutines for keypresses
.include "include/datawriter.inc" ;common point to write value in X to cursor-position, and note in Y to cursor position
.include "include/insdelcopy.inc" ;batch-manipulators, like insertion/deletion/cut/copy/paste/transpose/etc.
;...not too much bytes left here
.cerror *>$ffc0,"TOO MUCH CODE DOESN'T FIT IN MEMORY. MOVE SOME CODE TO LOWER FREE AREAS!"
;==============================================================================
;$ffc0 ;row26  ;videoram for 26th row
*=$ffc0 ;videoram for 26th row
row26

;===================================================================================================================================
