display2 ;refreshers, called from IRQ
		lda actwind
		cmp #1 ;orderlist
		bne +
		inc seqrefr ;refresh also when playing changes SEQCNT,x
		
+		cmp #2 ;instrument window / chordwindow / tempotable - refresh all
		bmi +
		inc insrefr+1
		+
		rts
		
;-------------------------------------------------------------------------------
cursord	;cursor displayer - BE CAREFUL TO KEEP THIS UNDER 3-4 rows' rastertime (called from IRQ bars)

		lda namemode ;instrument name-typing?
		beq +
		lda #0
		sta cury+1
		lda #32
		clc
		adc compzvar2 ;inamepos ;cursor-position of instrument-naming
		sta curx+1
		lda #$fe
		sta $d01d
		jmp otherwi

+		lda actwind
		bne chkwi1  ;patternwindow?
		lda subwpos3+0 ;calculate Y cursorpos. in pattern-window
		sta cury+1
		ldy #$ff
		lda subwpos2+0 ;calculate X cursorpos. in pattern-window
		beq nonotep ;if cursor in note column
		dey ;ldy #$fe
		clc
		adc #1
nonotep	sty $d01d
		ldy subwpos1+0 ;track number (0..2)
		sec ;add plus 1, because values in stplptr are counting from 0
		adc stplptr,y
		sta curx+1
		jmp otherwi
chkwi1	ldy #$fe
		sty $d01d
		cmp #1     ;orderlist?
		bne chkwi2
		lda subwpos1+1 ;track number (Y-position) in orderlist 
		asl         ; - multiply A by 2
		jsr multi3b ; - multiply A by 3 - here multiplied by 6 pixels
		sta $d001
		lda subwpos2+1
		sta curx+1
		jmp justxdis
chkwi2	cmp #2         ;instrument window
		bne chkwi3
		ldy subwpos1+2 ;instrument-subwindow (1..4)
		lda subwpos2+2
		clc
		adc iswposx,y
		cpy #0
		bne noiwin0
		cmp #36 ;check instrument window 0 positin X
		bmi noiwin0
		clc
		adc #2
noiwin0	sta curx+1
		lda iswposy,y
		clc
		adc subwpos3+2
		sta cury+1
		jmp otherwi
chkwi3	cmp #3           ;chordtable
		bne chkwi4
		lda subwpos1+3
		clc
		adc #6
		sta cury+1
		lda #38
		clc
		adc subwpos2+3
		sta curx+1
		jmp otherwi
chkwi4	lda subwpos1+4   ;tempotable
		clc
		adc #20
		sta cury+1
		lda #38
		clc
		adc subwpos2+4
		sta curx+1

otherwi
cury	lda #1 ;self-written variable ;cursor y coordinate (0..25..28)
		asl
		asl
		asl
		clc
		adc #$22
		sta $d001
justxdis
		;cursor-sprite display (coordinates,colour)
curx	lda #0 ;self-written variable   ;cursor x coordinate (0..39)
		asl
		asl
		asl
		php
		clc
		adc #$18
		sta $d000
		lda #$c0
		bcc no9bit1
		ora #$01
no9bit1 plp
		bcc no9bit2
		ora #$01
no9bit2 sta $d010
		;display cursor colour
jammode	lda #0 ;self-written variable ;if 0 - edit, if 1 - jam 
		bne + ;write/jam mode of keyboard
		dec curcolc+1 ;if edit-mode, flash faster
+		dec curcolc+1 ;cursor color flasher
		bpl norescc
		lda #23
		sta curcolc+1
norescc
curcolc	ldy #0 ;self-written variable ;cursor colour counter
		lda curcols,y
		sta $d027
		
retget	rts
		
;===============================================================================

setrpos ;set pointers to real ptn-positions of the display-starting positions
		ldy #2
		sty zpvari2
		
realop1	ldy zpvari2
		ldx prowpos,y ;the display position of track Y
		lda actptn1,y ;the pattern in track Y
		tay
		lda pptrlo,y  ;set pattern pointer for actual pattern
		sta datzptr
		lda pptrhi,y
		sta datzptr+1

		ldy #0
ydetlp	cpx #0    ;detect memory-index of given row
		beq getnext
		lda (datzptr),y
		bpl decxer0
		iny
		lda (datzptr),y
		bpl decxer0
		iny
		lda (datzptr),y
		and #$e0
		bne decxer0
		iny

decxer0	iny
		dex
		jmp ydetlp

getnext	ldx zpvari2
		tya
		sta ptn1pos,x
		dec zpvari2
		bpl realop1
		rts

;===============================================================================
seqdisp	;display orderlist numbering in 26th row (video ram 2)
seqdpos	ldx #0 ;self-written variable ;display-position of orderlist (sequence)
		ldy #0
		sty seqrefr
seqdlp	txa
		pha
		jsr div16
		cpx olstart
		bne +
		ora #$30
+		sta row26,y
		pla
		and #$0f
		ora #$90
		cpx olstart
		bne +
		stx sdxstor+1
		and #$0f
		tax
		lda hexchar,x
sdxstor	ldx #0 ;self-written, X stored before
+		sta row26+1,y
		inx
		iny
		iny
		cpy #$28
		bne seqdlp
		rts

;===============================================================================
ordldis            ;display orderlist values in sprite-bitmap ;zeropage: 2
		lda #$34 ;orderlist characters are under IO area
		sta banksel
		ldx #2
		stx zpvari7 ;counter for number of track
-		jsr getsubaddr ;get subtune-address position to Y
		adc zpvari7
		adc zpvari7 ;added 2 times 
		tay
		lda SUBTUNES,y  ;READ ORDERLIST LO-ADDRESSES FOR SUBTUNE
        sta seqaddr+1    ;SET ORDERLIST LO-ADDRESSES FOR SUBTUNE
        lda SUBTUNES+1,y  ;READ ORDERLIST HI-ADDRESSES FOR SUBTUNE
        sta seqaddr+2   ;SET ORDERLIST HI-ADDRESSES FOR SUBTUNE
		jsr dseqrow
		dec zpvari7
		bpl -
		lda #$35 ;orderlist characters are under IO area
		sta banksel
retorli	rts

;-------------------------
dseqrow ;displays one sequence-row, Accu holds sprite-characterrow pixelposition
		ldx zpvari7 ;actual track-sequence to display
		lda olypos,x  ;y position adder
		sta zpvari6
		lda mul7chn,x ;actually displayed track (0..2 from caller)
		clc
		adc #<SEQPOS ;for this, SEQPOS shouldn't be on boundaries
		sta actrack+1
		lda #>ordlspr
		sta datzptr+1      ;sprite pixeldata pointer hi-byte
		
		ldx #0
		stx zpvari2 ;orderlist-displayposition counter 0..20
ordloop	ldx zpvari2 ;counts displayed column of displayed 2 hexa digit pattern-number
		cpx #20
		beq retorli  ;check if we exceeded display area
		cpx #12
		bne +    ;if position 12, increase spritedata pointer
		inc datzptr+1
+		lda sprtable,x  ;precalc.table for sprite-addresses of corresponding orderlist x-coordinates (datatables.inc)
		clc
		adc zpvari6     ;sequence display startposition in memory 0 / 18 / 36, depending on which track/row we are displaying
		sta datzptr  ;set sprite-pixeldata lo-pointer 
		txa  ;actual value position in sequence (0..19)
		clc
		adc seqdpos+1 ;seq display-position
		tay
		ldx #$00
actrack	cpy SEQPOS ;self-written operand lo-byte, sequence played position in Player-routine
		bne +
		dex ;$ff   ;invert actually played position
+		stx seqposd+1	
seqaddr	lda $1111,y ;self-written , reads actual displayed orderlist-position's value from memory
		pha   ;accu holds the actual seq value here
		bne + ;if zero, display dots - zero has special meaning now, not used as pattern
		lda #$10  ;spritedata dot character
		bne ++  ;jump
+		and #$0f ;calculating 2nd digit
+		tay
		lda seqchtbl,y  ;seq-chartable
		sta wrsp1+1 ;left char
		pla
		lsr
		lsr
		lsr
		lsr
		bne + ; dig1zer ;if 1st digit is 0, a dot is written for better sight of orderlist (less crowded) 
dig1zer	lda #$10  ;spritedata dot character
+		tay
		lda seqchtbl,y
		sta wrsp2+1 ;right char
		
		ldy #12
		ldx #4
chrloop                ;writing character to pixeldata in sprites
wrsp1	lda seqchar,x  ;self-written prviously
		and #$0f
		sta zpvari3
wrsp2	lda seqchar,x  ;self-written prviously
		and #$f0
		ora zpvari3       ;merge left and right character pixeldata
seqposd	eor #$ff    ;self-written - if sequence position is played actually, the character is inverted
		sta (datzptr),y ;puts the graphdata to low-border sprites
		dex
		dey
		dey
		dey
		bpl chrloop  ;end of character-pixeldata displaying loop (for 1 value)

		inc zpvari2  ;holds actual hexa number display-column position (0..19)
		jmp ordloop
		
;===============================================================================

upbordisp  ;display upper border data in upper-border sprites
        ;need to switch bank with zeropage $01 := $34 to write RAM under IO area
        lda #$34
        sta banksel
        
        ldx #>updispr
        stx vidzptr+1
        
upbord1	ldx #4	      ;display the numbers in the upper border
-		lda posies,x
		sta vidzptr
		cpx #4-2 ;point, where sprite-graphic hi-pointer increases
		bne +
		inc vidzptr+1
+		lda memiel,x
		sta datzptr
		lda #>zerovar ;memieh,x
		sta datzptr+1
		ldy #0
		lda (datzptr),y
		jsr uphexac
		dex
		bpl -	

		lda #0+64*2 + 23
		sta vidzptr
		lda autoadv ;Autoadvance mode sign
		jsr upchar2

		lda #0 + 64*2 + 21  ;framespeed-display
        sta vidzptr
		lda framesp
		jsr upchar2	
		
		lda #0 + 64*2 + 3   ;jamming octave display
        sta vidzptr
jamoctave ldy #4 ;self-written variable ;octave for jamming and note/typing
		iny
		tya
		jsr upchar1	
		
		ldx #2          ;patternsize displays
-		lda ctuvm1,x
		sta vidzptr
		ldy actptn1,x
		lda ptnsize,y
		sec
		sbc #1
		pha
		jsr uplchar
		dec vidzptr
		cpx #1
		bne +
		dec vidzptr+1
		lda #<updispr+64*2+47
		sta vidzptr
+		pla
		jsr uprchar
		dex
		bpl -
;--------------
		ldx #0 ;subwpos1+0 ;actual track
		jsr DisPWmt ;display PW-meter for channel given in X
		ldx #1 ;subwpos1+0 ;actual track
		jsr DisPWmt ;display PW-meter for channel given in X
		ldx #2 ;subwpos1+0 ;actual track
		jsr DisPWmt ;display PW-meter for channel given in X
		
CTFMETR	LDA #0 ;SELF-WRITTEN - A HELP FROM PLAYER, CONTAINS CUTOFF-FREQUENCY HI-BYTE
		lsr ;/2 ;0..127
		lsr ;/4 ;0..63
		lsr ;/8 ;0..31
		sta scinput+1 ;store 5bit (0..31) input value
		lda #<(updispr+64*5+54)
		ldy #>(updispr+64*5+54)
		jsr dispmtr
;---------------- 
.if OSCILLOSCOPE=1 ;display oscilloscope 
		ldy #15*3 ;refresh (clear) scope-screen
-		lda #$80 ;left edge of oscilloscope-screen
		sta updispr+64*6+6,y
		lda #5 ;right edge of oscilloscope-screen
		sta updispr+64*6+7,y
		dey
		dey
		dey
		bpl -
;display oscilloscope-pixels in order horizontally
		ldx #12-1 ;width of oscilloscope 
ENV3sto	lda #0 ;self-written ;ENV3 (envelope of 3rd channel) ;Multiplier
		beq + ;if envelope is 0, no need to calculate multiplicaton (ensure zero)
		sta vidzptr ;retain original base-position in exp-table caused by ENV3
		clc
		adc OSC3buffer,x ;OSC3 (oscillator of 3rd channel) ;Multiplicand;
		tay
		lda EXPTABH,y ;FREQHI,y ;;;
		ldy vidzptr ;eliminate base position (shift) in exponent-table
		sec
		sbc EXPTABH+9,y ;adding 9 centers OSC3 produced value (roundabout 0..31) 
+		clc
		adc #16-1 ;this shifts the value to positive range for display
		lsr ;eliminate one pixel difference (on 0..15 scale) of exponent-table if ENV3=0
		and #$0f ;prevent from graphic-overwriting bugs
		jsr multi3b ;multiply by 3 for column-based sprite-display of new rightmost pixel
		tay
		cpx #12/2 ;treshold of 1 byte display
		bmi + ;handle second part of the scope
		iny ;by going to second byte in sprite-display
+		lda updispr+64*6+6,y
		ora OsciPixel,x
		sta updispr+64*6+6,y
		dex
		bpl ENV3sto
.fi		
;--------------
		inc banksel ;$35
		rts
		
;------------------------------------
pwmeterpos	.byte <(updispr+64*5+42),<(updispr+64*5+45),<(updispr+64*5+48)

DisPWmt	;display PW-meter for channel given in X
		ldy mul7chn,x ;transform 0..1..2 to 0..7..14
		lda PWLOGHO,y
		cmp #$80 ;set carry flag based on bit7 of pwlogho,x
		lda PWHIHELP,y ;PWHIGHO,y ;4 bit (0..15) value
		and #$0f ;range 0..15
		rol ;with carry-flag do 5 bit (0..32) value in Accu
		sta scinput+1 ;store 5bit (0..31) input value
		lda pwmeterpos,x
		ldy #>(updispr+64*5+42)
dispmtr	;display PW/Cutoff meters (5bit in 'scinput' , A-Y:screen-address)
		sta vidzptr+0 ;set screendata-pointers
		sty vidzptr+1
		ldy #2
-		ldx #0 ;point to $ff if below
		lda scalecomp,y
		sec
scinput	sbc #0 ;self-written - input value
		bmi +
		tax
		cpx #12
		bmi +
		ldx #11 ;point to $00 if above
+		lda scalemask1,x
		;lda scalemask2,x
		sta (vidzptr),y
		dey
		bpl -
		rts

;--------------- reserve X here in these routines! Needed for display-indexing
uphexac pha ;0. display a complete 2 digit hexa number in upper border
		jsr div16
		jsr upchar1
		pla
		and #$0f
		jmp upchar2
uplchar and #$0f     ;1. left char
upchar1	tay          ;2. left char
		lda #$0f
		jmp chdrcom
uprchar	jsr div16    ;3. right char 
upchar2	tay          ;4. right char
		lda #$f0
chdrcom	sta zpvari4
		eor #$ff
		sta zpvari5
		lda seqchtbl,y
		sta wrsp2b+1 ;char
		txa
		pha
		ldy #12
		ldx #4
wrsp2b	lda seqchar,x ;self-written
		eor #$ff
		ora zpvari4 ;#$f0 / #$0f
		sta zpvari6
		lda (vidzptr),y
		ora zpvari5 ;#$0f / #$f0
		and zpvari6 ;sw
		sta (vidzptr),y
		dey
		dey
		dey
		dex
		bpl wrsp2b
		pla
		tax  ;X reserved
		rts

;====================================
mutesolodisp ;performs colouring of track at mute/solo - tracknumber in y - done outside IRQ

		lda mutesolo,y ;mute/solo status byte for track Y
		and #1
		tax
		lda msolocol,x ;colour index for on/off
		sta msolocw+1
		lda msolocol+2,x ;instrument-colour index for on/off
		sta msoloc2+1
		ldx stplptr,y ;colour positions taken from step-highighting column position table
		inx
		stx msoloop+1
		
		lda #<COLRPOS
		sta datzptr
		lda #>COLRPOS
		sta datzptr+1

		ldx #23 ;number of rows to change colour of
msoloop ldy #0 ;self-written
msolocw	lda #0 ;self-written
		sta (datzptr),y
		iny
		sta (datzptr),y
msoloc2	lda #0 ;self-written
		iny
		sta (datzptr),y
		iny
		sta (datzptr),y
		lda datzptr
		clc
		adc #40
		sta datzptr
		bcc +
		inc datzptr+1
+		dex
		bpl msoloop
		
		rts

;===============================================================================
