;===========================================VARIABLES-tables (arrays) and DATA-TABLES ============================================

.if COMPILEDAPP=1 ;next part needed only for editor
;keyboard-jumptable																	  ;- 01 - 02 - 04 - 08 - 10 - 20 - 40 - 80 ---
keyjmp	.word deleter ,reter   ,cursori ,f7er    ,f1er    ,f3er    ,f5er    ,cursrdn  ; del |retu|crri| F7 | F1 | F3 | F5 |crdn|fe
		.word key3sub ,wkeysub ,keyAsub ,key4sub ,zkeysub ,skeysub ,keyEsub ,morekey  ;  3  | W  | A  | 4  | Z  | S  | E  |lSH |fd
		.word key5sub ,rkeysub ,keyDsub ,key6sub ,keyCsub ,fkeyer  ,tkeyer  ,xkeysub  ;  5  | R  | D  | 6  | C  | F  | T  | X  |fb
		.word key7sub ,ykeysub ,gkeysub ,key8sub ,keyBsub ,hkeysub ,ukeysub ,vkeysub  ;  7  | Y  | G  | 8  | B  | H  | U  | V  |f7
		.word key9sub ,ikeysub ,jkeysub ,key0sub ,mkeysub ,kkeyer  ,okeysub ,nkeysub  ;  9  | I  | J  | 0  | M  | K  | O  | N  |ef
		.word pluser  ,pkeysub ,lkeysub ,minuser ,dotter  ,semidot ,atkeysub,coloner  ;  +  | P  | L  | -  | .  | :  | @  | ,  |df
		.word inskeye ,starkey ,semicol ,homer   ,morekey ,dummykey,slasher ,slasher  ;pound| *  | ;  |HOME|rSH | =  | up | /  |bf
		.word key1sub ,dummykey,ctrler  ,key2sub ,spacer  ,morekey ,qkeysub ,stopper  ;  1  |back|CTRL| 2  |SPC | C= | Q  |stop|7f
		
OCTMULS	.BYTE 0,12,24,36,48,60,72,84 ;TRANSPOSITION VALUE OF OCTAVES TO ADD/SUBSTRACT FROM NOTE

.FI

;keyboard-charactertable for naming			  					  ;- 01 - 02 - 04 - 08 - 10 - 20 - 40 - 80 ---		
keychar	.byte $fd,$ff   ,$fc   ,$fe   ,$f8   ,$f9   ,$fe   ,$fb   ; del |retu|crri| F7 | F1 | F3 | F5 |crdn|fe
		.byte 51 ,23+64 ,1+64  ,52    ,26+64 ,19+64 ,5+64  ,$f6   ;  3  | W  | A  | 4  | Z  | S  | E  |lSH |fd
		.byte 53 ,18+64 ,4+64  ,54    ,3+64  ,6+64  ,20+64 ,24+64 ;  5  | R  | D  | 6  | C  | F  | T  | X  |fb
		.byte 55 ,25+64 ,7+64  ,56    ,2+64  ,8+64  ,21+64 ,22+64 ;  7  | Y  | G  | 8  | B  | H  | U  | V  |f7
		.byte 57 ,9+64  ,10+64 ,48    ,13+64 ,11+64 ,15+64 ,14+64 ;  9  | I  | J  | 0  | M  | K  | O  | N  |ef
		.byte 43 ,16+64 ,12+64 ,45    ,46    ,$3a   ,$00   ,$2c   ;  +  | P  | L  | -  | .  | :  | @  | ,  |df
		.byte $f7,0     ,$3b   ,$f5   ,$f6   ,$3d   ,$f9   ,$2f   ;pound| *  | ;  |HOME|rSH | =  | up | /  |bf
		.byte 49 ,$fe   ,$fa   ,50    ,32    ,0     ,17+64 ,$fe   ;  1  |back|CTRL| 2  |SPC | C= | Q  |stop|7f
		
;maybe separate table for shift / cbm keys would be useful, when keyboard-layout-change support is planned
;-------------------------------------------------------------------------------
modkeyc	.byte $7f,$bf,$fd ;columns of CBM, Right-SHIFT, Left-Shift
modkeyr	.byte $20,$10,$80 ;rows of CBM, Right-SHIFT, Left-Shift
;modkeyp .byte 1,  0,  0   ;index of modifier key
;=================================================================================================================================

;variables, that are initially zero, are stored at 'zerovar' section ($0340 possibly before beginning of main code)

;-------------------------------------------------------------------------------
;strings to display values / pattern-end signal

hexchar .text "0123456789ABCDEF"

;-------------------------------------------------------------
;multispeed frame-position/timing values

frmspds .byte 0,<(fspd1-framers),<(fspd2-framers),<(fspd3-framers),<(fspd4-framers)
		.byte <(fspd5-framers),<(fspd6-framers),<(fspd7-framers),<(fspd8-framers)

;framespeed-rasterrows (equal sharing among the $11c=$47*4=$5e*3 rasterrows) - avoid badline (modulo8=0)
fullrast=$11c ;amount of rasterrows (PAL) VIC produces
rastcomm = $f2    ;rasterrow for 26th row and 1st raster + keyhandling, etc.
subrast = fullrast-play1rast   ;$11c-$fe = $1e
;dist1 = fullrast / 1 ;$11c
dist2 = fullrast / 2 ;$8e ;calculate optimal distances between rasterbars 
dist3 = fullrast / 3 ;$5e
dist4 = fullrast / 4 ;$47
dist5 = fullrast / 5 ;$38
dist6 = fullrast / 6 ;$2f
dist7 = fullrast / 7 ;$28
dist8 = fullrast / 8 ;$23
framers 
fspd1	.byte rastcomm       ;1x framespeed rasterrow  ( and keyhandler, etc. this value mustn't change)
fspd2	.byte rastcomm, dist2-subrast
fspd3	.byte rastcomm, dist3-subrast, 2*dist3-subrast+2
fspd4	.byte rastcomm, dist4-subrast, 2*dist4-subrast, 3*dist4-subrast+1
fspd5   .byte rastcomm, dist5-subrast, 2*dist5-subrast, 3*dist5-subrast, 4*dist5-subrast 
fspd6   .byte rastcomm, dist6-subrast, 2*dist6-subrast, 3*dist6-subrast+1, 4*dist6-subrast+2, 5*dist6-subrast+3
fspd7   .byte rastcomm, dist7-subrast, 2*dist7-subrast, 3*dist7-subrast, 4*dist7-subrast-1, 5*dist7-subrast, 6*dist7-subrast
fspd8   .byte rastcomm, dist8-subrast, 2*dist8-subrast, 3*dist8-subrast, 4*dist8-subrast-1, 5*dist8-subrast-1, 6*dist8-subrast-2, 7*dist8-subrast-3


.if COMPILEDAPP=1 ;next part needed only for editor

ptendch .byte $be,$be,$be,$bb,$bc,$be,$be,$be  ;pattern-end string

;-------------------------------------------------------------------------------
;variables (positions) controlled by keyboard

curcols	.byte $00,$0b,$06,$04,$0e,$0c,$03,$0f,$0d,$07,$07,$01 ;cursor colours to flash
		.byte $01,$07,$07,$0d,$0f,$0a,$0c,$08,$02,$09,$00,$00

msolocol .byte mutecol,notecolucol, mutecol,instcolucol  ;mute/solo colours for note-column and instrument-column

;-----------------------------------------displaypositions------------
trdposl .byte <trk1plc,<trk2plc,<trk3plc ;screen position (lo) to draw patterns
trdposh .byte >trk1plc,>trk2plc,>trk3plc ;screen position (hi) to draw patterns

stplptr .byte 0,<(stp2plc-stp1plc),<(stp3plc-stp1plc) ;step-higliht-screen-pointers

vibtype .byte $6f,$70, $6e,$70, $6e,$71, $6e,$72 ;charactercodes for vibrato types 0...3

iswposx	.byte 32,31,31,31 ;instrument-window X basepositions (common,wf,pw,ctf)
iswposy .byte 01,6,15,20 ;instrument-window Y basepositions (common,wf,pw,ctf)

iswmaxy .byte 3,7,3,3 ;maximum Y-coordinates of instrument-windows

imainpos .byte $70,$72,$48,$4a,$98,$9a,$c0,$c2 ;screenpositions of main instrument-settings
mainstrw .byte 3,1,5,7,4,2,6,8 ;place of data in instrument (for datawriter)

;bits of instrument controlbyte (0) - screen addresses,on/off values, display lengths 
conbits .byte $80            ,$40            ,4              ,8              ,8
conadhi .byte >($d800+$316)  ,>($d800+$24e)  ,>(vidram+$77)  ,>(vidram+$4e)  ,>(vidram+$4f)
conadlo .byte <($d800+$316)  ,<($d800+$24e)  ,<(vidram+$77)  ,<(vidram+$4e)  ,<(vidram+$4f)
conboff .byte inacol,     inacol,              $7F,           $69,           $69
conbons .byte 12,             12,              $79,           $68,           $69
condlen .byte 4,4,0,0,0

olypos	.byte 0,18,36 ;starting memory positions of orderlist rows

;upper border display data source- and screenpositions
posies  .byte 0+64*2+4,      0+64*2+5,      0+47,     <updispr+64*2+45, <updispr+46
memiel  .byte <(songtime+0), <(songtime+1), <actptn3, <actptn2,         <actptn1
ctuvm1	.byte <updispr+64+46,0+45              ,0+64+47

;PW/Cutoff meter scaler - range 0..32 to 0..24 and sort to rough/fine bitfields
scalecomp	.byte 11,21,32 ;range-positions for 32 to 24 pixel conversion
scalemask1	.byte $ff,$fe,$fc,$f8,$f8,$f0,$e0,$e0,$c0,$80,$80,$00 ;used to display PW/cutoff-meters
;scalemask2	.byte $ff,$fe,$fc,$fc,$f8,$f0,$f0,$e0,$c0,$80,$00,$00 ;used to display PW/cutoff-meters - SMOOTHER
OsciPixel .byte $20,$10,8,4,2,1,$80,$40,$20,$10,8,4 ;oscilloscope pixel ORs

.FI ; end of part only needed for editor

;===============================================================================
