set TASS=64tass.exe
set PACKER=exomizer.exe
set CBMDISK=c1541.exe
set SOURCEDIR=.\source
set BINARYDIR=..\binary
set EXASWMDIR=..\examples\modules
set EXASWIDIR=..\examples\instruments
set APPNAME1=SID-Wizard
set APPNAME2=SID-Maker
set SW-SOURCE=%APPNAME1%.asm
set SM-SOURCE=%APPNAME2%.asm
set SW-SPLASH-SOURCE=%APPNAME1%-splashed.asm
set SW-EXEC=%APPNAME1%.prg
set SM-EXEC=%APPNAME2%.prg
set SW-PACK=%APPNAME1%-packed.prg
set SM-PACK=%APPNAME2%-packed.prg
set SW-SPLASH=%APPNAME1%-splashed.prg
set SWL-SOURCE=%APPNAME1%-light.asm
set SML-SOURCE=%APPNAME2%-light.asm
set SWL-EXEC=%APPNAME1%-light.prg
set SML-EXEC=%APPNAME2%-light.prg
set SWL-PACK=%APPNAME1%-packed-light.prg
set SML-PACK=%APPNAME2%-packed-light.prg
set SWM-SOURCE=%APPNAME1%-medium.asm
set SMM-SOURCE=%APPNAME2%-medium.asm
set SWM-EXEC=%APPNAME1%-medium.prg
set SMM-EXEC=%APPNAME2%-medium.prg
set SWM-PACK=%APPNAME1%-packed-medium.prg
set SMM-PACK=%APPNAME2%-packed-medium.prg
set SWM-CONVERTER=SWMconvert
set CCOMPILER=gcc.exe
set APPDIR=C:\Windows

rem -----------------------------------

cd source

rem -------- full version -------------

%TASS% -o %BINARYDIR%\%SW-EXEC% %SW-SOURCE%
%PACKER% sfx sys -o %BINARYDIR%\%SW-PACK% %BINARYDIR%\%SW-EXEC% 
%TASS% -o %BINARYDIR%\%SW-SPLASH% %SW-SPLASH-SOURCE%

%TASS% -o %BINARYDIR%\%SM-EXEC% %SM-SOURCE%
%PACKER% sfx sys -o %BINARYDIR%\%SM-PACK% %BINARYDIR%\%SM-EXEC% 

%CBMDISK% -format "sid-wizard disk,hm" d64 %BINARYDIR%\%APPNAME1%.d64
%CBMDISK% -attach %BINARYDIR%\%APPNAME1%.d64 -write %BINARYDIR%\%SW-SPLASH% sid-wizard 
%CBMDISK% -attach %BINARYDIR%\%APPNAME1%.d64 -write %BINARYDIR%\%SM-PACK% sid-maker

rem -------- medium version ------------

%TASS% -o %BINARYDIR%\%SWM-EXEC% %SWM-SOURCE%
%PACKER% sfx sys -o %BINARYDIR%\%SWM-PACK% %BINARYDIR%\%SWM-EXEC% 

%TASS% -o %BINARYDIR%\%SMM-EXEC% %SMM-SOURCE%
%PACKER% sfx sys -o %BINARYDIR%\%SMM-PACK% %BINARYDIR%\%SMM-EXEC% 

%CBMDISK% -format "sidwizard medium,hm" d64 %BINARYDIR%\%APPNAME1%-medium.d64
%CBMDISK% -attach %BINARYDIR%\%APPNAME1%-medium.d64 -write %BINARYDIR%\%SWM-PACK% sidwizard-medium 
%CBMDISK% -attach %BINARYDIR%\%APPNAME1%-medium.d64 -write %BINARYDIR%\%SMM-PACK% sid-maker-medium

rem -------- light version ------------

%TASS% -o %BINARYDIR%\%SWL-EXEC% %SWL-SOURCE%
%PACKER% sfx sys -o %BINARYDIR%\%SWL-PACK% %BINARYDIR%\%SWL-EXEC% 

%TASS% -o %BINARYDIR%\%SML-EXEC% %SML-SOURCE%
%PACKER% sfx sys -o %BINARYDIR%\%SML-PACK% %BINARYDIR%\%SML-EXEC% 

%CBMDISK% -format "sid-wizard light,hm" d64 %BINARYDIR%\%APPNAME1%-light.d64
%CBMDISK% -attach %BINARYDIR%\%APPNAME1%-light.d64 -write %BINARYDIR%\%SWL-PACK% sid-wizard-light 
%CBMDISK% -attach %BINARYDIR%\%APPNAME1%-light.d64 -write %BINARYDIR%\%SML-PACK% sid-maker-light

rem -------- add content (example tunes and instruments) --------------

%CBMDISK% -attach %BINARYDIR%\%APPNAME1%.d64 -write %EXASWMDIR%\*.prg example.swm 
%CBMDISK% -attach %BINARYDIR%\%APPNAME1%.d64 -write %EXASWIDIR%\*.prg example.swi
COPY %EXASWMDIR%\*.P00 %BINARYDIR%
COPY %EXASWIDIR%\*.P00 %BINARYDIR%

rem -------- compile SWM-converter ---------------------------------

%CCOMPILER% %SWM-CONVERTER%.c -o %BINARYDIR%\%SWM-CONVERTER%.exe -lm
COPY %BINARYDIR%\%SWM-CONVERTER%.exe %APPDIR%

cd ..
