fil$ = COMMAND$
IF COMMAND$ = "" THEN
   PRINT "Converts a .KSM file to a .KDM file.                 by Kenneth Silverman"
   PRINT "Command line:"
   PRINT
   PRINT "   >convksm [source .KSM file (extension optional)]"
   PRINT
   PRINT "Converted .KDM file will be stored in same directory as source .KSM"
   PRINT "Once converted, you will be able to view the tracks in the KDM editor,"
   PRINT "but the instruments default to boring piano and drums since there's no"
   PRINT "good way to map them properly."
   END
END IF

FOR z% = 1 TO LEN(fil$)
   IF UCASE$(RIGHT$(fil$, 4)) = ".KSM" THEN fil$ = LEFT$(fil$, LEN(fil$) - 4)
NEXT z%
OPEN fil$ + ".ksm" FOR BINARY AS #1
OPEN fil$ + ".kdm" FOR BINARY AS #2

DIM note&(8192)
  
trinst$ = STRING$(16, 0): GET #1, , trinst$
trquant$ = STRING$(16, 0): GET #1, , trquant$
trchan$ = STRING$(16, 0): GET #1, , trchan$
trprio$ = STRING$(16, 0): GET #1, , trprio$
trvol$ = STRING$(16, 0): GET #1, , trvol$
GET #1, , numnotes%
note$ = STRING$(numnotes% * 4, 0): GET #1, , note$
FOR z% = 0 TO numnotes% - 1
   note&(z%) = CVL(MID$(note$, z% * 4 + 1, 4))
NEXT z%
  
kdmversionum$ = MKL$(0&): PUT #2, , kdmversionum$
numnotes$ = MKL$(numnotes%): PUT #2, , numnotes$
numtracks$ = MKL$(16&): PUT #2, , numtracks$

trinst2$ = STRING$(16, 0)
FOR z% = 0 TO 15
   dat% = ASC(MID$(trinst$, z% + 1, 1))
   IF dat% < 192 THEN
      MID$(trinst2$, z% + 1, 1) = CHR$(10)
   ELSE
      IF z% = 11 THEN MID$(trinst2$, z% + 1, 1) = CHR$(1)
      IF z% = 12 THEN MID$(trinst2$, z% + 1, 1) = CHR$(3)
      IF z% = 13 THEN MID$(trinst2$, z% + 1, 1) = CHR$(6)
      IF z% = 14 THEN MID$(trinst2$, z% + 1, 1) = CHR$(8)
      IF z% = 15 THEN MID$(trinst2$, z% + 1, 1) = CHR$(7)
   END IF
NEXT z%

trquant2$ = STRING$(16, 0)
FOR z% = 0 TO 15
   dat% = ASC(MID$(trquant$, z% + 1, 1))
   IF dat% > 60 THEN
      MID$(trquant2$, z% + 1, 1) = CHR$(60)
   ELSE
      MID$(trquant2$, z% + 1, 1) = CHR$(dat%)
   END IF
NEXT z%

PUT #2, , trinst2$
PUT #2, , trquant2$
PUT #2, , trvol$
PUT #2, , trvol$

z$ = STRING$(numnotes% * 4, 0)
FOR z% = 0 TO numnotes% - 1
   datrack% = ((note&(z%) \ 256) AND 15)
   quant& = (120 \ ASC(MID$(trquant2$, datrack% + 1, 1)))
   tim& = ((((note&(z%) \ 4096) \ 2) + (quant& \ 2)) \ quant&) * quant&
   MID$(z$, z% * 4 + 1, 4) = MKL$(tim&)
NEXT z%
PUT #2, , z$

nttrack$ = STRING$(numnotes%, 0): ntfreq$ = STRING$(numnotes%, 0)
ntvol1$ = STRING$(numnotes%, 0): ntvol2$ = STRING$(numnotes%, 0)
FOR z% = 0 TO numnotes% - 1
   MID$(nttrack$, z% + 1, 1) = CHR$((note&(z%) \ 256) AND 15)
   MID$(ntfreq$, z% + 1, 1) = CHR$(note&(z%) AND 63)
   vol& = ((note&(z%) \ 64) AND 3)
   SELECT CASE vol&
      CASE 0: davol& = 0
      CASE 1: davol& = 64
      CASE 2: davol& = 80
      CASE 3: davol& = 48
   END SELECT
   MID$(ntvol1$, z% + 1, 1) = CHR$(davol&)
   MID$(ntvol2$, z% + 1, 1) = CHR$(davol&)
NEXT z%
PUT #2, , nttrack$
PUT #2, , ntfreq$
PUT #2, , ntvol1$
PUT #2, , ntvol2$
z$ = STRING$(numnotes%, 0)
PUT #2, , z$
PUT #2, , z$

CLOSE #1
CLOSE #2

