#if 0 //compile at VC6 command prompt by typing: nmake rawplay.c
rawplay.exe: rawplay.obj adlibemu.obj
	link      rawplay.obj adlibemu.obj winmm.lib /opt:nowin98
	del rawplay.obj
rawplay.obj:  rawplay.c ; cl rawplay.c  /c /O1 /G6Fy /MD /nologo
adlibemu.obj: adlibemu.c; cl adlibemu.c /c /O1 /G6Fy /MD /nologo
!if 0
#endif

#define WIN32_LEAN_AND_MEAN
#include <windows.h>
#include <mmsystem.h>
#include <conio.h>
#include <stdio.h>
#include <stdlib.h>
#include <memory.h>

extern void adlibinit (long dasamplerate, long danumspeakers, long dabytespersample);
extern void adlib0 (long i, long v);
extern void adlibgetsample (void *sndptr, long numbytes);

static int format; //0=.DRO,1=.RAW,2=.IMF
static int pos, totleng, delay, opl3, speed;
static unsigned char *data = 0;

static void rendsynth (void *snd, int leng)
{
	int i;

	while (1)
	{
		i = min(delay,leng);
		if (i) { adlibgetsample(snd,i); snd = (void *)(((long)snd)+i); delay -= i; leng -= i; }
		if (!leng) return;

		if (pos >= totleng) { adlibgetsample(snd,leng); return; } //EOF

		switch(format)
		{
			case 0: //DRO
				i = data[pos++];
				switch(i)
				{
					case 0: delay = (((long)data[pos])+1)*88; pos++; break;
					case 1: delay = (((long)(*(unsigned short *)&data[pos]))+1)*88; pos += 2; break;
					case 2: case 3: break;
					default: adlib0(i,data[pos]); pos++; break;
				}
				break;
			case 1: //RAW
				while ((!delay) && (pos < totleng))
				{
					switch (data[pos+1])
					{
						case 0: delay = ((((long)data[pos])*speed)&~1); break;
						case 2: if (data[pos]) { opl3 = ((long)data[pos])-1; break; }
							  pos += 2;
							  i = (long)(*(unsigned short *)(&data[pos])); if (!i) i = 65535;
							  speed = (long)(((double)i)*(88200.0/1193180.0));
							  break;
						case 255: if (data[pos] == 255) pos = totleng; break;
						default: if (!opl3) adlib0(data[pos+1],data[pos]); break;
					}
					pos += 2;
				}
				break;
			case 2: //IMF (700hz)
				while ((!delay) && (pos < totleng))
				{
					adlib0(data[pos],data[pos+1]);
					delay = ((long)(*(short *)&data[pos+2]))*speed;
					pos += 4;
				}
				break;
		}
	}
}

//---------------------------------------------------------------
	//Simple Windows sound streaming code..
#define LBUFSIZE 12
static HWAVEOUT waveOutHand;
static WAVEHDR waveHdr;
static short sndbuf[4<<LBUFSIZE];
static void snd_init (int samprate)
{
	DWORD threadId;
	WAVEFORMATEX wfx;

	wfx.wFormatTag = WAVE_FORMAT_PCM;
	wfx.nChannels = 1;
	wfx.wBitsPerSample = 16;
	wfx.nBlockAlign = ((wfx.nChannels*wfx.wBitsPerSample)>>3);
	wfx.nSamplesPerSec = samprate;
	wfx.nAvgBytesPerSec = wfx.nSamplesPerSec*wfx.nBlockAlign;
	waveOutOpen(&waveOutHand,WAVE_MAPPER,&wfx,0,0,0);

	waveHdr.dwFlags = WHDR_BEGINLOOP|WHDR_ENDLOOP;
	waveHdr.lpData = (LPSTR)sndbuf;
	waveHdr.dwBufferLength = sizeof(sndbuf)/sizeof(sndbuf[0]);
	waveHdr.dwLoops = -1;
	waveOutPrepareHeader(waveOutHand,&waveHdr,sizeof(WAVEHDR));
	waveOutWrite(waveOutHand,&waveHdr,sizeof(WAVEHDR));
}
static int snd_ready (short **sptr)
{
	static int curblk = 0;
	MMTIME mmt;

	mmt.wType = TIME_BYTES; waveOutGetPosition(waveOutHand,&mmt,sizeof(MMTIME));
	if (((mmt.u.cb>>(LBUFSIZE+1))&1) == curblk) return(0);
	*sptr = &sndbuf[curblk<<LBUFSIZE]; curblk ^= 1;
	return(2<<LBUFSIZE);
}
//---------------------------------------------------------------

static void myexit (int i)
{
	printf("\nSmall OPL2 player by Ken Silverman (http://advsys.net/ken)\n");
	printf("Usage: RawPlay [RAW/DRO/IMF]\n");
	printf("Formats:\n");
	printf("   RAW: AdPlug format\n");
	printf("   DRO: DOSBox Raw OPL format\n");
	printf("   IMF: Id Music Format\n");
	exit(i);
}

int main (int argc, char **argv)
{
	FILE *fil;
	int i, mstot;
	short *sptr;
	char filnam[MAX_PATH], st[8], mode;

	filnam[0] = 0;
	for(i=1;i<argc;i++)
	{
		if ((argv[i][0] == '-') || (argv[i][0] == '/')) continue;
		strcpy(filnam,argv[i]);
	}
	if (!filnam[0]) myexit(1);

	fil = fopen(filnam,"rb"); if (!fil) { printf("File not found.\n"); myexit(2); }
	fread(st,8,1,fil);
	if (!memcmp(st,"DBRAWOPL",8))
	{
		format = 0;
		fread(&mstot,4,1,fil); //milliseconds in file
		fread(&totleng,4,1,fil);  //data bytes in file
		mode = fgetc(fil);     //0=ModeOPL2,1=ModeOPL3,2=ModeDUALOPL2
	}
	else if (!memcmp(st,"RAWADATA",8))
	{
		unsigned short s;
		format = 1; opl3 = 0;
		fread(&s,2,1,fil); if (!s) s = 65535;
		fseek(fil,0,SEEK_END); totleng = ftell(fil)-10;
		fseek(fil,10,SEEK_SET);
		speed = (long)(((double)s)*(88200.0/1193180.0));
	}
	else if ((strlen(filnam) >= 4) && (!stricmp(&filnam[strlen(filnam)-4],".IMF")))
	{
		format = 2;
		fseek(fil,0,SEEK_END); totleng = ftell(fil);
		fseek(fil,0,SEEK_SET);
		if (*(unsigned short *)&st[0] == totleng-2) //Hack for buggy IMF files
			{ fseek(fil,2,SEEK_SET); totleng -= 2; }
		speed = (88200/700)&~1; //???
	}
	else
	{
		fclose(fil);
		printf("No compatible headers found.\n"); myexit(3);
	}
	data = (unsigned char *)malloc(totleng); if (!data) { fclose(fil); printf("malloc failed.\n"); myexit(4); }
	fread(data,totleng,1,fil);
	fclose(fil);

	adlibinit(44100,1,2);
	adlib0(1,32); //OPL2 mode
	pos = 0; delay = 0;

	snd_init(44100);
	while (pos < totleng)
	{
		if (kbhit()) { i = getch(); if (i == 27) break; }
		if (i = snd_ready(&sptr)) rendsynth(sptr,i);
		if (totleng > 0) printf("\rPlaying %s (%d%%)",filnam,pos*100/totleng);
		Sleep(15);
	}

	if (data) { free(data); data = 0; }
	return(0);
}

#if 0
!endif
#endif
