DECLARE FUNCTION insertsprite% (sectnum%)
DECLARE SUB drawfacesprite (spritenum%)
DECLARE FUNCTION inside% (x&, y&, sectnum%)
DECLARE SUB getsector ()
DECLARE SUB show2dboard ()
DECLARE SUB convertboard (fil$)
DECLARE SUB vline (x&, y1&, y2&, siz&, picplc&, walnume%)
DECLARE SUB florscan (xb1&, xb2&, sectnum%)
DECLARE SUB ceilscan (xb1&, xb2&, sectnum%)
DECLARE SUB loadnewall (bufplc&, wallnum%)
DECLARE SUB hline (xl&, xr&, yp&, sectnum%)
DECLARE SUB setupscreen ()
DECLARE SUB checksector (ox&, oy&, nx&, ny&)
DECLARE FUNCTION intersect% (x1l1&, y1l1&, x2l1&, y2l1&, l%)
DECLARE FUNCTION front% (l1%, l2%)
DECLARE SUB drawall (z%)
DECLARE SUB loadboard ()
DECLARE SUB loadtables ()
DECLARE SUB show3dboard ()
DECLARE SUB addboxlinum (sectore%, walle%)
DECLARE SUB scansector (sectnum%)

CONST maxsector = 1024 \ 128
CONST maxwalls = 4096 \ 128
CONST maxsprites = 4096 \ 128
CONST maxtiles = 4096
CONST numpalookups = 32
CONST xdim = 320
CONST ydim = 200

TYPE sectortype
   wallptr AS INTEGER
   wallnum AS INTEGER
  
   cstat1 AS STRING * 1  '(Parallax, Groudraw)
   z1 AS INTEGER
   zosc1 AS STRING * 1
   picnum1 AS INTEGER
   heinum1 AS INTEGER
   shade1 AS STRING * 1
  
   cstat2 AS STRING * 1  '(Parallax, Groudraw)
   z2 AS INTEGER
   zosc2 AS STRING * 1
   picnum2 AS INTEGER
   heinum2 AS INTEGER
   shade2 AS STRING * 1
END TYPE

TYPE walltype
   x AS LONG
   y AS LONG
   point2 AS INTEGER
   cstat AS STRING * 1 '(Clip XOR)
   picnum AS INTEGER
   shade AS STRING * 1
   xrepeat AS STRING * 1
   yrepeat AS STRING * 1
   nextsector1 AS INTEGER
   nextwall1 AS INTEGER
   nextsector2 AS INTEGER
   nextwall2 AS INTEGER
END TYPE

TYPE spritetype
   x AS LONG
   y AS LONG
   x2offs AS INTEGER
   y2offs AS INTEGER
   point2 AS INTEGER
   cstat AS STRING * 1
   picnum AS INTEGER
   shade AS STRING * 1
   xrepeat AS STRING * 1
   yrepeat AS STRING * 1
   z AS INTEGER
END TYPE

DIM SHARED sector(maxsector) AS sectortype
DIM SHARED wall(maxwalls) AS walltype
DIM SHARED sprite(maxsprites) AS spritetype

DIM SHARED firstsprite%(maxsector), got%(maxsector)
DIM SHARED spritesectnum%(maxsprites), spriteused%(maxsprites)
DIM SHARED buf%(16384), palookup%(numpalookups, 256)
DIM SHARED tempbuf%(maxwalls), lastx&(201)
DIM SHARED picsiz%(maxtiles), picanm%(maxtiles)
DIM SHARED sintable&(2048), linum&(xdim)
DIM SHARED startumost%(xdim), startdmost%(xdim)
DIM SHARED umost%(xdim), dmost%(xdim), h&(xdim), uplc&(xdim), dplc&(xdim)
DIM SHARED xb1&(maxwalls), yb1&(maxwalls), xb2&(maxwalls), yb2&(maxwalls)
DIM SHARED thesector%(maxwalls), thewall%(maxwalls)
DIM SHARED llinum%(maxwalls), rlinum%(maxwalls)
DIM SHARED sdist&(xdim, 32), splc%(xdim, 32), scnt%(xdim)
COMMON SHARED numsectors%, numwalls%, numscans%, cursectnum%, numhits%
COMMON SHARED posx&, posy&, posz&, ang%

CALL loadtables
CALL loadboard
'CALL convertboard("boards2.dat")

CALL setupscreen
CALL loadnewall(0&, 2)
CALL loadnewall(4096&, 20)
CALL loadnewall(8192&, 40)
CALL loadnewall(12288&, 53)

pag% = 0: OUT &H3CD, pag%
DO
   
   LINE (0, 0)-(319, 199), 0, BF
   'CALL show2dboard
   CALL show3dboard
  
   OUT &H3D4, &HC: OUT &H3D5, pag% * 64
   pag% = 1 - pag%
   OUT &H3CD, pag%
  
   DO
      z$ = INKEY$
   LOOP WHILE z$ = ""
  
   oldposx& = posx&: oldposy& = posy&
   IF z$ = CHR$(0) + CHR$(72) THEN
      posx& = posx& + sintable&((ang% + 512) AND 2047) \ 64
      posy& = posy& + sintable&(ang% AND 2047) \ 64
   END IF
   IF z$ = CHR$(0) + CHR$(80) THEN
      posx& = posx& - sintable&((ang% + 512) AND 2047) \ 64
      posy& = posy& - sintable&(ang% AND 2047) \ 64
   END IF
   IF z$ = CHR$(0) + CHR$(75) THEN ang% = (ang% + 1984) AND 2047
   IF z$ = CHR$(0) + CHR$(77) THEN ang% = (ang% + 64) AND 2047
   IF z$ = "A" OR z$ = "a" THEN posz& = posz& - 4
   IF z$ = "Z" OR z$ = "z" THEN posz& = posz& + 4
LOOP WHILE z$ <> CHR$(27)

SUB addboxlinum (sectore%, walle%)
  
   x1& = wall(walle%).x - posx&
   y1& = wall(walle%).y - posy&
   x2& = wall(wall(walle%).point2).x - posx&
   y2& = wall(wall(walle%).point2).y - posy&

   xp1& = (y1& * sintable&((ang% + 512) AND 2047) - x1& * sintable&((ang% + 0) AND 2047)) \ 65536
   yp1& = (x1& * sintable&((ang% + 512) AND 2047) + y1& * sintable&((ang% + 0) AND 2047)) \ 65536
   xp2& = (y2& * sintable&((ang% + 512) AND 2047) - x2& * sintable&((ang% + 0) AND 2047)) \ 65536
   yp2& = (x2& * sintable&((ang% + 512) AND 2047) + y2& * sintable&((ang% + 0) AND 2047)) \ 65536
 
   IF yp1& > 0 AND yp2& > 0 AND ABS(xp1&) <= yp1& AND ABS(xp2&) <= yp2& THEN
      good% = 7
   ELSE
      good% = 7
      IF ((yp1& - yp2&) * xp1& > (xp1& - xp2&) * yp1&) THEN
         IF xp1& < -yp1& AND xp2& > -yp2& THEN good% = good% - 1
         IF xp1& < yp1& AND xp2& > yp2& THEN good% = good% - 2
      END IF
      IF good% = 7 THEN good% = 0
   END IF
 
   IF (good% > 0) THEN
      yb1&(numscans%) = -1
      yb2&(numscans%) = -1
      IF (good% < 7) THEN templong& = xp1& * yp2& - xp2& * yp1&
      IF ((good% AND 1) > 0) THEN
         xb1&(numscans%) = 160& + ((xp1& * 160&) \ yp1&)
         yb1&(numscans%) = yp1&
         llinum%(numscans%) = 0
      ELSE
         xb1&(numscans%) = 0
         templong1& = yp1& - yp2& - xp2& + xp1&
         IF templong1& = 0 THEN EXIT SUB
         yb1&(numscans%) = templong& \ templong1&
         
         xc& = ((160& - xb1&(numscans%)) * yb1&(numscans%)) \ 160&
         yc& = yb1&(numscans%)
         llinum%(numscans%) = (4095& * (ABS(xc& + xp1&) + ABS(yc& - yp1&))) \ (ABS(xp2& - xp1&) + ABS(yp2& - yp1&))
      END IF
      IF ((good% AND 2) > 0) THEN
         xb2&(numscans%) = 160& + ((xp2& * 160&) \ yp2&)
         yb2&(numscans%) = yp2&
         rlinum%(numscans%) = 4095
      ELSE
         xb2&(numscans%) = 319
         templong1& = yp2& - yp1& - xp2& + xp1&
         IF templong1& = 0 THEN EXIT SUB
         yb2&(numscans%) = templong& \ templong1&
      
         xc& = ((160& - xb2&(numscans%)) * yb2&(numscans%)) \ 160&
         yc& = yb2&(numscans%)
         rlinum%(numscans%) = (4095& * (ABS(xc& + xp1&) + ABS(yc& - yp1&))) \ (ABS(xp2& - xp1&) + ABS(yp2& - yp1&))
      END IF
      IF (yb1&(numscans%) > 0) AND (yb2&(numscans%) > 0) THEN
         IF (xb1&(numscans%) < xb2&(numscans%)) THEN
            thesector%(numscans%) = sectore%
            thewall%(numscans%) = walle%
            numscans% = numscans% + 1
         END IF
      END IF
   END IF
END SUB

SUB ceilscan (xb1&, xb2&, sectnum%)
   'umost[] as top, lowest of dmost[] and uplc[] as bottom

   FOR z% = 0 TO ydim
      lastx&(z%) = -1
   NEXT z%
   y1& = uplc&(xb1&): y2& = y1& - 1

   FOR x& = xb1& TO xb2&
      y1g& = umost%(x&)
      y2g& = uplc&(x&)
      IF y2g& < -1 THEN y2g& = -1
      IF y2g& > dmost%(x&) THEN y2g& = dmost%(x&)
   
      WHILE y1g& > y1&
         IF lastx&(y1& + 1) >= 0 THEN
            CALL hline(lastx&(y1& + 1), x& - 1, y1&, sectnum%)
            lastx&(y1& + 1) = -1
         END IF
         y1& = y1& + 1
      WEND
   
      WHILE y2g& < y2&
         IF lastx&(y2& + 1) >= 0 THEN
            CALL hline(lastx&(y2& + 1), x& - 1, y2&, sectnum%)
            lastx&(y2& + 1) = -1
         END IF
         y2& = y2& - 1
      WEND
  
      IF y1& > y2& + 1 THEN y1& = y2& + 1
      WHILE y1g& < y1&
         y1& = y1& - 1
         lastx&(y1& + 1) = x&
      WEND
      y1& = y1g&
  
      IF y1& > y2& + 1 THEN y2& = y1& - 1
      WHILE y2g& > y2&
         y2& = y2& + 1
         lastx&(y2& + 1) = x&
      WEND
      y2& = y2g&

   NEXT x&

   FOR y& = y1& TO y2&
      IF lastx&(y& + 1) >= 0 THEN
         CALL hline(lastx&(y& + 1), xb2&, y&, sectnum%)
         lastx&(y& + 1) = -1
      END IF
   NEXT y&

END SUB

SUB checksector (ox&, oy&, nx&, ny&)
   startwall% = sector(cursectnum%).wallptr
   endwall% = startwall% + sector(cursectnum%).wallnum - 1
   z% = startwall%
   lastwall% = -1
   WHILE z% <= endwall%
      IF wall(z%).nextsector1 >= 0 THEN
         IF intersect(ox&, oy&, nx&, ny&, z%) = 1 AND z% <> lastwall% THEN
            lastwall% = wall(z%).nextwall1
            cursectnum% = wall(z%).nextsector1
            startwall% = sector(cursectnum%).wallptr
            endwall% = startwall% + sector(cursectnum%).wallnum - 1
            z% = startwall% - 1
         END IF
      END IF
      z% = z% + 1
   WEND
END SUB

SUB deletesprite (spritetype%, spritenum%)
   REM hi
END SUB

SUB drawall (z%)
   wallnum% = thewall%(z%)
   sectnum% = thesector%(z%)
 
   top& = 0: topinc& = (rlinum%(z%) - llinum%(z%)) * yb1&(z%)
   bot& = (xb2&(z%) - xb1&(z%)) * yb2&(z%): botinc& = yb1&(z%) - yb2&(z%)
  
   yb1&(z%) = 524288 \ yb1&(z%)
   yb2&(z%) = 524288 \ yb2&(z%)
  
   IF yb1&(z%) > 16384& THEN yb1&(z%) = 16384&
   IF yb2&(z%) > 16384& THEN yb2&(z%) = 16384&

   hplc& = yb1&(z%): hinc& = (yb2&(z%) - yb1&(z%)) \ (xb2&(z%) - xb1&(z%))

   FOR x& = xb1&(z%) TO xb2&(z%)
      h&(x&) = hplc&: hplc& = hplc& + hinc&
      uplc&(x&) = 100 + (h&(x&) * (sector(sectnum%).z1 - posz&)) \ 1024
      dplc&(x&) = 100 + (h&(x&) * (sector(sectnum%).z2 - posz&)) \ 1024
      IF uplc&(x&) < umost%(x&) THEN uplc&(x&) = umost%(x&)
      IF uplc&(x&) > dmost%(x&) THEN uplc&(x&) = dmost%(x&)
      IF dplc&(x&) < umost%(x&) THEN dplc&(x&) = umost%(x&)
      IF dplc&(x&) > dmost%(x&) THEN dplc&(x&) = dmost%(x&)
     
      IF (bot& <> 0) THEN linum&(x&) = llinum%(z%) + (top& \ bot&)
      top& = top& + topinc&
      bot& = bot& + botinc&
      IF ((top& AND &HC0000000) <> 0) THEN
         top& = top& \ 2
         bot& = bot& \ 2
         topinc& = topinc& \ 2
         botinc& = botinc& \ 2
      END IF
   NEXT x&
  
   CALL ceilscan(xb1&(z%), xb2&(z%), sectnum%)
   CALL florscan(xb1&(z%), xb2&(z%), sectnum%)

   nextsectnum% = wall(wallnum%).nextsector1
  
   IF nextsectnum% = -1 THEN
      FOR x& = xb1&(z%) TO xb2&(z%)
         IF umost%(x&) <= dmost%(x&) THEN
            uplc&(x&) = 101 + (h&(x&) * (sector(sectnum%).z1 - posz&)) \ 1024
            dplc&(x&) = 99 + (h&(x&) * (sector(sectnum%).z2 - posz&)) \ 1024
            CALL vline(x&, uplc&(x&) * 65536, dplc&(x&) * 65536, h&(x&) * 32768, linum&(x&), wallnum%)
            umost%(x&) = ydim
            dmost%(x&) = 0
           
            sdist&(x&, scnt%(x&)) = -h&(x&)
            splc%(x&, scnt%(x&)) = -1
            scnt%(x&) = scnt%(x&) + 1

            numhits% = numhits% - 1
         END IF
      NEXT x&
   ELSE
      IF sector(nextsectnum%).z1 <= sector(sectnum%).z1 THEN
         dontbother% = 0
         IF sector(nextsectnum%).z1 = sector(sectnum%).z1 THEN dontbother% = 1
         FOR x& = xb1&(z%) TO xb2&(z%)
            IF umost%(x&) <= dmost%(x&) THEN
               IF uplc&(x&) > umost%(x&) THEN
                  umost%(x&) = uplc&(x&)
                  IF dontbother% = 0 THEN
                     sdist&(x&, scnt%(x&)) = h&(x&)
                     splc%(x&, scnt%(x&)) = umost%(x&)
                     scnt%(x&) = scnt%(x&) + 1
                  END IF
                  IF umost%(x&) > dmost%(x&) THEN numhits% = numhits% - 1
               END IF
            END IF
         NEXT x&
      ELSE
         FOR x& = xb1&(z%) TO xb2&(z%)
            IF umost%(x&) <= dmost%(x&) THEN
               y& = 99 + (h&(x&) * (sector(nextsectnum%).z1 - posz&)) \ 1024
          
               uplc&(x&) = 101 + (h&(x&) * (sector(sectnum%).z1 - posz&)) \ 1024
               CALL vline(x&, uplc&(x&) * 65536, y& * 65536, h&(x&) * 32768, linum&(x&), wallnum%)
          
               IF y& > dmost%(x&) THEN y& = dmost%(x&)
               IF y& > umost%(x&) THEN
                  umost%(x&) = y&
                
                  sdist&(x&, scnt%(x&)) = h&(x&)
                  splc%(x&, scnt%(x&)) = umost%(x&)
                  scnt%(x&) = scnt%(x&) + 1

                  IF umost%(x&) > dmost%(x&) THEN numhits% = numhits% - 1
               END IF
            END IF
         NEXT x&
      END IF
      IF sector(nextsectnum%).z2 >= sector(sectnum%).z2 THEN
         dontbother% = 0
         IF sector(nextsectnum%).z2 = sector(sectnum%).z2 THEN dontbother% = 1
         FOR x& = xb1&(z%) TO xb2&(z%)
            IF umost%(x&) <= dmost%(x&) THEN
               IF dplc&(x&) < dmost%(x&) THEN
                  dmost%(x&) = dplc&(x&)
                  IF dontbother% = 0 THEN
                     sdist&(x&, scnt%(x&)) = -h&(x&)
                     splc%(x&, scnt%(x&)) = dmost%(x&)
                     scnt%(x&) = scnt%(x&) + 1
                  END IF
                  IF umost%(x&) > dmost%(x&) THEN numhits% = numhits% - 1
               END IF
            END IF
         NEXT x&
      ELSE
         FOR x& = xb1&(z%) TO xb2&(z%)
            IF umost%(x&) <= dmost%(x&) THEN
               y& = 101 + (h&(x&) * (sector(nextsectnum%).z2 - posz&)) \ 1024
          
               dplc&(x&) = 99 + (h&(x&) * (sector(sectnum%).z2 - posz&)) \ 1024
               CALL vline(x&, y& * 65536, dplc&(x&) * 65536, h&(x&) * 32768, linum&(x&), wallnum%)
             
               IF y& < umost%(x&) THEN y& = umost%(x&)
               IF y& < dmost%(x&) THEN
                  dmost%(x&) = y&
                 
                  sdist&(x&, scnt%(x&)) = -h&(x&)
                  splc%(x&, scnt%(x&)) = dmost%(x&)
                  scnt%(x&) = scnt%(x&) + 1
                 
                  IF umost%(x&) > dmost%(x&) THEN numhits% = numhits% - 1
               END IF
            END IF
         NEXT x&
      END IF
   END IF
     
   IF numhits% <= 0 THEN EXIT SUB

   xb1bak& = xb1&(z%)
   xb2bak& = xb2&(z%)

   numscans% = numscans% - 1
   IF z% <> numscans% THEN
      xb1&(z%) = xb1&(numscans%)
      yb1&(z%) = yb1&(numscans%)
      xb2&(z%) = xb2&(numscans%)
      yb2&(z%) = yb2&(numscans%)
      llinum%(z%) = llinum%(numscans%)
      rlinum%(z%) = rlinum%(numscans%)
      thesector%(z%) = thesector%(numscans%)
      thewall%(z%) = thewall%(numscans%)
   END IF

   IF nextsectnum% >= 0 THEN
      IF got%(nextsectnum%) = 0 THEN
         FOR x& = xb1bak& TO xb2bak&
            IF umost%(x&) < dmost%(x&) THEN
               CALL scansector(nextsectnum%)
               EXIT FOR
            END IF
         NEXT x&
      END IF
   END IF
END SUB

SUB drawfacesprite (s%)
   xs& = sprite(s%).x - posx&
   ys& = sprite(s%).y - posy&

   xp& = (ys& * sintable&((ang% + 512) AND 2047) - xs& * sintable&((ang% + 0) AND 2047)) \ 65536
   yp& = (xs& * sintable&((ang% + 512) AND 2047) + ys& * sintable&((ang% + 0) AND 2047)) \ 65536
        
   xb& = 160& + ((xp& * 160&) \ yp&)
   siz& = 524288 \ yp&
   yb& = 100& + (siz& * (sprite(s%).z - posz&)) \ 1024

   x1& = xb& - siz& \ 32: x2& = x1& + siz& \ 16
   y1& = yb& - siz& \ 32: y2& = y1& + siz& \ 16

   lx% = x1&: IF lx% < 0 THEN lx% = 0
   rx% = x2&: IF rx% >= ydim THEN rx% = ydim - 1
 
   shade% = yp& \ 128&
   IF shade% < 0 THEN shade% = 0
   IF shade% >= numpalookups THEN shade% = numpalookups - 1
  
   FOR x& = lx% TO rx%
      um% = y1&: IF startumost%(x&) > y1& THEN y1& = startumost%(x&)
      dm% = y2&: IF startdmost%(x&) < y2& THEN y2& = startdmost%(x&)
      das% = 0
      WHILE siz& < ABS(sdist&(x&, das%)) AND das% < scnt%(x&)
         IF sdist&(x&, das%) > 0 THEN
            IF splc%(x&, das%) > um% THEN um% = splc%(x&, das%)
         ELSE
            IF splc%(x&, das%) < dm% THEN dm% = splc%(x&, das%)
         END IF
         das% = das% + 1
      WEND
      IF um% < dm% THEN
         linum& = (((x& - x1&) * 4095) \ (x2& - x1&)) AND &HFC0
         bufplc& = 12288& + linum&
         yplc& = ((um% - y1&) * 63 * 4096&) \ (y2& - y1&)
         yinc& = ((dm% - y1&) * 63 * 4096&) \ (y2& - y1&)
         yinc& = (yinc& - yplc&) \ (dm% - um%)
         p& = um% * 320& + x&: DEF SEG = &HA000
         FOR y& = um% TO dm%
            dat% = buf%(bufplc& + yplc& \ 4096)
            IF dat% <> 255 THEN POKE p&, palookup%(shade%, dat%)
            p& = p& + 320
            yplc& = yplc& + yinc&
         NEXT y&
      END IF
   NEXT x&
END SUB

SUB florscan (xb1&, xb2&, sectnum%)
   'dmost[] as bottom, highest of umost[] and dplc[] as bottom

   FOR z% = 0 TO ydim
      lastx&(z%) = -1
   NEXT z%
   y2& = dplc&(xb1&)
   IF y2& < 1 THEN y2& = 1
   y1& = y2& + 1

   FOR x& = xb1& TO xb2&
      y2g& = dmost%(x&)
      y1g& = dplc&(x&)
      IF y1g& < umost%(x&) THEN y1g& = umost%(x&)
  
      WHILE y1g& > y1&
         IF lastx&(y1& + 1) >= 0 THEN
            CALL hline(lastx&(y1& + 1), x& - 1, y1&, sectnum%)
            lastx&(y1& + 1) = -1
         END IF
         y1& = y1& + 1
      WEND
  
      WHILE y2g& < y2&
         IF lastx&(y2& + 1) >= 0 THEN
            CALL hline(lastx&(y2& + 1), x& - 1, y2&, sectnum%)
            lastx&(y2& + 1) = -1
         END IF
         y2& = y2& - 1
      WEND
 
      IF y1& > y2& + 1 THEN y1& = y2& + 1
      WHILE y1g& < y1&
         y1& = y1& - 1
         lastx&(y1& + 1) = x&
      WEND
      y1& = y1g&
 
      IF y1& > y2& + 1 THEN y2& = y1& - 1
      WHILE y2g& > y2&
         y2& = y2& + 1
         lastx&(y2& + 1) = x&
      WEND
      y2& = y2g&

   NEXT x&

   FOR y& = y1& TO y2&
      IF lastx&(y& + 1) >= 0 THEN
         CALL hline(lastx&(y& + 1), xb2&, y&, sectnum%)
         lastx&(y& + 1) = -1
      END IF
   NEXT y&

END SUB

FUNCTION front% (l1%, l2%)
 
   x1l1& = wall(thewall%(l1%)).x
   y1l1& = wall(thewall%(l1%)).y
   x2l1& = wall(wall(thewall%(l1%)).point2).x
   y2l1& = wall(wall(thewall%(l1%)).point2).y
   x1l2& = wall(thewall%(l2%)).x
   y1l2& = wall(thewall%(l2%)).y
   x2l2& = wall(wall(thewall%(l2%)).point2).x
   y2l2& = wall(wall(thewall%(l2%)).point2).y

   templong1& = (x1l2& - x1l1&) * (y2l1& - y1l1&) - (x2l1& - x1l1&) * (y1l2& - y1l1&)    'p1(l2) vs. l1
   templong2& = (x2l2& - x1l1&) * (y2l1& - y1l1&) - (x2l1& - x1l1&) * (y2l2& - y1l1&)    'p2(l2) vs. l1
   IF templong1& = 0 THEN templong1& = templong2&
   IF templong2& = 0 THEN templong2& = templong1&
   IF (templong1& < 0) = (templong2& < 0) THEN
      templong0& = (posx& - x1l1&) * (y2l1& - y1l1&) - (x2l1& - x1l1&) * (posy& - y1l1&) 'pos vs. l1
      IF (templong1& < 0) = (templong0& < 0) THEN front% = l2% ELSE front% = l1%
      EXIT FUNCTION
   END IF

   templong1& = (x1l1& - x1l2&) * (y2l2& - y1l2&) - (x2l2& - x1l2&) * (y1l1& - y1l2&)     'p1(l1) vs. l2
   templong2& = (x2l1& - x1l2&) * (y2l2& - y1l2&) - (x2l2& - x1l2&) * (y2l1& - y1l2&)     'p2(l1) vs. l2
   IF templong1& = 0 THEN templong1& = templong2&
   IF templong2& = 0 THEN templong2& = templong1&
   IF (templong1& < 0) = (templong2& < 0) THEN
      templong0& = (posx& - x1l2&) * (y2l2& - y1l2&) - (x2l2& - x1l2&) * (posy& - y1l2&)  'pos vs. l2
      IF (templong1& < 0) = (templong0& < 0) THEN front% = l1% ELSE front% = l2%
      EXIT FUNCTION
   END IF

   front% = -2: EXIT FUNCTION
 
END FUNCTION

SUB getsector
   IF inside%(posx&, posy&, cursectnum%) = 0 THEN
      FOR z% = 0 TO numsectors% - 1
         IF inside%(posx&, posy&, z%) = 1 THEN
            cursectnum% = z%
            EXIT SUB
         END IF
      NEXT z%
   END IF
END SUB

SUB hline (xl&, xr&, yp&, sectnum%)
   IF ((yp& = ydim \ 2) OR (picsiz%(walnume%) = 0)) THEN EXIT SUB
   IF xl& > xr& THEN SWAP xl&, xr&
   siz& = xr& - xl& + 1
  
   IF yp& < (ydim \ 2) THEN
      zd& = (sector(sectnum%).z1 - posz&) * 256&
      bufplc& = 0& 'sector(sectnum%).picnum1
   ELSE
      zd& = (posz& - sector(sectnum%).z2) * 256&
      bufplc& = 4096& 'sector(sectnum%).picnum2
   END IF

   hd& = (zd& * 16384&) \ (xdim * ABS(ydim \ 2 - yp&))
   IF ABS(hd&) > 131072 THEN EXIT SUB
   xc& = (hd& * sintable&((2048 + ang%) AND 2047)) \ 1024&
   yc& = (hd& * sintable&((2560 + ang%) AND 2047)) \ 1024&
   x& = xc& * xl& - (xc& + yc&) * (xdim \ 2) + (posx& * 16384&)
   y& = yc& * xl& + (xc& - yc&) * (xdim \ 2) - (posy& * 16384&)
   IF yp& > (ydim \ 2) THEN
      y& = y& XOR &HFFFFFFFF
      yc& = yc& XOR &HFFFFFFFF
   END IF
 
   shade% = ABS(hd&) \ 4096&
   IF shade% < 0 THEN shade% = 0
   IF shade% >= numpalookups THEN shade% = numpalookups - 1
    
   pscr& = yp& * 320& + xl&: DEF SEG = &HA000
  
   FOR zx& = 1 TO siz&
      POKE pscr&, palookup%(shade%, buf%(((x& \ 262144) AND 63) * 64& + ((y& \ 262144) AND 63) + bufplc&))
      pscr& = pscr& + 1
      x& = x& + xc&
      y& = y& + yc&
   NEXT zx&
END SUB

FUNCTION insertsprite% (sectnum%)
   z% = 0
   WHILE spriteused%(z%) <> 0
      z% = z% + 1
   WEND
   spriteused%(z%) = 1
   sprite(z%).point2 = firstsprite%(sectnum%)
   firstsprite%(sectnum%) = z%
   insertsprite% = z%
END FUNCTION

FUNCTION inside% (x&, y&, sectnum%)
   cnt% = 0
   startwall% = sector(sectnum%).wallptr
   endwall% = startwall% + sector(sectnum%).wallnum - 1

   FOR z% = startwall% TO endwall%
      x1& = wall(z%).x: x2& = wall(wall(z%).point2).x
      IF (x1& >= x& OR x2& >= x&) THEN
         y1& = wall(z%).y: y2& = wall(wall(z%).point2).y
         IF y1& > y2& THEN SWAP x1&, x2&: SWAP y1&, y2&
         IF (y1& <= y& AND y2& > y&) THEN
            IF x1& * (y& - y2&) + x2& * (y1& - y&) <= x& * (y1& - y2&) THEN cnt% = 1 - cnt%
         END IF
      END IF
   NEXT z%
   inside% = cnt%
END FUNCTION

FUNCTION intersect% (x1l1&, y1l1&, x2l1&, y2l1&, l%)

   x1l2& = wall(l%).x
   y1l2& = wall(l%).y
   x2l2& = wall(wall(l%).point2).x
   y2l2& = wall(wall(l%).point2).y

   value% = 0

   IF (x1l1& < x2l1&) = (x2l1& < x2l1&) THEN
      IF (x1l1& < x2l2&) = (x2l1& < x2l2&) THEN
         IF (x1l1& < x2l1&) = (x1l1& < x2l2&) THEN
            IF (y1l1& < y2l1&) = (y2l1& < y2l1&) THEN
               IF (y1l1& < y2l2&) = (y2l1& < y2l2&) THEN
                  IF (y1l1& < y2l1&) = (y1l1& < y2l2&) THEN
                     value% = -1
                  END IF
               END IF
            END IF
         END IF
      END IF
   END IF
  
   IF value% = 0 THEN
      templong1& = (x1l2& - x1l1&) * (y2l1& - y1l1&) - (x2l1& - x1l1&) * (y1l2& - y1l1&)    'p1(l2) vs. l1
      templong2& = (x2l2& - x1l1&) * (y2l1& - y1l1&) - (x2l1& - x1l1&) * (y2l2& - y1l1&)    'p2(l2) vs. l1
      IF (templong1& < 0) = (templong2& < 0) THEN value% = -1
      IF templong1& = 0 OR templong2& = 0 THEN value% = 0
   END IF

   IF value% = 0 THEN
      templong1& = (x1l1& - x1l2&) * (y2l2& - y1l2&) - (x2l2& - x1l2&) * (y1l1& - y1l2&)     'p1(l1) vs. l2
      templong2& = (x2l1& - x1l2&) * (y2l2& - y1l2&) - (x2l2& - x1l2&) * (y2l1& - y1l2&)     'p2(l1) vs. l2
      IF (templong1& < 0) = (templong2& < 0) THEN value% = -1
      IF templong1& = 0 OR templong2& = 0 THEN value% = 0
   END IF

   IF value% >= 0 THEN
      templong2& = (x2l1& - x1l2&) * (y2l2& - y1l2&) - (x2l2& - x1l2&) * (y2l1& - y1l2&)     'p2(l1) vs. l2
      IF templong2& >= 0 THEN value% = 1 ELSE value% = 2
   END IF

   intersect% = value%

END FUNCTION

SUB loadboard
   numsectors% = 3
   numwalls% = 20
   numsprites% = 1

   cursectnum% = 1
   posx& = 4608
   posy& = 512
   posz& = 0
   ang% = 1024

   sector(0).wallptr = 0
   sector(0).wallnum = 6
   sector(0).cstat1 = CHR$(0)
   sector(0).z1 = -32
   sector(0).zosc1 = CHR$(0)
   sector(0).picnum1 = 9
   sector(0).heinum1 = 0
   sector(0).shade1 = CHR$(0)
   sector(0).cstat2 = CHR$(0)
   sector(0).z2 = 32
   sector(0).zosc2 = CHR$(0)
   sector(0).picnum2 = 10
   sector(0).heinum2 = 0
   sector(0).shade2 = CHR$(0)

   sector(1).wallptr = 6
   sector(1).wallnum = 11
   sector(1).cstat1 = CHR$(0)
   sector(1).z1 = -48
   sector(1).zosc1 = CHR$(0)
   sector(1).picnum1 = 11
   sector(1).heinum1 = 0
   sector(1).shade1 = CHR$(0)
   sector(1).cstat2 = CHR$(0)
   sector(1).z2 = 48
   sector(1).zosc2 = CHR$(0)
   sector(1).picnum2 = 12
   sector(1).heinum2 = 0
   sector(1).shade2 = CHR$(0)

   sector(2).wallptr = 17
   sector(2).wallnum = 3
   sector(2).cstat1 = CHR$(0)
   sector(2).z1 = -48
   sector(2).zosc1 = CHR$(0)
   sector(2).picnum1 = 13
   sector(2).heinum1 = 0
   sector(2).shade1 = CHR$(0)
   sector(2).cstat2 = CHR$(0)
   sector(2).z2 = 20
   sector(2).zosc2 = CHR$(0)
   sector(2).picnum2 = 6
   sector(2).heinum2 = 0
   sector(2).shade2 = CHR$(0)

   wall(0).x = 0: wall(0).y = 2048: wall(0).point2 = 1
   wall(0).cstat = CHR$(0)
   wall(0).picnum = 15: wall(0).shade = CHR$(0)
   wall(0).xrepeat = CHR$(8): wall(0).yrepeat = CHR$(8)
   wall(0).nextsector1 = -1: wall(0).nextwall1 = -1
   wall(0).nextsector2 = -1: wall(0).nextwall2 = -1
 
   wall(1).x = 0: wall(1).y = 1024: wall(1).point2 = 2
   wall(1).cstat = CHR$(0)
   wall(1).picnum = 15: wall(1).shade = CHR$(0)
   wall(1).xrepeat = CHR$(8): wall(1).yrepeat = CHR$(8)
   wall(1).nextsector1 = -1: wall(1).nextwall1 = -1
   wall(1).nextsector2 = -1: wall(1).nextwall2 = -1

   wall(2).x = 1024: wall(2).y = 0: wall(2).point2 = 3
   wall(2).cstat = CHR$(0)
   wall(2).picnum = 15: wall(2).shade = CHR$(0)
   wall(2).xrepeat = CHR$(8): wall(2).yrepeat = CHR$(8)
   wall(2).nextsector1 = -1: wall(2).nextwall1 = -1
   wall(2).nextsector2 = -1: wall(2).nextwall2 = -1

   wall(3).x = 3072: wall(3).y = 0: wall(3).point2 = 4
   wall(3).cstat = CHR$(0)
   wall(3).picnum = 15: wall(3).shade = CHR$(0)
   wall(3).xrepeat = CHR$(8): wall(3).yrepeat = CHR$(8)
   wall(3).nextsector1 = 1: wall(3).nextwall1 = 8
   wall(3).nextsector2 = -1: wall(3).nextwall2 = -1

   wall(4).x = 3072: wall(4).y = 1024: wall(4).point2 = 5
   wall(4).cstat = CHR$(0)
   wall(4).picnum = 15: wall(4).shade = CHR$(0)
   wall(4).xrepeat = CHR$(8): wall(4).yrepeat = CHR$(8)
   wall(4).nextsector1 = -1: wall(4).nextwall1 = -1
   wall(4).nextsector2 = -1: wall(4).nextwall2 = -1

   wall(5).x = 2048: wall(5).y = 2048: wall(5).point2 = 0
   wall(5).cstat = CHR$(0)
   wall(5).picnum = 15: wall(5).shade = CHR$(0)
   wall(5).xrepeat = CHR$(8): wall(5).yrepeat = CHR$(8)
   wall(5).nextsector1 = -1: wall(5).nextwall1 = -1
   wall(5).nextsector2 = -1: wall(5).nextwall2 = -1

   wall(6).x = 2048: wall(6).y = 3072: wall(6).point2 = 7
   wall(6).cstat = CHR$(0)
   wall(6).picnum = 14: wall(6).shade = CHR$(0)
   wall(6).xrepeat = CHR$(23): wall(6).yrepeat = CHR$(8)
   wall(6).nextsector1 = -1: wall(6).nextwall1 = -1
   wall(6).nextsector2 = -1: wall(6).nextwall2 = -1

   wall(7).x = 4096: wall(7).y = 1024: wall(7).point2 = 8
   wall(7).cstat = CHR$(0)
   wall(7).picnum = 14: wall(7).shade = CHR$(0)
   wall(7).xrepeat = CHR$(8): wall(7).yrepeat = CHR$(8)
   wall(7).nextsector1 = -1: wall(7).nextwall1 = -1
   wall(7).nextsector2 = -1: wall(7).nextwall2 = -1

   wall(8).x = 3072: wall(8).y = 1024: wall(8).point2 = 9
   wall(8).cstat = CHR$(0)
   wall(8).picnum = 14: wall(8).shade = CHR$(0)
   wall(8).xrepeat = CHR$(8): wall(8).yrepeat = CHR$(8)
   wall(8).nextsector1 = 0: wall(8).nextwall1 = 3
   wall(8).nextsector2 = -1: wall(8).nextwall2 = -1

   wall(9).x = 3072: wall(9).y = 0: wall(9).point2 = 10
   wall(9).cstat = CHR$(0)
   wall(9).picnum = 14: wall(9).shade = CHR$(0)
   wall(9).xrepeat = CHR$(16): wall(9).yrepeat = CHR$(8)
   wall(9).nextsector1 = -1: wall(9).nextwall1 = -1
   wall(9).nextsector2 = -1: wall(9).nextwall2 = -1

   wall(10).x = 5120: wall(10).y = 0: wall(10).point2 = 11
   wall(10).cstat = CHR$(0)
   wall(10).picnum = 14: wall(10).shade = CHR$(0)
   wall(10).xrepeat = CHR$(32): wall(10).yrepeat = CHR$(8)
   wall(10).nextsector1 = -1: wall(10).nextwall1 = -1
   wall(10).nextsector2 = -1: wall(10).nextwall2 = -1

   wall(11).x = 5120: wall(11).y = 4096: wall(11).point2 = 12
   wall(11).cstat = CHR$(0)
   wall(11).picnum = 14: wall(11).shade = CHR$(0)
   wall(11).xrepeat = CHR$(40): wall(11).yrepeat = CHR$(8)
   wall(11).nextsector1 = -1: wall(11).nextwall1 = -1
   wall(11).nextsector2 = -1: wall(11).nextwall2 = -1

   wall(12).x = 0: wall(12).y = 4096: wall(12).point2 = 13
   wall(12).cstat = CHR$(0)
   wall(12).picnum = 14: wall(12).shade = CHR$(0)
   wall(12).xrepeat = CHR$(8): wall(12).yrepeat = CHR$(8)
   wall(12).nextsector1 = -1: wall(12).nextwall1 = -1
   wall(12).nextsector2 = -1: wall(12).nextwall2 = -1

   wall(13).x = 0: wall(13).y = 3072: wall(13).point2 = 6
   wall(13).cstat = CHR$(0)
   wall(13).picnum = 14: wall(13).shade = CHR$(0)
   wall(13).xrepeat = CHR$(16): wall(13).yrepeat = CHR$(8)
   wall(13).nextsector1 = -1: wall(13).nextwall1 = -1
   wall(13).nextsector2 = -1: wall(13).nextwall2 = -1

   wall(14).x = 3072: wall(14).y = 3072: wall(14).point2 = 15
   wall(14).cstat = CHR$(0)
   wall(14).picnum = 14: wall(14).shade = CHR$(0)
   wall(14).xrepeat = CHR$(8): wall(14).yrepeat = CHR$(8)
   wall(14).nextsector1 = 2: wall(14).nextwall1 = 18
   wall(14).nextsector2 = -1: wall(14).nextwall2 = -1

   wall(15).x = 4096: wall(15).y = 3072: wall(15).point2 = 16
   wall(15).cstat = CHR$(0)
   wall(15).picnum = 14: wall(15).shade = CHR$(0)
   wall(15).xrepeat = CHR$(8): wall(15).yrepeat = CHR$(8)
   wall(15).nextsector1 = 2: wall(15).nextwall1 = 17
   wall(15).nextsector2 = -1: wall(15).nextwall2 = -1

   wall(16).x = 4096: wall(16).y = 2048: wall(16).point2 = 14
   wall(16).cstat = CHR$(0)
   wall(16).picnum = 14: wall(16).shade = CHR$(0)
   wall(16).xrepeat = CHR$(8): wall(16).yrepeat = CHR$(8)
   wall(16).nextsector1 = 2: wall(16).nextwall1 = 19
   wall(16).nextsector2 = -1: wall(16).nextwall2 = -1

   wall(17).x = 4096: wall(17).y = 2048: wall(17).point2 = 18
   wall(17).cstat = CHR$(0)
   wall(17).picnum = 13: wall(17).shade = CHR$(0)
   wall(17).xrepeat = CHR$(8): wall(17).yrepeat = CHR$(8)
   wall(17).nextsector1 = 1: wall(17).nextwall1 = 15
   wall(17).nextsector2 = -1: wall(17).nextwall2 = -1

   wall(18).x = 4096: wall(18).y = 3072: wall(18).point2 = 19
   wall(18).cstat = CHR$(0)
   wall(18).picnum = 13: wall(18).shade = CHR$(0)
   wall(18).xrepeat = CHR$(8): wall(18).yrepeat = CHR$(8)
   wall(18).nextsector1 = 1: wall(18).nextwall1 = 14
   wall(18).nextsector2 = -1: wall(18).nextwall2 = -1

   wall(19).x = 3072: wall(19).y = 3072: wall(19).point2 = 17
   wall(19).cstat = CHR$(0)
   wall(19).picnum = 13: wall(19).shade = CHR$(19)
   wall(19).xrepeat = CHR$(8): wall(19).yrepeat = CHR$(8)
   wall(19).nextsector1 = 1: wall(19).nextwall1 = 16
   wall(19).nextsector2 = -1: wall(19).nextwall2 = -1

   FOR z% = 0 TO numsectors% - 1
      firstsprite%(z%) = -1
   NEXT z%

   FOR z% = 0 TO maxsprites - 1
      spritesectnum%(z%) = -1
      spriteused%(z%) = 0
   NEXT z%
  
   spritesectnum%(0) = 0   'ex: read(fil,&spritesectnum,numsprites)
  
   z% = insertsprite(spritesectnum%(0))
   sprite(z%).x = 2048: sprite(z%).y = 1024
   sprite(z%).x2offs = 0: sprite(z%).y2offs = 0
   sprite(z%).cstat = CHR$(0)
   sprite(z%).picnum = 15: sprite(z%).shade = CHR$(0)
   sprite(z%).xrepeat = CHR$(8): sprite(z%).yrepeat = CHR$(8)
   sprite(z%).z = 0

END SUB

SUB loadnewall (bufplc&, wallnum%)
   OPEN "pics.dat" FOR BINARY AS #1

   SEEK #1, 1
   buf$ = STRING$(maxtiles, 0)
   GET #1, , buf$
   FOR z% = 0 TO maxtiles - 1
      picsiz%(z%) = ASC(MID$(buf$, z% + 1, 1))
   NEXT z%
   buf$ = STRING$(maxtiles, 0)
   GET #1, , buf$
   FOR z% = 0 TO maxtiles - 1
      picanm%(z%) = ASC(MID$(buf$, z% + 1, 1))
   NEXT z%

   totsiz& = 0
   FOR z% = 0 TO wallnum% - 1
      IF picsiz%(z%) > 0 THEN totsiz& = totsiz& + 2 ^ ((picsiz%(z%) AND 15) + (picsiz%(z%) \ 16))
   NEXT z%
   SEEK #1, totsiz& + maxtiles * 2 + 1

   buf$ = STRING$(4096, 0)
   GET #1, , buf$
   DEF SEG = VARSEG(buf$)
   offs& = SADD(buf$)
   FOR z% = 0 TO 63
      FOR zz% = 0 TO 63
         buf%(bufplc& + z% * 64 + zz%) = PEEK(offs&): offs& = offs& + 1
      NEXT zz%
   NEXT z%
   asksave% = 0
   CLOSE #1
END SUB

SUB loadtables
   FOR z& = 0 TO 511
      sintable&(z&) = 16384& * SIN(z& * 3.141592 / 1024)
   NEXT z&
   FOR z& = 512 TO 1023
      sintable&(z&) = sintable&(1023 - z&)
   NEXT z&
   FOR z& = 1024 TO 2047
      sintable&(z&) = -sintable&(z& - 1024)
   NEXT z&
END SUB

SUB scansector (sectnum%)
   got%(sectnum%) = 1
   startwall% = sector(sectnum%).wallptr
   endwall% = startwall% + sector(sectnum%).wallnum - 1
   FOR z% = startwall% TO endwall%
      CALL addboxlinum(sectnum%, z%)
   NEXT z%
END SUB

SUB setupscreen
   SCREEN 13
   OPEN "palette.dat" FOR BINARY AS #1
   pal$ = STRING$(768, 0)
   GET #1, , pal$
   OUT &H3C8, 0
   FOR z% = 1 TO 768
      OUT &H3C9, ASC(MID$(pal$, z%, 1))
   NEXT z%
   pal$ = STRING$(256, 0)
   FOR z% = 0 TO numpalookups
      GET #1, , pal$
      FOR zz% = 0 TO 255
         palookup%(z%, zz%) = ASC(MID$(pal$, zz% + 1, 1))
      NEXT zz%
   NEXT z%
   CLOSE #1

   FOR z% = 0 TO xdim - 1
      startumost%(z%) = -1
      startdmost%(z%) = ydim
   NEXT z%

END SUB

SUB show2dboard
   FOR z% = 0 TO numsectors% - 1
      startwall% = sector(z%).wallptr
      endwall% = startwall% + sector(z%).wallnum - 1
      FOR zz% = startwall% TO endwall%
         IF wall(zz%).nextsector1 = -1 AND wall(zz%).nextsector2 = -1 THEN
            LINE (xdim \ 2 + (wall(zz%).x - posx&) \ 32, ydim \ 2 + (wall(zz%).y - posy&) \ 32)-(xdim \ 2 + (wall(wall(zz%).point2).x - posx&) \ 32, ydim \ 2 + (wall(wall(zz%).point2).y - posy&) \ 32), 31
         ELSE
            LINE (xdim \ 2 + (wall(zz%).x - posx&) \ 32, ydim \ 2 + (wall(zz%).y - posy&) \ 32)-(xdim \ 2 + (wall(wall(zz%).point2).x - posx&) \ 32, ydim \ 2 + (wall(wall(zz%).point2).y - posy&) \ 32), 120
         END IF
      NEXT zz%
   NEXT z%
   xv& = sintable&((ang% + 2560) AND 2047) \ 2048
   yv& = sintable&((ang% + 2048) AND 2047) \ 2048
   LINE (xdim \ 2 + xv&, ydim \ 2 + yv&)-(xdim \ 2 - xv&, ydim \ 2 - yv&), 15
   LINE (xdim \ 2 + xv&, ydim \ 2 + yv&)-(xdim \ 2 - yv&, ydim \ 2 + xv&), 15
   LINE (xdim \ 2 + xv&, ydim \ 2 + yv&)-(xdim \ 2 + yv&, ydim \ 2 - xv&), 15
END SUB

SUB show3dboard
   FOR z% = 0 TO numsectors% - 1
      got%(z%) = 0
   NEXT z%
   FOR z% = 0 TO xdim - 1
      umost%(z%) = startumost%(z%)
      dmost%(z%) = startdmost%(z%)
      scnt%(z%) = 0
   NEXT z%

   CALL getsector

   numhits% = xdim
   numscans% = 0
   CALL scansector(cursectnum%)
   WHILE numscans% > 0 AND numhits% > 0
     
      tempbuf%(0) = 1
      FOR z% = 1 TO numscans%
         tempbuf%(z%) = 0
      NEXT z%
      
      closest% = 0

      FOR z% = 0 TO numscans% - 1
         IF tempbuf%(z%) = 0 THEN
            IF xb1&(z%) < xb2&(closest%) AND xb1&(closest%) < xb2&(z%) THEN
               IF front%(z%, closest%) = z% THEN
                  closest% = z%
                  tempbuf%(z%) = 1
                  z% = 0
               END IF
            END IF
         END IF
      NEXT z%
     
      CALL drawall(closest%)
   WEND
  
   FOR z% = 0 TO numsectors% - 1
      IF got%(z%) <> 0 THEN
         s% = firstsprite%(z%)
         WHILE s% >= 0
            IF sprite(s%).cstat = CHR$(0) THEN CALL drawfacesprite(s%)
            'IF sprite(s%).cstat = chr$(1) THEN CALL drawwallsprite(s%)
            s% = sprite(s%).point2
         WEND
      END IF
   NEXT z%

END SUB

SUB vline (x&, y1&, y2&, siz&, picplc&, walnume%)
   y1v% = y1& \ 65536
   y2v% = y2& \ 65536
   sizv% = siz& \ 65536
   thesiz% = y2v% - y1v%
 
   IF (y1v% > dmost%(x&)) OR (y2v% < umost%(x&)) OR (thesiz% <= 0) OR (sizv% <= 0) OR (x& < 0) OR (x& >= xdim) THEN EXIT SUB

   picplc& = (picplc& * ASC(wall(walnume%).xrepeat)) \ 8
   picplc& = picplc& AND &HFC0
   vinc& = (33554432 * 32) \ (siz& \ 2048)
   vplc& = ((((y1& AND 65535 XOR 65535) * (vinc& \ 256)) \ 256) AND 65535)
   IF (y1v% < umost%(x&)) THEN
      vplc& = vplc& + (umost%(x&) - y1v%) * vinc&
      y1v% = umost%(x&)
   END IF
   IF (y2v% >= dmost%(x&)) THEN y2v% = dmost%(x&) - 1
   thesiz% = y2v% - y1v%
   IF (thesiz% < 1) OR (thesiz% > dmost%(x&)) THEN EXIT SUB

   shade% = vinc& \ 16384&
   IF shade% < 0 THEN shade% = 0
   IF shade% >= numpalookups THEN shade% = numpalookups - 1

   picplc& = picplc& + 8192&   'wall(walnume%).picnum

   DEF SEG = &HA000
   p& = y1v% * 320& + x&
   FOR zx% = 0 TO thesiz%
      vplc& = vplc& + vinc&
      POKE p&, palookup%(shade%, buf%(picplc& + ((vplc& \ 65536) AND 63)))
      p& = p& + 320
   NEXT zx%
END SUB

