
#version 150 compatibility 

uniform mat4 mat_view ;
uniform mat4 mat_proj ;
uniform mat4 mat_world ;

out vec4 color ;

/// The bounce of the vertices.
uniform float uni_bounce ;

void main()
{	
	vec4 vertex = gl_Vertex * uni_bounce ;

	// transform to projection space.
	// need camera rotation matrix and projection matrix.
	vec4 position = mat_proj * mat_view * mat_world * vec4(vertex.xyz,1.0) ;


	gl_Position = position ;
}