#ifdef GL_ES
precision highp float;
#endif

uniform vec2 resolution;
uniform float time;
uniform sampler2D tex0;
uniform sampler2D tex1;

vec3 deform( in vec2 p )
{
    vec2 uv;

    vec2 q = vec2( sin(5.1*time+p.x),sin(5.2*time+p.y) );

    float a = atan(q.y,q.x);
    float r = sqrt(dot(q,q));

    uv.x = 1.0+p.x*sqrt(r*r+1.0);
    uv.y = 1.0+p.y*sqrt(r*r+1.0);
	uv = uv*0.5;
	return texture2D(tex0,uv).xyz;
	return (
			texture2D(tex0,uv).xyz
			+texture2D(tex0,vec2(uv.x,uv.y+0.005)).xyz
			+texture2D(tex0,vec2(uv.x,uv.y-0.005)).xyz
			+texture2D(tex0,vec2(uv.x+0.005,uv.y)).xyz
			+texture2D(tex0,vec2(uv.x-0.005,uv.y)).xyz
			)/4.0;
}

void main(void)
{
    //vec2 p = -1.0 + 2.0 * gl_FragCoord.xy / vec2(640,480);
    vec2 p = -1.0 + 2.0 * gl_TexCoord[0].xy ;
	vec2 s = p;

    vec3 total = vec3(0.0);
    vec2 d = (vec2(0.0,0.0)-p)/40.0;
    float w = 0.899;
    for( int i=0; i<100; i++ )
    {
        vec3 res = deform(s);
        res = smoothstep(0.1,1.0,res*res);
        total += w*res;
        w *= .94;
        s += d;
    }
    total /= 20.0;
    float r = 1.5/(1.0+dot(p,p));
    gl_FragColor = texture2D(tex0,gl_TexCoord[0].xy)+vec4( total*r,1.0);
}