#ifdef GL_ES
precision highp float;
#endif
uniform sampler2D tex0;
varying vec3 N;
varying vec3 v;    
void main (void)  
{  
//	vec2 tp = gl_TexCoord[0].xy ;
//	vec4 tc = texture2D(tex0, tp);
   vec3 L = normalize(vec3(0,5,0)-v);   
   vec3 E = normalize(-v); // we are in Eye Coordinates, so EyePos is (0,0,0)  
   vec3 R = normalize(-reflect(L,N));  
 
   //calculate Ambient Term:  
   vec4 Iamb = vec4(0,0,0,0);   

   //calculate Diffuse Term:
   vec4 Idiff = vec4(0.65,0.59,0.5,1.0) * max(dot(N,L), 0.0);
   //vec4 Idiff = gl_Color * max(dot(N,L), 0.0);
   Idiff = clamp(Idiff, 0.0, 1.0);     
   
   // calculate Specular Term:
   vec4 Ispec = vec4(0.75,0.75,0.75,1) * pow(max(dot(R,E),0.0),0.1*180.0);
   Ispec = clamp(Ispec, 0.0, 1.0); 
   // write Total Color:  
//   vec4 text = texture2D(tex0, gl_TexCoord[0].xy);
   gl_FragColor =  Iamb + Idiff + Ispec;     
}