#version 330 core

uniform vec4 time;
uniform sampler2D tex0;
uniform vec4 opasity;

in vec2 texcoord0;

layout(location = 0, index = 0) out vec4 out_color0;

//yes, ripped directly from shadertoy
void main(void)
{
	vec2 p = 2.0f * texcoord0 - 1.0f;

	float a = atan(p.y,p.x);
	float r = sqrt(dot(p,p));

	vec2 uv;
	uv.x = 0.75f * time.x + 0.1f/ r;
	uv.y = a / 3.1416f;

	vec3 col = texture(tex0, uv).xyz;

	out_color0 = vec4( col*r*r, opasity.x );
}
