uniform sampler2D tex;
uniform float fadealpha;
uniform float time;
uniform float warppower;
varying vec2 texcoord;

const float pi = 3.1415926535897932;
const float offmul = 0.008;
const float texcolmul = 4.0;
const float rt = 0.1, gt = 0.9, bt = 0.0;
const float ro = 0.1, go = 0.9, bo = 0.0;

float noise(float x, float distort)
{
	return (cos(x*pi)*cos(x*pi))*cos(x*3.0*pi)*cos(x*5.0*pi)*0.5+sin(x*25.0*pi)*0.02*distort;
}

void main(void)
{
//	float satcol = smoothstep( 0.2, 0.75, sin(time) );
	float satcol = 0.75;
	float offprm = offmul + 2.0 * warppower;
	vec2 texcol = texcoord.xy;
	//vec2 texcol_r = vec2(texcol.x+ro+offmul*noise(rt+texcol.y*texcolmul+noise(time*pi+texcol.y,satcol),0.9), texcol.y);
	//vec2 texcol_g = vec2(texcol.x+go+offmul*noise(gt+texcol.y*texcolmul+noise(time*pi+texcol.y,satcol),0.9), texcol.y);
	//vec2 texcol_b = vec2(texcol.x+bo+offmul*noise(bt+texcol.y*texcolmul+noise(time*pi+texcol.y,satcol),0.9), texcol.y);
	vec2 texcol_r = vec2(texcol.x+ro+offprm*noise(rt+texcol.y*texcolmul+noise(time*pi+texcol.y,satcol),0.9), texcol.y);
	vec2 texcol_g = vec2(texcol.x+go+offprm*noise(gt+texcol.y*texcolmul+noise(time*pi+texcol.y,satcol),0.9), texcol.y);
	vec2 texcol_b = vec2(texcol.x+bo+offprm*noise(bt+texcol.y*texcolmul+noise(time*pi+texcol.y,satcol),0.9), texcol.y);

	float r = texture2D(tex, texcol_r).r;
	float g = texture2D(tex, texcol_g).g;
	float b = texture2D(tex, texcol_b).b;
	
	float gr = (r+g+b)*0.5;
	gr = gr*0.25+0.75*gr*gr;
	
	r = r*satcol + gr*(1.0-satcol);
	g = g*satcol + gr*(1.0-satcol);
	b = b*satcol + gr*(1.0-satcol);
	
	gl_FragColor = vec4(r, g, b, 1.0*fadealpha);

	
}